#!/usr/bin/env ruby

################################################################################
# This file is part of KDevelop-PG-Qt.                                         #
# Copyright Ⓒ 2011 Jonathan Schmidt-Dominé <devel@the-user.org>                #
#                                                                              #
# This library is free software; you can redistribute it and/or                #
# modify it under the terms of the GNU Library General Public License as       #
# published by the Free Software Foundation; either version 2 of the License,  #
# or (at your option) any later version.                                       #
#                                                                              #
# This library is distributed in the hope that it will be useful, but WITHOUT  #
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or        #
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public        #
# License for more details.                                                    #
#                                                                              #
# You should have received a copy of the GNU Library General Public License    #
# along with this library; see the file COPYING.LIB.  If not, write to the     #
# Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  #
# 02110-1301, USA.                                                             #
################################################################################

puts <<-code
// This file is generated by generate-get-utf8-tubles.rb
// WARNING! All changes made in this file will be lost!

template<template<CharEncoding> class CharSet>
NFA<CharSet<Latin1> > getUtf8Tuples(typename Codec2Int<Latin1>::Result from0, typename Codec2Int<Latin1>::Result to0)
{
  return NFA<CharSet<Latin1> >(CharSet<Latin1>::range(from0, to0));
}
code

for numranges in 2..4
  puts <<-code
template<template<CharEncoding> class CharSet>
NFA<CharSet<Latin1> > getUtf8Tuples(typename Codec2Int<Latin1>::Result from0, typename Codec2Int<Latin1>::Result to0
code
  for i in 1..(numranges-1)
    print ", typename Codec2Int<Latin1>::Result from#{i}, typename Codec2Int<Latin1>::Result to#{i}"
  end
  puts <<-code
)
{
    typedef typename Codec2Int<Latin1>::Result Int;
    if(from0 == to0)
    {
      auto tuples = NFA<CharSet<Latin1> >(CharSet<Latin1>(from0));
      tuples <<= getUtf8Tuples<CharSet>(from1, to1
code
      for i in 2..(numranges-1)
        print ", from#{i}, to#{i}"
      end
      puts <<-code
      );
      return tuples;
    }
    else
    {
      NFA<CharSet<Latin1> > tuples;
      auto firstTuples = NFA<CharSet<Latin1> >(CharSet<Latin1>(from0));
      firstTuples <<= getUtf8Tuples<CharSet>(from1, Int(0x80 + (1<<6))
code
      for i in 2..(numranges-1)
        print ", from#{i}, to#{i}"
      end
      puts <<-code
      );
      tuples |= firstTuples;
      auto midTuples = NFA<CharSet<Latin1> >(CharSet<Latin1>::range(from0 + 1, to0));
      midTuples <<= getUtf8Tuples<CharSet>(Int(0x80), Int(0x80 + (1<<6))
code
      for i in 2..(numranges-1)
        print ", from#{i}, to#{i}"
      end
      puts <<-code
      );
      tuples |= midTuples;
      auto lastTuples = NFA<CharSet<Latin1> >(CharSet<Latin1>(to0));
      lastTuples <<= getUtf8Tuples<CharSet>(Int(0x80), to1
code
      for i in 2..(numranges-1)
        print ", from#{i}, to#{i}"
      end
      puts <<-code
      );
      tuples |= lastTuples;
      return tuples;
    }
}
code
end