/* Definitions of target machine for GNU compiler,
   for ARM with PE obj format running under the EPOC operating system. 
   Copyright (C) 1999 Free Software Foundation, Inc.
   
   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published
   by the Free Software Foundation; either version 2, or (at your
   option) any later version.

   GCC is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with GCC; see the file COPYING.  If not, write to the Free
   Software Foundation, 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

/* XXX This is a guess - what is the default CPU for EPOC/PE builds ? */
#ifndef SUBTARGET_CPU_DEFAULT
#define SUBTARGET_CPU_DEFAULT 		TARGET_CPU_arm7tdmi
#endif

#define ARM_EPOC			1

#include "arm-pe.h"

#undef  USER_LABEL_PREFIX
#define USER_LABEL_PREFIX ""

#undef  SIZE_TYPE
#define SIZE_TYPE "unsigned int"

#undef  TARGET_VERSION
#define TARGET_VERSION	fputs (" (ARM/EPOC/PE)", stderr);

#undef  CC1_SPEC
#define CC1_SPEC "			\
-fno-leading-underscore			\
-fvtable-thunks				\
-fcheck-new				\
%{!DIN_GCC:-fno-rtti}			\
%{!DIN_GCC:-fno-exceptions}		\
%{!mapcs-32:%{!mapcs-26:-mapcs-32}}	\
%{!march=*:-mthumb-interwork} 		\
-march=armv4t 				\
-msoft-float 				\
-malignment-traps 			\
"
#undef  TARGET_DEFAULT
#define TARGET_DEFAULT 			ARM_FLAG_SOFT_FLOAT

#undef  CPP_APCS_PC_DEFAULT_SPEC
#define CPP_APCS_PC_DEFAULT_SPEC	"-D__APCS_32__"

#undef  ASM_SPEC
#define ASM_SPEC "			\
%{mbig-endian:-EB}			\
%{mcpu=*:-m%*}				\
%{march=*:-m%*}				\
%{mapcs-*:-mapcs-%*}			\
%{mthumb-interwork:-mthumb-interwork}	\
%{!mapcs-32:%{!mapcs-26:-mapcs-32}}	\
"

#undef  MULTILIB_DEFAULTS
#define MULTILIB_DEFAULTS { "msoft-float", "mno-thumb-interwork", "mapcs-32" }

