#############################################################
#
# vixie-cron
#
#############################################################
ifneq ($(USE_CVS), true)
VIXIE_CRON_SOURCE:=vixie-cron.tar.gz
VIXIE_CRON_CAT:=zcat
endif

VIXIE_CRON_DIR:=$(BUILD_DIR)/vixie-cron
VIXIE_CRON_BINARY:=vixie-cron
VIXIE_CRON_TARGET_BINARY:=usr/sbin/vixie-cron

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(VIXIE_CRON_SOURCE):

vixie-cron-source: $(DL_DIR)/$(VIXIE_CRON_SOURCE)
else
vixie-cron-source:
endif

VIXIE_CRON_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d vixie-cron $(CVS_TAG) $(CVS_PREFIX)vixie-cron

vixie-cron-checkout:
	@$(VIXIE_CRON_CVSCO)

$(VIXIE_CRON_DIR)/.unpacked: $(DL_DIR)/$(VIXIE_CRON_SOURCE)
ifneq ($(USE_CVS), true)
	$(VIXIE_CRON_CAT) $(DL_DIR)/$(VIXIE_CRON_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(VIXIE_CRON_CVSCO)
endif
	-cat $(SOURCE_DIR)/vixie-cron.patch | patch -d $(VIXIE_CRON_DIR)
	touch  $(VIXIE_CRON_DIR)/.unpacked

$(VIXIE_CRON_DIR)/.configured: $(VIXIE_CRON_DIR)/.unpacked
	touch $(VIXIE_CRON_DIR)/.configured

$(VIXIE_CRON_DIR)/$(VIXIE_CRON_BINARY): $(VIXIE_CRON_DIR)/.configured
	$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(VIXIE_CRON_DIR)

$(TARGET_DIR)/$(VIXIE_CRON_TARGET_BINARY): $(VIXIE_CRON_DIR)/$(VIXIE_CRON_BINARY)
	$(MAKE) $(TARGET_CONFIGURE_OPTS) DESTDIR=$(TARGET_DIR) -C $(VIXIE_CRON_DIR) install
	install -m0755 $(VIXIE_CRON_DIR)/vixie-cron.init $(TARGET_DIR)/etc/rc.d/init.d/crond
	install -d -m0755 $(TARGET_DIR)/etc/cron.d

vixie-cron: uclibc initscripts $(TARGET_DIR)/$(VIXIE_CRON_TARGET_BINARY)

vixie-cron-clean:
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(VIXIE_CRON_DIR) uninstall
	-rm -f $(TARGET_DIR)/etc/rc.d/init.d/crond
	-$(MAKE) -C $(VIXIE_CRON_DIR) clean

vixie-cron-dirclean:
	rm -rf $(VIXIE_CRON_DIR)

