#############################################################
#
# sed
#
#############################################################
ifneq ($(USE_CVS),true)
#SED_SOURCE:=sed-3.02.tar.gz
SED_SOURCE:=sed.tar.gz
SED_SITE:=ftp://ftp.gnu.org/gnu/sed
SED_CAT:=zcat
endif

SED_DIR:=$(BUILD_DIR)/sed
SED_BINARY:=sed/sed
SED_TARGET_BINARY:=bin/sed

ifneq ($(USE_CVS),true)
sed-fetch:
	 $(WGET) -P $(DL_DIR) $(SED_SITE)/$(SED_SOURCE)

sed-source: $(DL_DIR)/$(SED_SOURCE)
endif

SED_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co $(CVS_TAG) -d sed $(CVS_PREFIX)sed

sed-checkout:
	@$(SED_CVSCO)

$(SED_DIR)/.unpacked: $(DL_DIR)/$(SED_SOURCE)
ifneq ($(USE_CVS),true)
	$(SED_CAT) $(DL_DIR)/$(SED_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(SED_CVSCO)
endif
	touch $(SED_DIR)/.unpacked

$(SED_DIR)/.configured: $(SED_DIR)/.unpacked
	(cd $(SED_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/bin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(SED_DIR)/.configured

$(SED_DIR)/$(SED_BINARY): $(SED_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(SED_DIR)

# This stuff is needed to work around GNU make deficiencies
sed-target_binary: $(SED_DIR)/$(SED_BINARY)
	@if [ -L $(TARGET_DIR)/$(SED_TARGET_BINARY) ] ; then \
		rm -f $(TARGET_DIR)/$(SED_TARGET_BINARY); fi;
	@if [ $(TARGET_DIR)/$(SED_TARGET_BINARY) -ot $(SED_DIR)/$(SED_BINARY) ] ; then \
		set -x; \
		$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(SED_DIR) install; \
	fi
	install -d $(DOC_DIR)/doc/sed
	for f in AUTHORS BUGS COPYING NEWS README THANKS ; do \
		install -m0644 $(SED_DIR)/$$f $(DOC_DIR)/doc/sed/$$f ;\
	done

sed: uclibc sed-target_binary

sed-clean:
	-$(MAKE) PATH=$$PATH:/sbin DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(SED_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/sed
	-$(MAKE) -C $(SED_DIR) clean

sed-dirclean:
	rm -rf $(SED_DIR)

