#############################################################
#
# procps
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
PROCPS_SOURCE:=procps.tar.gz
PROCPS_SITE:=ftp://ftp.gnu.org/gnu/procps
PROCPS_CAT:=zcat
endif

PROCPS_DIR:=$(BUILD_DIR)/procps
PROCPS_BINARY:=uptime
PROCPS_TARGET_BINARY:=usr/bin/uptime
PROCPS_BINPROGS:=free pgrep pkill pmap skill slabtop snice tload top uptime vmstat w watch

ifneq ($(USE_CVS),true)
procps-fetch:
	 $(WGET) -P $(DL_DIR) $(PROCPS_SITE)/$(PROCPS_SOURCE)

procps-source: $(DL_DIR)/$(PROCPS_SOURCE)
else
procps-source:
endif

PROCPS_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d procps $(CVS_TAG) $(CVS_PREFIX)procps

procps-checkout:
	@$(PROCPS_CVSCO)

$(PROCPS_DIR)/.unpacked: $(DL_DIR)/$(PROCPS_SOURCE)
ifneq ($(USE_CVS),true)
	$(PROCPS_CAT) $(DL_DIR)/$(PROCPS_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(PROCPS_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(PROCPS_DIR)/
	sed -i -e 's,--strip ,,g;s,-I/usr/include,-I$(STAGING_DIR)/usr/include,g' $(PROCPS_DIR)/Makefile $(PROCPS_DIR)/proc/module.mk $(PROCPS_DIR)/ps/module.mk
	touch $(PROCPS_DIR)/.unpacked

$(PROCPS_DIR)/$(PROCPS_BINARY): $(PROCPS_DIR)/.unpacked
	$(MAKE) CC=$(TARGET_CC) CC_FOR_BUILD=$(HOSTCC) -C $(PROCPS_DIR)

$(TARGET_DIR)/$(PROCPS_TARGET_BINARY): $(PROCPS_DIR)/$(PROCPS_BINARY)
	$(MAKE) ldconfig=/bin/true DESTDIR=$(TARGET_DIR) -C $(PROCPS_DIR) install
	for f in $(PROCPS_BINPROGS) ; do \
		chmod u+w $(TARGET_DIR)/usr/bin/$$f ;\
		$(STRIP) $(TARGET_DIR)/usr/bin/$$f || : ;\
		chmod u-w $(TARGET_DIR)/usr/bin/$$f ;\
	done
	-$(STRIP) $(TARGET_DIR)/lib/libproc.so.* $(TARGET_DIR)/bin/ps $(TARGET_DIR)/sbin/sysctl
	chmod u+w $(TARGET_DIR)/bin/kill
	$(STRIP) $(TARGET_DIR)/bin/kill
	chmod u-w $(TARGET_DIR)/bin/kill
	install -d $(DOC_DIR)/doc/procps
	@for f in COPYING COPYING.LIB BUGS NEWS README README.top ; do \
		install -m0644 $(PROCPS_DIR)/$$f $(DOC_DIR)/doc/procps/$$f ;\
	done

procps: uclibc $(TARGET_DIR)/$(PROCPS_TARGET_BINARY)

procps-clean:
	-rm -f $(TARGET_DIR)/lib/libproc.so*
	-@for f in $(PROCPS_BINPROGS) ; do \
		rm -f $(TARGET_DIR)/usr/bin/$$f ;\
		rm -f $(TARGET_DIR)/usr/man/man*/$$f.* ;\
	done
	-rm -f $(TARGET_DIR)/bin/ps
	-rm -f $(TARGET_DIR)/sbin/sysctl
	-rm -rf $(DOC_DIR)/doc/procps
	-$(MAKE) -C $(PROCPS_DIR) clean

procps-dirclean:
	rm -rf $(PROCPS_DIR)
endif

