#############################################################
#
# fbset
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
FBSET_SOURCE:=fbset.tar.gz
FBSET_SITE:=ftp://ftp.gnu.org/gnu/fbset
FBSET_CAT:=zcat
endif

FBSET_DIR:=$(BUILD_DIR)/fbset
FBSET_BINARY:=fbset
FBSET_TARGET_BINARY:=usr/sbin/fbset

ifneq ($(USE_CVS),true)
fbset-fetch:
	 $(WGET) -P $(DL_DIR) $(FBSET_SITE)/$(FBSET_SOURCE)

fbset-source: $(DL_DIR)/$(FBSET_SOURCE)
else
fbset-source:
endif

FBSET_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d fbset $(CVS_TAG) $(CVS_PREFIX)fbset

fbset-checkout:
	@$(FBSET_CVSCO)

$(FBSET_DIR)/.unpacked: $(DL_DIR)/$(FBSET_SOURCE)
ifneq ($(USE_CVS),true)
	$(FBSET_CAT) $(DL_DIR)/$(FBSET_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(FBSET_CVSCO)
endif
	sed -i -e 's,CC =[[:space:]]\+gcc[[:space:]],CC = $(TARGET_CC) ,' $(FBSET_DIR)/Makefile
	cp $(SOURCE_DIR)/config.sub $(FBSET_DIR)/
	touch $(FBSET_DIR)/.unpacked

$(FBSET_DIR)/$(FBSET_BINARY): $(FBSET_DIR)/.unpacked
	$(MAKE) -C $(FBSET_DIR)

$(TARGET_DIR)/$(FBSET_TARGET_BINARY): $(FBSET_DIR)/$(FBSET_BINARY)
	$(MAKE) PREFIX=$(TARGET_DIR) -C $(FBSET_DIR) install
	$(STRIP) $(TARGET_DIR)/$(FBSET_TARGET_BINARY)
	install -d $(DOC_DIR)/doc/fbset

fbset: uclibc $(TARGET_DIR)/$(FBSET_TARGET_BINARY)

fbset-clean:
	-rm -f $(TARGET_DIR)/etc/fb.modes
	-rm -f $(TARGET_DIR)/$(FBSET_TARGET_BINARY)
	-rm -f $(TARGET_DIR)/usr/sbin/modeline2fb
	-rm -f $(TARGET_DIR)/usr/man/man5/fb.modes.5
	-rm -f $(TARGET_DIR)/usr/man/man8/fbset.8
	-rm -rf $(DOC_DIR)/doc/fbset
	-$(MAKE) -C $(FBSET_DIR) clean

fbset-dirclean:
	rm -rf $(FBSET_DIR)
endif

