/*	Copyright (C) 1995 Cygnus Support, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, Cygnus Support gives permission
 * for additional uses of the text contained in its release of this library.
 *
 * The exception is that, if you link this library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking this library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by 
 * Cygnus Support as part of this library.  If you copy
 * code from other releases distributed under the terms of the GPL into a copy of
 * this library, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from such code.
 *
 * If you write modifications of your own for this library, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */

#include <stdio.h>
#include "tclInt.h"
#include "guile-tcl.h"
#include "_scm.h"
#include "gscm.h"

#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* __GNUC__ not defined.  */
#if HAVE_ALLOCA_H
#include <alloca.h>
#else /* not HAVE_ALLOCA_H */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not HAVE_ALLOCA_H */
#endif /* __GNUC__ not defined.  */
#endif /* alloca not defined.  */




#ifdef __STDC__
static sizet
free_interp (SCM obj)
#else
static sizet
free_interp (obj)
     SCM obj;
#endif
{
  SCMDATA (obj) = EOL;
  Tcl_DeleteInterp (TERP (obj));
  return 0;
}

#ifdef __STDC__
static SCM
mark_interp (SCM obj)
#else
static SCM
mark_interp (obj)
     SCM obj;
#endif
{
  if (GC8MARKP (obj))
    return BOOL_F;

  SETGC8MARK (obj);
  return SCMDATA (obj); 
}

#ifdef __STDC__
static int
print_interp (SCM exp, SCM port, int writing)
#else
static int
print_interp (exp, port, writing)
     SCM exp;
     SCM port;
     int writing;
#endif
{
  scm_gen_puts(scm_regular_string, "#<tcl-interpreter ", port);
  scm_intprint(exp, 16, port);
  scm_gen_putc('>', port);
  return 1;
}

static scm_smobfuns tcl_interp_smob 
= {mark_interp, free_interp, print_interp, 0};
int scm_tc16_tcl_interp;



PROC (s_tcl_create_interp, "tcl-create-interp", 0, 0, 0, scm_tcl_create_interp);
#ifdef __STDC__
SCM
scm_tcl_create_interp (void)
#else
SCM
scm_tcl_create_interp ()
#endif
{
  SCM answer;
  SCM cell2;
  NEWCELL (answer);
  NEWCELL (cell2);
  DEFER_INTS;
  CDR (answer) = (SCM)Tcl_CreateInterp ();
  CAR (answer) = scm_tc16_tcl_interp;
  SCMDATA (answer) = cell2;
  PROPS (answer) = EOL;
  SELF (answer) = answer;
  ALLOW_INTS;
  return answer;
}


#ifdef I18N
#ifdef __STDC__
static SCM
tcl_encoding (Tcl_Interp *interp)
#else
static SCM
tcl_encoding (interp)
     Tcl_Interp *interp;
#endif
{
  SCM encoding;
  switch (Tcl_KanjiCode (interp)) {
  case TCL_EUC: encoding = CAR (scm_intern0 ("*euc-japan*")); break;
  case TCL_SJIS: encoding =  CAR (scm_intern0 ("*sjis*")); break;
  case TCL_JIS: encoding = CAR (scm_intern0 ("*junet*")); break;
  case TCL_ANY:
  default: return BOOL_F;
  }
  return encoding;
}
#endif

PROC (s_tcl_global_eval, "tcl-global-eval", 2, 0, 0, scm_tcl_global_eval);
#ifdef __STDC__
SCM
scm_tcl_global_eval (SCM tobj, SCM script)
#else
SCM
scm_tcl_global_eval (tobj, script)
     SCM tobj;
     SCM script;
#endif
{
  char * bufp;
  int status;

  ASSERT (NIMP (tobj) && TERPP (tobj), tobj, ARG1, s_tcl_global_eval);
  ASSERT (NIMP (script) && STRINGP (script), script, ARG2, s_tcl_global_eval);
  
#ifdef I18N
  if (MB_STRINGP (script)) {
    int len;
    gscm_2_foreign_str (&bufp, &len, &script, tcl_encoding (TERP (tobj)));
  }
#endif
  bufp = alloca (1 + LENGTH (script));
  bcopy (CHARS (script), bufp, LENGTH (script));
  bufp[LENGTH(script)] = 0;
  DEFER_INTS;
  status = Tcl_GlobalEval (TERP (tobj), bufp);
  ALLOW_INTS;
  /* !!! fixme -- leaking "result" */
#ifndef I18N
  return scm_cons (MAKINUM (status), makfrom0str (TERP (tobj)->result));
#else
  return scm_cons (MAKINUM (status),
		   makfrom0mbstr (TERP (tobj)->result,
				  tcl_encoding(TERP(tobj))));
#endif
}



#ifdef __STDC__
static SCM
listify_strings (int argc, char * argv[])
#else
static SCM
listify_strings (argc, argv)
     int argc;
     char * argv[];
#endif
{
  SCM answer;

  answer = EOL;
  while (argc--)
    {
      answer = scm_cons (makfrom0str (argv[argc]), answer);
    }
  return answer;
  
}

#ifdef I18N
#ifdef __STDC__
static SCM
listify_mbstrings (int argc, char * argv[], SCM encoding)
#else
static SCM
listify_mbstrings (argc, argv, encoding)
     int argc;
     char * argv[];
     SCM encoding
#endif
{
  SCM answer;

  if (IMP (encoding))
    return listify_strings (argc, argv);

  answer = EOL;
  while (argc--)
    {
      unsigned char *first_mb_char = (unsigned char *)argv[argc];

      while (*first_mb_char && ASCII_P (*first_mb_char))
	first_mb_char++;
      if (*first_mb_char != 0)
	answer = scm_cons (makfrom0mbstr (argv[argc], encoding), answer);
      else
	answer = scm_cons (makfrom0str (argv[argc]), answer);
    }
  return answer;
  
}
#endif

static SCM id_fn;
static char s_id_fn[] = " id-fn";

#ifdef __STDC__
static SCM
scm_id_fn (SCM obj)
#else
static SCM
scm_id_fn (obj)
     SCM obj;
#endif
{
  return obj;
}

static char *s_tcl_create_command;

#ifdef __STDC__
static int
invoke_tcl_command (ClientData data, Tcl_Interp * interp, int argc, char * argv[])
#else
static int
invoke_tcl_command (data, interp, argc, argv)
     ClientData data;
     Tcl_Interp * interp;
     int argc;
     char * argv[];
#endif
{
  SCM tobj;
  SCM proc;
  SCM result;
  tobj = CAR((SCM)interp->client_data);
  proc = CAR ((SCM)data);
#if 1
#ifndef I18N
  result = scm_app_wdr (proc, listify_strings (argc - 1, argv + 1), EOL, id_fn);
#else
  result = scm_app_wdr (proc, listify_mbstrings (argc - 1, argv + 1,
						 tcl_encoding(interp)),
			EOL, id_fn);
#endif
#else
  result = scm_apply (proc, listify_strings (argc - 1, argv + 1), EOL);
#endif

  if (NIMP (result) && (STRINGP (result) || SYMBOLP (result)))
    {
#ifdef I18N
      int len;
      char *bufp;
      gscm_2_foreign_str (&bufp, &len, &result, tcl_encoding (interp));
#endif
      Tcl_SetResult (interp, CHARS (result), TCL_VOLATILE);
      return TCL_OK;
    }
  else if (NUMBERP (result))
    {
      SCM name;
      name = scm_number_to_string (result, MAKINUM (10));
      Tcl_SetResult (interp, CHARS (CDR (name)), TCL_VOLATILE);
      return TCL_OK;
    }
  else if (NIMP (result) && CONSP (result) && INUMP (CAR (result)) &&
	   NIMP (CDR (result)) &&
	   (STRINGP (CDR (result)) || SYMBOLP (result)))
    {
      Tcl_SetResult (interp, CHARS (CDR (result)), TCL_VOLATILE);
      return INUM (CAR (result));
    }
  else
    {
      Tcl_SetResult (interp, "Strange Scheme result", TCL_STATIC);
      return TCL_ERROR;
    }
}

#ifdef __STDC__
static void
delete_tcl_command (ClientData data)
#else
static void
delete_tcl_command (data)
     ClientData data;
#endif
{
  SCM obj;
  if (CONSP (data))
    {
      obj = (SCM) data;
      if (SCMDATA (CDR (obj)) != EOL)
	PROPS (CDR (obj)) = scm_delq_x (obj, PROPS (CDR (obj)));
    }
}

PROC (s_tcl_create_command, "tcl-create-command", 3, 0, 0, scm_tcl_create_command);
#ifdef __STDC__
SCM
scm_tcl_create_command (SCM tobj, SCM name, SCM proc)
#else
SCM
scm_tcl_create_command (tobj, name, proc)
     SCM tobj;
     SCM name;
     SCM proc;
#endif
{
  ASSERT (NIMP (tobj) && TERPP (tobj), tobj, ARG1, s_tcl_create_command);
  ASSERT (NIMP (name) && (STRINGP (name) || SYMBOLP (name)), name, ARG2, s_tcl_create_command);
  ASSERT (scm_procedurep (proc) == BOOL_T, proc, ARG3, s_tcl_create_command);
  PROPS (tobj) = scm_acons (proc, tobj, PROPS (tobj));
#ifdef I18N
  if (MB_STRINGP (name)) {
    int len;
    char *bufp;
    gscm_2_foreign_str (&bufp, &len, &name, tcl_encoding (TERP (tobj)));
  }
#endif
  DEFER_INTS;
  Tcl_CreateCommand (TERP (tobj), CHARS (name),
		     invoke_tcl_command,
		     (ClientData)CAR (PROPS (tobj)),
		     delete_tcl_command);
  ALLOW_INTS;
  return UNSPECIFIED;
}


PROC (s_tcl_delete_command, "tcl-delete-command", 2, 0, 0, scm_tcl_delete_command);
#ifdef __STDC__
SCM
scm_tcl_delete_command (SCM tobj, SCM name)
#else
SCM
scm_tcl_delete_command (tobj, name)
     SCM tobj;
     SCM name;
#endif
{
  ASSERT (NIMP (tobj) && TERPP (tobj), tobj, ARG1, s_tcl_delete_command);
  ASSERT (NIMP (name) && (STRINGP(name) || SYMBOLP (name)), name, ARG2, s_tcl_delete_command);
#ifdef I18N
  if (MB_STRINGP (name)) {
    int len;
    char *bufp;
    gscm_2_foreign_str (&bufp, &len, &name, tcl_encoding (TERP (tobj)));
  }
#endif
  Tcl_DeleteCommand (TERP (tobj), CHARS (name));
  return UNSPECIFIED;
}



PROC (s_tcl_get_int, "tcl-get-int", 2, 0, 0, scm_tcl_get_int);
#ifdef __STDC__
SCM
scm_tcl_get_int (SCM tobj, SCM name)
#else
SCM
scm_tcl_get_int (tobj, name)
     SCM tobj;
     SCM name;
#endif
{
  int c_answer;
  ASSERT (NIMP (tobj) && TERPP (tobj), tobj, ARG1, s_tcl_get_int);
  ASSERT (NIMP (name)
	  && (SYMBOLP (name) || STRINGP (name)),
	  name, ARG2, s_tcl_get_int);
  ASSERT (TCL_OK == Tcl_GetInt (TERP (tobj), CHARS (name), &c_answer),
	  name, TERP (tobj)->result, s_tcl_get_int);

  /* !!! leaking result */
  return scm_long2num ((long)c_answer);
}

PROC (s_tcl_get_double, "tcl-get-double", 2, 0, 0, scm_tcl_get_double);
#ifdef __STDC__
SCM
scm_tcl_get_double (SCM tobj, SCM name)
#else
SCM
scm_tcl_get_double (tobj, name)
     SCM tobj;
     SCM name;
#endif
{
  double c_answer;
  ASSERT (NIMP (tobj) && TERPP (tobj), tobj, ARG1, s_tcl_get_double);
  ASSERT (NIMP (name)
	  && (SYMBOLP (name) || STRINGP (name)),
	  name, ARG2, s_tcl_get_double);
  ASSERT (TCL_OK == Tcl_GetDouble (TERP (tobj), CHARS (name), &c_answer),
	 tobj, TERP (tobj)->result, s_tcl_get_double);
  /* !!! leaking result */
  return scm_makdbl (c_answer, 0.0);
}

PROC (s_tcl_get_boolean, "tcl-get-boolean", 2, 0, 0, scm_tcl_get_boolean);
#ifdef __STDC__
SCM
scm_tcl_get_boolean (SCM tobj, SCM name)
#else
SCM
scm_tcl_get_boolean (tobj, name)
     SCM tobj;
     SCM name;
#endif
{
  int c_answer;
  ASSERT (NIMP (tobj) && TERPP (tobj), tobj, ARG1, s_tcl_get_boolean);
  ASSERT (NIMP (name)
	  && (SYMBOLP (name) || STRINGP (name)),
	  name, ARG2, s_tcl_get_boolean);
  ASSERT (TCL_OK == Tcl_GetBoolean (TERP (tobj), CHARS (name), &c_answer),
	  tobj, TERP (tobj)->result, s_tcl_get_boolean);
  /* !!! leaking result */
  return (c_answer
	  ? BOOL_T
	  : BOOL_F);
}

PROC (s_tcl_split_list, "tcl-split-list", 2, 0, 0, scm_tcl_split_list);
#ifdef __STDC__
SCM
scm_tcl_split_list (SCM tobj, SCM name)
#else
SCM
scm_tcl_split_list (tobj, name)
     SCM tobj;
     SCM name;
#endif
{
  char **argv;
  int argc;
  int tcl_result;

  ASSERT (NIMP (tobj) && TERPP (tobj), tobj, ARG1, s_tcl_split_list);
  ASSERT (NIMP (name)
	  && (SYMBOLP (name) || STRINGP (name)),
	  name, ARG2, s_tcl_split_list);
#ifdef I18N
  if (MB_STRINGP (name)) {
    int len;
    char *bufp;
    gscm_2_foreign_str (&bufp, &len, &name, tcl_encoding (TERP (tobj)));
  }
#endif
  DEFER_INTS;
  tcl_result = (TCL_OK == Tcl_SplitList (TERP (tobj),
					 CHARS (name), &argc, &argv));
  ALLOW_INTS;
  ASSERT (tcl_result, name, TERP (tobj)->result, s_tcl_split_list);
  /* !!! leaking result */
  {
    SCM answer;
#ifndef I18N
    answer = listify_strings (argc, argv);
#else
    answer = listify_mbstrings (argc, argv, tcl_encoding (TERP (tobj)));
#endif
    DEFER_INTS;
    free (argv);
    ALLOW_INTS;
    return answer;
  }
}

PROC (s_tcl_merge, "tcl-merge", 2, 0, 0, scm_tcl_merge);
#ifdef __STDC__
SCM
scm_tcl_merge (SCM tobj, SCM args)
#else
SCM
scm_tcl_merge (tobj, args)
     SCM tobj;
     SCM args;
#endif
{
  int argc;
  char ** argv;
#ifdef I18N
  SCM lst = EOL;
#endif
  ASSERT (NIMP (tobj) && TERPP (tobj), tobj, ARG1, s_tcl_merge);
  argc = scm_ilength (args);
  if (argc == 0)
    argv = 0;
  else
    {
      int i;
      DEFER_INTS;
      argv = (char **)alloca (sizeof (char *) * argc);
      ALLOW_INTS;
      for (i = 0; i < argc; ++i)
	{
	  ASSERT (NIMP (CAR (args))
		  && (STRINGP (CAR (args)) || SYMBOLP (CAR (args))),
		  CAR (args), "all arguments must be strings",
		  s_tcl_merge);

	  argv[i] = CHARS (CAR (args));
#ifdef I18N
	  if (MB_STRINGP (CAR (args))) {
	    int len;
	    char *bufp;
	    SCM s = CAR (args);
	    gscm_2_foreign_str (&bufp, &len, &s, tcl_encoding (TERP (tobj)));
	    if (bufp) {
	      argv[i] = bufp;
	      lst = scm_cons (s, lst);
	    }
	  }
#endif
	  args = CDR (args);
	}
    }
  /* !!! leaking result */
  {
    char * c_answer;
    SCM answer;
    DEFER_INTS;
    c_answer = Tcl_Merge (argc, argv);
    ALLOW_INTS;
#ifndef I18N
    answer = makfrom0str (c_answer);
#else
    answer = makfrom0mbstr (c_answer, tcl_encoding (TERP (tobj)));
#endif
    DEFER_INTS;
    free (c_answer);
    ALLOW_INTS;
    return answer;
  }
}


#ifdef __STDC__
char *
trace_variable (ClientData data, Tcl_Interp * interp, char * name, char * name2, int flags)
#else
char *
trace_variable (data, interp, name, name2, flags)
     ClientData data;
     Tcl_Interp * interp;
     char * name;
     char * name2;
     int flags;
#endif
{
  SCM proc;
  SCM result;
  proc = (SCM)CAR (data);
  result = scm_app_wdr (proc,
			scm_listify (SELF_interp (interp),
				     makfrom0str (name),
				     makfrom0str_opt (name2),
				     MAKINUM (flags),
				     SCM_UNDEFINED),
			EOL,
			id_fn);
  return ((result == BOOL_F)
	  ? "Error from Scheme variable trace."
	  : 0);
}

PROC (s_tcl_trace_var2, "tcl-trace-var2", 5, 0, 0, scm_tcl_trace_var2);
#ifdef __STDC__
SCM
scm_tcl_trace_var2 (SCM tobj, SCM name, SCM index, SCM flags, SCM thunk)
#else
SCM
scm_tcl_trace_var2 (tobj, name, index, flags, thunk)
     SCM tobj;
     SCM name;
     SCM index;
     SCM flags;
     SCM thunk;
#endif
{
  ASSERT (NIMP (tobj) && TERPP (tobj), tobj, ARG1, s_tcl_trace_var2);
  ASSERT (NIMP (name)
	  && (SYMBOLP (name) || STRINGP (name)),
	  name, ARG2, s_tcl_trace_var2);
  ASSERT ((BOOL_F == index)
	  || (NIMP (index)
	      && (SYMBOLP (index) || STRINGP (index))),
	  name, ARG3, s_tcl_trace_var2);
  ASSERT (INUMP (flags), flags, ARG4, s_tcl_trace_var2);
  ASSERT (scm_procedurep (thunk), thunk, ARG5, s_tcl_trace_var2);
  PROPS (tobj) = scm_acons (thunk, EOL, PROPS (tobj));
#ifdef I18N
  if (MB_STRINGP (name)) {
    int len;
    char *bufp;
    gscm_2_foreign_str (&bufp, &len, &name, tcl_encoding (TERP (tobj)));
  }
#endif
  DEFER_INTS;
  Tcl_TraceVar2 (TERP (tobj),
		 CHARS (name),
		 ((index == BOOL_F)
		  ? 0
		  : CHARS (index)),
		 INUM (flags),
		 trace_variable,
		 (ClientData)CAR (PROPS (tobj)));
  /* !!! leaking result */
  ALLOW_INTS;
  return UNSPECIFIED;
}



PROC (s_tcl_untrace_var2, "tcl-untrace-var2", 5, 0, 0, scm_tcl_untrace_var2);
#ifdef __STDC__
SCM
scm_tcl_untrace_var2 (SCM tobj, SCM name, SCM index, SCM flags, SCM thunk)
#else
SCM
scm_tcl_untrace_var2 (tobj, name, index, flags, thunk)
     SCM tobj;
     SCM name;
     SCM index;
     SCM flags;
     SCM thunk;
#endif
{
  ASSERT (NIMP (tobj) && TERPP (tobj), tobj, ARG1, s_tcl_untrace_var2);
  ASSERT (NIMP (name)
	  && (SYMBOLP (name) || STRINGP (name)),
	  name, ARG2, s_tcl_untrace_var2);
  ASSERT ((NIMP (name) && (SYMBOLP (name) || STRINGP (name))),
	  name, ARG2, s_tcl_untrace_var2);
  ASSERT ((BOOL_F == index)
	  || (NIMP (index)
	      && (SYMBOLP (index) || STRINGP (index))),
	  name, ARG3, s_tcl_untrace_var2);
  ASSERT (INUMP (flags), flags, ARG4, s_tcl_untrace_var2);
  ASSERT (scm_procedurep (thunk), thunk, ARG5, s_tcl_untrace_var2);

#ifdef I18N
  if (MB_STRINGP (name)) {
    int len;
    char *bufp;
    gscm_2_foreign_str (&bufp, &len, &name, tcl_encoding (TERP (tobj)));
  }
#endif

  {
    SCM pos;
    pos = PROPS (tobj);
    while (pos != BOOL_F)
      {
	if (CAR (CAR (pos)) == thunk)
	  {
	    DEFER_INTS;
	    Tcl_UntraceVar2 (TERP (tobj),
			     CHARS (name),
			     ((BOOL_F == index)
			      ? 0
			      : CHARS (index)),
			     flags,
			     trace_variable,
			     (ClientData)CAR (pos));
	    ALLOW_INTS;
	    PROPS (tobj) = scm_delq_x (CAR (pos), PROPS (tobj));
	    return UNSPECIFIED;
	  }
	pos = CDR (pos);
      }
    return UNSPECIFIED;
  }
}



PROC (s_tcl_set_var2, "tcl-set-var2", 5, 0, 0, scm_tcl_set_var2);
#ifdef __STDC__
SCM
scm_tcl_set_var2 (SCM tobj, SCM name, SCM index, SCM value, SCM flags)
#else
SCM
scm_tcl_set_var2 (tobj, name, index, value, flags)
     SCM tobj;
     SCM name;
     SCM index;
     SCM value;
     SCM flags;
#endif
{
  char * c_answer;
  ASSERT (NIMP (tobj) && TERPP (tobj), tobj, ARG1, s_tcl_set_var2);
  ASSERT (NIMP (name)
	  && (SYMBOLP (name) || STRINGP (name)),
	  name, ARG2, s_tcl_set_var2);
  ASSERT ((NIMP (name) && (SYMBOLP (name) || STRINGP (name))),
	  name, ARG2, s_tcl_set_var2);
  ASSERT ((BOOL_F == index)
	  || (NIMP (index)
	      && (SYMBOLP (index) || STRINGP (index))),
	  name, ARG3, s_tcl_set_var2);
  ASSERT (NIMP (value) && (STRINGP (value) || SYMBOLP (value)),
	  value, ARG4, s_tcl_set_var2);
  ASSERT (INUMP (flags), flags, ARG5, s_tcl_set_var2);

#ifdef I18N
  {
    int len;
    char *bufp;
    if (MB_STRINGP (name))
      gscm_2_foreign_str (&bufp, &len, &name, tcl_encoding (TERP (tobj)));
    if (MB_STRINGP (value))
      gscm_2_foreign_str (&bufp, &len, &value, tcl_encoding (TERP (tobj)));
  }
#endif /* I18N */

  DEFER_INTS;
  c_answer = Tcl_SetVar2 (TERP (tobj),
			  CHARS (name),
			  ((index == BOOL_F) ? 0 : CHARS (index)),
			  CHARS (value),
			  INUM (flags));
  ALLOW_INTS;
  /* !!! leaking c_answer */
#ifndef I18N
  return makfrom0str_opt (c_answer);
#else
  return makfrom0mbstr (c_answer, tcl_encoding (TERP (tobj)));
#endif
}


PROC (s_tcl_get_var2, "tcl-get-var2", 4, 0, 0, scm_tcl_get_var2);
#ifdef __STDC__
SCM
scm_tcl_get_var2 (SCM tobj, SCM name, SCM index, SCM flags)
#else
SCM
scm_tcl_get_var2 (tobj, name, index, flags)
     SCM tobj;
     SCM name;
     SCM index;
     SCM flags;
#endif
{
  char * c_answer;
  ASSERT (NIMP (tobj) && TERPP (tobj), tobj, ARG1, s_tcl_get_var2);
  ASSERT (NIMP (name)
	  && (SYMBOLP (name) || STRINGP (name)),
	  name, ARG2, s_tcl_get_var2);
  ASSERT ((NIMP (name) && (SYMBOLP (name) || STRINGP (name))),
	  name, ARG2, s_tcl_get_var2);
  ASSERT ((BOOL_F == index)
	  || (NIMP (index)
	      && (SYMBOLP (index) || STRINGP (index))),
	  name, ARG3, s_tcl_get_var2);
  ASSERT (INUMP (flags), flags, ARG4, s_tcl_get_var2);

#ifdef I18N
  if (MB_STRINGP (name)) {
    int len;
    char *bufp;
    gscm_2_foreign_str (&bufp, &len, &name, tcl_encoding (TERP (tobj)));
  }
#endif

  DEFER_INTS;
  c_answer = Tcl_GetVar2 (TERP (tobj),
			  CHARS (name),
			  ((index == BOOL_F) ? 0 : CHARS (index)),
			  INUM (flags));
  ALLOW_INTS;
  /* !!! leaking c_answer */
#ifndef I18N
  return makfrom0str_opt (c_answer);
#else
  return makfrom0mbstr (c_answer, tcl_encoding (TERP (tobj)));
#endif
}




static void cmd_die P((SCM));
static struct gscm_type tcl_command_type = { "tcl-command", 0, 0, cmd_die };

struct tcl_command
{
  SCM tobj;
  SCM name;
  Tcl_CmdInfo info;
};

/* when the scheme object dies: */
#ifdef __STDC__
static void
cmd_die (SCM obj)
#else
static void
cmd_die (obj)
     SCM obj;
#endif
{
  struct tcl_command * command;
  struct Tcl_CmdInfo * info;

  command = (struct tcl_command *)gscm_unwrap_obj (&tcl_command_type, &obj);
  info = &command->info;
  info->appDeleteProc = 0;
  info->appDeleteData = 0;
  info->appChangeProc = 0;
  Tcl_SetCommandAppInfo (TERP (command->tobj), CHARS (command->name), info);
}

/* when the tcl object dies */
#ifdef __STDC__
static void
command_app_delete (SCM data)
#else
static void
command_app_delete (data)
     SCM data;
#endif
{
  struct tcl_command * command;
  Tcl_CmdInfo * info;

  command = (struct tcl_command *)gscm_unwrap_obj (&tcl_command_type, &data);
  info = &command->info;
  info->proc = 0;
}

#ifdef __STDC__
static void
command_app_change (Tcl_CmdInfo * data)
#else
static void
command_app_change (data)
     Tcl_CmdInfo * data;
#endif
{
  struct tcl_command * command;
  Tcl_CmdInfo * info;

  command = (struct tcl_command *)gscm_unwrap_obj (&tcl_command_type,
						   data->appDeleteData);
  info = &command->info;
  info->proc = 0;
}


PROC (s_tcl_command, "tcl-command", 2, 0, 0, scm_tcl_command);
#ifdef __STDC__
SCM
scm_tcl_command (SCM tobj, SCM name)
#else
SCM
scm_tcl_command (tobj, name)
     SCM tobj;
     SCM name;
#endif
{
  Tcl_CmdInfo info;
  int status;

  ASSERT (NIMP (tobj) && TERPP (tobj), tobj, ARG1, s_tcl_command);
#ifdef I18N
  if (MB_STRINGP (name)) {
    int len;
    char *bufp;
    gscm_2_foreign_str (&bufp, &len, &name, tcl_encoding (TERP (tobj)));
  }
#endif /* I18N */
  DEFER_INTS;
  status = Tcl_GetCommandInfo (TERP (tobj), CHARS (name), &info);
  ALLOW_INTS;

  if (!status)
    return BOOL_F;
  
  if (info.appDeleteData)
    return (SCM)info.appDeleteData;

  {
    SCM answer;
    struct tcl_command * command;
    Tcl_CmdInfo * infop;

    answer = gscm_alloc (&tcl_command_type, sizeof (struct tcl_command));
    command = (struct tcl_command *)gscm_unwrap_obj (&tcl_command_type, &answer);
    infop = &command->info;

    DEFER_INTS;
    *infop = info;
    infop->appDeleteData = (ClientData) answer;
    infop->appDeleteProc = command_app_delete;
    infop->appChangeProc = command_app_change;
    Tcl_SetCommandAppInfo (TERP (tobj), CHARS (name), infop);
    ALLOW_INTS;
    command->tobj = tobj;
    command->name = scm_makfromstr (CHARS (name), LENGTH (name), 0);
    return answer;
  }
}

SCM tcl_type_converter = BOOL_F;
SCM tcc_symbol = BOOL_F;

PROC (s_tcl_apply_command, "tcl-apply-command", 2, 0, 0, scm_tcl_apply_command);
#ifdef __STDC__
SCM
scm_tcl_apply_command (SCM command, SCM args)
#else
SCM
scm_tcl_apply_command (command, args)
     SCM command;
     SCM args;
#endif
{
  struct tcl_command * cmd_data;
  Tcl_CmdInfo * info;
  int argc;
  char ** argv;
  int status;
  char static_result[TCL_RESULT_SIZE];
  SCM number_name;
  SCM answer;
  char * default_argv[2];
#ifdef I18N
  SCM lst = EOL;
#endif
  
  cmd_data= (struct tcl_command *)gscm_unwrap_obj (&tcl_command_type, &command);
  info = &cmd_data->info;

  if (!info->proc)
    {
      SCM renewed;
      renewed = scm_tcl_command (cmd_data->tobj, cmd_data->name);
      if (renewed != BOOL_F)
	{
	  DEFER_INTS;
	  *info = ((struct tcl_command *)
		   gscm_unwrap_obj (&tcl_command_type, &renewed))->info;
	  ALLOW_INTS;
	  cmd_die (renewed);
	  DEFER_INTS;
	  info->appDeleteData = (ClientData) command;
	  Tcl_SetCommandAppInfo (TERP (cmd_data->tobj),
				 CHARS (cmd_data->name),
				 info);
	  ALLOW_INTS;
	}
    }

  ASSERT (!!info->proc, command, "command has expired", s_tcl_apply_command);

  argc = scm_ilength (args);
  ASSERT (argc >= 0, args, ARG2, s_tcl_apply_command);
  if (argc == 0)
    argv = default_argv;
  else
    {
      int i;
      DEFER_INTS;
      argv = (char **)alloca (sizeof (char *) * (argc + 1));
      ALLOW_INTS;
      for (i = 0; i < argc; ++i)
	{
	  SCM item;

	  item = CAR (args);

	retry_item:
	  if (IMP (item))
	    {
	      if (INUMP (item))
		{
		  char * storage;
		  storage = alloca (sizeof(long) * 8);
		  sprintf (storage, "%d", INUM (item));
		  argv[i + 1] = storage;
		}
	      else if (item == BOOL_T)
		argv[i + 1] = "1";
	      else if (item == BOOL_F)
		argv[i + 1] = "0";
	      else if (scm_procedurep (item))
		{
		  static int count = 0;
		  char name[64];
		  char * calling_conventions;
		  SCM conv_string;

		item_is_proc:
		  if (!CLOSUREP (item))
		    calling_conventions = "";
		  else
		    {
		      conv_string = gscm_procedure_property (item, tcc_symbol);
		      if (!(NIMP (conv_string) && STRINGP (conv_string)))
			calling_conventions = "";
		      else
			calling_conventions = CHARS (conv_string);
		      scm_remember (&conv_string);
		    }

		  sprintf (name, "__guile#%d", count);
		  {
		    SCM tobj;
		    tobj = cmd_data->tobj;
		    PROPS (tobj) = scm_acons (item, tobj, PROPS (tobj));
		    Tcl_CreateCommand (TERP (tobj), name,
				       invoke_tcl_command,
				       (ClientData)CAR (PROPS (tobj)),
				       delete_tcl_command);
		  }

		  {
		    char * arg_string;
		    arg_string = ((char *)
				  alloca (strlen (name) + 10
					  + strlen (calling_conventions)));
		    sprintf (arg_string, "*__guile#%d%s%s",
			     count,
			     (calling_conventions[0] ? " " : ""),
			     calling_conventions);
		    argv[i + 1] = arg_string;
		  }
		  ++count;
		}
	      else if ((item == UNSPECIFIED) || (item == SCM_UNDEFINED))
		{
		signal_type_error:
		  ASSERT (0, item, "unhandled type to tcl command",
			  s_tcl_apply_command);
		}
	      else
		{
		item_is_unhandled_type:
		  if (tcl_type_converter == BOOL_F)
		    goto signal_type_error;
		  else
		    {
		      item = scm_apply (CDR (tcl_type_converter),
					scm_cons (item, EOL), EOL);
		      goto retry_item;
		    }
		}
	    }
	  else if (KEYWORDP (item))
	    argv[i + 1] = CHARS (KEYWORDSYM (item));
	  else if (STRINGP (item) || SYMBOLP (item))
	    {
	      argv[i + 1] = CHARS (CAR (args));
#ifdef I18N
	      if (MB_STRINGP (CAR (args))) {
		int len;
		char *bufp;
		SCM s = CAR (args);
		gscm_2_foreign_str (&bufp, &len, &s,
				    tcl_encoding (TERP (cmd_data->tobj)));
		if (bufp) {
		  argv[i + 1] = bufp;
		  lst = scm_cons (s, lst);
		}
	      }
#endif
	    }
	  else if (NUMBERP (item))
	    {
	      number_name = scm_number_to_string (item, MAKINUM (10));
	      argv[i + 1] = CHARS (number_name);
	      scm_remember (&number_name);
	    }
	  else if (scm_procedurep (item))
	    {
	      goto item_is_proc;
	    }
	  else
	    {
	      goto item_is_unhandled_type;
	    }
	  args = CDR (args);
	}
    }
  argv[0] = CHARS (cmd_data->name);
  ++argc;
  DEFER_INTS;
  {
    register Interp *iptr;

    iptr = (Interp *) TERP (cmd_data->tobj);
    Tcl_FreeResult (iptr);
    iptr->result = iptr->resultSpace;
    iptr->resultSpace[0] = 0;

    status = info->proc (info->clientData, TERP (cmd_data->tobj), argc, argv);
    if (Tcl_AsyncReady ())
      status = Tcl_AsyncInvoke (TERP (cmd_data->tobj), status);

#ifndef I18N
    answer = scm_cons (MAKINUM (status),
		       makfrom0str (TERP (cmd_data->tobj)->result));
#else
    answer = scm_cons (MAKINUM (status),
		       makfrom0mbstr (TERP (cmd_data->tobj)->result,
				      tcl_encoding (TERP (cmd_data->tobj))));
#endif
  }
  ALLOW_INTS;
  return answer;
}





#ifdef __STDC__
void
scm_init_gtcl (void)
#else
void
scm_init_gtcl ()
#endif
{
  scm_tc16_tcl_interp = scm_newsmob (&tcl_interp_smob);
  tcl_type_converter = scm_sysintern ("tcl-type-converter", BOOL_F);
  tcc_symbol = scm_sysintern ("tcl-calling-convention", BOOL_F);
  CDR (tcc_symbol) = CAR (tcc_symbol);
  tcc_symbol = CAR (tcc_symbol);

  id_fn = scm_make_gsubr (s_id_fn, 1, 0, 0, scm_id_fn);
#include "guile-tcl.x"
}


