% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guides-axis.r
\name{guide_axis}
\alias{guide_axis}
\title{Axis guide}
\usage{
guide_axis(
  title = waiver(),
  check.overlap = FALSE,
  angle = NULL,
  n.dodge = 1,
  order = 0,
  position = waiver()
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[=waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[=labs]{labs()}} is used for the title.}

\item{check.overlap}{silently remove overlapping labels,
(recursively) prioritizing the first, last, and middle labels.}

\item{angle}{Compared to setting the angle in \code{\link[=theme]{theme()}} / \code{\link[=element_text]{element_text()}},
this also uses some heuristics to automatically pick the \code{hjust} and \code{vjust} that
you probably want.}

\item{n.dodge}{The number of rows (for vertical axes) or columns (for
horizontal axes) that should be used to render the labels. This is
useful for displaying labels that would otherwise overlap.}

\item{order}{Used to determine the order of the guides (left-to-right,
top-to-bottom), if more than one  guide must be drawn at the same location.}

\item{position}{Where this guide should be drawn: one of top, bottom,
left, or right.}
}
\description{
Axis guides are the visual representation of position scales like those
created with \link[=scale_x_continuous]{scale_(x|y)_continuous()} and
\link[=scale_x_discrete]{scale_(x|y)_discrete()}.
}
\examples{
# plot with overlapping text
p <- ggplot(mpg, aes(cty * 100, hwy * 100)) +
  geom_point() +
  facet_wrap(vars(class))

# axis guides can be customized in the scale_* functions or
# using guides()
p + scale_x_continuous(guide = guide_axis(n.dodge = 2))
p + guides(x = guide_axis(angle = 90))

# can also be used to add a duplicate guide
p + guides(x = guide_axis(n.dodge = 2), y.sec = guide_axis())


}
