/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumFormatAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumLetterSyncAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumPrefixAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumSuffixAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextCitationBodyStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextCitationStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextDefaultStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextFootnotesPositionAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextMasterPageNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextNoteClassAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStartNumberingAtAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStartValueAttribute;

/**
 * DOM implementation of OpenDocument element  {@odf.element text:notes-configuration}.
 *
 */
public class TextNotesConfigurationElement extends OdfElement {

	public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "notes-configuration");

	/**
	 * Create the instance of <code>TextNotesConfigurationElement</code>
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public TextNotesConfigurationElement(OdfFileDom ownerDoc) {
		super(ownerDoc, ELEMENT_NAME);
	}

	/**
	 * Get the element name
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element text:notes-configuration}.
	 */
	public OdfName getOdfName() {
		return ELEMENT_NAME;
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleNumFormatAttribute</code> , See {@odf.attribute style:num-format}
	 *
	 * Attribute is mandatory.
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleNumFormatAttribute() {
		StyleNumFormatAttribute attr = (StyleNumFormatAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "num-format");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleNumFormatAttribute</code> , See {@odf.attribute style:num-format}
	 *
	 * @param styleNumFormatValue   The type is <code>String</code>
	 */
	public void setStyleNumFormatAttribute(String styleNumFormatValue) {
		StyleNumFormatAttribute attr = new StyleNumFormatAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleNumFormatValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleNumLetterSyncAttribute</code> , See {@odf.attribute style:num-letter-sync}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleNumLetterSyncAttribute() {
		StyleNumLetterSyncAttribute attr = (StyleNumLetterSyncAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "num-letter-sync");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleNumLetterSyncAttribute</code> , See {@odf.attribute style:num-letter-sync}
	 *
	 * @param styleNumLetterSyncValue   The type is <code>Boolean</code>
	 */
	public void setStyleNumLetterSyncAttribute(Boolean styleNumLetterSyncValue) {
		StyleNumLetterSyncAttribute attr = new StyleNumLetterSyncAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(styleNumLetterSyncValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleNumPrefixAttribute</code> , See {@odf.attribute style:num-prefix}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleNumPrefixAttribute() {
		StyleNumPrefixAttribute attr = (StyleNumPrefixAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "num-prefix");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleNumPrefixAttribute</code> , See {@odf.attribute style:num-prefix}
	 *
	 * @param styleNumPrefixValue   The type is <code>String</code>
	 */
	public void setStyleNumPrefixAttribute(String styleNumPrefixValue) {
		StyleNumPrefixAttribute attr = new StyleNumPrefixAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleNumPrefixValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleNumSuffixAttribute</code> , See {@odf.attribute style:num-suffix}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleNumSuffixAttribute() {
		StyleNumSuffixAttribute attr = (StyleNumSuffixAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "num-suffix");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleNumSuffixAttribute</code> , See {@odf.attribute style:num-suffix}
	 *
	 * @param styleNumSuffixValue   The type is <code>String</code>
	 */
	public void setStyleNumSuffixAttribute(String styleNumSuffixValue) {
		StyleNumSuffixAttribute attr = new StyleNumSuffixAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleNumSuffixValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextCitationBodyStyleNameAttribute</code> , See {@odf.attribute text:citation-body-style-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextCitationBodyStyleNameAttribute() {
		TextCitationBodyStyleNameAttribute attr = (TextCitationBodyStyleNameAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "citation-body-style-name");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TextCitationBodyStyleNameAttribute</code> , See {@odf.attribute text:citation-body-style-name}
	 *
	 * @param textCitationBodyStyleNameValue   The type is <code>String</code>
	 */
	public void setTextCitationBodyStyleNameAttribute(String textCitationBodyStyleNameValue) {
		TextCitationBodyStyleNameAttribute attr = new TextCitationBodyStyleNameAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(textCitationBodyStyleNameValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextCitationStyleNameAttribute</code> , See {@odf.attribute text:citation-style-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextCitationStyleNameAttribute() {
		TextCitationStyleNameAttribute attr = (TextCitationStyleNameAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "citation-style-name");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TextCitationStyleNameAttribute</code> , See {@odf.attribute text:citation-style-name}
	 *
	 * @param textCitationStyleNameValue   The type is <code>String</code>
	 */
	public void setTextCitationStyleNameAttribute(String textCitationStyleNameValue) {
		TextCitationStyleNameAttribute attr = new TextCitationStyleNameAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(textCitationStyleNameValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextDefaultStyleNameAttribute</code> , See {@odf.attribute text:default-style-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextDefaultStyleNameAttribute() {
		TextDefaultStyleNameAttribute attr = (TextDefaultStyleNameAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "default-style-name");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TextDefaultStyleNameAttribute</code> , See {@odf.attribute text:default-style-name}
	 *
	 * @param textDefaultStyleNameValue   The type is <code>String</code>
	 */
	public void setTextDefaultStyleNameAttribute(String textDefaultStyleNameValue) {
		TextDefaultStyleNameAttribute attr = new TextDefaultStyleNameAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(textDefaultStyleNameValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextFootnotesPositionAttribute</code> , See {@odf.attribute text:footnotes-position}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextFootnotesPositionAttribute() {
		TextFootnotesPositionAttribute attr = (TextFootnotesPositionAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "footnotes-position");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TextFootnotesPositionAttribute</code> , See {@odf.attribute text:footnotes-position}
	 *
	 * @param textFootnotesPositionValue   The type is <code>String</code>
	 */
	public void setTextFootnotesPositionAttribute(String textFootnotesPositionValue) {
		TextFootnotesPositionAttribute attr = new TextFootnotesPositionAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(textFootnotesPositionValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextMasterPageNameAttribute</code> , See {@odf.attribute text:master-page-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextMasterPageNameAttribute() {
		TextMasterPageNameAttribute attr = (TextMasterPageNameAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "master-page-name");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TextMasterPageNameAttribute</code> , See {@odf.attribute text:master-page-name}
	 *
	 * @param textMasterPageNameValue   The type is <code>String</code>
	 */
	public void setTextMasterPageNameAttribute(String textMasterPageNameValue) {
		TextMasterPageNameAttribute attr = new TextMasterPageNameAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(textMasterPageNameValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextNoteClassAttribute</code> , See {@odf.attribute text:note-class}
	 *
	 * Attribute is mandatory.
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextNoteClassAttribute() {
		TextNoteClassAttribute attr = (TextNoteClassAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "note-class");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TextNoteClassAttribute</code> , See {@odf.attribute text:note-class}
	 *
	 * @param textNoteClassValue   The type is <code>String</code>
	 */
	public void setTextNoteClassAttribute(String textNoteClassValue) {
		TextNoteClassAttribute attr = new TextNoteClassAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(textNoteClassValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextStartNumberingAtAttribute</code> , See {@odf.attribute text:start-numbering-at}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextStartNumberingAtAttribute() {
		TextStartNumberingAtAttribute attr = (TextStartNumberingAtAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "start-numbering-at");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TextStartNumberingAtAttribute</code> , See {@odf.attribute text:start-numbering-at}
	 *
	 * @param textStartNumberingAtValue   The type is <code>String</code>
	 */
	public void setTextStartNumberingAtAttribute(String textStartNumberingAtValue) {
		TextStartNumberingAtAttribute attr = new TextStartNumberingAtAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(textStartNumberingAtValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextStartValueAttribute</code> , See {@odf.attribute text:start-value}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTextStartValueAttribute() {
		TextStartValueAttribute attr = (TextStartValueAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "start-value");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return Integer.valueOf(TextStartValueAttribute.DEFAULT_VALUE);
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TextStartValueAttribute</code> , See {@odf.attribute text:start-value}
	 *
	 * @param textStartValueValue   The type is <code>Integer</code>
	 */
	public void setTextStartValueAttribute(Integer textStartValueValue) {
		TextStartValueAttribute attr = new TextStartValueAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(textStartValueValue.intValue());
	}

	/**
	 * Create child element {@odf.element text:note-continuation-notice-backward}.
	 *
	 * @return the element {@odf.element text:note-continuation-notice-backward}
	 */
	public TextNoteContinuationNoticeBackwardElement newTextNoteContinuationNoticeBackwardElement() {
		TextNoteContinuationNoticeBackwardElement textNoteContinuationNoticeBackward = ((OdfFileDom) this.ownerDocument).newOdfElement(TextNoteContinuationNoticeBackwardElement.class);
		this.appendChild(textNoteContinuationNoticeBackward);
		return textNoteContinuationNoticeBackward;
	}

	/**
	 * Create child element {@odf.element text:note-continuation-notice-forward}.
	 *
	 * @return the element {@odf.element text:note-continuation-notice-forward}
	 */
	public TextNoteContinuationNoticeForwardElement newTextNoteContinuationNoticeForwardElement() {
		TextNoteContinuationNoticeForwardElement textNoteContinuationNoticeForward = ((OdfFileDom) this.ownerDocument).newOdfElement(TextNoteContinuationNoticeForwardElement.class);
		this.appendChild(textNoteContinuationNoticeForward);
		return textNoteContinuationNoticeForward;
	}

	@Override
	public void accept(ElementVisitor visitor) {
		if (visitor instanceof DefaultElementVisitor) {
			DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
			defaultVisitor.visit(this);
		} else {
			visitor.visit(this);
		}
	}
}
