# frozen_string_literal: true

require 'spec_helper'
require_migration!

RSpec.describe FinalizeFixVulnerabilityReadsHasIssues, feature_category: :vulnerability_management do
  it 'finalizes FixVulnerabilityReadsHasIssues migration' do
    expect_next_instance_of(described_class) do |instance|
      expect(instance).to receive(:ensure_batched_background_migration_is_finished).with(
        job_class_name: 'FixVulnerabilityReadsHasIssues',
        table_name: :vulnerability_issue_links,
        column_name: :vulnerability_id,
        job_arguments: [],
        finalize: true
      )
    end

    migrate!
  end
end
