# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network lb frontend-ip update",
)
class Update(AAZCommand):
    """Update a frontend IP address.

    :example: Update the frontend IP address of a public load balancer.
        az network lb frontend-ip update -g MyResourceGroup --lb-name MyLb -n MyFrontendIp --public-ip-address MyNewPublicIp

    :example: Update the frontend IP address of an internal load balancer.
        az network lb frontend-ip update -g MyResourceGroup --lb-name MyLb -n MyFrontendIp --private-ip-address 10.10.10.50
    """

    _aaz_info = {
        "version": "2022-05-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/loadbalancers/{}", "2022-05-01", "properties.frontendIPConfigurations[]"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    AZ_SUPPORT_GENERIC_UPDATE = True

    def _handler(self, command_args):
        super()._handler(command_args)
        self.SubresourceSelector(ctx=self.ctx, name="subresource")
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.lb_name = AAZStrArg(
            options=["--lb-name"],
            help="The load balancer name.",
            required=True,
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="The name of the frontend IP configuration.",
            required=True,
        )

        # define Arg Group "Parameters.properties.frontendIPConfigurations[]"

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.gateway_lb = AAZStrArg(
            options=["--gateway-lb"],
            arg_group="Properties",
            help="The reference to gateway load balancer frontend IP.",
            nullable=True,
        )
        _args_schema.private_ip_address = AAZStrArg(
            options=["--private-ip-address"],
            arg_group="Properties",
            help="Static private IP address to associate with the configuration.",
            nullable=True,
        )
        _args_schema.private_ip_address_version = AAZStrArg(
            options=["--private-ipv", "--private-ip-address-version"],
            arg_group="Properties",
            help="Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.",
            nullable=True,
            enum={"IPv4": "IPv4", "IPv6": "IPv6"},
        )
        _args_schema.private_ip_allocation_method = AAZStrArg(
            options=["--private-ip-allocation-method"],
            arg_group="Properties",
            help="The Private IP allocation method.",
            nullable=True,
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        _args_schema.public_ip_address = AAZResourceIdArg(
            options=["--public-ip-address"],
            arg_group="Properties",
            help="Name or ID of the existing public IP to associate with the configuration.",
            nullable=True,
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/publicIPAddresses/{}",
            ),
        )
        _args_schema.public_ip_prefix = AAZStrArg(
            options=["--public-ip-prefix"],
            arg_group="Properties",
            help="Name or ID of a public IP prefix.",
            nullable=True,
        )
        _args_schema.subnet = AAZResourceIdArg(
            options=["--subnet"],
            arg_group="Properties",
            help="Resource ID.",
            nullable=True,
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/virtualNetworks/{}/subnets/{}",
            ),
        )
        _args_schema.zones = AAZListArg(
            options=["-z", "--zone", "--zones"],
            arg_group="Properties",
            help="A list of availability zones denoting the IP allocated for the resource needs to come from.",
            nullable=True,
        )

        zones = cls._args_schema.zones
        zones.Element = AAZStrArg(
            nullable=True,
        )

        # define Arg Group "PublicIpAddress"

        # define Arg Group "Subnet"
        return cls._args_schema

    _args_application_security_group_update = None

    @classmethod
    def _build_args_application_security_group_update(cls, _schema):
        if cls._args_application_security_group_update is not None:
            _schema.location = cls._args_application_security_group_update.location
            _schema.tags = cls._args_application_security_group_update.tags
            return

        cls._args_application_security_group_update = AAZObjectArg(
            nullable=True,
        )

        application_security_group_update = cls._args_application_security_group_update
        application_security_group_update.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            nullable=True,
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        application_security_group_update.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
            nullable=True,
        )

        tags = cls._args_application_security_group_update.tags
        tags.Element = AAZStrArg(
            nullable=True,
        )

        _schema.location = cls._args_application_security_group_update.location
        _schema.tags = cls._args_application_security_group_update.tags

    _args_extended_location_update = None

    @classmethod
    def _build_args_extended_location_update(cls, _schema):
        if cls._args_extended_location_update is not None:
            _schema.name = cls._args_extended_location_update.name
            _schema.type = cls._args_extended_location_update.type
            return

        cls._args_extended_location_update = AAZObjectArg(
            nullable=True,
        )

        extended_location_update = cls._args_extended_location_update
        extended_location_update.name = AAZStrArg(
            options=["name"],
            help="The name of the extended location.",
            nullable=True,
        )
        extended_location_update.type = AAZStrArg(
            options=["type"],
            help="The type of the extended location.",
            nullable=True,
            enum={"EdgeZone": "EdgeZone"},
        )

        _schema.name = cls._args_extended_location_update.name
        _schema.type = cls._args_extended_location_update.type

    _args_public_ip_address_update = None

    @classmethod
    def _build_args_public_ip_address_update(cls, _schema):
        if cls._args_public_ip_address_update is not None:
            _schema.ddos_settings = cls._args_public_ip_address_update.ddos_settings
            _schema.delete_option = cls._args_public_ip_address_update.delete_option
            _schema.dns_settings = cls._args_public_ip_address_update.dns_settings
            _schema.extended_location = cls._args_public_ip_address_update.extended_location
            _schema.id = cls._args_public_ip_address_update.id
            _schema.idle_timeout_in_minutes = cls._args_public_ip_address_update.idle_timeout_in_minutes
            _schema.ip_address = cls._args_public_ip_address_update.ip_address
            _schema.ip_tags = cls._args_public_ip_address_update.ip_tags
            _schema.linked_public_ip_address = cls._args_public_ip_address_update.linked_public_ip_address
            _schema.location = cls._args_public_ip_address_update.location
            _schema.migration_phase = cls._args_public_ip_address_update.migration_phase
            _schema.nat_gateway = cls._args_public_ip_address_update.nat_gateway
            _schema.public_ip_address_version = cls._args_public_ip_address_update.public_ip_address_version
            _schema.public_ip_allocation_method = cls._args_public_ip_address_update.public_ip_allocation_method
            _schema.public_ip_prefix = cls._args_public_ip_address_update.public_ip_prefix
            _schema.service_public_ip_address = cls._args_public_ip_address_update.service_public_ip_address
            _schema.sku = cls._args_public_ip_address_update.sku
            _schema.tags = cls._args_public_ip_address_update.tags
            _schema.zones = cls._args_public_ip_address_update.zones
            return

        cls._args_public_ip_address_update = AAZObjectArg(
            nullable=True,
        )

        public_ip_address_update = cls._args_public_ip_address_update
        public_ip_address_update.extended_location = AAZObjectArg(
            options=["extended-location"],
            help="The extended location of the public ip address.",
            nullable=True,
        )
        cls._build_args_extended_location_update(public_ip_address_update.extended_location)
        public_ip_address_update.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            nullable=True,
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/publicIPAddresses/{}",
            ),
        )
        public_ip_address_update.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            nullable=True,
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        public_ip_address_update.ddos_settings = AAZObjectArg(
            options=["ddos-settings"],
            help="The DDoS protection custom policy associated with the public IP address.",
            nullable=True,
        )
        public_ip_address_update.delete_option = AAZStrArg(
            options=["delete-option"],
            help="Specify what happens to the public IP address when the VM using it is deleted",
            nullable=True,
            enum={"Delete": "Delete", "Detach": "Detach"},
        )
        public_ip_address_update.dns_settings = AAZObjectArg(
            options=["dns-settings"],
            help="The FQDN of the DNS record associated with the public IP address.",
            nullable=True,
        )
        public_ip_address_update.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The idle timeout of the public IP address.",
            nullable=True,
        )
        public_ip_address_update.ip_address = AAZStrArg(
            options=["ip-address"],
            help="The IP address associated with the public IP address resource.",
            nullable=True,
        )
        public_ip_address_update.ip_tags = AAZListArg(
            options=["ip-tags"],
            help="The list of tags associated with the public IP address.",
            nullable=True,
        )
        public_ip_address_update.linked_public_ip_address = AAZObjectArg(
            options=["linked-public-ip-address"],
            help="The linked public IP address of the public IP address resource.",
            nullable=True,
        )
        cls._build_args_public_ip_address_update(public_ip_address_update.linked_public_ip_address)
        public_ip_address_update.migration_phase = AAZStrArg(
            options=["migration-phase"],
            help="Migration phase of Public IP Address.",
            nullable=True,
            enum={"Abort": "Abort", "Commit": "Commit", "Committed": "Committed", "None": "None", "Prepare": "Prepare"},
        )
        public_ip_address_update.nat_gateway = AAZObjectArg(
            options=["nat-gateway"],
            help="The NatGateway for the Public IP address.",
            nullable=True,
        )
        public_ip_address_update.public_ip_address_version = AAZStrArg(
            options=["public-ip-address-version"],
            help="The public IP address version.",
            nullable=True,
            enum={"IPv4": "IPv4", "IPv6": "IPv6"},
        )
        public_ip_address_update.public_ip_allocation_method = AAZStrArg(
            options=["public-ip-allocation-method"],
            help="The public IP address allocation method.",
            nullable=True,
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        public_ip_address_update.public_ip_prefix = AAZObjectArg(
            options=["public-ip-prefix"],
            help="The Public IP Prefix this Public IP Address should be allocated from.",
            nullable=True,
        )
        cls._build_args_sub_resource_update(public_ip_address_update.public_ip_prefix)
        public_ip_address_update.service_public_ip_address = AAZObjectArg(
            options=["service-public-ip-address"],
            help="The service public IP address of the public IP address resource.",
            nullable=True,
        )
        cls._build_args_public_ip_address_update(public_ip_address_update.service_public_ip_address)
        public_ip_address_update.sku = AAZObjectArg(
            options=["sku"],
            help="The public IP address SKU.",
            nullable=True,
        )
        public_ip_address_update.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
            nullable=True,
        )
        public_ip_address_update.zones = AAZListArg(
            options=["zones"],
            help="A list of availability zones denoting the IP allocated for the resource needs to come from.",
            nullable=True,
        )

        ddos_settings = cls._args_public_ip_address_update.ddos_settings
        ddos_settings.ddos_protection_plan = AAZObjectArg(
            options=["ddos-protection-plan"],
            help="The DDoS protection plan associated with the public IP. Can only be set if ProtectionMode is Enabled",
            nullable=True,
        )
        cls._build_args_sub_resource_update(ddos_settings.ddos_protection_plan)
        ddos_settings.protection_mode = AAZStrArg(
            options=["protection-mode"],
            help="The DDoS protection mode of the public IP",
            nullable=True,
            enum={"Disabled": "Disabled", "Enabled": "Enabled", "VirtualNetworkInherited": "VirtualNetworkInherited"},
        )

        dns_settings = cls._args_public_ip_address_update.dns_settings
        dns_settings.domain_name_label = AAZStrArg(
            options=["domain-name-label"],
            help="The domain name label. The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.",
            nullable=True,
        )
        dns_settings.fqdn = AAZStrArg(
            options=["fqdn"],
            help="The Fully Qualified Domain Name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.",
            nullable=True,
        )
        dns_settings.reverse_fqdn = AAZStrArg(
            options=["reverse-fqdn"],
            help="The reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.",
            nullable=True,
        )

        ip_tags = cls._args_public_ip_address_update.ip_tags
        ip_tags.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_public_ip_address_update.ip_tags.Element
        _element.ip_tag_type = AAZStrArg(
            options=["ip-tag-type"],
            help="The IP tag type. Example: FirstPartyUsage.",
            nullable=True,
        )
        _element.tag = AAZStrArg(
            options=["tag"],
            help="The value of the IP tag associated with the public IP. Example: SQL.",
            nullable=True,
        )

        nat_gateway = cls._args_public_ip_address_update.nat_gateway
        nat_gateway.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            nullable=True,
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/natGateways/{}",
            ),
        )
        nat_gateway.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            nullable=True,
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        nat_gateway.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The idle timeout of the nat gateway.",
            nullable=True,
        )
        nat_gateway.public_ip_addresses = AAZListArg(
            options=["public-ip-addresses"],
            help="An array of public ip addresses associated with the nat gateway resource.",
            nullable=True,
        )
        nat_gateway.public_ip_prefixes = AAZListArg(
            options=["public-ip-prefixes"],
            help="An array of public ip prefixes associated with the nat gateway resource.",
            nullable=True,
        )
        nat_gateway.sku = AAZObjectArg(
            options=["sku"],
            help="The nat gateway SKU.",
            nullable=True,
        )
        nat_gateway.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
            nullable=True,
        )
        nat_gateway.zones = AAZListArg(
            options=["zones"],
            help="A list of availability zones denoting the zone in which Nat Gateway should be deployed.",
            nullable=True,
        )

        public_ip_addresses = cls._args_public_ip_address_update.nat_gateway.public_ip_addresses
        public_ip_addresses.Element = AAZObjectArg(
            nullable=True,
        )
        cls._build_args_sub_resource_update(public_ip_addresses.Element)

        public_ip_prefixes = cls._args_public_ip_address_update.nat_gateway.public_ip_prefixes
        public_ip_prefixes.Element = AAZObjectArg(
            nullable=True,
        )
        cls._build_args_sub_resource_update(public_ip_prefixes.Element)

        sku = cls._args_public_ip_address_update.nat_gateway.sku
        sku.name = AAZStrArg(
            options=["name"],
            help="Name of Nat Gateway SKU.",
            nullable=True,
            enum={"Standard": "Standard"},
        )

        tags = cls._args_public_ip_address_update.nat_gateway.tags
        tags.Element = AAZStrArg(
            nullable=True,
        )

        zones = cls._args_public_ip_address_update.nat_gateway.zones
        zones.Element = AAZStrArg(
            nullable=True,
        )

        sku = cls._args_public_ip_address_update.sku
        sku.name = AAZStrArg(
            options=["name"],
            help="Name of a public IP address SKU.",
            nullable=True,
            enum={"Basic": "Basic", "Standard": "Standard"},
        )
        sku.tier = AAZStrArg(
            options=["tier"],
            help="Tier of a public IP address SKU.",
            nullable=True,
            enum={"Global": "Global", "Regional": "Regional"},
        )

        tags = cls._args_public_ip_address_update.tags
        tags.Element = AAZStrArg(
            nullable=True,
        )

        zones = cls._args_public_ip_address_update.zones
        zones.Element = AAZStrArg(
            nullable=True,
        )

        _schema.ddos_settings = cls._args_public_ip_address_update.ddos_settings
        _schema.delete_option = cls._args_public_ip_address_update.delete_option
        _schema.dns_settings = cls._args_public_ip_address_update.dns_settings
        _schema.extended_location = cls._args_public_ip_address_update.extended_location
        _schema.id = cls._args_public_ip_address_update.id
        _schema.idle_timeout_in_minutes = cls._args_public_ip_address_update.idle_timeout_in_minutes
        _schema.ip_address = cls._args_public_ip_address_update.ip_address
        _schema.ip_tags = cls._args_public_ip_address_update.ip_tags
        _schema.linked_public_ip_address = cls._args_public_ip_address_update.linked_public_ip_address
        _schema.location = cls._args_public_ip_address_update.location
        _schema.migration_phase = cls._args_public_ip_address_update.migration_phase
        _schema.nat_gateway = cls._args_public_ip_address_update.nat_gateway
        _schema.public_ip_address_version = cls._args_public_ip_address_update.public_ip_address_version
        _schema.public_ip_allocation_method = cls._args_public_ip_address_update.public_ip_allocation_method
        _schema.public_ip_prefix = cls._args_public_ip_address_update.public_ip_prefix
        _schema.service_public_ip_address = cls._args_public_ip_address_update.service_public_ip_address
        _schema.sku = cls._args_public_ip_address_update.sku
        _schema.tags = cls._args_public_ip_address_update.tags
        _schema.zones = cls._args_public_ip_address_update.zones

    _args_sub_resource_update = None

    @classmethod
    def _build_args_sub_resource_update(cls, _schema):
        if cls._args_sub_resource_update is not None:
            _schema.id = cls._args_sub_resource_update.id
            return

        cls._args_sub_resource_update = AAZObjectArg(
            nullable=True,
        )

        sub_resource_update = cls._args_sub_resource_update
        sub_resource_update.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
            nullable=True,
        )

        _schema.id = cls._args_sub_resource_update.id

    def _execute_operations(self):
        self.pre_operations()
        self.LoadBalancersGet(ctx=self.ctx)()
        self.pre_instance_update(self.ctx.selectors.subresource.required())
        self.InstanceUpdateByJson(ctx=self.ctx)()
        self.InstanceUpdateByGeneric(ctx=self.ctx)()
        self.post_instance_update(self.ctx.selectors.subresource.required())
        yield self.LoadBalancersCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    @register_callback
    def pre_instance_update(self, instance):
        pass

    @register_callback
    def post_instance_update(self, instance):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.selectors.subresource.required(), client_flatten=True)
        return result

    class SubresourceSelector(AAZJsonSelector):

        def _get(self):
            result = self.ctx.vars.instance
            result = result.properties.frontendIPConfigurations
            filters = enumerate(result)
            filters = filter(
                lambda e: e[1].name == self.ctx.args.name,
                filters
            )
            idx = next(filters)[0]
            return result[idx]

        def _set(self, value):
            result = self.ctx.vars.instance
            result = result.properties.frontendIPConfigurations
            filters = enumerate(result)
            filters = filter(
                lambda e: e[1].name == self.ctx.args.name,
                filters
            )
            idx = next(filters, [len(result)])[0]
            result[idx] = value
            return

    class LoadBalancersGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "loadBalancerName", self.ctx.args.lb_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-05-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_load_balancer_read(cls._schema_on_200)

            return cls._schema_on_200

    class LoadBalancersCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "loadBalancerName", self.ctx.args.lb_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-05-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()
            _UpdateHelper._build_schema_load_balancer_read(cls._schema_on_200_201)

            return cls._schema_on_200_201

    class InstanceUpdateByJson(AAZJsonInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance(self.ctx.selectors.subresource.required())

        def _update_instance(self, instance):
            _instance_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=instance,
                typ=AAZObjectType
            )
            _builder.set_prop("name", AAZStrType, ".name")
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("zones", AAZListType, ".zones")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("gatewayLoadBalancer", AAZObjectType)
                properties.set_prop("privateIPAddress", AAZStrType, ".private_ip_address")
                properties.set_prop("privateIPAddressVersion", AAZStrType, ".private_ip_address_version")
                properties.set_prop("privateIPAllocationMethod", AAZStrType, ".private_ip_allocation_method")
                properties.set_prop("publicIPAddress", AAZObjectType)
                properties.set_prop("publicIPPrefix", AAZObjectType)
                properties.set_prop("subnet", AAZObjectType)

            gateway_load_balancer = _builder.get(".properties.gatewayLoadBalancer")
            if gateway_load_balancer is not None:
                gateway_load_balancer.set_prop("id", AAZStrType, ".gateway_lb")

            public_ip_address = _builder.get(".properties.publicIPAddress")
            if public_ip_address is not None:
                public_ip_address.set_prop("id", AAZStrType, ".public_ip_address")
                public_ip_address.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            public_ip_prefix = _builder.get(".properties.publicIPPrefix")
            if public_ip_prefix is not None:
                public_ip_prefix.set_prop("id", AAZStrType, ".public_ip_prefix")

            subnet = _builder.get(".properties.subnet")
            if subnet is not None:
                subnet.set_prop("id", AAZStrType, ".subnet")
                subnet.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            zones = _builder.get(".zones")
            if zones is not None:
                zones.set_elements(AAZStrType, ".")

            return _instance_value

    class InstanceUpdateByGeneric(AAZGenericInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance_by_generic(
                self.ctx.selectors.subresource.required(),
                self.ctx.generic_update_args
            )


class _UpdateHelper:
    """Helper class for Update"""

    @classmethod
    def _build_schema_application_security_group_update(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("location", AAZStrType, ".location")
        _builder.set_prop("tags", AAZDictType, ".tags")

        tags = _builder.get(".tags")
        if tags is not None:
            tags.set_elements(AAZStrType, ".")

    @classmethod
    def _build_schema_extended_location_update(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("name", AAZStrType, ".name")
        _builder.set_prop("type", AAZStrType, ".type")

    @classmethod
    def _build_schema_public_ip_address_update(cls, _builder):
        if _builder is None:
            return
        cls._build_schema_extended_location_update(_builder.set_prop("extendedLocation", AAZObjectType, ".extended_location"))
        _builder.set_prop("id", AAZStrType, ".id")
        _builder.set_prop("location", AAZStrType, ".location")
        _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
        _builder.set_prop("sku", AAZObjectType, ".sku")
        _builder.set_prop("tags", AAZDictType, ".tags")
        _builder.set_prop("zones", AAZListType, ".zones")

        properties = _builder.get(".properties")
        if properties is not None:
            properties.set_prop("ddosSettings", AAZObjectType, ".ddos_settings")
            properties.set_prop("deleteOption", AAZStrType, ".delete_option")
            properties.set_prop("dnsSettings", AAZObjectType, ".dns_settings")
            properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
            properties.set_prop("ipAddress", AAZStrType, ".ip_address")
            properties.set_prop("ipTags", AAZListType, ".ip_tags")
            cls._build_schema_public_ip_address_update(properties.set_prop("linkedPublicIPAddress", AAZObjectType, ".linked_public_ip_address"))
            properties.set_prop("migrationPhase", AAZStrType, ".migration_phase")
            properties.set_prop("natGateway", AAZObjectType, ".nat_gateway")
            properties.set_prop("publicIPAddressVersion", AAZStrType, ".public_ip_address_version")
            properties.set_prop("publicIPAllocationMethod", AAZStrType, ".public_ip_allocation_method")
            cls._build_schema_sub_resource_update(properties.set_prop("publicIPPrefix", AAZObjectType, ".public_ip_prefix"))
            cls._build_schema_public_ip_address_update(properties.set_prop("servicePublicIPAddress", AAZObjectType, ".service_public_ip_address"))

        ddos_settings = _builder.get(".properties.ddosSettings")
        if ddos_settings is not None:
            cls._build_schema_sub_resource_update(ddos_settings.set_prop("ddosProtectionPlan", AAZObjectType, ".ddos_protection_plan"))
            ddos_settings.set_prop("protectionMode", AAZStrType, ".protection_mode")

        dns_settings = _builder.get(".properties.dnsSettings")
        if dns_settings is not None:
            dns_settings.set_prop("domainNameLabel", AAZStrType, ".domain_name_label")
            dns_settings.set_prop("fqdn", AAZStrType, ".fqdn")
            dns_settings.set_prop("reverseFqdn", AAZStrType, ".reverse_fqdn")

        ip_tags = _builder.get(".properties.ipTags")
        if ip_tags is not None:
            ip_tags.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.ipTags[]")
        if _elements is not None:
            _elements.set_prop("ipTagType", AAZStrType, "@PublicIPAddress_update.ip_tags.[].ip_tag_type")
            _elements.set_prop("tag", AAZStrType, "@PublicIPAddress_update.ip_tags.[].tag")

        nat_gateway = _builder.get(".properties.natGateway")
        if nat_gateway is not None:
            nat_gateway.set_prop("id", AAZStrType, ".id")
            nat_gateway.set_prop("location", AAZStrType, ".location")
            nat_gateway.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            nat_gateway.set_prop("sku", AAZObjectType, ".sku")
            nat_gateway.set_prop("tags", AAZDictType, ".tags")
            nat_gateway.set_prop("zones", AAZListType, ".zones")

        properties = _builder.get(".properties.natGateway.properties")
        if properties is not None:
            properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
            properties.set_prop("publicIpAddresses", AAZListType, ".public_ip_addresses")
            properties.set_prop("publicIpPrefixes", AAZListType, ".public_ip_prefixes")

        public_ip_addresses = _builder.get(".properties.natGateway.properties.publicIpAddresses")
        if public_ip_addresses is not None:
            cls._build_schema_sub_resource_update(public_ip_addresses.set_elements(AAZObjectType, "."))

        public_ip_prefixes = _builder.get(".properties.natGateway.properties.publicIpPrefixes")
        if public_ip_prefixes is not None:
            cls._build_schema_sub_resource_update(public_ip_prefixes.set_elements(AAZObjectType, "."))

        sku = _builder.get(".properties.natGateway.sku")
        if sku is not None:
            sku.set_prop("name", AAZStrType, ".name")

        tags = _builder.get(".properties.natGateway.tags")
        if tags is not None:
            tags.set_elements(AAZStrType, ".")

        zones = _builder.get(".properties.natGateway.zones")
        if zones is not None:
            zones.set_elements(AAZStrType, ".")

        sku = _builder.get(".sku")
        if sku is not None:
            sku.set_prop("name", AAZStrType, ".name")
            sku.set_prop("tier", AAZStrType, ".tier")

        tags = _builder.get(".tags")
        if tags is not None:
            tags.set_elements(AAZStrType, ".")

        zones = _builder.get(".zones")
        if zones is not None:
            zones.set_elements(AAZStrType, ".")

    @classmethod
    def _build_schema_sub_resource_update(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")

    _schema_application_security_group_read = None

    @classmethod
    def _build_schema_application_security_group_read(cls, _schema):
        if cls._schema_application_security_group_read is not None:
            _schema.etag = cls._schema_application_security_group_read.etag
            _schema.id = cls._schema_application_security_group_read.id
            _schema.location = cls._schema_application_security_group_read.location
            _schema.name = cls._schema_application_security_group_read.name
            _schema.properties = cls._schema_application_security_group_read.properties
            _schema.tags = cls._schema_application_security_group_read.tags
            _schema.type = cls._schema_application_security_group_read.type
            return

        cls._schema_application_security_group_read = _schema_application_security_group_read = AAZObjectType()

        application_security_group_read = _schema_application_security_group_read
        application_security_group_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        application_security_group_read.id = AAZStrType()
        application_security_group_read.location = AAZStrType()
        application_security_group_read.name = AAZStrType(
            flags={"read_only": True},
        )
        application_security_group_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        application_security_group_read.tags = AAZDictType()
        application_security_group_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_application_security_group_read.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )

        tags = _schema_application_security_group_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_application_security_group_read.etag
        _schema.id = cls._schema_application_security_group_read.id
        _schema.location = cls._schema_application_security_group_read.location
        _schema.name = cls._schema_application_security_group_read.name
        _schema.properties = cls._schema_application_security_group_read.properties
        _schema.tags = cls._schema_application_security_group_read.tags
        _schema.type = cls._schema_application_security_group_read.type

    _schema_backend_address_pool_read = None

    @classmethod
    def _build_schema_backend_address_pool_read(cls, _schema):
        if cls._schema_backend_address_pool_read is not None:
            _schema.etag = cls._schema_backend_address_pool_read.etag
            _schema.id = cls._schema_backend_address_pool_read.id
            _schema.name = cls._schema_backend_address_pool_read.name
            _schema.properties = cls._schema_backend_address_pool_read.properties
            _schema.type = cls._schema_backend_address_pool_read.type
            return

        cls._schema_backend_address_pool_read = _schema_backend_address_pool_read = AAZObjectType()

        backend_address_pool_read = _schema_backend_address_pool_read
        backend_address_pool_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        backend_address_pool_read.id = AAZStrType()
        backend_address_pool_read.name = AAZStrType()
        backend_address_pool_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        backend_address_pool_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_backend_address_pool_read.properties
        properties.backend_ip_configurations = AAZListType(
            serialized_name="backendIPConfigurations",
            flags={"read_only": True},
        )
        properties.drain_period_in_seconds = AAZIntType(
            serialized_name="drainPeriodInSeconds",
        )
        properties.inbound_nat_rules = AAZListType(
            serialized_name="inboundNatRules",
            flags={"read_only": True},
        )
        properties.load_balancer_backend_addresses = AAZListType(
            serialized_name="loadBalancerBackendAddresses",
        )
        properties.load_balancing_rules = AAZListType(
            serialized_name="loadBalancingRules",
            flags={"read_only": True},
        )
        properties.location = AAZStrType()
        properties.outbound_rule = AAZObjectType(
            serialized_name="outboundRule",
        )
        cls._build_schema_sub_resource_read(properties.outbound_rule)
        properties.outbound_rules = AAZListType(
            serialized_name="outboundRules",
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.tunnel_interfaces = AAZListType(
            serialized_name="tunnelInterfaces",
        )

        backend_ip_configurations = _schema_backend_address_pool_read.properties.backend_ip_configurations
        backend_ip_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

        inbound_nat_rules = _schema_backend_address_pool_read.properties.inbound_nat_rules
        inbound_nat_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(inbound_nat_rules.Element)

        load_balancer_backend_addresses = _schema_backend_address_pool_read.properties.load_balancer_backend_addresses
        load_balancer_backend_addresses.Element = AAZObjectType()

        _element = _schema_backend_address_pool_read.properties.load_balancer_backend_addresses.Element
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_backend_address_pool_read.properties.load_balancer_backend_addresses.Element.properties
        properties.admin_state = AAZStrType(
            serialized_name="adminState",
        )
        properties.inbound_nat_rules_port_mapping = AAZListType(
            serialized_name="inboundNatRulesPortMapping",
            flags={"read_only": True},
        )
        properties.ip_address = AAZStrType(
            serialized_name="ipAddress",
        )
        properties.load_balancer_frontend_ip_configuration = AAZObjectType(
            serialized_name="loadBalancerFrontendIPConfiguration",
        )
        cls._build_schema_sub_resource_read(properties.load_balancer_frontend_ip_configuration)
        properties.network_interface_ip_configuration = AAZObjectType(
            serialized_name="networkInterfaceIPConfiguration",
        )
        cls._build_schema_sub_resource_read(properties.network_interface_ip_configuration)
        properties.subnet = AAZObjectType()
        cls._build_schema_sub_resource_read(properties.subnet)
        properties.virtual_network = AAZObjectType(
            serialized_name="virtualNetwork",
        )
        cls._build_schema_sub_resource_read(properties.virtual_network)

        inbound_nat_rules_port_mapping = _schema_backend_address_pool_read.properties.load_balancer_backend_addresses.Element.properties.inbound_nat_rules_port_mapping
        inbound_nat_rules_port_mapping.Element = AAZObjectType()

        _element = _schema_backend_address_pool_read.properties.load_balancer_backend_addresses.Element.properties.inbound_nat_rules_port_mapping.Element
        _element.backend_port = AAZIntType(
            serialized_name="backendPort",
        )
        _element.frontend_port = AAZIntType(
            serialized_name="frontendPort",
        )
        _element.inbound_nat_rule_name = AAZStrType(
            serialized_name="inboundNatRuleName",
        )

        load_balancing_rules = _schema_backend_address_pool_read.properties.load_balancing_rules
        load_balancing_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(load_balancing_rules.Element)

        outbound_rules = _schema_backend_address_pool_read.properties.outbound_rules
        outbound_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(outbound_rules.Element)

        tunnel_interfaces = _schema_backend_address_pool_read.properties.tunnel_interfaces
        tunnel_interfaces.Element = AAZObjectType()

        _element = _schema_backend_address_pool_read.properties.tunnel_interfaces.Element
        _element.identifier = AAZIntType()
        _element.port = AAZIntType()
        _element.protocol = AAZStrType()
        _element.type = AAZStrType()

        _schema.etag = cls._schema_backend_address_pool_read.etag
        _schema.id = cls._schema_backend_address_pool_read.id
        _schema.name = cls._schema_backend_address_pool_read.name
        _schema.properties = cls._schema_backend_address_pool_read.properties
        _schema.type = cls._schema_backend_address_pool_read.type

    _schema_extended_location_read = None

    @classmethod
    def _build_schema_extended_location_read(cls, _schema):
        if cls._schema_extended_location_read is not None:
            _schema.name = cls._schema_extended_location_read.name
            _schema.type = cls._schema_extended_location_read.type
            return

        cls._schema_extended_location_read = _schema_extended_location_read = AAZObjectType()

        extended_location_read = _schema_extended_location_read
        extended_location_read.name = AAZStrType()
        extended_location_read.type = AAZStrType()

        _schema.name = cls._schema_extended_location_read.name
        _schema.type = cls._schema_extended_location_read.type

    _schema_frontend_ip_configuration_read = None

    @classmethod
    def _build_schema_frontend_ip_configuration_read(cls, _schema):
        if cls._schema_frontend_ip_configuration_read is not None:
            _schema.etag = cls._schema_frontend_ip_configuration_read.etag
            _schema.id = cls._schema_frontend_ip_configuration_read.id
            _schema.name = cls._schema_frontend_ip_configuration_read.name
            _schema.properties = cls._schema_frontend_ip_configuration_read.properties
            _schema.type = cls._schema_frontend_ip_configuration_read.type
            _schema.zones = cls._schema_frontend_ip_configuration_read.zones
            return

        cls._schema_frontend_ip_configuration_read = _schema_frontend_ip_configuration_read = AAZObjectType()

        frontend_ip_configuration_read = _schema_frontend_ip_configuration_read
        frontend_ip_configuration_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        frontend_ip_configuration_read.id = AAZStrType()
        frontend_ip_configuration_read.name = AAZStrType()
        frontend_ip_configuration_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        frontend_ip_configuration_read.type = AAZStrType(
            flags={"read_only": True},
        )
        frontend_ip_configuration_read.zones = AAZListType()

        properties = _schema_frontend_ip_configuration_read.properties
        properties.gateway_load_balancer = AAZObjectType(
            serialized_name="gatewayLoadBalancer",
        )
        cls._build_schema_sub_resource_read(properties.gateway_load_balancer)
        properties.inbound_nat_pools = AAZListType(
            serialized_name="inboundNatPools",
            flags={"read_only": True},
        )
        properties.inbound_nat_rules = AAZListType(
            serialized_name="inboundNatRules",
            flags={"read_only": True},
        )
        properties.load_balancing_rules = AAZListType(
            serialized_name="loadBalancingRules",
            flags={"read_only": True},
        )
        properties.outbound_rules = AAZListType(
            serialized_name="outboundRules",
            flags={"read_only": True},
        )
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )
        properties.private_ip_address_version = AAZStrType(
            serialized_name="privateIPAddressVersion",
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_public_ip_address_read(properties.public_ip_address)
        properties.public_ip_prefix = AAZObjectType(
            serialized_name="publicIPPrefix",
        )
        cls._build_schema_sub_resource_read(properties.public_ip_prefix)
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        inbound_nat_pools = _schema_frontend_ip_configuration_read.properties.inbound_nat_pools
        inbound_nat_pools.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(inbound_nat_pools.Element)

        inbound_nat_rules = _schema_frontend_ip_configuration_read.properties.inbound_nat_rules
        inbound_nat_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(inbound_nat_rules.Element)

        load_balancing_rules = _schema_frontend_ip_configuration_read.properties.load_balancing_rules
        load_balancing_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(load_balancing_rules.Element)

        outbound_rules = _schema_frontend_ip_configuration_read.properties.outbound_rules
        outbound_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(outbound_rules.Element)

        zones = _schema_frontend_ip_configuration_read.zones
        zones.Element = AAZStrType()

        _schema.etag = cls._schema_frontend_ip_configuration_read.etag
        _schema.id = cls._schema_frontend_ip_configuration_read.id
        _schema.name = cls._schema_frontend_ip_configuration_read.name
        _schema.properties = cls._schema_frontend_ip_configuration_read.properties
        _schema.type = cls._schema_frontend_ip_configuration_read.type
        _schema.zones = cls._schema_frontend_ip_configuration_read.zones

    _schema_ip_configuration_read = None

    @classmethod
    def _build_schema_ip_configuration_read(cls, _schema):
        if cls._schema_ip_configuration_read is not None:
            _schema.etag = cls._schema_ip_configuration_read.etag
            _schema.id = cls._schema_ip_configuration_read.id
            _schema.name = cls._schema_ip_configuration_read.name
            _schema.properties = cls._schema_ip_configuration_read.properties
            return

        cls._schema_ip_configuration_read = _schema_ip_configuration_read = AAZObjectType()

        ip_configuration_read = _schema_ip_configuration_read
        ip_configuration_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        ip_configuration_read.id = AAZStrType()
        ip_configuration_read.name = AAZStrType()
        ip_configuration_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_ip_configuration_read.properties
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_public_ip_address_read(properties.public_ip_address)
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        _schema.etag = cls._schema_ip_configuration_read.etag
        _schema.id = cls._schema_ip_configuration_read.id
        _schema.name = cls._schema_ip_configuration_read.name
        _schema.properties = cls._schema_ip_configuration_read.properties

    _schema_inbound_nat_rule_read = None

    @classmethod
    def _build_schema_inbound_nat_rule_read(cls, _schema):
        if cls._schema_inbound_nat_rule_read is not None:
            _schema.etag = cls._schema_inbound_nat_rule_read.etag
            _schema.id = cls._schema_inbound_nat_rule_read.id
            _schema.name = cls._schema_inbound_nat_rule_read.name
            _schema.properties = cls._schema_inbound_nat_rule_read.properties
            _schema.type = cls._schema_inbound_nat_rule_read.type
            return

        cls._schema_inbound_nat_rule_read = _schema_inbound_nat_rule_read = AAZObjectType()

        inbound_nat_rule_read = _schema_inbound_nat_rule_read
        inbound_nat_rule_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        inbound_nat_rule_read.id = AAZStrType()
        inbound_nat_rule_read.name = AAZStrType()
        inbound_nat_rule_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        inbound_nat_rule_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_inbound_nat_rule_read.properties
        properties.backend_address_pool = AAZObjectType(
            serialized_name="backendAddressPool",
        )
        cls._build_schema_sub_resource_read(properties.backend_address_pool)
        properties.backend_ip_configuration = AAZObjectType(
            serialized_name="backendIPConfiguration",
        )
        cls._build_schema_network_interface_ip_configuration_read(properties.backend_ip_configuration)
        properties.backend_port = AAZIntType(
            serialized_name="backendPort",
        )
        properties.enable_floating_ip = AAZBoolType(
            serialized_name="enableFloatingIP",
        )
        properties.enable_tcp_reset = AAZBoolType(
            serialized_name="enableTcpReset",
        )
        properties.frontend_ip_configuration = AAZObjectType(
            serialized_name="frontendIPConfiguration",
        )
        cls._build_schema_sub_resource_read(properties.frontend_ip_configuration)
        properties.frontend_port = AAZIntType(
            serialized_name="frontendPort",
        )
        properties.frontend_port_range_end = AAZIntType(
            serialized_name="frontendPortRangeEnd",
        )
        properties.frontend_port_range_start = AAZIntType(
            serialized_name="frontendPortRangeStart",
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.protocol = AAZStrType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        _schema.etag = cls._schema_inbound_nat_rule_read.etag
        _schema.id = cls._schema_inbound_nat_rule_read.id
        _schema.name = cls._schema_inbound_nat_rule_read.name
        _schema.properties = cls._schema_inbound_nat_rule_read.properties
        _schema.type = cls._schema_inbound_nat_rule_read.type

    _schema_load_balancer_read = None

    @classmethod
    def _build_schema_load_balancer_read(cls, _schema):
        if cls._schema_load_balancer_read is not None:
            _schema.etag = cls._schema_load_balancer_read.etag
            _schema.extended_location = cls._schema_load_balancer_read.extended_location
            _schema.id = cls._schema_load_balancer_read.id
            _schema.location = cls._schema_load_balancer_read.location
            _schema.name = cls._schema_load_balancer_read.name
            _schema.properties = cls._schema_load_balancer_read.properties
            _schema.sku = cls._schema_load_balancer_read.sku
            _schema.tags = cls._schema_load_balancer_read.tags
            _schema.type = cls._schema_load_balancer_read.type
            return

        cls._schema_load_balancer_read = _schema_load_balancer_read = AAZObjectType()

        load_balancer_read = _schema_load_balancer_read
        load_balancer_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        load_balancer_read.extended_location = AAZObjectType(
            serialized_name="extendedLocation",
        )
        cls._build_schema_extended_location_read(load_balancer_read.extended_location)
        load_balancer_read.id = AAZStrType()
        load_balancer_read.location = AAZStrType()
        load_balancer_read.name = AAZStrType(
            flags={"read_only": True},
        )
        load_balancer_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        load_balancer_read.sku = AAZObjectType()
        load_balancer_read.tags = AAZDictType()
        load_balancer_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_load_balancer_read.properties
        properties.backend_address_pools = AAZListType(
            serialized_name="backendAddressPools",
        )
        properties.frontend_ip_configurations = AAZListType(
            serialized_name="frontendIPConfigurations",
        )
        properties.inbound_nat_pools = AAZListType(
            serialized_name="inboundNatPools",
        )
        properties.inbound_nat_rules = AAZListType(
            serialized_name="inboundNatRules",
        )
        properties.load_balancing_rules = AAZListType(
            serialized_name="loadBalancingRules",
        )
        properties.outbound_rules = AAZListType(
            serialized_name="outboundRules",
        )
        properties.probes = AAZListType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )

        backend_address_pools = _schema_load_balancer_read.properties.backend_address_pools
        backend_address_pools.Element = AAZObjectType()
        cls._build_schema_backend_address_pool_read(backend_address_pools.Element)

        frontend_ip_configurations = _schema_load_balancer_read.properties.frontend_ip_configurations
        frontend_ip_configurations.Element = AAZObjectType()
        cls._build_schema_frontend_ip_configuration_read(frontend_ip_configurations.Element)

        inbound_nat_pools = _schema_load_balancer_read.properties.inbound_nat_pools
        inbound_nat_pools.Element = AAZObjectType()

        _element = _schema_load_balancer_read.properties.inbound_nat_pools.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_load_balancer_read.properties.inbound_nat_pools.Element.properties
        properties.backend_port = AAZIntType(
            serialized_name="backendPort",
            flags={"required": True},
        )
        properties.enable_floating_ip = AAZBoolType(
            serialized_name="enableFloatingIP",
        )
        properties.enable_tcp_reset = AAZBoolType(
            serialized_name="enableTcpReset",
        )
        properties.frontend_ip_configuration = AAZObjectType(
            serialized_name="frontendIPConfiguration",
        )
        cls._build_schema_sub_resource_read(properties.frontend_ip_configuration)
        properties.frontend_port_range_end = AAZIntType(
            serialized_name="frontendPortRangeEnd",
            flags={"required": True},
        )
        properties.frontend_port_range_start = AAZIntType(
            serialized_name="frontendPortRangeStart",
            flags={"required": True},
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.protocol = AAZStrType(
            flags={"required": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        inbound_nat_rules = _schema_load_balancer_read.properties.inbound_nat_rules
        inbound_nat_rules.Element = AAZObjectType()
        cls._build_schema_inbound_nat_rule_read(inbound_nat_rules.Element)

        load_balancing_rules = _schema_load_balancer_read.properties.load_balancing_rules
        load_balancing_rules.Element = AAZObjectType()

        _element = _schema_load_balancer_read.properties.load_balancing_rules.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_load_balancer_read.properties.load_balancing_rules.Element.properties
        properties.backend_address_pool = AAZObjectType(
            serialized_name="backendAddressPool",
        )
        cls._build_schema_sub_resource_read(properties.backend_address_pool)
        properties.backend_address_pools = AAZListType(
            serialized_name="backendAddressPools",
        )
        properties.backend_port = AAZIntType(
            serialized_name="backendPort",
        )
        properties.disable_outbound_snat = AAZBoolType(
            serialized_name="disableOutboundSnat",
        )
        properties.enable_floating_ip = AAZBoolType(
            serialized_name="enableFloatingIP",
        )
        properties.enable_tcp_reset = AAZBoolType(
            serialized_name="enableTcpReset",
        )
        properties.frontend_ip_configuration = AAZObjectType(
            serialized_name="frontendIPConfiguration",
        )
        cls._build_schema_sub_resource_read(properties.frontend_ip_configuration)
        properties.frontend_port = AAZIntType(
            serialized_name="frontendPort",
            flags={"required": True},
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.load_distribution = AAZStrType(
            serialized_name="loadDistribution",
        )
        properties.probe = AAZObjectType()
        cls._build_schema_sub_resource_read(properties.probe)
        properties.protocol = AAZStrType(
            flags={"required": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        backend_address_pools = _schema_load_balancer_read.properties.load_balancing_rules.Element.properties.backend_address_pools
        backend_address_pools.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(backend_address_pools.Element)

        outbound_rules = _schema_load_balancer_read.properties.outbound_rules
        outbound_rules.Element = AAZObjectType()

        _element = _schema_load_balancer_read.properties.outbound_rules.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_load_balancer_read.properties.outbound_rules.Element.properties
        properties.allocated_outbound_ports = AAZIntType(
            serialized_name="allocatedOutboundPorts",
        )
        properties.backend_address_pool = AAZObjectType(
            serialized_name="backendAddressPool",
            flags={"required": True},
        )
        cls._build_schema_sub_resource_read(properties.backend_address_pool)
        properties.enable_tcp_reset = AAZBoolType(
            serialized_name="enableTcpReset",
        )
        properties.frontend_ip_configurations = AAZListType(
            serialized_name="frontendIPConfigurations",
            flags={"required": True},
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.protocol = AAZStrType(
            flags={"required": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        frontend_ip_configurations = _schema_load_balancer_read.properties.outbound_rules.Element.properties.frontend_ip_configurations
        frontend_ip_configurations.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(frontend_ip_configurations.Element)

        probes = _schema_load_balancer_read.properties.probes
        probes.Element = AAZObjectType()

        _element = _schema_load_balancer_read.properties.probes.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_load_balancer_read.properties.probes.Element.properties
        properties.interval_in_seconds = AAZIntType(
            serialized_name="intervalInSeconds",
        )
        properties.load_balancing_rules = AAZListType(
            serialized_name="loadBalancingRules",
            flags={"read_only": True},
        )
        properties.number_of_probes = AAZIntType(
            serialized_name="numberOfProbes",
        )
        properties.port = AAZIntType(
            flags={"required": True},
        )
        properties.probe_threshold = AAZIntType(
            serialized_name="probeThreshold",
        )
        properties.protocol = AAZStrType(
            flags={"required": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.request_path = AAZStrType(
            serialized_name="requestPath",
        )

        load_balancing_rules = _schema_load_balancer_read.properties.probes.Element.properties.load_balancing_rules
        load_balancing_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(load_balancing_rules.Element)

        sku = _schema_load_balancer_read.sku
        sku.name = AAZStrType()
        sku.tier = AAZStrType()

        tags = _schema_load_balancer_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_load_balancer_read.etag
        _schema.extended_location = cls._schema_load_balancer_read.extended_location
        _schema.id = cls._schema_load_balancer_read.id
        _schema.location = cls._schema_load_balancer_read.location
        _schema.name = cls._schema_load_balancer_read.name
        _schema.properties = cls._schema_load_balancer_read.properties
        _schema.sku = cls._schema_load_balancer_read.sku
        _schema.tags = cls._schema_load_balancer_read.tags
        _schema.type = cls._schema_load_balancer_read.type

    _schema_network_interface_ip_configuration_read = None

    @classmethod
    def _build_schema_network_interface_ip_configuration_read(cls, _schema):
        if cls._schema_network_interface_ip_configuration_read is not None:
            _schema.etag = cls._schema_network_interface_ip_configuration_read.etag
            _schema.id = cls._schema_network_interface_ip_configuration_read.id
            _schema.name = cls._schema_network_interface_ip_configuration_read.name
            _schema.properties = cls._schema_network_interface_ip_configuration_read.properties
            _schema.type = cls._schema_network_interface_ip_configuration_read.type
            return

        cls._schema_network_interface_ip_configuration_read = _schema_network_interface_ip_configuration_read = AAZObjectType()

        network_interface_ip_configuration_read = _schema_network_interface_ip_configuration_read
        network_interface_ip_configuration_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        network_interface_ip_configuration_read.id = AAZStrType()
        network_interface_ip_configuration_read.name = AAZStrType()
        network_interface_ip_configuration_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        network_interface_ip_configuration_read.type = AAZStrType()

        properties = _schema_network_interface_ip_configuration_read.properties
        properties.application_gateway_backend_address_pools = AAZListType(
            serialized_name="applicationGatewayBackendAddressPools",
        )
        properties.application_security_groups = AAZListType(
            serialized_name="applicationSecurityGroups",
        )
        properties.gateway_load_balancer = AAZObjectType(
            serialized_name="gatewayLoadBalancer",
        )
        cls._build_schema_sub_resource_read(properties.gateway_load_balancer)
        properties.load_balancer_backend_address_pools = AAZListType(
            serialized_name="loadBalancerBackendAddressPools",
        )
        properties.load_balancer_inbound_nat_rules = AAZListType(
            serialized_name="loadBalancerInboundNatRules",
        )
        properties.primary = AAZBoolType()
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )
        properties.private_ip_address_version = AAZStrType(
            serialized_name="privateIPAddressVersion",
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.private_link_connection_properties = AAZObjectType(
            serialized_name="privateLinkConnectionProperties",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_public_ip_address_read(properties.public_ip_address)
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)
        properties.virtual_network_taps = AAZListType(
            serialized_name="virtualNetworkTaps",
        )

        application_gateway_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools
        application_gateway_backend_address_pools.Element = AAZObjectType()

        _element = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties
        properties.backend_addresses = AAZListType(
            serialized_name="backendAddresses",
        )
        properties.backend_ip_configurations = AAZListType(
            serialized_name="backendIPConfigurations",
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        backend_addresses = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties.backend_addresses
        backend_addresses.Element = AAZObjectType()

        _element = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties.backend_addresses.Element
        _element.fqdn = AAZStrType()
        _element.ip_address = AAZStrType(
            serialized_name="ipAddress",
        )

        backend_ip_configurations = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties.backend_ip_configurations
        backend_ip_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

        application_security_groups = _schema_network_interface_ip_configuration_read.properties.application_security_groups
        application_security_groups.Element = AAZObjectType()
        cls._build_schema_application_security_group_read(application_security_groups.Element)

        load_balancer_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools
        load_balancer_backend_address_pools.Element = AAZObjectType()
        cls._build_schema_backend_address_pool_read(load_balancer_backend_address_pools.Element)

        load_balancer_inbound_nat_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules
        load_balancer_inbound_nat_rules.Element = AAZObjectType()
        cls._build_schema_inbound_nat_rule_read(load_balancer_inbound_nat_rules.Element)

        private_link_connection_properties = _schema_network_interface_ip_configuration_read.properties.private_link_connection_properties
        private_link_connection_properties.fqdns = AAZListType(
            flags={"read_only": True},
        )
        private_link_connection_properties.group_id = AAZStrType(
            serialized_name="groupId",
            flags={"read_only": True},
        )
        private_link_connection_properties.required_member_name = AAZStrType(
            serialized_name="requiredMemberName",
            flags={"read_only": True},
        )

        fqdns = _schema_network_interface_ip_configuration_read.properties.private_link_connection_properties.fqdns
        fqdns.Element = AAZStrType()

        virtual_network_taps = _schema_network_interface_ip_configuration_read.properties.virtual_network_taps
        virtual_network_taps.Element = AAZObjectType()
        cls._build_schema_virtual_network_tap_read(virtual_network_taps.Element)

        _schema.etag = cls._schema_network_interface_ip_configuration_read.etag
        _schema.id = cls._schema_network_interface_ip_configuration_read.id
        _schema.name = cls._schema_network_interface_ip_configuration_read.name
        _schema.properties = cls._schema_network_interface_ip_configuration_read.properties
        _schema.type = cls._schema_network_interface_ip_configuration_read.type

    _schema_network_interface_tap_configuration_read = None

    @classmethod
    def _build_schema_network_interface_tap_configuration_read(cls, _schema):
        if cls._schema_network_interface_tap_configuration_read is not None:
            _schema.etag = cls._schema_network_interface_tap_configuration_read.etag
            _schema.id = cls._schema_network_interface_tap_configuration_read.id
            _schema.name = cls._schema_network_interface_tap_configuration_read.name
            _schema.properties = cls._schema_network_interface_tap_configuration_read.properties
            _schema.type = cls._schema_network_interface_tap_configuration_read.type
            return

        cls._schema_network_interface_tap_configuration_read = _schema_network_interface_tap_configuration_read = AAZObjectType()

        network_interface_tap_configuration_read = _schema_network_interface_tap_configuration_read
        network_interface_tap_configuration_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        network_interface_tap_configuration_read.id = AAZStrType()
        network_interface_tap_configuration_read.name = AAZStrType()
        network_interface_tap_configuration_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        network_interface_tap_configuration_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_interface_tap_configuration_read.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.virtual_network_tap = AAZObjectType(
            serialized_name="virtualNetworkTap",
        )
        cls._build_schema_virtual_network_tap_read(properties.virtual_network_tap)

        _schema.etag = cls._schema_network_interface_tap_configuration_read.etag
        _schema.id = cls._schema_network_interface_tap_configuration_read.id
        _schema.name = cls._schema_network_interface_tap_configuration_read.name
        _schema.properties = cls._schema_network_interface_tap_configuration_read.properties
        _schema.type = cls._schema_network_interface_tap_configuration_read.type

    _schema_network_interface_read = None

    @classmethod
    def _build_schema_network_interface_read(cls, _schema):
        if cls._schema_network_interface_read is not None:
            _schema.etag = cls._schema_network_interface_read.etag
            _schema.extended_location = cls._schema_network_interface_read.extended_location
            _schema.id = cls._schema_network_interface_read.id
            _schema.location = cls._schema_network_interface_read.location
            _schema.name = cls._schema_network_interface_read.name
            _schema.properties = cls._schema_network_interface_read.properties
            _schema.tags = cls._schema_network_interface_read.tags
            _schema.type = cls._schema_network_interface_read.type
            return

        cls._schema_network_interface_read = _schema_network_interface_read = AAZObjectType()

        network_interface_read = _schema_network_interface_read
        network_interface_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        network_interface_read.extended_location = AAZObjectType(
            serialized_name="extendedLocation",
        )
        cls._build_schema_extended_location_read(network_interface_read.extended_location)
        network_interface_read.id = AAZStrType()
        network_interface_read.location = AAZStrType()
        network_interface_read.name = AAZStrType(
            flags={"read_only": True},
        )
        network_interface_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        network_interface_read.tags = AAZDictType()
        network_interface_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_interface_read.properties
        properties.auxiliary_mode = AAZStrType(
            serialized_name="auxiliaryMode",
        )
        properties.disable_tcp_state_tracking = AAZBoolType(
            serialized_name="disableTcpStateTracking",
        )
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.dscp_configuration = AAZObjectType(
            serialized_name="dscpConfiguration",
        )
        cls._build_schema_sub_resource_read(properties.dscp_configuration)
        properties.enable_accelerated_networking = AAZBoolType(
            serialized_name="enableAcceleratedNetworking",
        )
        properties.enable_ip_forwarding = AAZBoolType(
            serialized_name="enableIPForwarding",
        )
        properties.hosted_workloads = AAZListType(
            serialized_name="hostedWorkloads",
            flags={"read_only": True},
        )
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
        )
        properties.mac_address = AAZStrType(
            serialized_name="macAddress",
            flags={"read_only": True},
        )
        properties.migration_phase = AAZStrType(
            serialized_name="migrationPhase",
        )
        properties.network_security_group = AAZObjectType(
            serialized_name="networkSecurityGroup",
        )
        cls._build_schema_network_security_group_read(properties.network_security_group)
        properties.nic_type = AAZStrType(
            serialized_name="nicType",
        )
        properties.primary = AAZBoolType(
            flags={"read_only": True},
        )
        properties.private_endpoint = AAZObjectType(
            serialized_name="privateEndpoint",
        )
        cls._build_schema_private_endpoint_read(properties.private_endpoint)
        properties.private_link_service = AAZObjectType(
            serialized_name="privateLinkService",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )
        properties.tap_configurations = AAZListType(
            serialized_name="tapConfigurations",
            flags={"read_only": True},
        )
        properties.virtual_machine = AAZObjectType(
            serialized_name="virtualMachine",
        )
        cls._build_schema_sub_resource_read(properties.virtual_machine)
        properties.vnet_encryption_supported = AAZBoolType(
            serialized_name="vnetEncryptionSupported",
            flags={"read_only": True},
        )
        properties.workload_type = AAZStrType(
            serialized_name="workloadType",
        )

        dns_settings = _schema_network_interface_read.properties.dns_settings
        dns_settings.applied_dns_servers = AAZListType(
            serialized_name="appliedDnsServers",
            flags={"read_only": True},
        )
        dns_settings.dns_servers = AAZListType(
            serialized_name="dnsServers",
        )
        dns_settings.internal_dns_name_label = AAZStrType(
            serialized_name="internalDnsNameLabel",
        )
        dns_settings.internal_domain_name_suffix = AAZStrType(
            serialized_name="internalDomainNameSuffix",
            flags={"read_only": True},
        )
        dns_settings.internal_fqdn = AAZStrType(
            serialized_name="internalFqdn",
            flags={"read_only": True},
        )

        applied_dns_servers = _schema_network_interface_read.properties.dns_settings.applied_dns_servers
        applied_dns_servers.Element = AAZStrType()

        dns_servers = _schema_network_interface_read.properties.dns_settings.dns_servers
        dns_servers.Element = AAZStrType()

        hosted_workloads = _schema_network_interface_read.properties.hosted_workloads
        hosted_workloads.Element = AAZStrType()

        ip_configurations = _schema_network_interface_read.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_ip_configuration_read(ip_configurations.Element)

        private_link_service = _schema_network_interface_read.properties.private_link_service
        private_link_service.etag = AAZStrType(
            flags={"read_only": True},
        )
        private_link_service.extended_location = AAZObjectType(
            serialized_name="extendedLocation",
        )
        cls._build_schema_extended_location_read(private_link_service.extended_location)
        private_link_service.id = AAZStrType()
        private_link_service.location = AAZStrType()
        private_link_service.name = AAZStrType(
            flags={"read_only": True},
        )
        private_link_service.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        private_link_service.tags = AAZDictType()
        private_link_service.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_interface_read.properties.private_link_service.properties
        properties.alias = AAZStrType(
            flags={"read_only": True},
        )
        properties.auto_approval = AAZObjectType(
            serialized_name="autoApproval",
        )
        properties.enable_proxy_protocol = AAZBoolType(
            serialized_name="enableProxyProtocol",
        )
        properties.fqdns = AAZListType()
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
        )
        properties.load_balancer_frontend_ip_configurations = AAZListType(
            serialized_name="loadBalancerFrontendIpConfigurations",
        )
        properties.network_interfaces = AAZListType(
            serialized_name="networkInterfaces",
            flags={"read_only": True},
        )
        properties.private_endpoint_connections = AAZListType(
            serialized_name="privateEndpointConnections",
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.visibility = AAZObjectType()

        auto_approval = _schema_network_interface_read.properties.private_link_service.properties.auto_approval
        auto_approval.subscriptions = AAZListType()

        subscriptions = _schema_network_interface_read.properties.private_link_service.properties.auto_approval.subscriptions
        subscriptions.Element = AAZStrType()

        fqdns = _schema_network_interface_read.properties.private_link_service.properties.fqdns
        fqdns.Element = AAZStrType()

        ip_configurations = _schema_network_interface_read.properties.private_link_service.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()

        _element = _schema_network_interface_read.properties.private_link_service.properties.ip_configurations.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_interface_read.properties.private_link_service.properties.ip_configurations.Element.properties
        properties.primary = AAZBoolType()
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )
        properties.private_ip_address_version = AAZStrType(
            serialized_name="privateIPAddressVersion",
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        load_balancer_frontend_ip_configurations = _schema_network_interface_read.properties.private_link_service.properties.load_balancer_frontend_ip_configurations
        load_balancer_frontend_ip_configurations.Element = AAZObjectType()
        cls._build_schema_frontend_ip_configuration_read(load_balancer_frontend_ip_configurations.Element)

        network_interfaces = _schema_network_interface_read.properties.private_link_service.properties.network_interfaces
        network_interfaces.Element = AAZObjectType()
        cls._build_schema_network_interface_read(network_interfaces.Element)

        private_endpoint_connections = _schema_network_interface_read.properties.private_link_service.properties.private_endpoint_connections
        private_endpoint_connections.Element = AAZObjectType()

        _element = _schema_network_interface_read.properties.private_link_service.properties.private_endpoint_connections.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_interface_read.properties.private_link_service.properties.private_endpoint_connections.Element.properties
        properties.link_identifier = AAZStrType(
            serialized_name="linkIdentifier",
            flags={"read_only": True},
        )
        properties.private_endpoint = AAZObjectType(
            serialized_name="privateEndpoint",
        )
        cls._build_schema_private_endpoint_read(properties.private_endpoint)
        properties.private_link_service_connection_state = AAZObjectType(
            serialized_name="privateLinkServiceConnectionState",
        )
        cls._build_schema_private_link_service_connection_state_read(properties.private_link_service_connection_state)
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        visibility = _schema_network_interface_read.properties.private_link_service.properties.visibility
        visibility.subscriptions = AAZListType()

        subscriptions = _schema_network_interface_read.properties.private_link_service.properties.visibility.subscriptions
        subscriptions.Element = AAZStrType()

        tags = _schema_network_interface_read.properties.private_link_service.tags
        tags.Element = AAZStrType()

        tap_configurations = _schema_network_interface_read.properties.tap_configurations
        tap_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_tap_configuration_read(tap_configurations.Element)

        tags = _schema_network_interface_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_network_interface_read.etag
        _schema.extended_location = cls._schema_network_interface_read.extended_location
        _schema.id = cls._schema_network_interface_read.id
        _schema.location = cls._schema_network_interface_read.location
        _schema.name = cls._schema_network_interface_read.name
        _schema.properties = cls._schema_network_interface_read.properties
        _schema.tags = cls._schema_network_interface_read.tags
        _schema.type = cls._schema_network_interface_read.type

    _schema_network_security_group_read = None

    @classmethod
    def _build_schema_network_security_group_read(cls, _schema):
        if cls._schema_network_security_group_read is not None:
            _schema.etag = cls._schema_network_security_group_read.etag
            _schema.id = cls._schema_network_security_group_read.id
            _schema.location = cls._schema_network_security_group_read.location
            _schema.name = cls._schema_network_security_group_read.name
            _schema.properties = cls._schema_network_security_group_read.properties
            _schema.tags = cls._schema_network_security_group_read.tags
            _schema.type = cls._schema_network_security_group_read.type
            return

        cls._schema_network_security_group_read = _schema_network_security_group_read = AAZObjectType()

        network_security_group_read = _schema_network_security_group_read
        network_security_group_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        network_security_group_read.id = AAZStrType()
        network_security_group_read.location = AAZStrType()
        network_security_group_read.name = AAZStrType(
            flags={"read_only": True},
        )
        network_security_group_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        network_security_group_read.tags = AAZDictType()
        network_security_group_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_security_group_read.properties
        properties.default_security_rules = AAZListType(
            serialized_name="defaultSecurityRules",
            flags={"read_only": True},
        )
        properties.flow_logs = AAZListType(
            serialized_name="flowLogs",
            flags={"read_only": True},
        )
        properties.flush_connection = AAZBoolType(
            serialized_name="flushConnection",
        )
        properties.network_interfaces = AAZListType(
            serialized_name="networkInterfaces",
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )
        properties.security_rules = AAZListType(
            serialized_name="securityRules",
        )
        properties.subnets = AAZListType(
            flags={"read_only": True},
        )

        default_security_rules = _schema_network_security_group_read.properties.default_security_rules
        default_security_rules.Element = AAZObjectType()
        cls._build_schema_security_rule_read(default_security_rules.Element)

        flow_logs = _schema_network_security_group_read.properties.flow_logs
        flow_logs.Element = AAZObjectType()

        _element = _schema_network_security_group_read.properties.flow_logs.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.location = AAZStrType()
        _element.name = AAZStrType(
            flags={"read_only": True},
        )
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.tags = AAZDictType()
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_security_group_read.properties.flow_logs.Element.properties
        properties.enabled = AAZBoolType()
        properties.flow_analytics_configuration = AAZObjectType(
            serialized_name="flowAnalyticsConfiguration",
        )
        properties.format = AAZObjectType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.retention_policy = AAZObjectType(
            serialized_name="retentionPolicy",
        )
        properties.storage_id = AAZStrType(
            serialized_name="storageId",
            flags={"required": True},
        )
        properties.target_resource_guid = AAZStrType(
            serialized_name="targetResourceGuid",
            flags={"read_only": True},
        )
        properties.target_resource_id = AAZStrType(
            serialized_name="targetResourceId",
            flags={"required": True},
        )

        flow_analytics_configuration = _schema_network_security_group_read.properties.flow_logs.Element.properties.flow_analytics_configuration
        flow_analytics_configuration.network_watcher_flow_analytics_configuration = AAZObjectType(
            serialized_name="networkWatcherFlowAnalyticsConfiguration",
        )

        network_watcher_flow_analytics_configuration = _schema_network_security_group_read.properties.flow_logs.Element.properties.flow_analytics_configuration.network_watcher_flow_analytics_configuration
        network_watcher_flow_analytics_configuration.enabled = AAZBoolType()
        network_watcher_flow_analytics_configuration.traffic_analytics_interval = AAZIntType(
            serialized_name="trafficAnalyticsInterval",
        )
        network_watcher_flow_analytics_configuration.workspace_id = AAZStrType(
            serialized_name="workspaceId",
        )
        network_watcher_flow_analytics_configuration.workspace_region = AAZStrType(
            serialized_name="workspaceRegion",
        )
        network_watcher_flow_analytics_configuration.workspace_resource_id = AAZStrType(
            serialized_name="workspaceResourceId",
        )

        format = _schema_network_security_group_read.properties.flow_logs.Element.properties.format
        format.type = AAZStrType()
        format.version = AAZIntType()

        retention_policy = _schema_network_security_group_read.properties.flow_logs.Element.properties.retention_policy
        retention_policy.days = AAZIntType()
        retention_policy.enabled = AAZBoolType()

        tags = _schema_network_security_group_read.properties.flow_logs.Element.tags
        tags.Element = AAZStrType()

        network_interfaces = _schema_network_security_group_read.properties.network_interfaces
        network_interfaces.Element = AAZObjectType()
        cls._build_schema_network_interface_read(network_interfaces.Element)

        security_rules = _schema_network_security_group_read.properties.security_rules
        security_rules.Element = AAZObjectType()
        cls._build_schema_security_rule_read(security_rules.Element)

        subnets = _schema_network_security_group_read.properties.subnets
        subnets.Element = AAZObjectType()
        cls._build_schema_subnet_read(subnets.Element)

        tags = _schema_network_security_group_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_network_security_group_read.etag
        _schema.id = cls._schema_network_security_group_read.id
        _schema.location = cls._schema_network_security_group_read.location
        _schema.name = cls._schema_network_security_group_read.name
        _schema.properties = cls._schema_network_security_group_read.properties
        _schema.tags = cls._schema_network_security_group_read.tags
        _schema.type = cls._schema_network_security_group_read.type

    _schema_private_endpoint_read = None

    @classmethod
    def _build_schema_private_endpoint_read(cls, _schema):
        if cls._schema_private_endpoint_read is not None:
            _schema.etag = cls._schema_private_endpoint_read.etag
            _schema.extended_location = cls._schema_private_endpoint_read.extended_location
            _schema.id = cls._schema_private_endpoint_read.id
            _schema.location = cls._schema_private_endpoint_read.location
            _schema.name = cls._schema_private_endpoint_read.name
            _schema.properties = cls._schema_private_endpoint_read.properties
            _schema.tags = cls._schema_private_endpoint_read.tags
            _schema.type = cls._schema_private_endpoint_read.type
            return

        cls._schema_private_endpoint_read = _schema_private_endpoint_read = AAZObjectType()

        private_endpoint_read = _schema_private_endpoint_read
        private_endpoint_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        private_endpoint_read.extended_location = AAZObjectType(
            serialized_name="extendedLocation",
        )
        cls._build_schema_extended_location_read(private_endpoint_read.extended_location)
        private_endpoint_read.id = AAZStrType()
        private_endpoint_read.location = AAZStrType()
        private_endpoint_read.name = AAZStrType(
            flags={"read_only": True},
        )
        private_endpoint_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        private_endpoint_read.tags = AAZDictType()
        private_endpoint_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_private_endpoint_read.properties
        properties.application_security_groups = AAZListType(
            serialized_name="applicationSecurityGroups",
        )
        properties.custom_dns_configs = AAZListType(
            serialized_name="customDnsConfigs",
        )
        properties.custom_network_interface_name = AAZStrType(
            serialized_name="customNetworkInterfaceName",
        )
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
        )
        properties.manual_private_link_service_connections = AAZListType(
            serialized_name="manualPrivateLinkServiceConnections",
        )
        properties.network_interfaces = AAZListType(
            serialized_name="networkInterfaces",
            flags={"read_only": True},
        )
        properties.private_link_service_connections = AAZListType(
            serialized_name="privateLinkServiceConnections",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        application_security_groups = _schema_private_endpoint_read.properties.application_security_groups
        application_security_groups.Element = AAZObjectType()
        cls._build_schema_application_security_group_read(application_security_groups.Element)

        custom_dns_configs = _schema_private_endpoint_read.properties.custom_dns_configs
        custom_dns_configs.Element = AAZObjectType()

        _element = _schema_private_endpoint_read.properties.custom_dns_configs.Element
        _element.fqdn = AAZStrType()
        _element.ip_addresses = AAZListType(
            serialized_name="ipAddresses",
        )

        ip_addresses = _schema_private_endpoint_read.properties.custom_dns_configs.Element.ip_addresses
        ip_addresses.Element = AAZStrType()

        ip_configurations = _schema_private_endpoint_read.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()

        _element = _schema_private_endpoint_read.properties.ip_configurations.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_private_endpoint_read.properties.ip_configurations.Element.properties
        properties.group_id = AAZStrType(
            serialized_name="groupId",
        )
        properties.member_name = AAZStrType(
            serialized_name="memberName",
        )
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )

        manual_private_link_service_connections = _schema_private_endpoint_read.properties.manual_private_link_service_connections
        manual_private_link_service_connections.Element = AAZObjectType()
        cls._build_schema_private_link_service_connection_read(manual_private_link_service_connections.Element)

        network_interfaces = _schema_private_endpoint_read.properties.network_interfaces
        network_interfaces.Element = AAZObjectType()
        cls._build_schema_network_interface_read(network_interfaces.Element)

        private_link_service_connections = _schema_private_endpoint_read.properties.private_link_service_connections
        private_link_service_connections.Element = AAZObjectType()
        cls._build_schema_private_link_service_connection_read(private_link_service_connections.Element)

        tags = _schema_private_endpoint_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_private_endpoint_read.etag
        _schema.extended_location = cls._schema_private_endpoint_read.extended_location
        _schema.id = cls._schema_private_endpoint_read.id
        _schema.location = cls._schema_private_endpoint_read.location
        _schema.name = cls._schema_private_endpoint_read.name
        _schema.properties = cls._schema_private_endpoint_read.properties
        _schema.tags = cls._schema_private_endpoint_read.tags
        _schema.type = cls._schema_private_endpoint_read.type

    _schema_private_link_service_connection_state_read = None

    @classmethod
    def _build_schema_private_link_service_connection_state_read(cls, _schema):
        if cls._schema_private_link_service_connection_state_read is not None:
            _schema.actions_required = cls._schema_private_link_service_connection_state_read.actions_required
            _schema.description = cls._schema_private_link_service_connection_state_read.description
            _schema.status = cls._schema_private_link_service_connection_state_read.status
            return

        cls._schema_private_link_service_connection_state_read = _schema_private_link_service_connection_state_read = AAZObjectType()

        private_link_service_connection_state_read = _schema_private_link_service_connection_state_read
        private_link_service_connection_state_read.actions_required = AAZStrType(
            serialized_name="actionsRequired",
        )
        private_link_service_connection_state_read.description = AAZStrType()
        private_link_service_connection_state_read.status = AAZStrType()

        _schema.actions_required = cls._schema_private_link_service_connection_state_read.actions_required
        _schema.description = cls._schema_private_link_service_connection_state_read.description
        _schema.status = cls._schema_private_link_service_connection_state_read.status

    _schema_private_link_service_connection_read = None

    @classmethod
    def _build_schema_private_link_service_connection_read(cls, _schema):
        if cls._schema_private_link_service_connection_read is not None:
            _schema.etag = cls._schema_private_link_service_connection_read.etag
            _schema.id = cls._schema_private_link_service_connection_read.id
            _schema.name = cls._schema_private_link_service_connection_read.name
            _schema.properties = cls._schema_private_link_service_connection_read.properties
            _schema.type = cls._schema_private_link_service_connection_read.type
            return

        cls._schema_private_link_service_connection_read = _schema_private_link_service_connection_read = AAZObjectType()

        private_link_service_connection_read = _schema_private_link_service_connection_read
        private_link_service_connection_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        private_link_service_connection_read.id = AAZStrType()
        private_link_service_connection_read.name = AAZStrType()
        private_link_service_connection_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        private_link_service_connection_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_private_link_service_connection_read.properties
        properties.group_ids = AAZListType(
            serialized_name="groupIds",
        )
        properties.private_link_service_connection_state = AAZObjectType(
            serialized_name="privateLinkServiceConnectionState",
        )
        cls._build_schema_private_link_service_connection_state_read(properties.private_link_service_connection_state)
        properties.private_link_service_id = AAZStrType(
            serialized_name="privateLinkServiceId",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.request_message = AAZStrType(
            serialized_name="requestMessage",
        )

        group_ids = _schema_private_link_service_connection_read.properties.group_ids
        group_ids.Element = AAZStrType()

        _schema.etag = cls._schema_private_link_service_connection_read.etag
        _schema.id = cls._schema_private_link_service_connection_read.id
        _schema.name = cls._schema_private_link_service_connection_read.name
        _schema.properties = cls._schema_private_link_service_connection_read.properties
        _schema.type = cls._schema_private_link_service_connection_read.type

    _schema_public_ip_address_read = None

    @classmethod
    def _build_schema_public_ip_address_read(cls, _schema):
        if cls._schema_public_ip_address_read is not None:
            _schema.etag = cls._schema_public_ip_address_read.etag
            _schema.extended_location = cls._schema_public_ip_address_read.extended_location
            _schema.id = cls._schema_public_ip_address_read.id
            _schema.location = cls._schema_public_ip_address_read.location
            _schema.name = cls._schema_public_ip_address_read.name
            _schema.properties = cls._schema_public_ip_address_read.properties
            _schema.sku = cls._schema_public_ip_address_read.sku
            _schema.tags = cls._schema_public_ip_address_read.tags
            _schema.type = cls._schema_public_ip_address_read.type
            _schema.zones = cls._schema_public_ip_address_read.zones
            return

        cls._schema_public_ip_address_read = _schema_public_ip_address_read = AAZObjectType()

        public_ip_address_read = _schema_public_ip_address_read
        public_ip_address_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        public_ip_address_read.extended_location = AAZObjectType(
            serialized_name="extendedLocation",
        )
        cls._build_schema_extended_location_read(public_ip_address_read.extended_location)
        public_ip_address_read.id = AAZStrType()
        public_ip_address_read.location = AAZStrType()
        public_ip_address_read.name = AAZStrType(
            flags={"read_only": True},
        )
        public_ip_address_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        public_ip_address_read.sku = AAZObjectType()
        public_ip_address_read.tags = AAZDictType()
        public_ip_address_read.type = AAZStrType(
            flags={"read_only": True},
        )
        public_ip_address_read.zones = AAZListType()

        properties = _schema_public_ip_address_read.properties
        properties.ddos_settings = AAZObjectType(
            serialized_name="ddosSettings",
        )
        properties.delete_option = AAZStrType(
            serialized_name="deleteOption",
        )
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.ip_address = AAZStrType(
            serialized_name="ipAddress",
        )
        properties.ip_configuration = AAZObjectType(
            serialized_name="ipConfiguration",
        )
        cls._build_schema_ip_configuration_read(properties.ip_configuration)
        properties.ip_tags = AAZListType(
            serialized_name="ipTags",
        )
        properties.linked_public_ip_address = AAZObjectType(
            serialized_name="linkedPublicIPAddress",
        )
        cls._build_schema_public_ip_address_read(properties.linked_public_ip_address)
        properties.migration_phase = AAZStrType(
            serialized_name="migrationPhase",
        )
        properties.nat_gateway = AAZObjectType(
            serialized_name="natGateway",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.public_ip_address_version = AAZStrType(
            serialized_name="publicIPAddressVersion",
        )
        properties.public_ip_allocation_method = AAZStrType(
            serialized_name="publicIPAllocationMethod",
        )
        properties.public_ip_prefix = AAZObjectType(
            serialized_name="publicIPPrefix",
        )
        cls._build_schema_sub_resource_read(properties.public_ip_prefix)
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )
        properties.service_public_ip_address = AAZObjectType(
            serialized_name="servicePublicIPAddress",
        )
        cls._build_schema_public_ip_address_read(properties.service_public_ip_address)

        ddos_settings = _schema_public_ip_address_read.properties.ddos_settings
        ddos_settings.ddos_protection_plan = AAZObjectType(
            serialized_name="ddosProtectionPlan",
        )
        cls._build_schema_sub_resource_read(ddos_settings.ddos_protection_plan)
        ddos_settings.protection_mode = AAZStrType(
            serialized_name="protectionMode",
        )

        dns_settings = _schema_public_ip_address_read.properties.dns_settings
        dns_settings.domain_name_label = AAZStrType(
            serialized_name="domainNameLabel",
        )
        dns_settings.fqdn = AAZStrType()
        dns_settings.reverse_fqdn = AAZStrType(
            serialized_name="reverseFqdn",
        )

        ip_tags = _schema_public_ip_address_read.properties.ip_tags
        ip_tags.Element = AAZObjectType()

        _element = _schema_public_ip_address_read.properties.ip_tags.Element
        _element.ip_tag_type = AAZStrType(
            serialized_name="ipTagType",
        )
        _element.tag = AAZStrType()

        nat_gateway = _schema_public_ip_address_read.properties.nat_gateway
        nat_gateway.etag = AAZStrType(
            flags={"read_only": True},
        )
        nat_gateway.id = AAZStrType()
        nat_gateway.location = AAZStrType()
        nat_gateway.name = AAZStrType(
            flags={"read_only": True},
        )
        nat_gateway.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        nat_gateway.sku = AAZObjectType()
        nat_gateway.tags = AAZDictType()
        nat_gateway.type = AAZStrType(
            flags={"read_only": True},
        )
        nat_gateway.zones = AAZListType()

        properties = _schema_public_ip_address_read.properties.nat_gateway.properties
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.public_ip_addresses = AAZListType(
            serialized_name="publicIpAddresses",
        )
        properties.public_ip_prefixes = AAZListType(
            serialized_name="publicIpPrefixes",
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )
        properties.subnets = AAZListType(
            flags={"read_only": True},
        )

        public_ip_addresses = _schema_public_ip_address_read.properties.nat_gateway.properties.public_ip_addresses
        public_ip_addresses.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(public_ip_addresses.Element)

        public_ip_prefixes = _schema_public_ip_address_read.properties.nat_gateway.properties.public_ip_prefixes
        public_ip_prefixes.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(public_ip_prefixes.Element)

        subnets = _schema_public_ip_address_read.properties.nat_gateway.properties.subnets
        subnets.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(subnets.Element)

        sku = _schema_public_ip_address_read.properties.nat_gateway.sku
        sku.name = AAZStrType()

        tags = _schema_public_ip_address_read.properties.nat_gateway.tags
        tags.Element = AAZStrType()

        zones = _schema_public_ip_address_read.properties.nat_gateway.zones
        zones.Element = AAZStrType()

        sku = _schema_public_ip_address_read.sku
        sku.name = AAZStrType()
        sku.tier = AAZStrType()

        tags = _schema_public_ip_address_read.tags
        tags.Element = AAZStrType()

        zones = _schema_public_ip_address_read.zones
        zones.Element = AAZStrType()

        _schema.etag = cls._schema_public_ip_address_read.etag
        _schema.extended_location = cls._schema_public_ip_address_read.extended_location
        _schema.id = cls._schema_public_ip_address_read.id
        _schema.location = cls._schema_public_ip_address_read.location
        _schema.name = cls._schema_public_ip_address_read.name
        _schema.properties = cls._schema_public_ip_address_read.properties
        _schema.sku = cls._schema_public_ip_address_read.sku
        _schema.tags = cls._schema_public_ip_address_read.tags
        _schema.type = cls._schema_public_ip_address_read.type
        _schema.zones = cls._schema_public_ip_address_read.zones

    _schema_security_rule_read = None

    @classmethod
    def _build_schema_security_rule_read(cls, _schema):
        if cls._schema_security_rule_read is not None:
            _schema.etag = cls._schema_security_rule_read.etag
            _schema.id = cls._schema_security_rule_read.id
            _schema.name = cls._schema_security_rule_read.name
            _schema.properties = cls._schema_security_rule_read.properties
            _schema.type = cls._schema_security_rule_read.type
            return

        cls._schema_security_rule_read = _schema_security_rule_read = AAZObjectType()

        security_rule_read = _schema_security_rule_read
        security_rule_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        security_rule_read.id = AAZStrType()
        security_rule_read.name = AAZStrType()
        security_rule_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        security_rule_read.type = AAZStrType()

        properties = _schema_security_rule_read.properties
        properties.access = AAZStrType(
            flags={"required": True},
        )
        properties.description = AAZStrType()
        properties.destination_address_prefix = AAZStrType(
            serialized_name="destinationAddressPrefix",
        )
        properties.destination_address_prefixes = AAZListType(
            serialized_name="destinationAddressPrefixes",
        )
        properties.destination_application_security_groups = AAZListType(
            serialized_name="destinationApplicationSecurityGroups",
        )
        properties.destination_port_range = AAZStrType(
            serialized_name="destinationPortRange",
        )
        properties.destination_port_ranges = AAZListType(
            serialized_name="destinationPortRanges",
        )
        properties.direction = AAZStrType(
            flags={"required": True},
        )
        properties.priority = AAZIntType()
        properties.protocol = AAZStrType(
            flags={"required": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.source_address_prefix = AAZStrType(
            serialized_name="sourceAddressPrefix",
        )
        properties.source_address_prefixes = AAZListType(
            serialized_name="sourceAddressPrefixes",
        )
        properties.source_application_security_groups = AAZListType(
            serialized_name="sourceApplicationSecurityGroups",
        )
        properties.source_port_range = AAZStrType(
            serialized_name="sourcePortRange",
        )
        properties.source_port_ranges = AAZListType(
            serialized_name="sourcePortRanges",
        )

        destination_address_prefixes = _schema_security_rule_read.properties.destination_address_prefixes
        destination_address_prefixes.Element = AAZStrType()

        destination_application_security_groups = _schema_security_rule_read.properties.destination_application_security_groups
        destination_application_security_groups.Element = AAZObjectType()
        cls._build_schema_application_security_group_read(destination_application_security_groups.Element)

        destination_port_ranges = _schema_security_rule_read.properties.destination_port_ranges
        destination_port_ranges.Element = AAZStrType()

        source_address_prefixes = _schema_security_rule_read.properties.source_address_prefixes
        source_address_prefixes.Element = AAZStrType()

        source_application_security_groups = _schema_security_rule_read.properties.source_application_security_groups
        source_application_security_groups.Element = AAZObjectType()
        cls._build_schema_application_security_group_read(source_application_security_groups.Element)

        source_port_ranges = _schema_security_rule_read.properties.source_port_ranges
        source_port_ranges.Element = AAZStrType()

        _schema.etag = cls._schema_security_rule_read.etag
        _schema.id = cls._schema_security_rule_read.id
        _schema.name = cls._schema_security_rule_read.name
        _schema.properties = cls._schema_security_rule_read.properties
        _schema.type = cls._schema_security_rule_read.type

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id

    _schema_subnet_read = None

    @classmethod
    def _build_schema_subnet_read(cls, _schema):
        if cls._schema_subnet_read is not None:
            _schema.etag = cls._schema_subnet_read.etag
            _schema.id = cls._schema_subnet_read.id
            _schema.name = cls._schema_subnet_read.name
            _schema.properties = cls._schema_subnet_read.properties
            _schema.type = cls._schema_subnet_read.type
            return

        cls._schema_subnet_read = _schema_subnet_read = AAZObjectType()

        subnet_read = _schema_subnet_read
        subnet_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        subnet_read.id = AAZStrType()
        subnet_read.name = AAZStrType()
        subnet_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        subnet_read.type = AAZStrType()

        properties = _schema_subnet_read.properties
        properties.address_prefix = AAZStrType(
            serialized_name="addressPrefix",
        )
        properties.address_prefixes = AAZListType(
            serialized_name="addressPrefixes",
        )
        properties.application_gateway_ip_configurations = AAZListType(
            serialized_name="applicationGatewayIpConfigurations",
        )
        properties.delegations = AAZListType()
        properties.ip_allocations = AAZListType(
            serialized_name="ipAllocations",
        )
        properties.ip_configuration_profiles = AAZListType(
            serialized_name="ipConfigurationProfiles",
            flags={"read_only": True},
        )
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
            flags={"read_only": True},
        )
        properties.nat_gateway = AAZObjectType(
            serialized_name="natGateway",
        )
        cls._build_schema_sub_resource_read(properties.nat_gateway)
        properties.network_security_group = AAZObjectType(
            serialized_name="networkSecurityGroup",
        )
        cls._build_schema_network_security_group_read(properties.network_security_group)
        properties.private_endpoint_network_policies = AAZStrType(
            serialized_name="privateEndpointNetworkPolicies",
        )
        properties.private_endpoints = AAZListType(
            serialized_name="privateEndpoints",
            flags={"read_only": True},
        )
        properties.private_link_service_network_policies = AAZStrType(
            serialized_name="privateLinkServiceNetworkPolicies",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.purpose = AAZStrType(
            flags={"read_only": True},
        )
        properties.resource_navigation_links = AAZListType(
            serialized_name="resourceNavigationLinks",
            flags={"read_only": True},
        )
        properties.route_table = AAZObjectType(
            serialized_name="routeTable",
        )
        properties.service_association_links = AAZListType(
            serialized_name="serviceAssociationLinks",
            flags={"read_only": True},
        )
        properties.service_endpoint_policies = AAZListType(
            serialized_name="serviceEndpointPolicies",
        )
        properties.service_endpoints = AAZListType(
            serialized_name="serviceEndpoints",
        )

        address_prefixes = _schema_subnet_read.properties.address_prefixes
        address_prefixes.Element = AAZStrType()

        application_gateway_ip_configurations = _schema_subnet_read.properties.application_gateway_ip_configurations
        application_gateway_ip_configurations.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.application_gateway_ip_configurations.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_subnet_read.properties.application_gateway_ip_configurations.Element.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.subnet = AAZObjectType()
        cls._build_schema_sub_resource_read(properties.subnet)

        delegations = _schema_subnet_read.properties.delegations
        delegations.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.delegations.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType()

        properties = _schema_subnet_read.properties.delegations.Element.properties
        properties.actions = AAZListType(
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.service_name = AAZStrType(
            serialized_name="serviceName",
        )

        actions = _schema_subnet_read.properties.delegations.Element.properties.actions
        actions.Element = AAZStrType()

        ip_allocations = _schema_subnet_read.properties.ip_allocations
        ip_allocations.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(ip_allocations.Element)

        ip_configuration_profiles = _schema_subnet_read.properties.ip_configuration_profiles
        ip_configuration_profiles.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.ip_configuration_profiles.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_subnet_read.properties.ip_configuration_profiles.Element.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        ip_configurations = _schema_subnet_read.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()
        cls._build_schema_ip_configuration_read(ip_configurations.Element)

        private_endpoints = _schema_subnet_read.properties.private_endpoints
        private_endpoints.Element = AAZObjectType()
        cls._build_schema_private_endpoint_read(private_endpoints.Element)

        resource_navigation_links = _schema_subnet_read.properties.resource_navigation_links
        resource_navigation_links.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.resource_navigation_links.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType(
            flags={"read_only": True},
        )
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_subnet_read.properties.resource_navigation_links.Element.properties
        properties.link = AAZStrType()
        properties.linked_resource_type = AAZStrType(
            serialized_name="linkedResourceType",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        route_table = _schema_subnet_read.properties.route_table
        route_table.etag = AAZStrType(
            flags={"read_only": True},
        )
        route_table.id = AAZStrType()
        route_table.location = AAZStrType()
        route_table.name = AAZStrType(
            flags={"read_only": True},
        )
        route_table.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        route_table.tags = AAZDictType()
        route_table.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_subnet_read.properties.route_table.properties
        properties.disable_bgp_route_propagation = AAZBoolType(
            serialized_name="disableBgpRoutePropagation",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )
        properties.routes = AAZListType()
        properties.subnets = AAZListType(
            flags={"read_only": True},
        )

        routes = _schema_subnet_read.properties.route_table.properties.routes
        routes.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.route_table.properties.routes.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType()

        properties = _schema_subnet_read.properties.route_table.properties.routes.Element.properties
        properties.address_prefix = AAZStrType(
            serialized_name="addressPrefix",
        )
        properties.has_bgp_override = AAZBoolType(
            serialized_name="hasBgpOverride",
        )
        properties.next_hop_ip_address = AAZStrType(
            serialized_name="nextHopIpAddress",
        )
        properties.next_hop_type = AAZStrType(
            serialized_name="nextHopType",
            flags={"required": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        subnets = _schema_subnet_read.properties.route_table.properties.subnets
        subnets.Element = AAZObjectType()
        cls._build_schema_subnet_read(subnets.Element)

        tags = _schema_subnet_read.properties.route_table.tags
        tags.Element = AAZStrType()

        service_association_links = _schema_subnet_read.properties.service_association_links
        service_association_links.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.service_association_links.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_subnet_read.properties.service_association_links.Element.properties
        properties.allow_delete = AAZBoolType(
            serialized_name="allowDelete",
        )
        properties.link = AAZStrType()
        properties.linked_resource_type = AAZStrType(
            serialized_name="linkedResourceType",
        )
        properties.locations = AAZListType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        locations = _schema_subnet_read.properties.service_association_links.Element.properties.locations
        locations.Element = AAZStrType()

        service_endpoint_policies = _schema_subnet_read.properties.service_endpoint_policies
        service_endpoint_policies.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.service_endpoint_policies.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.kind = AAZStrType(
            flags={"read_only": True},
        )
        _element.location = AAZStrType()
        _element.name = AAZStrType(
            flags={"read_only": True},
        )
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.tags = AAZDictType()
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_subnet_read.properties.service_endpoint_policies.Element.properties
        properties.contextual_service_endpoint_policies = AAZListType(
            serialized_name="contextualServiceEndpointPolicies",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )
        properties.service_alias = AAZStrType(
            serialized_name="serviceAlias",
        )
        properties.service_endpoint_policy_definitions = AAZListType(
            serialized_name="serviceEndpointPolicyDefinitions",
        )
        properties.subnets = AAZListType(
            flags={"read_only": True},
        )

        contextual_service_endpoint_policies = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.contextual_service_endpoint_policies
        contextual_service_endpoint_policies.Element = AAZStrType()

        service_endpoint_policy_definitions = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions
        service_endpoint_policy_definitions.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType()

        properties = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element.properties
        properties.description = AAZStrType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.service = AAZStrType()
        properties.service_resources = AAZListType(
            serialized_name="serviceResources",
        )

        service_resources = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element.properties.service_resources
        service_resources.Element = AAZStrType()

        subnets = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.subnets
        subnets.Element = AAZObjectType()
        cls._build_schema_subnet_read(subnets.Element)

        tags = _schema_subnet_read.properties.service_endpoint_policies.Element.tags
        tags.Element = AAZStrType()

        service_endpoints = _schema_subnet_read.properties.service_endpoints
        service_endpoints.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.service_endpoints.Element
        _element.locations = AAZListType()
        _element.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        _element.service = AAZStrType()

        locations = _schema_subnet_read.properties.service_endpoints.Element.locations
        locations.Element = AAZStrType()

        _schema.etag = cls._schema_subnet_read.etag
        _schema.id = cls._schema_subnet_read.id
        _schema.name = cls._schema_subnet_read.name
        _schema.properties = cls._schema_subnet_read.properties
        _schema.type = cls._schema_subnet_read.type

    _schema_virtual_network_tap_read = None

    @classmethod
    def _build_schema_virtual_network_tap_read(cls, _schema):
        if cls._schema_virtual_network_tap_read is not None:
            _schema.etag = cls._schema_virtual_network_tap_read.etag
            _schema.id = cls._schema_virtual_network_tap_read.id
            _schema.location = cls._schema_virtual_network_tap_read.location
            _schema.name = cls._schema_virtual_network_tap_read.name
            _schema.properties = cls._schema_virtual_network_tap_read.properties
            _schema.tags = cls._schema_virtual_network_tap_read.tags
            _schema.type = cls._schema_virtual_network_tap_read.type
            return

        cls._schema_virtual_network_tap_read = _schema_virtual_network_tap_read = AAZObjectType()

        virtual_network_tap_read = _schema_virtual_network_tap_read
        virtual_network_tap_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        virtual_network_tap_read.id = AAZStrType()
        virtual_network_tap_read.location = AAZStrType()
        virtual_network_tap_read.name = AAZStrType(
            flags={"read_only": True},
        )
        virtual_network_tap_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        virtual_network_tap_read.tags = AAZDictType()
        virtual_network_tap_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_virtual_network_tap_read.properties
        properties.destination_load_balancer_front_end_ip_configuration = AAZObjectType(
            serialized_name="destinationLoadBalancerFrontEndIPConfiguration",
        )
        cls._build_schema_frontend_ip_configuration_read(properties.destination_load_balancer_front_end_ip_configuration)
        properties.destination_network_interface_ip_configuration = AAZObjectType(
            serialized_name="destinationNetworkInterfaceIPConfiguration",
        )
        cls._build_schema_network_interface_ip_configuration_read(properties.destination_network_interface_ip_configuration)
        properties.destination_port = AAZIntType(
            serialized_name="destinationPort",
        )
        properties.network_interface_tap_configurations = AAZListType(
            serialized_name="networkInterfaceTapConfigurations",
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )

        network_interface_tap_configurations = _schema_virtual_network_tap_read.properties.network_interface_tap_configurations
        network_interface_tap_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_tap_configuration_read(network_interface_tap_configurations.Element)

        tags = _schema_virtual_network_tap_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_virtual_network_tap_read.etag
        _schema.id = cls._schema_virtual_network_tap_read.id
        _schema.location = cls._schema_virtual_network_tap_read.location
        _schema.name = cls._schema_virtual_network_tap_read.name
        _schema.properties = cls._schema_virtual_network_tap_read.properties
        _schema.tags = cls._schema_virtual_network_tap_read.tags
        _schema.type = cls._schema_virtual_network_tap_read.type


__all__ = ["Update"]
