#define I_IOCTL
#define I_ERRNO
#define I_TYPES
#define I_STAT
#define I_SOCKET
#include "includes.h"

#include "debug.h"

int termerrno = 0;

extern int share;
int share = -1;
extern int use_nonblock;
int use_nonblock = 1;

/*-----------------------------------------------------------------------*/
void set_nonblock(int fd) {
#ifdef SCO
   int one = 1;
#endif
#ifdef USE_FCNTL
#ifdef USE_NONBLOCK
  if (use_nonblock) {
    if (!(fcntl (fd, F_GETFL) & O_NONBLOCK)) {
      fcntl (fd, F_SETFL, (fcntl(fd, F_GETFL) | O_NONBLOCK));
    }
  }
#ifdef SCO
  ioctl(fd, FIONBIO, &one);
#endif
#else
  if (!(fcntl (fd, F_GETFL) & FNDELAY)) {
    fcntl (fd, F_SETFL, (fcntl(fd, F_GETFL) | FNDELAY));
  }
#endif
#else
  int one = 1;
  ioctl( fd, FIONBIO, &one);
#endif
}

void set_block(int fd) { 
#ifdef SCO
  int zero = 0;
#endif
#ifdef USE_FCNTL
#ifdef USE_NONBLOCK
  if (use_nonblock) {
    fcntl (fd, F_SETFL, (fcntl(fd, F_GETFL) & ~O_NONBLOCK));
#ifdef SCO
    ioctl(fd, FIONBIO, &zero);
#endif
  }
#else
  fcntl (fd, F_SETFL, (fcntl(fd, F_GETFL) & ~FNDELAY));
#endif
#else
  int zero = 0;
  ioctl(fd, FIONBIO, &zero);
#endif
}
/*------------------------------------------------------------------------*/
/* Do a partial read into the buffer. */
int do_read_into_buff(int fd, struct Buffer *b, int size) {
  int r = 0, t;
  
  if (!size || size > b->alloced - 1 - b->size)
    size = b->alloced - 1 - b->size;
  termerrno = 0;
  t = b->alloced - b->start;
  if (t > size) t = size;
  r = read(fd, b->data + b->start, t);
  DEBUG_LL(stderr, "%s: d_r_i_b: read1 from %d (%d) did %d\n", 
	   term_server, fd, t, r);
  if (r <= 0)  {
    if (!r) termerrno = 1;
    else 
#ifndef SVR4
      if (errno != ERR_BLOCK)
#endif /* SVR4 */
        termerrno = errno + 1;
    return r;
  }
  
  b->start += r;
  b->size += r;
  SANITY(b->start <= b->alloced);
  if (b->start == b->alloced)
    b->start = 0;
  size -= r;
  if (!size || b->start != 0) return r;
  
  t = b->alloced - b->start;
  if (t > size) t = size;
  t = read(fd, b->data + b->start, t);
  DEBUG_LL(stderr, "%s: d_r_i_b: read2 from %d (%d) did %d\n", 
	   term_server, fd, t, t);
  if (t <= 0) {
    if (!t) termerrno = 1;
    else if(errno != ERR_BLOCK)
      termerrno = errno+1;
    return r;
  }
  
  b->start += t;
  b->size += t;
  if (b->start == b->alloced)
    b->start = 0;
  size -= t;
  r += t;
  return r;
}

/* Read from a file-descriptor into a ring buffer. Read atmost size bytes */
int read_into_buff(int fd, struct Buffer *b, int size) {
  int ret, l = 0;
  if (!size) size = b->alloced - 1 - b->size;

  do {
    ret = do_read_into_buff(fd, b, size);
    if (ret < 1) break;
    l += ret;
    size -= ret;
  } while (!termerrno && size);
  if (!l) return ret;
  return l;
}

/*------------------------------------------------------------------------*/
/* Write from ring buffer to file descriptor. Write at most size bytes    */

int write_from_buff(int fd, struct Buffer *b, int size) {
  int r = 0, t;
  if (!size) size = b->size;
  t = b->alloced - b->end;
  if (t > size) t = size;
  
  r = write(fd, b->data + b->end, t);
  DEBUG_LL(stderr, "%s: d_w_f_b: write1 from %d (%d) did %d\n", 
	   term_server, fd, t, r);
  if (r <= 0) {
    if (!r) termerrno = 1;
    else if (errno != ERR_BLOCK)
      termerrno = errno+1;
    return r;
  }

  b->end += r;
  b->size -= r;
  SANITY(b->end <= b->alloced);

  if (b->end >= b->alloced)
    b->end -= b->alloced;
  size -= r;
  if (!size || b->end != 0) 
    return r;
  
  t = b->alloced - b->end;
  if (t > size) t = size;
  t = write(fd, b->data + b->end, t);
  DEBUG_LL(stderr, "%s: d_w_f_b: write2 from %d (%d) did %d\n", 
	   term_server, fd, t, r);

  if (t <= 0) {
    if (!t) termerrno = 1;
    else if (errno != ERR_BLOCK)
      termerrno = errno+1;
    return r;
  }
  
  b->end += t;
  b->size -= t;
  SANITY(b->end <= b->alloced);
  if (b->end >= b->alloced)
    b->end -= b->alloced;
  r += t;
  return r;
}

#define BUFF_INC_SIZE 2048

int add_to_buffer(struct Buffer *B, un_char c)
{
  if (B->size >= B->alloced - 2) {
    
    DEBUG_LL (stderr, "growing buffer: add_to_buffer %d, %d\n",
	     B->size, B->alloced);

    if (!B->data || !B->alloced){
      B->data = (un_char *) malloc( B->alloced + BUFF_INC_SIZE );
      if(B->data==NULL){
         perror("Term: malloc");
         return -1;
      };
    }else if((B->data = (un_char *) realloc(B->data, B->alloced + BUFF_INC_SIZE)) == NULL){
      perror("Term: realloc");
      return -1;
    };
    B->alloced += BUFF_INC_SIZE;
    if (B->end > B->start) {	/* curses. need to move data. */
      int i; char *p, *q;
      p = (caddr_t)B->data + B->alloced - 1;
      q = (caddr_t)B->data + B->alloced - BUFF_INC_SIZE - 1;
      for (i = B->alloced - BUFF_INC_SIZE - B->end; i > 0; --i)
	*p-- = *q--;
      B->end += BUFF_INC_SIZE;
    }
  }
  B->data[B->start++] = (c);
  B->start == B->alloced ? B->start = 0 : 0; 
  B->size++;
  return 0;
}

int get_from_buffer(struct Buffer *b) {
  un_char c;
  if (b->size < 1)
    return -1;
  c = b->data[b->end++];
  --b->size;
  if (b->end >= b->alloced)
    b->end = 0;
  return (int) c&255;
}
/*-----------------------------------------------------------------------*/

	/* KLUDGE. suns always need stderr, so ignore the config.h if */
	/* it says otherwise. This is mostly just a sanity check */
char *strerror(int errno) {
#ifndef NetBSD
  extern char *sys_errlist[];
#endif
  
  return sys_errlist[errno];
}

	/* This is to allow easy checking of effective access */
int eaccess(char *pathname, int mode){
  struct stat file_status;
  int m;

  if(stat(pathname,&file_status) == -1) return -1;
  if(! mode) return 0;

  if(file_status.st_uid == geteuid())
    m = mode << 6;
  else if ( file_status.st_gid == getegid())
    m = mode << 3;
  else
    m = mode;

  return  - ((file_status.st_mode & m) != m) ; 
}

#ifdef SHAREDIR
	/* This tests whether we are in shared mode */
void set_share_mode(void){
  char *e;

  e=getenv("TERMMODE");
  if(e!=NULL){
    share=atoi(e);
    if(share<0||share>1) share = -1;
  };
  if(share == -1)
#ifndef USERSHARE
    share = (getgid() != getegid());
  if (! share)
    setgid(getgid());
#ifdef _POSIX_SAVED_IDS
  else if(share && savedeid < 0){
    savedeid = getegid();
    setgid(getgid());
  }
#endif
#else
    share = (getuid() != geteuid()) ? 1 : -1;
  if (! share)
    setuid(getuid());
#ifdef _POSIX_SAVED_IDS
  else if(share && savedeid < 0){
    savedeid = geteuid();
    setuid(getuid());
  }
#endif
#endif
  if(share == 1)
    putenv("TERMMODE=1");
  else if (! share) 
    putenv("TERMMODE=0");
}
#endif

char *str_version(long unsigned int version){
  static char v[25];
  if(! (version%100))
    sprintf(v, "%lu.%02lu",(version/10000),
      (version/100)%100);
  else if(version%100 < 50 )	/* These are bug fix releases */
    sprintf(v, "%lu.%02lupl%02lu",(version/10000),
      (version/100)%100,version%100);
  else if(version%100 < 77 ) 	/* These are alpha releases */
    sprintf(v, "%lu.%02lu%c (alpha)",(version/10000),
      (version/100)%100,'a'+(char)((version-51)%100));
  else		/* Even more alpha releases */
    sprintf(v, "%lu.%02lu%c%c (alpha)\r\n",(version/10000),
      (version/100)%100,'z','a'+(char)((version-77)%100));
  return v;
}


