/*
** nsw_hosts.h         Hosts cover routines for the Name Service Switch
**
** Copyright (c) 1993 Signum Support AB, Sweden
**
** This file is part of the NYS Library.
**
** The NYS Library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS Library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with the NYS Library; see the file COPYING.LIB.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
*/

#ifndef __NSSWITCH_HOSTS_H__
#define __NSSWITCH_HOSTS_H__

#include <sys/types.h>
#include <netdb.h>

#ifdef ENABLE_NIS
#include "../nis/nis_hosts.h"
#endif

#ifdef ENABLE_YP
#include "../yp/yp_hosts.h"
#endif

#ifdef ENABLE_DNS
#include "../dns/dns_hosts.h"
#endif

void _ENSWF(_sethostent)(int stayopen);
void _ENSWF(_endhostent)(void);
struct hostent * _ENSWF(_gethostent)(void);
struct hostent * _ENSWF(_gethostbyname)(const char *name);
struct hostent * _ENSWF(_gethostbyaddr)(const char *addr, int len, int type);

#endif
