/*
** nis_print.c
**
** Copyright (c) 1993 Signum Support AB, Sweden
**
** This file is part of the NYS Library.
**
** The NYS Library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS Library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with the NYS Library; see the file COPYING.LIB.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Author: Peter Eriksson <pen@signum.se>
*/

#ifndef __NIS_PRINT_H__
#define __NIS_PRINT_H__

#include <stdio.h>
#include <rpcsvc/nis.h>

extern void _nis_print_directory(directory_obj *dob, int ind, FILE *fp);
extern void nis_print_directory(directory_obj *dob);
extern void _nis_print_group(group_obj *go, int ind, FILE *fp);
extern void nis_print_group(group_obj *go);
extern void _nis_print_table_col(table_col *tc, int ind, FILE *fp);
extern void _nis_print_table(table_obj *to, int ind, FILE *fp);
extern void nis_print_table(table_obj *to);
extern void _nis_print_entry_col(entry_col *ec, int ind, FILE *fp);
extern void _nis_print_entry(entry_obj *eo, int ind, FILE *fp);
extern void nis_print_entry(entry_obj *eo);
extern void _nis_print_attr(nis_attr *at, int ind, FILE *fp);
extern void nis_print_attr(nis_attr *at);
extern void _nis_print_link(link_obj *lo, int ind, FILE *fp);
extern void nis_print_link(link_obj *lo);
extern void _nis_print_objdata(objdata *obd, int ind, FILE *fp);
extern void _nis_print_object(nis_object *ob, int ind, FILE *fp);
extern void nis_print_object(nis_object *ob);
extern void _nis_print_result(nis_result *nsres, int ind, FILE *fp);
extern void nis_print_result(nis_result *res);

#endif
