# Changelog

All notable changes to this project will be documented in this file.

The format follows the [Keep a Changelog](https://keepachangelog.com/en/1.0.0/) conventions and this project adheres to [Semantic Versioning 2.0.0](https://semver.org/spec/v2.0.0.html).

## [2.0.1] - 2025-12-04

### Fixed

- **h52nx**: be more resilient to esrf mounting point

## [2.0.0] - 2025-11-21

### Changed

- Save NXtomo according to McStats (a flip between *x*, *y* and *z* axes is now supported).

### Added

- **h52nx**
  - Handle `rotation_is_clockwise`.
  - Allow users to provide mechanical flips.
  - Try to deduce scan category/type from `technique` / `scan_category`.

### Fixed

- **h52nx** – Improve robustness to invalid unit.

### Misc

- The minimum Python version required is now **3.10**.

## [1.2.7] - 2025-09-22

### Fixed

- **h52nx** – Read `optic_pixel_size` first to determine detector/pixel size (PR 337).

## [1.2.6] - 2025-09-19

### Fixed

- **h52nx** – Fix execution from the configuration file (PR 334).

## [1.2.5] - 2025-07-29

### Fixed

- **h52nx** – Improve robustness if the camera is defined but no dataset is created (PR 328).

## [1.2.4] - 2025-07-29

### Removed

- **h52nx** – Remove `bam_single_file` option (PR 324).
- Applications – Remove `configuration-level` option (PR 324).

### Changed

- Move config files to **pydantic** (PR 324).

## [1.2.3] - 2025-07-21

### Fixed

- **h52nx** – Fix performance issues from `deduce_machine_current` (PR 320).

## [1.2.0] - 2025‑07‑18

### Changed

- Refactored acquisition handling: added `_AcquisitionConstructor` classes (PR 313).
- `pcotomo` deprecated in favour of `multitomo`.
- Renamed `machine_electric_current` → `machine_current` (PR 305, 285).
- Switched from `pyunit` to **pint** for units handling (PR 310, 309, 306, 294).
- **Documentation**
  - Use `program-output` (PR 299, 293).

### Added

- **h52nx**
  - `--with-master-file` option (replaces the old `--no-master-file` flag).
  - Propagation distance, sample‑to‑source distance, and sample pixel size handling.
  - Bliss “back‑and‑forth” sequence handling.
  - `sequence_number` handling.

### Fixed

- Silx deprecation warning removed (PR 315).

### Misc

- Minimum supported Python version is now **3.9**.
- Added **Bandit** to the CI pipeline.

## [1.1.0] - 2024‑12‑06

### Added

- **h52nx**
  - `--no-master-file` option (PR 272).
  - Cropping fix for machine‑current points (PR 177).
  - Motor geometry fix (PR 195).
  - Source‑to‑sample distance handling (PR 202).
  - Region‑of‑interest (ROI) support (PR 172).
- **edf2nx**
  - Option to use real angle values (PR 181).

### Changed

- **h52nx**
  - Improved machine‑current deduction (PR 179).

### Misc

- Progress reporting moved to **tqdm** (PR 187).
- Removed legacy `3D‑XRD` and `XRD‑CT` classes (PR 196).
- Dropped `require_x_translation` and `require_z_translation` (PR 199).
- Removed `scan_numbers` usage (PR 173).
- Updated to `__future__` annotations (PR 166).
- Sources moved to the `src` directory (PR 130).

## [1.0.11] - 2024‑10‑07

### Changed

- **h52nx** – Modified Bliss file scan ordering to use each scan’s `start_time` when present.

## [1.0.9] - 2024‑08‑27

### Added

- **h52nx** – Added handling for Z‑series version 3 (PR 258).

## [1.0.0] - 2024‑02‑23

### Added

- **app**
  - `nx-copy` – Copies an NXtomo and updates relative HDF5 VDS links (PR 188).

### Removed

- Removed `is_xrdct_entry` (PR 209).

### Misc

- Documentation rebuilt with **sphinx‑pydata‑theme**.
- Upgraded to **silx 2.0**.

## [0.13.2] - 2023‑08‑03

### Added

- **converter → hdf5**
  - `bliss_original_files` option.

## [0.13.0] - 2023‑08‑01

### Changed

- **hdf5**
  - Uses `technique/image` Bliss metadata when available (PR 147, 168).
  - Improved multi‑tomo (`pcotomo`) robustness (PR 160, 159).
  - `estimated_cor_from_motor` now set for 360° scans (PR 161).
  - Better handling of cancelled scans (PR 158, 165).
  - Removed `real pixel size` and `magnification` fields.
- **nexus**
  - Strengthened node‑name vs‑path handling robustness (PR 173).
- **app**
  - `edf2nx-check` – Verify previous conversions and optionally delete EDF sources (PR 164).
  - `split-nxfile` – Split a file containing multiple NXtomo entries (PR 172).
  - `z-concatenate-scans` – Concatenate a Z‑series into a single NXtomo (PR 174, 175).
  - Deprecated `h5-quick-start` → `h5-config` and `edf-quick-start` → `edf-config` (PR 166).
- **misc**
  - Deprecated `from_dx_to_nx` → `from_dx_config_to_nx` (PR 167).
  - Replaced `str.format` with f‑strings where possible (PR 154).
  - Added batch‑processing example to docs.

### Added

- **edf2**
  - `output-checks` option to validate generated volumes (PR 155).
  - `delete-edf` option to delete source EDF files after conversion (PR 155).
  - `zstages2nxs` – Added `output_filename_template` option (PR 176).

### Removed

- **converter**
  - Removed `x`/`y` real‑pixel‑size and magnification metadata.
    - **hdf5**
    - Removed unused plugins system (PR 177).

## [0.12.0] - 2023‑02‑23

### Added

- **app**
  - `zstages2nxs` command (PR 145).
- **converter → hdf5**
  - Frame‑flip information (PR 109).

### Changed

- **converter → edf2nx**
  - Better handling of current units (PR 150).

### misc

- Dropped `numpy.distutils` for packaging (PR 151).

## [0.11.0] - 2022‑12‑15

### Added

- **converter → hdf5**
  - Support for `{detector_name}` placeholders in paths.
  - Flip handling.
  - Fixed inability to locate pixel position & energy for Z‑series.

## [0.10.9] - 2022‑10‑26

### Added

- **converter → hdf5converter**
  - Support for EBStomo `pcotomo` second version.

## [0.10.1] - 2022‑08‑31

### Fixed

- **converter**
  - Default distance, X/Y/Z translation units set to **millimeter** in `EDFConfig`.
  - Fixed field‑of‑view deduction in `edf2nx`.

## [0.10.0] - 2022‑08‑30

### Added

- **converter**
  - `hdf5converter`
    - Added magnification management (PR 110).
    - Added sub‑selection of NXtomo by rotation angle and pcotomo‑specific parameters (PR 100).
  - `edf2nx`
    - Added option to avoid data duplication (PR 114, 115, 118).
- **nexus**
  - Added `probe` to `NXsource` (PR 117).

### Changed

- **converter**

  - Improved `NXdetector.data` setter (PR 122).
  - Renamed attribute `unit` → `units`.

### Removed

- **converter**
  - Removed deprecated `h5_to_nx` (since 0.5.0).

## [0.9.0] - 2022‑06‑24

### Added

- **converter → hdf5**
  - Machine electrical current handling (PR 106).
  - `is_rearranged` attribute management (PR 111).
- **converter → edf**
  - Configuration‑file support (PR 104).
- **nexus**
  - Added Nxtomo concatenation (PR 109).

## [0.8.0] - 2021‑06‑04

### Added

- **converter → hdf5**
  - `bam_single_file` option (PR 96).
  - pcotomo management (PR 91, 88).
- Added **nexus** module exposing an API to edit an NXtomo (PR 87).

## [0.7.0] - 2021‑01‑07

### Added

- **converter → hdf5**
  - ExternalLink handling for Bliss proposal files (PR 85).
- **converter → edf**
  - Fixed progress‑bar issues (PR 80).
- **patch‑nx**
  - Option to convert all frames of a given type (PR 84).
- **dxfile2nx**
  - Single‑value pixel‑size support (PR 77).
- **miscellaneous**
  - Added missing aliases `flat`/`ref` (PR 83).
  - Integrated validator (PR 81).

## [0.6.0] - 2021‑10‑04

### Added

- **app**
  - `dxfile2nx` – Convert DX‑files to NXtomo.
  - `h52nx` – New `duplicate_data` flag to force frame duplication.
  - `h5-3dxrd-2nx` – Convert Bliss‑HDF5 3D‑XRD to enhanced NXtomo (updates VDS links).
- **converter**
  - Added `dxfileconverter`.

## [0.5.0] - 2021‑04‑20

### Fixed

- **utils**
  - Fixed negative‑index handling.

### Added

- **converter → hdf5**
  - Added `start_time` & `end_time` fields.
  - Full configuration‑file support (`HDF5Config`, `HDF5ConfigHandler`).
  - `ignore_sub_entries` to skip specific scans.
- **app**
  - `patch-nx` – Added `--embed-data` flag.
  - Added `--ignore-sub-entries` option.

### Changed

- **converter → hdf5**
  - Reworked virtual‑dataset creation.
  - Enforced projection count consistency (`tomo_n`).
  - Improved key/path discovery logic.
  - Warning when no acquisitions are found.

- **utils**
  - Refactored `_insert_frame_data` into `_FrameAppender` class.
- **app**
  - Renamed `tomoh52nx` → `h52nx` (deprecating former).
  - Renamed `tomoedf2nx` → `edf2nx` (deprecating former).
  - `h52nx` now accepts a configuration file (`--config`).

## [0.4.0] - 2020‑11‑09

### Added

- **utils**
  - `change_image_key_control` – Modify frame type in‑place.
  - `add_dark_flat_nx_file` – Insert dark/flat series into an existing NXtomo.
- **converter → h5_to_nx**
  - Proposal‑file handling (External/SoftLink).
  - Saved discovered magnified/sample pixel size as `pixel_size`.
  - Optional `display_advancement` flag.
  - Z‑series split by Z value.
  - Added NXdata for root‑level detector/image display.
- **app**
  - `tomoh52nx` – Added warnings for files already containing NXtomo entries, auto‑creates output directories, checks write permissions, splits Z‑series.

### Changed

- **app**
  - `patch-nx` – Modify existing NXtomo (add dark/flat, change frame type).
- **converter → h5_to_nx**
  - Enforced relative paths for output files.

### Misc

- Minimum required **h5py ≥ 3**.
- Adopted **black** code‑style formatting.

## [0.3.4] - 2020‑10‑05

### Fixed

- Logging issues in the converter.

## [0.3.3] - 2020‑08‑26

### Added

- **h5_to_nx**
  - `set-param` option to pre‑define parameters (e.g., energy) and avoid interactive prompts.
- **io**
  - Support for HDF5 files via `tomoscan.io.HDF5File`.

## [0.3.1] - 2020‑08‑19

### Added

- `field_of_view` parameter.
- Plugin system allowing users to define motor positions from a Python script (PR !19).

## [0.3.0] - 2020‑03‑20

### Added

- **app**
  - Various options to set titles.
- **h5_to_nx**
  - Plugin support for custom motor positions.
  - Distances now expressed in **metres**.
- **edf_to_nx**
  - Distances now expressed in **metres**.

## [0.2.0] - 2020‑04‑22

### Added

- Entry point on `__main__`.
- **converter → h5_to_nx**
  - Optional callback for input handling.
- **doc**
  - API documentation.
  - Tutorials for `tomoedf2nx` and `tomoh5tonx`.

## [0.1.0] - 2020‑03‑12

### Added

- **app**
  - `tomoedf2nx` – Convert Bliss + EDF acquisitions to HDF5/NXtomo.
  - `tomoh5tonx` – Convert Bliss/HDF5 acquisitions to NXtomo.
- **converter**
  - `h5_to_nx` – Core conversion function from Bliss HDF5 to NXtomo.
  - `get_bliss_tomo_entries` – Retrieve Bliss “roor” entries (e.g., `tomo:basic`, `tomo:fullturn`).
