# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from azure.core.exceptions import HttpResponseError


class AclFailedEntry(Model):
    """AclFailedEntry.

    :param name:
    :type name: str
    :param type:
    :type type: str
    :param error_message:
    :type error_message: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, type: str=None, error_message: str=None, **kwargs) -> None:
        super(AclFailedEntry, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.error_message = error_message


class FileSystem(Model):
    """FileSystem.

    :param name:
    :type name: str
    :param last_modified:
    :type last_modified: str
    :param e_tag:
    :type e_tag: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'last_modified': {'key': 'lastModified', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, last_modified: str=None, e_tag: str=None, **kwargs) -> None:
        super(FileSystem, self).__init__(**kwargs)
        self.name = name
        self.last_modified = last_modified
        self.e_tag = e_tag


class FileSystemList(Model):
    """FileSystemList.

    :param filesystems:
    :type filesystems: list[~azure.storage.filedatalake.models.FileSystem]
    """

    _attribute_map = {
        'filesystems': {'key': 'filesystems', 'type': '[FileSystem]'},
    }

    def __init__(self, *, filesystems=None, **kwargs) -> None:
        super(FileSystemList, self).__init__(**kwargs)
        self.filesystems = filesystems


class LeaseAccessConditions(Model):
    """Additional parameters for a set of operations.

    :param lease_id: If specified, the operation only succeeds if the
     resource's lease is active and matches this ID.
    :type lease_id: str
    """

    _attribute_map = {
        'lease_id': {'key': '', 'type': 'str'},
    }

    def __init__(self, *, lease_id: str=None, **kwargs) -> None:
        super(LeaseAccessConditions, self).__init__(**kwargs)
        self.lease_id = lease_id


class ModifiedAccessConditions(Model):
    """Additional parameters for a set of operations.

    :param if_modified_since: Specify this header value to operate only on a
     blob if it has been modified since the specified date/time.
    :type if_modified_since: datetime
    :param if_unmodified_since: Specify this header value to operate only on a
     blob if it has not been modified since the specified date/time.
    :type if_unmodified_since: datetime
    :param if_match: Specify an ETag value to operate only on blobs with a
     matching value.
    :type if_match: str
    :param if_none_match: Specify an ETag value to operate only on blobs
     without a matching value.
    :type if_none_match: str
    """

    _attribute_map = {
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
    }

    def __init__(self, *, if_modified_since=None, if_unmodified_since=None, if_match: str=None, if_none_match: str=None, **kwargs) -> None:
        super(ModifiedAccessConditions, self).__init__(**kwargs)
        self.if_modified_since = if_modified_since
        self.if_unmodified_since = if_unmodified_since
        self.if_match = if_match
        self.if_none_match = if_none_match


class Path(Model):
    """Path.

    :param name:
    :type name: str
    :param is_directory:  Default value: False .
    :type is_directory: bool
    :param last_modified:
    :type last_modified: str
    :param e_tag:
    :type e_tag: str
    :param content_length:
    :type content_length: long
    :param owner:
    :type owner: str
    :param group:
    :type group: str
    :param permissions:
    :type permissions: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_directory': {'key': 'isDirectory', 'type': 'bool'},
        'last_modified': {'key': 'lastModified', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'content_length': {'key': 'contentLength', 'type': 'long'},
        'owner': {'key': 'owner', 'type': 'str'},
        'group': {'key': 'group', 'type': 'str'},
        'permissions': {'key': 'permissions', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, is_directory: bool=False, last_modified: str=None, e_tag: str=None, content_length: int=None, owner: str=None, group: str=None, permissions: str=None, **kwargs) -> None:
        super(Path, self).__init__(**kwargs)
        self.name = name
        self.is_directory = is_directory
        self.last_modified = last_modified
        self.e_tag = e_tag
        self.content_length = content_length
        self.owner = owner
        self.group = group
        self.permissions = permissions


class PathHTTPHeaders(Model):
    """Additional parameters for a set of operations, such as: Path_create,
    Path_update, Path_flush_data, Path_append_data.

    :param cache_control: Optional. Sets the blob's cache control. If
     specified, this property is stored with the blob and returned with a read
     request.
    :type cache_control: str
    :param content_encoding: Optional. Sets the blob's content encoding. If
     specified, this property is stored with the blob and returned with a read
     request.
    :type content_encoding: str
    :param content_language: Optional. Set the blob's content language. If
     specified, this property is stored with the blob and returned with a read
     request.
    :type content_language: str
    :param content_disposition: Optional. Sets the blob's Content-Disposition
     header.
    :type content_disposition: str
    :param content_type: Optional. Sets the blob's content type. If specified,
     this property is stored with the blob and returned with a read request.
    :type content_type: str
    :param content_md5: Specify the transactional md5 for the body, to be
     validated by the service.
    :type content_md5: bytearray
    :param transactional_content_hash: Specify the transactional md5 for the
     body, to be validated by the service.
    :type transactional_content_hash: bytearray
    """

    _attribute_map = {
        'cache_control': {'key': '', 'type': 'str'},
        'content_encoding': {'key': '', 'type': 'str'},
        'content_language': {'key': '', 'type': 'str'},
        'content_disposition': {'key': '', 'type': 'str'},
        'content_type': {'key': '', 'type': 'str'},
        'content_md5': {'key': '', 'type': 'bytearray'},
        'transactional_content_hash': {'key': '', 'type': 'bytearray'},
    }

    def __init__(self, *, cache_control: str=None, content_encoding: str=None, content_language: str=None, content_disposition: str=None, content_type: str=None, content_md5: bytearray=None, transactional_content_hash: bytearray=None, **kwargs) -> None:
        super(PathHTTPHeaders, self).__init__(**kwargs)
        self.cache_control = cache_control
        self.content_encoding = content_encoding
        self.content_language = content_language
        self.content_disposition = content_disposition
        self.content_type = content_type
        self.content_md5 = content_md5
        self.transactional_content_hash = transactional_content_hash


class PathList(Model):
    """PathList.

    :param paths:
    :type paths: list[~azure.storage.filedatalake.models.Path]
    """

    _attribute_map = {
        'paths': {'key': 'paths', 'type': '[Path]'},
    }

    def __init__(self, *, paths=None, **kwargs) -> None:
        super(PathList, self).__init__(**kwargs)
        self.paths = paths


class SetAccessControlRecursiveResponse(Model):
    """SetAccessControlRecursiveResponse.

    :param directories_successful:
    :type directories_successful: int
    :param files_successful:
    :type files_successful: int
    :param failure_count:
    :type failure_count: int
    :param failed_entries:
    :type failed_entries:
     list[~azure.storage.filedatalake.models.AclFailedEntry]
    """

    _attribute_map = {
        'directories_successful': {'key': 'directoriesSuccessful', 'type': 'int'},
        'files_successful': {'key': 'filesSuccessful', 'type': 'int'},
        'failure_count': {'key': 'failureCount', 'type': 'int'},
        'failed_entries': {'key': 'failedEntries', 'type': '[AclFailedEntry]'},
    }

    def __init__(self, *, directories_successful: int=None, files_successful: int=None, failure_count: int=None, failed_entries=None, **kwargs) -> None:
        super(SetAccessControlRecursiveResponse, self).__init__(**kwargs)
        self.directories_successful = directories_successful
        self.files_successful = files_successful
        self.failure_count = failure_count
        self.failed_entries = failed_entries


class SourceModifiedAccessConditions(Model):
    """Additional parameters for create operation.

    :param source_if_match: Specify an ETag value to operate only on blobs
     with a matching value.
    :type source_if_match: str
    :param source_if_none_match: Specify an ETag value to operate only on
     blobs without a matching value.
    :type source_if_none_match: str
    :param source_if_modified_since: Specify this header value to operate only
     on a blob if it has been modified since the specified date/time.
    :type source_if_modified_since: datetime
    :param source_if_unmodified_since: Specify this header value to operate
     only on a blob if it has not been modified since the specified date/time.
    :type source_if_unmodified_since: datetime
    """

    _attribute_map = {
        'source_if_match': {'key': '', 'type': 'str'},
        'source_if_none_match': {'key': '', 'type': 'str'},
        'source_if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'source_if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, *, source_if_match: str=None, source_if_none_match: str=None, source_if_modified_since=None, source_if_unmodified_since=None, **kwargs) -> None:
        super(SourceModifiedAccessConditions, self).__init__(**kwargs)
        self.source_if_match = source_if_match
        self.source_if_none_match = source_if_none_match
        self.source_if_modified_since = source_if_modified_since
        self.source_if_unmodified_since = source_if_unmodified_since


class StorageError(Model):
    """StorageError.

    :param error: The service error response object.
    :type error: ~azure.storage.filedatalake.models.StorageErrorError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'StorageErrorError'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(StorageError, self).__init__(**kwargs)
        self.error = error


class StorageErrorException(HttpResponseError):
    """Server responsed with exception of type: 'StorageError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, response, deserialize, *args):

      model_name = 'StorageError'
      self.error = deserialize(model_name, response)
      if self.error is None:
          self.error = deserialize.dependencies[model_name]()
      super(StorageErrorException, self).__init__(response=response)


class StorageErrorError(Model):
    """The service error response object.

    :param code: The service error code.
    :type code: str
    :param message: The service error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'Code', 'type': 'str'},
        'message': {'key': 'Message', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, message: str=None, **kwargs) -> None:
        super(StorageErrorError, self).__init__(**kwargs)
        self.code = code
        self.message = message
