/*
 * Copyright (c) 1991 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef lint
static  char rcsid[] =
    "@(#)$Header: disk.c,v 1.10 91/03/04 16:33:13 leres Exp $ (LBL)";
#endif

/*
 * disk - disk usage routines
 */

#include <sys/file.h>
#include <sys/param.h>
#ifndef ultrix
#ifndef SYSV
#if BSD < 199006
/* Old BSD */
#include <sys/vfs.h>
#else
/* New BSD */
#include <sys/types.h>
#include <sys/mount.h>
#endif
#else
/* SYSV */
#ifdef FUNET
#ifdef FUNET_DEBUG
#include <stdio.h>
extern int verbose;
extern int debug;
#endif
#include <sys/types.h>
#include <sys/statvfs.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#define DFS
#include <sys/ustat.h>
#endif
#else
/* Ultrix */
#include <sys/types.h>
#include <sys/mount.h>
#endif
#ifdef SYSV
#include <string.h>
#else
#include <strings.h>
#endif

#include "dexpire.h"
#include "disk.h"

/* Returns free space of specified filesystem in kbytes */
disk_usage(fs, usedp, freep, inodep)
	char *fs;
	long *usedp, *freep, *inodep;
{
#ifndef ultrix
#ifndef SYSV
	/* BSD code */
	struct statfs fsb;

	if (statfs(fs, &fsb) < 0)
		return(-1);

	/* Return the stats (unknown values are set to -1) */
	if (fsb.f_blocks < 0 || fsb.f_bfree < 0)
		*usedp = -1;
	else
		*usedp = fsb.f_blocks - fsb.f_bfree;
	*freep = fsb.f_bavail;
	if (fsb.f_files < 0 || fsb.f_ffree < 0)
		*inodep = -1;
	else
		*inodep = fsb.f_files - fsb.f_ffree;
#else
#ifdef FUNET
	struct statvfs buf;

	statvfs(fs, &buf);
#ifdef FUNET_DEBUG
	if (debug) {
		fprintf(stdout, "Filesystem stats from %s:\n", fs);
		fprintf(stdout, "f_bsize=%d\n", buf.f_bsize);
		fprintf(stdout, "f_frsize=%d\n", buf.f_frsize);
		fprintf(stdout, "f_blocks=%d\n", buf.f_blocks);
		fprintf(stdout, "f_bfree=%d\n", buf.f_bfree);
		fprintf(stdout, "f_bavail=%d\n", buf.f_bavail);
		fprintf(stdout, "f_files=%d\n", buf.f_files);
		fprintf(stdout, "f_ffree=%d\n", buf.f_ffree);
		fprintf(stdout, "f_favail=%d\n", buf.f_favail);
		fprintf(stdout, "f_namemax=%d\n", buf.f_namemax);
		fprintf(stdout, "f_basetype=%s\n", buf.f_basetype);
	} 
#endif
	*inodep=buf.f_ffree;
	*freep=buf.f_bavail/1024*buf.f_frsize;
	*usedp=(buf.f_blocks-buf.f_bfree)/1024*buf.f_frsize;

#else
	/* SYSV code */
	struct stat sb;
	struct statfs fsb;
	struct ustat usb;
#define BLOCKSIZE     512

	if (statfs(fs, &fsb, sizeof(fsb), 0) < 0)
		return(-1);

	if (stat(fs, &sb) < 0)
		return(-1);

	if (ustat(sb.st_dev, &usb))
		return(-1);

	/* Return the stats (unknown values are set to -1) */
	if (usb.f_tinode < 0)
		*inodep = -1;
	else
		*inodep = usb.f_tinode;

	if (usb.f_tfree < 0)
		*freep = -1;
	else
		*freep = usb.f_tfree * BLOCKSIZE / 1024;

	if (fsb.f_blocks < 0 | fsb.f_bfree < 0)
		*usedp = -1;
	else
		*usedp = (fsb.f_blocks - fsb.f_bfree) * BLOCKSIZE / 1024;
#endif
#endif
#else
	/* Ultrix code */
	struct fs_data fsb;

	if (statfs(fs, &fsb) != 1 ) /* if != 1, error or fs not mounted */
		return(-1);

	*usedp = (long)(fsb.fd_btot - fsb.fd_bfree);
	*freep = (long)fsb.fd_bfreen;
	*inodep = (long)(fsb.fd_gtot - fsb.fd_gfree);
#endif
	return(0);
}
