#ifdef RCSID
static char RcsId[] = "@(#)$Revision: 1.1 $";
#endif
/*
$Header: /hdf/hdf/v3.2/test/RCS/tdfp.c,v 1.1 1992/02/10 20:59:34 chouck beta $

$Log: tdfp.c,v $
 * Revision 1.1  1992/02/10  20:59:34  chouck
 * Initial revision
 *
*/
#include "hdf.h"

#define TESTFILE "tpal.hdf"

char pal1[768], pal2[768];
char ipal[768];

main()
{
    int i;
    int ret;
    uint16 ref1, ref2;

    for (i=0;i<256;i++) {
       pal1[3*i] = i;
       pal1[3*i + 1] = i;
       pal1[3*i + 2] = i;
       pal2[i] = i;
       pal2[i + 256] = i;
       pal2[i + 512] = i;
    }
    puts("Putting pal1 in new file.");
    ret = DFPputpal(TESTFILE, pal1, 0, "w");
    printf("ret from DFPputpal is %d\n", ret);
    puts("Getting ref1");
    ref1 = DFPlastref();
    printf("ref1 is %u\n", ref1);
    puts("Putting pal2 in file.");
    ret = DFPaddpal(TESTFILE, pal2);
    printf("ret from DFPaddpal is %d\n", ret);
    puts("Getting ref2");
    ref2 = DFPlastref();
    printf("ref2 is %u\n", ref2);
    puts("Restarting palette interface.");
    ret = DFPrestart();
    printf("ret from DFPrestart is %d\n", ret);
    puts("Reading pal1.");
    ret = DFPgetpal(TESTFILE, ipal);
    printf("ret from DFPgetpal is %d\n", ret);
    for (i=0;i<768;i++)
       if (ipal[i] != pal1[i])
           printf("Error at %d, ipal %d pal1 %d\n", i, ipal[i], pal1[i]);
    puts("Getting ref1");
    ref1 = DFPlastref();
    printf("ref1 is %u\n", ref1);
    puts("Reading pal2.");
    ret = DFPgetpal(TESTFILE, ipal);
    printf("ret from DFPgetpal is %d\n", ret);
    for (i=0;i<768;i++)
       if (ipal[i] != pal2[i])
           printf("Error at %d, ipal %d pal2 %d\n", i, ipal[i], pal2[i]);
    puts("Getting ref2");
    ref2 = DFPlastref();
    printf("ref2 is %u\n", ref2);
    puts("Getting number of pals.");
    ret = DFPnpals(TESTFILE);
    printf("Number of pals is %d\n", ret);
    puts("Setting read ref to ref2.");
    ret = DFPreadref(TESTFILE, ref2);
    printf("ret from DFPreadref is %d\n", ret);
    puts("Reading pal2.");
    ret = DFPgetpal(TESTFILE, ipal);
    printf("ret from DFPgetpal is %d\n", ret);
    for (i=0;i<768;i++)
       if (ipal[i] != pal2[i])
           printf("Error at %d, ipal %d pal2 %d\n", i, ipal[i], pal2[i]);
    puts("Setting read ref to ref1.");
    ret = DFPreadref(TESTFILE, ref1);
    printf("ret from DFPreadref is %d\n", ret);
    puts("Reading pal1.");
    ret = DFPgetpal(TESTFILE, ipal);
    printf("ret from DFPgetpal is %d\n", ret);
    for (i=0;i<768;i++)
       if (ipal[i] != pal1[i])
           printf("Error at %d, ipal %d pal1 %d\n", i, ipal[i], pal1[i]);
    puts("Setting write ref to ref2.");
    puts("Modifying pal1");
    for (i=0;i<256;i++)
       pal1[i+256] = 255 - i;
    ret = DFPwriteref(TESTFILE, ref1);
    printf("ret from DFPwriteref is %d\n", ret);
    puts("Reading pal1.");
    ret = DFPputpal(TESTFILE, pal1, 1, "a");
    printf("ret from DFPputpal is %d\n", ret);
    puts("Setting read ref to ref1.");
    ret = DFPreadref(TESTFILE, ref1);
    printf("ret from DFPreadref is %d\n", ret);
    puts("Reading pal1.");
    ret = DFPgetpal(TESTFILE, ipal);
    printf("ret from DFPgetpal is %d\n", ret);
    for (i=0;i<768;i++)
       if (ipal[i] != pal1[i])
           printf("Error at %d, ipal %d pal1 %d\n", i, ipal[i], pal1[i]);
}

