#ifdef RCSID
static char RcsId[] = "@(#)$Revision: 1.1 $";
#endif
/*
$Header: /hdf/hdf/v3.2/test/RCS/tdf24.c,v 1.1 1992/02/10 21:11:56 chouck beta $

$Log: tdf24.c,v $
 * Revision 1.1  1992/02/10  21:11:56  chouck
 * Initial revision
 *
*/
#include "hdf.h"

#define XSIZE 100
#define YSIZE 100
#define TESTFILE "tdf24.hdf"
#define RESULT(a) printf("ret from %s is %d\n", a, ret)

main()
{
    int32 xd, yd;
    int il;
    char buf[XSIZE][YSIZE][3];
    char buf1[XSIZE][3][YSIZE];
    char buf2[3][XSIZE][YSIZE];
    char in[XSIZE][YSIZE][3];
    char in1[XSIZE][3][YSIZE];
    char in2[3][XSIZE][YSIZE];
    int i,j,ret;

    for (i=0; i < XSIZE; i++)
       for (j=0; j < YSIZE; j++) {
           buf[i][j][0] = buf[i][j][1] = buf[i][j][2] = i + j;
           buf1[i][0][j] = buf1[i][1][j] = buf1[i][2][j] = i | j;
           buf2[0][i][j] = buf2[1][i][j] = buf2[2][i][j] = i ^ j;
       }

    puts("Setting il to 0");
    ret = DF24setil(0);
    RESULT("DF24setil");
    puts("Putting buffer 0");
    ret = DF24putimage(TESTFILE, &(buf[0][0][0]), XSIZE, YSIZE);
    RESULT("DF24putimage");

    puts("Setting il to 1");
    ret = DF24setil(1);
    RESULT("DF24setil");
    puts("Adding buffer 1");
    ret = DF24addimage(TESTFILE, &(buf1[0][0][0]), XSIZE, YSIZE);
    RESULT("DF24addimage");

    puts("Setting il to 2");
    ret = DF24setil(2);
    RESULT("DF24setil");
    puts("Adding buffer 2");
    ret = DF24addimage(TESTFILE, &(buf2[0][0][0]), XSIZE, YSIZE);
    RESULT("DF24addimage");

    puts("Restarting file");
    ret = DF24restart();
    RESULT("DF24restart");
    puts("Req il 0");
    ret = DF24reqil(0);
    RESULT("DF24reqil");
    puts("Getting dims");
    ret = DF24getdims(TESTFILE, &xd, &yd, &il);
    RESULT("DF24getdims");
    printf("xdim %d ydim %d il %d\n", xd, yd, il);
    puts("Getting image");
    ret = DF24getimage(TESTFILE,(VOIDP)in, XSIZE, YSIZE);
    RESULT("DF24getimage");
     for (i=0; i< XSIZE; i++)
       for (j=0; j< YSIZE; j++)
           if (in[i][j][0] != buf[i][j][0]
               || in[i][j][1] != buf[i][j][1]
               || in[i][j][2] != buf[i][j][2]) {
               printf("error at %d %d\n",i,j);
       }
    puts("Getting dims");
    ret = DF24getdims(TESTFILE, &xd, &yd, &il);
    RESULT("DF24getdims");
    printf("xdim %d ydim %d il %d\n", xd, yd, il);
    puts("Getting image");
    ret = DF24getimage(TESTFILE,(VOIDP)in, XSIZE, YSIZE);
    RESULT("DF24getimage");
     for (i=0; i< XSIZE; i++)
       for (j=0; j< YSIZE; j++)
           if (in[i][j][0] != buf1[i][0][j]
               || in[i][j][1] != buf1[i][1][j]
               || in[i][j][2] != buf1[i][2][j]) {
               printf("error at %d %d\n",i,j);
       }
    puts("Getting dims");
    ret = DF24getdims(TESTFILE, &xd, &yd, &il);
    RESULT("DF24getdims");
    printf("xdim %d ydim %d il %d\n", xd, yd, il);
    puts("Getting image");
    ret = DF24getimage(TESTFILE,(VOIDP)in, XSIZE, YSIZE);
    RESULT("DF24getimage");
     for (i=0; i< XSIZE; i++)
       for (j=0; j< YSIZE; j++)
           if (in[i][j][0] != buf2[0][i][j]
               || in[i][j][1] != buf2[1][i][j]
               || in[i][j][2] != buf2[2][i][j]) {
               printf("error at %d %d\n",i,j);
       }

    puts("Restarting file");
    ret = DF24restart();
    RESULT("DF24restart");
    puts("Req il 1");
    ret = DF24reqil(1);
    RESULT("DF24reqil");
    puts("Getting dims");
    ret = DF24getdims(TESTFILE, &xd, &yd, &il);
    RESULT("DF24getdims");
    printf("xdim %d ydim %d il %d\n", xd, yd, il);
    puts("Getting image");
    ret = DF24getimage(TESTFILE,(VOIDP)in1, XSIZE, YSIZE);
    RESULT("DF24getimage");
     for (i=0; i< XSIZE; i++)
       for (j=0; j< YSIZE; j++)
           if (in1[i][0][j] != buf[i][j][0]
               || in1[i][1][j] != buf[i][j][1]
               || in1[i][2][j] != buf[i][j][2]) {
               printf("error at %d %d\n",i,j);
       }
    puts("Getting dims");
    ret = DF24getdims(TESTFILE, &xd, &yd, &il);
    RESULT("DF24getdims");
    printf("xdim %d ydim %d il %d\n", xd, yd, il);
    puts("Getting image");
    ret = DF24getimage(TESTFILE,(VOIDP)in1, XSIZE, YSIZE);
    RESULT("DF24getimage");
     for (i=0; i< XSIZE; i++)
       for (j=0; j< YSIZE; j++)
           if (in1[i][0][j] != buf1[i][0][j]
               || in1[i][1][j] != buf1[i][1][j]
               || in1[i][2][j] != buf1[i][2][j]) {
               printf("error at %d %d\n",i,j);
       }
    puts("Getting dims");
    ret = DF24getdims(TESTFILE, &xd, &yd, &il);
    RESULT("DF24getdims");
    printf("xdim %d ydim %d il %d\n", xd, yd, il);
    puts("Getting image");
    ret = DF24getimage(TESTFILE,(VOIDP)in1, XSIZE, YSIZE);
    RESULT("DF24getimage");
     for (i=0; i< XSIZE; i++)
       for (j=0; j< YSIZE; j++)
           if (in1[i][0][j] != buf2[0][i][j]
               || in1[i][1][j] != buf2[1][i][j]
               || in1[i][2][j] != buf2[2][i][j]) {
               printf("error at %d %d\n",i,j);
       }

    puts("Restarting file");
    ret = DF24restart();
    RESULT("DF24restart");
    puts("Req il 2");
    ret = DF24reqil(2);
    RESULT("DF24reqil");
    puts("Getting dims");
    ret = DF24getdims(TESTFILE, &xd, &yd, &il);
    RESULT("DF24getdims");
    printf("xdim %d ydim %d il %d\n", xd, yd, il);
    puts("Getting image");
    ret = DF24getimage(TESTFILE,(VOIDP)in2, XSIZE, YSIZE);
    RESULT("DF24getimage");
     for (i=0; i< XSIZE; i++)
       for (j=0; j< YSIZE; j++)
           if (in2[0][i][j] != buf[i][j][0]
               || in2[1][i][j] != buf[i][j][1]
               || in2[2][i][j] != buf[i][j][2]) {
               printf("error at %d %d\n",i,j);
       }
    puts("Getting dims");
    ret = DF24getdims(TESTFILE, &xd, &yd, &il);
    RESULT("DF24getdims");
    printf("xdim %d ydim %d il %d\n", xd, yd, il);
    puts("Getting image");
    ret = DF24getimage(TESTFILE,(VOIDP)in2, XSIZE, YSIZE);
    RESULT("DF24getimage");
     for (i=0; i< XSIZE; i++)
       for (j=0; j< YSIZE; j++)
           if (in2[0][i][j] != buf1[i][0][j]
               || in2[1][i][j] != buf1[i][1][j]
               || in2[2][i][j] != buf1[i][2][j]) {
               printf("error at %d %d\n",i,j);
       }
    puts("Getting dims");
    ret = DF24getdims(TESTFILE, &xd, &yd, &il);
    RESULT("DF24getdims");
    printf("xdim %d ydim %d il %d\n", xd, yd, il);
    puts("Getting image");
    ret = DF24getimage(TESTFILE,(VOIDP)in2, XSIZE, YSIZE);
    RESULT("DF24getimage");
     for (i=0; i< XSIZE; i++)
       for (j=0; j< YSIZE; j++)
           if (in2[0][i][j] != buf2[0][i][j]
               || in2[1][i][j] != buf2[1][i][j]
               || in2[2][i][j] != buf2[2][i][j]) {
               printf("error at %d %d\n",i,j);
       }
}
