#!perl -w
use Config;
use AutoSplit;
use File::Find;
$zipexe = $Config{zip};
unless (defined $zipexe) {
  die "Config.pm doesn't know where zip is; can't make the test zips";
}

my %flags;
my %command;

while (<DATA>) {
  next if /^#/;
  # file	flags
  my ($dir, $flag) = /^([a-z]+)\t([^\#]*)/;
  if ($flag =~ /;/) {
    $flag =~ s/;([^|]*)\|(.*)//;
    $command{$dir} = [$1, $2];
  }
  $flags{$dir} = $2;
}
      
chdir 'test-zip-contents' or die "chdir $!";
my @dirs = grep {/^[a-z]{3,}$/} <*>;
foreach my $dir (@dirs) {
  my $zip = "../$dir.zip";
  my $flags = $flags{$dir} || '';

  while (-f $zip) {
    unlink $zip or die "unlink $zip: $!";
  }
  chdir $dir or die "chdir $!";
  if (-d "auto") {
    find ({no_chdir=>1, wanted=>sub {
	     autosplit ($_, "auto") if /\.pm$/;
	   }}, '.');
  }
  my $command = "$zipexe $flags ../$zip *";
  print "$command\n";
  system $command and die "zip failed"; 
  if ($command{$dir}) {
    my ($fore, $flags) = @{$command{$dir}};
    $command = "$fore | $zipexe $flags ../$zip";
    print "$command\n";
    system $command and die "subsiduary thing failed"; 
  }
  chdir ".."  or die "chdir $!";
}

chdir ".."  or die "chdir $!";

my $script = <<EOM;
#!perl -w
# This script is autogenerated from pushme.pl and pullyou.zip
# Any edits you make here will be lost
# Beware. Even just saving this file from your text editor may corrupt it.
EOM

undef $/;
open FH, "pushme.pl" or die "open: $!";
binmode FH;
$script .= <FH>;
open FH, "pullyou.zip" or die "open: $!";
binmode FH;
$script .= <FH>;
open FH, ">pushmepullyou.t" or die "open: $!";
binmode FH;
print FH $script or die "print: $!";
close FH or die "print: $!";

# 
my $command = "$zipexe -A pushmepullyou.t";
system $command and die "'$command' failed";

__DATA__
one	-0	# Store, don't compress
two	-X	# exclude extra attributes
three	-rD	# recurse, no directories
# Reassembly code isn't taxed by this, as end central dir is intact in buffer
four	-1	; echo Longer zipfile comment is safe | -z
# Comment length chosen to test reassembly code by splitting end central dir
nineovertwo	-9	; echo zipfile comment | -z
