package WWW::Salesforce::Constants;

use strict;
use warnings;

our $VERSION = '0.400';

#thanks to Jun Shimizu and Garth Webb
our %TYPES = (
    'account' => {
        'accountnumber'        => 'xsd:string',
        'active__c'            => 'xsd:string',
        'annualrevenue'        => 'xsd:double',
        'billingcity'          => 'xsd:string',
        'billingcountry'       => 'xsd:string',
        'billingpostalcode'    => 'xsd:string',
        'billingstate'         => 'xsd:string',
        'billingstreet'        => 'xsd:string',
        'createdbyid'          => 'xsd:string',
        'createddate'          => 'xsd:dateTime',
        'customerpriority__c'  => 'xsd:string',
        'description'          => 'xsd:string',
        'fax'                  => 'xsd:string',
        'industry'             => 'xsd:string',
        'lastmodifiedbyid'     => 'xsd:string',
        'lastmodifieddate'     => 'xsd:dateTime',
        'name'                 => 'xsd:string',
        'numberofemployees'    => 'xsd:int',
        'numberoflocations__c' => 'xsd:double',
        'ownerid'              => 'xsd:string',
        'ownership'            => 'xsd:string',
        'parentid'             => 'xsd:string',
        'phone'                => 'xsd:string',
        'rating'               => 'xsd:string',
        'slaexpirationdate__c' => 'xsd:date',
        'slaserialnumber__c'   => 'xsd:string',
        'sla__c'               => 'xsd:string',
        'shippingcity'         => 'xsd:string',
        'shippingcountry'      => 'xsd:string',
        'shippingpostalcode'   => 'xsd:string',
        'shippingstate'        => 'xsd:string',
        'shippingstreet'       => 'xsd:string',
        'sic'                  => 'xsd:string',
        'site'                 => 'xsd:string',
        'systemmodstamp'       => 'xsd:dateTime',
        'tickersymbol'         => 'xsd:string',
        'type'                 => 'xsd:string',
        'upsellopportunity__c' => 'xsd:string',
        'website'              => 'xsd:string',
    },
    'accountcontactrole' => {
        'accountid'        => 'xsd:string',
        'contactid'        => 'xsd:string',
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'isprimary'        => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'role'             => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'accountpartner' => {
        'accountfromid'    => 'xsd:string',
        'accounttoid'      => 'xsd:string',
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'isprimary'        => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'opportunityid'    => 'xsd:string',
        'role'             => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'accountshare' => {
        'accountaccesslevel'     => 'xsd:string',
        'accountid'              => 'xsd:string',
        'caseaccesslevel'        => 'xsd:string',
        'lastmodifiedbyid'       => 'xsd:string',
        'lastmodifieddate'       => 'xsd:dateTime',
        'opportunityaccesslevel' => 'xsd:string',
        'rowcause'               => 'xsd:string',
        'userorgroupid'          => 'xsd:string',
    },
    'approval' => {
        'approvecomment'   => 'xsd:string',
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'ownerid'          => 'xsd:string',
        'parentid'         => 'xsd:string',
        'requestcomment'   => 'xsd:string',
        'status'           => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'asset' => {
        'accountid'           => 'xsd:string',
        'contactid'           => 'xsd:string',
        'createdbyid'         => 'xsd:string',
        'createddate'         => 'xsd:dateTime',
        'description'         => 'xsd:string',
        'installdate'         => 'xsd:date',
        'iscompetitorproduct' => 'xsd:boolean',
        'lastmodifiedbyid'    => 'xsd:string',
        'lastmodifieddate'    => 'xsd:dateTime',
        'name'                => 'xsd:string',
        'price'               => 'xsd:double',
        'product2id'          => 'xsd:string',
        'purchasedate'        => 'xsd:date',
        'quantity'            => 'xsd:double',
        'serialnumber'        => 'xsd:string',
        'status'              => 'xsd:string',
        'systemmodstamp'      => 'xsd:dateTime',
        'usageenddate'        => 'xsd:date',
    },
    'assignmentrule' => {
        'active'           => 'xsd:boolean',
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'name'             => 'xsd:string',
        'ruletype'         => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'attachment' => {
        'body'             => 'xsd:base64Binary',
        'bodylength'       => 'xsd:int',
        'contenttype'      => 'xsd:string',
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'isprivate'        => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'name'             => 'xsd:string',
        'ownerid'          => 'xsd:string',
        'parentid'         => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'businesshours' => {
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'fridayend'        => 'xsd:string',
        'fridaystart'      => 'xsd:string',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'mondayend'        => 'xsd:string',
        'mondaystart'      => 'xsd:string',
        'saturdayend'      => 'xsd:string',
        'saturdaystart'    => 'xsd:string',
        'sundayend'        => 'xsd:string',
        'sundaystart'      => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
        'thursdayend'      => 'xsd:string',
        'thursdaystart'    => 'xsd:string',
        'tuesdayend'       => 'xsd:string',
        'tuesdaystart'     => 'xsd:string',
        'wednesdayend'     => 'xsd:string',
        'wednesdaystart'   => 'xsd:string',
    },
    'businessprocess' => {
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'description'      => 'xsd:string',
        'isactive'         => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'name'             => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
        'tableenumorid'    => 'xsd:string',
    },
    'campaign' => {
        'actualcost'               => 'xsd:double',
        'amountallopportunities'   => 'xsd:double',
        'amountwonopportunities'   => 'xsd:double',
        'budgetedcost'             => 'xsd:double',
        'createdbyid'              => 'xsd:string',
        'createddate'              => 'xsd:dateTime',
        'description'              => 'xsd:string',
        'enddate'                  => 'xsd:date',
        'expectedresponse'         => 'xsd:double',
        'expectedrevenue'          => 'xsd:double',
        'field1__c'                => 'xsd:string',
        'isactive'                 => 'xsd:boolean',
        'lastmodifiedbyid'         => 'xsd:string',
        'lastmodifieddate'         => 'xsd:dateTime',
        'name'                     => 'xsd:string',
        'numberofcontacts'         => 'xsd:int',
        'numberofconvertedleads'   => 'xsd:int',
        'numberofleads'            => 'xsd:int',
        'numberofopportunities'    => 'xsd:int',
        'numberofresponses'        => 'xsd:int',
        'numberofwonopportunities' => 'xsd:int',
        'numbersent'               => 'xsd:double',
        'ownerid'                  => 'xsd:string',
        'startdate'                => 'xsd:date',
        'status'                   => 'xsd:string',
        'systemmodstamp'           => 'xsd:dateTime',
        'type'                     => 'xsd:string',
    },
    'campaignmember' => {
        'campaignid'         => 'xsd:string',
        'contactid'          => 'xsd:string',
        'createdbyid'        => 'xsd:string',
        'createddate'        => 'xsd:dateTime',
        'firstrespondeddate' => 'xsd:date',
        'hasresponded'       => 'xsd:boolean',
        'lastmodifiedbyid'   => 'xsd:string',
        'lastmodifieddate'   => 'xsd:dateTime',
        'leadid'             => 'xsd:string',
        'status'             => 'xsd:string',
        'systemmodstamp'     => 'xsd:dateTime',
    },
    'case' => {
        'assetid'                 => 'xsd:string',
        'casenumber'              => 'xsd:string',
        'closeddate'              => 'xsd:dateTime',
        'contactid'               => 'xsd:string',
        'createdbyid'             => 'xsd:string',
        'createddate'             => 'xsd:dateTime',
        'description'             => 'xsd:string',
        'engineeringreqnumber__c' => 'xsd:string',
        'isclosed'                => 'xsd:boolean',
        'isescalated'             => 'xsd:boolean',
        'lastmodifiedbyid'        => 'xsd:string',
        'lastmodifieddate'        => 'xsd:dateTime',
        'origin'                  => 'xsd:string',
        'ownerid'                 => 'xsd:string',
        'potentialliability__c'   => 'xsd:string',
        'priority'                => 'xsd:string',
        'product__c'              => 'xsd:string',
        'reason'                  => 'xsd:string',
        'slaviolation__c'         => 'xsd:string',
        'status'                  => 'xsd:string',
        'subject'                 => 'xsd:string',
        'suppliedcompany'         => 'xsd:string',
        'suppliedemail'           => 'xsd:string',
        'suppliedname'            => 'xsd:string',
        'suppliedphone'           => 'xsd:string',
        'systemmodstamp'          => 'xsd:dateTime',
        'type'                    => 'xsd:string',
    },
    'casecomment' => {
        'commentbody'    => 'xsd:string',
        'createdbyid'    => 'xsd:string',
        'createddate'    => 'xsd:dateTime',
        'ispublished'    => 'xsd:boolean',
        'parentid'       => 'xsd:string',
        'systemmodstamp' => 'xsd:dateTime',
    },
    'casehistory' => {
        'caseid'      => 'xsd:string',
        'createdbyid' => 'xsd:string',
        'createddate' => 'xsd:dateTime',
        'field'       => 'xsd:string',
        'newvalue'    => 'xsd:anytype',
        'oldvalue'    => 'xsd:anytype',
    },
    'caseshare' => {
        'caseaccesslevel'  => 'xsd:string',
        'caseid'           => 'xsd:string',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'rowcause'         => 'xsd:string',
        'userorgroupid'    => 'xsd:string',
    },
    'casesolution' => {
        'caseid'         => 'xsd:string',
        'createdbyid'    => 'xsd:string',
        'createddate'    => 'xsd:dateTime',
        'solutionid'     => 'xsd:string',
        'systemmodstamp' => 'xsd:dateTime',
    },
    'casestatus' => {
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'isclosed'         => 'xsd:boolean',
        'isdefault'        => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'masterlabel'      => 'xsd:string',
        'sortorder'        => 'xsd:int',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'contact' => {
        'accountid'         => 'xsd:string',
        'assistantname'     => 'xsd:string',
        'assistantphone'    => 'xsd:string',
        'birthdate'         => 'xsd:date',
        'createdbyid'       => 'xsd:string',
        'createddate'       => 'xsd:dateTime',
        'department'        => 'xsd:string',
        'description'       => 'xsd:string',
        'email'             => 'xsd:string',
        'fax'               => 'xsd:string',
        'firstname'         => 'xsd:string',
        'homephone'         => 'xsd:string',
        'languages__c'      => 'xsd:string',
        'lastcurequestdate' => 'xsd:dateTime',
        'lastcuupdatedate'  => 'xsd:dateTime',
        'lastmodifiedbyid'  => 'xsd:string',
        'lastmodifieddate'  => 'xsd:dateTime',
        'lastname'          => 'xsd:string',
        'leadsource'        => 'xsd:string',
        'level__c'          => 'xsd:string',
        'mailingcity'       => 'xsd:string',
        'mailingcountry'    => 'xsd:string',
        'mailingpostalcode' => 'xsd:string',
        'mailingstate'      => 'xsd:string',
        'mailingstreet'     => 'xsd:string',
        'mobilephone'       => 'xsd:string',
        'othercity'         => 'xsd:string',
        'othercountry'      => 'xsd:string',
        'otherphone'        => 'xsd:string',
        'otherpostalcode'   => 'xsd:string',
        'otherstate'        => 'xsd:string',
        'otherstreet'       => 'xsd:string',
        'ownerid'           => 'xsd:string',
        'phone'             => 'xsd:string',
        'reportstoid'       => 'xsd:string',
        'salutation'        => 'xsd:string',
        'systemmodstamp'    => 'xsd:dateTime',
        'title'             => 'xsd:string',
    },
    'contract' => {
        'accountid'             => 'xsd:string',
        'activatedbyid'         => 'xsd:string',
        'activateddate'         => 'xsd:dateTime',
        'billingcity'           => 'xsd:string',
        'billingcountry'        => 'xsd:string',
        'billingpostalcode'     => 'xsd:string',
        'billingstate'          => 'xsd:string',
        'billingstreet'         => 'xsd:string',
        'companysigneddate'     => 'xsd:date',
        'companysignedid'       => 'xsd:string',
        'contractnumber'        => 'xsd:string',
        'contractterm'          => 'xsd:int',
        'createdbyid'           => 'xsd:string',
        'createddate'           => 'xsd:dateTime',
        'customersigneddate'    => 'xsd:date',
        'customersignedid'      => 'xsd:string',
        'customersignedtitle'   => 'xsd:string',
        'description'           => 'xsd:string',
        'enddate'               => 'xsd:date',
        'lastapproveddate'      => 'xsd:dateTime',
        'lastmodifiedbyid'      => 'xsd:string',
        'lastmodifieddate'      => 'xsd:dateTime',
        'ownerexpirationnotice' => 'xsd:string',
        'ownerid'               => 'xsd:string',
        'specialterms'          => 'xsd:string',
        'startdate'             => 'xsd:date',
        'status'                => 'xsd:string',
        'statuscode'            => 'xsd:string',
        'systemmodstamp'        => 'xsd:dateTime',
    },
    'contractcontactrole' => {
        'contactid'        => 'xsd:string',
        'contractid'       => 'xsd:string',
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'isprimary'        => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'role'             => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'contractstatus' => {
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'isdefault'        => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'masterlabel'      => 'xsd:string',
        'sortorder'        => 'xsd:int',
        'statuscode'       => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'customobject1__c' => {
        'contact__c'       => 'xsd:string',
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'field1__c'        => 'xsd:string',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'lead__c'          => 'xsd:string',
        'name'             => 'xsd:string',
        'ownerid'          => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'customer__c' => {
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'name'             => 'xsd:string',
        'ownerid'          => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'document' => {
        'authorid'          => 'xsd:string',
        'body'              => 'xsd:base64Binary',
        'bodylength'        => 'xsd:int',
        'contenttype'       => 'xsd:string',
        'createdbyid'       => 'xsd:string',
        'createddate'       => 'xsd:dateTime',
        'description'       => 'xsd:string',
        'folderid'          => 'xsd:string',
        'isinternaluseonly' => 'xsd:boolean',
        'ispublic'          => 'xsd:boolean',
        'keywords'          => 'xsd:string',
        'lastmodifiedbyid'  => 'xsd:string',
        'lastmodifieddate'  => 'xsd:dateTime',
        'name'              => 'xsd:string',
        'systemmodstamp'    => 'xsd:dateTime',
        'type'              => 'xsd:string',
        'url'               => 'xsd:string',
    },
    'entityhistory' => {
        'createdbyid'       => 'xsd:string',
        'createddate'       => 'xsd:dateTime',
        'fieldname'         => 'xsd:string',
        'newvalue'          => 'xsd:anytype',
        'oldvalue'          => 'xsd:anytype',
        'parentid'          => 'xsd:string',
        'parentsobjecttype' => 'xsd:string',
    },
    'event' => {
        'accountid'                => 'xsd:string',
        'activitydate'             => 'xsd:date',
        'activitydateTime'         => 'xsd:dateTime',
        'createdbyid'              => 'xsd:string',
        'createddate'              => 'xsd:dateTime',
        'description'              => 'xsd:string',
        'durationinminutes'        => 'xsd:int',
        'isalldayevent'            => 'xsd:boolean',
        'ischild'                  => 'xsd:boolean',
        'isgroupevent'             => 'xsd:boolean',
        'isprivate'                => 'xsd:boolean',
        'isrecurrence'             => 'xsd:boolean',
        'lastmodifiedbyid'         => 'xsd:string',
        'lastmodifieddate'         => 'xsd:dateTime',
        'location'                 => 'xsd:string',
        'ownerid'                  => 'xsd:string',
        'recurrenceactivityid'     => 'xsd:string',
        'recurrencedayofmonth'     => 'xsd:int',
        'recurrencedayofweekmask'  => 'xsd:int',
        'recurrenceenddateonly'    => 'xsd:date',
        'recurrenceinstance'       => 'xsd:string',
        'recurrenceinterval'       => 'xsd:int',
        'recurrencemonthofyear'    => 'xsd:string',
        'recurrencestartdateTime'  => 'xsd:dateTime',
        'recurrencetimezonesidkey' => 'xsd:string',
        'recurrencetype'           => 'xsd:string',
        'showas'                   => 'xsd:string',
        'subject'                  => 'xsd:string',
        'systemmodstamp'           => 'xsd:dateTime',
        'whatid'                   => 'xsd:string',
        'whoid'                    => 'xsd:string',
    },
    'eventattendee' => {
        'attendeeid'       => 'xsd:string',
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'eventid'          => 'xsd:string',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'respondeddate'    => 'xsd:dateTime',
        'response'         => 'xsd:string',
        'status'           => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'fiscalyearsettings' => {
        'isstandardyear'     => 'xsd:boolean',
        'name'               => 'xsd:string',
        'periodid'           => 'xsd:string',
        'periodlabelscheme'  => 'xsd:string',
        'periodprefix'       => 'xsd:string',
        'quarterlabelscheme' => 'xsd:string',
        'quarterprefix'      => 'xsd:string',
        'systemmodstamp'     => 'xsd:dateTime',
        'weeklabelscheme'    => 'xsd:string',
        'yeartype'           => 'xsd:string',
    },
    'folder' => {
        'accesstype'       => 'xsd:string',
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'isreadonly'       => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'name'             => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
        'type'             => 'xsd:string',
    },
    'group' => {
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'email'            => 'xsd:string',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'name'             => 'xsd:string',
        'ownerid'          => 'xsd:string',
        'relatedid'        => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
        'type'             => 'xsd:string',
    },
    'groupmember' => {
        'groupid'        => 'xsd:string',
        'systemmodstamp' => 'xsd:dateTime',
        'userorgroupid'  => 'xsd:string',
    },
    'lead' => {
        'annualrevenue'          => 'xsd:double',
        'city'                   => 'xsd:string',
        'company'                => 'xsd:string',
        'convertedaccountid'     => 'xsd:string',
        'convertedcontactid'     => 'xsd:string',
        'converteddate'          => 'xsd:date',
        'convertedopportunityid' => 'xsd:string',
        'country'                => 'xsd:string',
        'createdbyid'            => 'xsd:string',
        'createddate'            => 'xsd:dateTime',
        'currentgenerators__c'   => 'xsd:string',
        'description'            => 'xsd:string',
        'email'                  => 'xsd:string',
        'fax'                    => 'xsd:string',
        'field1__c'              => 'xsd:date',
        'firstname'              => 'xsd:string',
        'industry'               => 'xsd:string',
        'isconverted'            => 'xsd:boolean',
        'isunreadbyowner'        => 'xsd:boolean',
        'lastmodifiedbyid'       => 'xsd:string',
        'lastmodifieddate'       => 'xsd:dateTime',
        'lastname'               => 'xsd:string',
        'leadsource'             => 'xsd:string',
        'mobilephone'            => 'xsd:string',
        'numberofemployees'      => 'xsd:int',
        'numberoflocations__c'   => 'xsd:double',
        'ownerid'                => 'xsd:string',
        'phone'                  => 'xsd:string',
        'postalcode'             => 'xsd:string',
        'primary__c'             => 'xsd:string',
        'productinterest__c'     => 'xsd:string',
        'rating'                 => 'xsd:string',
        'siccode__c'             => 'xsd:string',
        'salutation'             => 'xsd:string',
        'state'                  => 'xsd:string',
        'status'                 => 'xsd:string',
        'street'                 => 'xsd:string',
        'systemmodstamp'         => 'xsd:dateTime',
        'title'                  => 'xsd:string',
        'website'                => 'xsd:string',
    },
    'leadshare' => {
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'leadaccesslevel'  => 'xsd:string',
        'leadid'           => 'xsd:string',
        'rowcause'         => 'xsd:string',
        'userorgroupid'    => 'xsd:string',
    },
    'leadstatus' => {
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'isconverted'      => 'xsd:boolean',
        'isdefault'        => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'masterlabel'      => 'xsd:string',
        'sortorder'        => 'xsd:int',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'mailmergetemplate' => {
        'body'             => 'xsd:base64Binary',
        'bodylength'       => 'xsd:int',
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'description'      => 'xsd:string',
        'filename'         => 'xsd:string',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'lastuseddate'     => 'xsd:dateTime',
        'name'             => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'note' => {
        'body'             => 'xsd:string',
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'isprivate'        => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'ownerid'          => 'xsd:string',
        'parentid'         => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
        'title'            => 'xsd:string',
    },
    'opportunity' => {
        'accountid'                     => 'xsd:string',
        'amount'                        => 'xsd:double',
        'campaignid'                    => 'xsd:string',
        'closedate'                     => 'xsd:date',
        'createdbyid'                   => 'xsd:string',
        'createddate'                   => 'xsd:dateTime',
        'currentgenerators__c'          => 'xsd:string',
        'deliveryinstallationstatus__c' => 'xsd:string',
        'description'                   => 'xsd:string',
        'expectedrevenue'               => 'xsd:double',
        'forecastcategory'              => 'xsd:string',
        'hasopportunitylineitem'        => 'xsd:boolean',
        'isclosed'                      => 'xsd:boolean',
        'isprivate'                     => 'xsd:boolean',
        'iswon'                         => 'xsd:boolean',
        'lastmodifiedbyid'              => 'xsd:string',
        'lastmodifieddate'              => 'xsd:dateTime',
        'leadsource'                    => 'xsd:string',
        'maincompetitors__c'            => 'xsd:string',
        'name'                          => 'xsd:string',
        'nextstep'                      => 'xsd:string',
        'ordernumber__c'                => 'xsd:string',
        'ownerid'                       => 'xsd:string',
        'pricebook2id'                  => 'xsd:string',
        'pricebookid'                   => 'xsd:string',
        'probability'                   => 'xsd:double',
        'stagename'                     => 'xsd:string',
        'systemmodstamp'                => 'xsd:dateTime',
        'totalopportunityquantity'      => 'xsd:double',
        'trackingnumber__c'             => 'xsd:string',
        'type'                          => 'xsd:string',
    },
    'opportunitycompetitor' => {
        'competitorname'   => 'xsd:string',
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'opportunityid'    => 'xsd:string',
        'strengths'        => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
        'weaknesses'       => 'xsd:string',
    },
    'opportunitycontactrole' => {
        'contactid'        => 'xsd:string',
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'isprimary'        => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'opportunityid'    => 'xsd:string',
        'role'             => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'opportunityhistory' => {
        'amount'           => 'xsd:double',
        'closedate'        => 'xsd:date',
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'expectedrevenue'  => 'xsd:double',
        'forecastcategory' => 'xsd:string',
        'opportunityid'    => 'xsd:string',
        'probability'      => 'xsd:double',
        'stagename'        => 'xsd:string',
    },
    'opportunitylineitem' => {
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'description'      => 'xsd:string',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'listprice'        => 'xsd:double',
        'opportunityid'    => 'xsd:string',
        'pricebookentryid' => 'xsd:string',
        'productid'        => 'xsd:string',
        'quantity'         => 'xsd:double',
        'servicedate'      => 'xsd:date',
        'sortorder'        => 'xsd:int',
        'systemmodstamp'   => 'xsd:dateTime',
        'totalprice'       => 'xsd:double',
        'unitprice'        => 'xsd:double',
    },
    'opportunitypartner' => {
        'accounttoid'      => 'xsd:string',
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'isprimary'        => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'opportunityid'    => 'xsd:string',
        'role'             => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'opportunityshare' => {
        'lastmodifiedbyid'       => 'xsd:string',
        'lastmodifieddate'       => 'xsd:dateTime',
        'opportunityaccesslevel' => 'xsd:string',
        'opportunityid'          => 'xsd:string',
        'rowcause'               => 'xsd:string',
        'userorgroupid'          => 'xsd:string',
    },
    'opportunitystage' => {
        'createdbyid'        => 'xsd:string',
        'createddate'        => 'xsd:dateTime',
        'defaultprobability' => 'xsd:double',
        'description'        => 'xsd:string',
        'forecastcategory'   => 'xsd:string',
        'isactive'           => 'xsd:boolean',
        'isclosed'           => 'xsd:boolean',
        'iswon'              => 'xsd:boolean',
        'lastmodifiedbyid'   => 'xsd:string',
        'lastmodifieddate'   => 'xsd:dateTime',
        'masterlabel'        => 'xsd:string',
        'sortorder'          => 'xsd:int',
        'systemmodstamp'     => 'xsd:dateTime',
    },
    'organization' => {
        'city'                           => 'xsd:string',
        'compliancebccemail'             => 'xsd:string',
        'country'                        => 'xsd:string',
        'createdbyid'                    => 'xsd:string',
        'createddate'                    => 'xsd:dateTime',
        'defaultaccountandcontactaccess' => 'xsd:string',
        'defaultcalendaraccess'          => 'xsd:string',
        'defaultcaseaccess'              => 'xsd:string',
        'defaultleadaccess'              => 'xsd:string',
        'defaultlocalesidkey'            => 'xsd:string',
        'defaultopportunityaccess'       => 'xsd:string',
        'defaultpricebookaccess'         => 'xsd:string',
        'division'                       => 'xsd:string',
        'fax'                            => 'xsd:string',
        'fiscalyearstartmonth'           => 'xsd:int',
        'languagelocalekey'              => 'xsd:string',
        'lastmodifiedbyid'               => 'xsd:string',
        'lastmodifieddate'               => 'xsd:dateTime',
        'maxactionsperrule'              => 'xsd:int',
        'maxrulesperentity'              => 'xsd:int',
        'name'                           => 'xsd:string',
        'phone'                          => 'xsd:string',
        'postalcode'                     => 'xsd:string',
        'primarycontact'                 => 'xsd:string',
        'receivesadmininfoemails'        => 'xsd:boolean',
        'receivesinfoemails'             => 'xsd:boolean',
        'state'                          => 'xsd:string',
        'street'                         => 'xsd:string',
        'systemmodstamp'                 => 'xsd:dateTime',
        'uiskin'                         => 'xsd:string',
        'usesstartdateasfiscalyearname'  => 'xsd:boolean',
        'webtocasedefaultorigin'         => 'xsd:string',
    },
    'partner' => {
        'accountfromid'    => 'xsd:string',
        'accounttoid'      => 'xsd:string',
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'isprimary'        => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'opportunityid'    => 'xsd:string',
        'role'             => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'partnerrole' => {
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'masterlabel'      => 'xsd:string',
        'reverserole'      => 'xsd:string',
        'sortorder'        => 'xsd:int',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'period' => {
        'enddate'          => 'xsd:date',
        'isforecastperiod' => 'xsd:boolean',
        'number'           => 'xsd:int',
        'periodlabel'      => 'xsd:string',
        'quarterlabel'     => 'xsd:string',
        'startdate'        => 'xsd:date',
        'systemmodstamp'   => 'xsd:dateTime',
        'type'             => 'xsd:string',
    },
    'pricebook' => {
        'isactive'         => 'xsd:boolean',
        'lastmodifieddate' => 'xsd:dateTime',
        'name'             => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'pricebook2' => {
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'description'      => 'xsd:string',
        'isactive'         => 'xsd:boolean',
        'isstandard'       => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'name'             => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'pricebookentry' => {
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'isactive'         => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'name'             => 'xsd:string',
        'pricebook2id'     => 'xsd:string',
        'product2id'       => 'xsd:string',
        'productcode'      => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
        'unitprice'        => 'xsd:double',
        'usestandardprice' => 'xsd:boolean',
    },
    'product' => {
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'defaultprice'     => 'xsd:double',
        'description'      => 'xsd:string',
        'isactive'         => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'name'             => 'xsd:string',
        'pricebookid'      => 'xsd:string',
        'productcode'      => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'product2' => {
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'description'      => 'xsd:string',
        'family'           => 'xsd:string',
        'isactive'         => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'name'             => 'xsd:string',
        'productcode'      => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'profile' => {
        'createdbyid'                         => 'xsd:string',
        'createddate'                         => 'xsd:dateTime',
        'description'                         => 'xsd:string',
        'lastmodifiedbyid'                    => 'xsd:string',
        'lastmodifieddate'                    => 'xsd:dateTime',
        'name'                                => 'xsd:string',
        'permissionsapiuseronly'              => 'xsd:boolean',
        'permissionsconvertleads'             => 'xsd:boolean',
        'permissionscreatemultiforce'         => 'xsd:boolean',
        'permissionscustomizeapplication'     => 'xsd:boolean',
        'permissionseditactivatedorders'      => 'xsd:boolean',
        'permissionseditevent'                => 'xsd:boolean',
        'permissionseditforecast'             => 'xsd:boolean',
        'permissionseditopplineitemunitprice' => 'xsd:boolean',
        'permissionseditpublicdocuments'      => 'xsd:boolean',
        'permissionseditreadonlyfields'       => 'xsd:boolean',
        'permissionsedittask'                 => 'xsd:boolean',
        'permissionsimportleads'              => 'xsd:boolean',
        'permissionsinstallmultiforce'        => 'xsd:boolean',
        'permissionsmanagecases'              => 'xsd:boolean',
        'permissionsmanagecategories'         => 'xsd:boolean',
        'permissionsmanagecssusers'           => 'xsd:boolean',
        'permissionsmanagedashboards'         => 'xsd:boolean',
        'permissionsmanageleads'              => 'xsd:boolean',
        'permissionsmanageselfservice'        => 'xsd:boolean',
        'permissionsmanagesolutions'          => 'xsd:boolean',
        'permissionsmanageterritories'        => 'xsd:boolean',
        'permissionsmanageusers'              => 'xsd:boolean',
        'permissionsmodifyalldata'            => 'xsd:boolean',
        'permissionspasswordneverexpires'     => 'xsd:boolean',
        'permissionspublishmultiforce'        => 'xsd:boolean',
        'permissionsrunreports'               => 'xsd:boolean',
        'permissionssendsitrequests'          => 'xsd:boolean',
        'permissionstransferanyentity'        => 'xsd:boolean',
        'permissionstransferanylead'          => 'xsd:boolean',
        'permissionsuseteamreassignwizards'   => 'xsd:boolean',
        'permissionsviewagentconsole'         => 'xsd:boolean',
        'permissionsviewalldata'              => 'xsd:boolean',
        'permissionsviewsetup'                => 'xsd:boolean',
        'systemmodstamp'                      => 'xsd:dateTime',
    },
    'recordtype' => {
        'businessprocessid' => 'xsd:string',
        'createdbyid'       => 'xsd:string',
        'createddate'       => 'xsd:dateTime',
        'description'       => 'xsd:string',
        'isactive'          => 'xsd:boolean',
        'lastmodifiedbyid'  => 'xsd:string',
        'lastmodifieddate'  => 'xsd:dateTime',
        'name'              => 'xsd:string',
        'sobjecttype'       => 'xsd:string',
        'systemmodstamp'    => 'xsd:dateTime',
    },
    'scontrol' => {
        'binary'           => 'xsd:base64Binary',
        'bodylength'       => 'xsd:int',
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'description'      => 'xsd:string',
        'filename'         => 'xsd:string',
        'htmlwrapper'      => 'xsd:string',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'name'             => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'selfserviceuser' => {
        'contactid'         => 'xsd:string',
        'createdbyid'       => 'xsd:string',
        'createddate'       => 'xsd:dateTime',
        'email'             => 'xsd:string',
        'firstname'         => 'xsd:string',
        'isactive'          => 'xsd:boolean',
        'languagelocalekey' => 'xsd:string',
        'lastlogindate'     => 'xsd:dateTime',
        'lastmodifiedbyid'  => 'xsd:string',
        'lastmodifieddate'  => 'xsd:dateTime',
        'lastname'          => 'xsd:string',
        'localesidkey'      => 'xsd:string',
        'superuser'         => 'xsd:boolean',
        'systemmodstamp'    => 'xsd:dateTime',
        'timezonesidkey'    => 'xsd:string',
        'username'          => 'xsd:string',
    },
    'solution' => {
        'createdbyid'           => 'xsd:string',
        'createddate'           => 'xsd:dateTime',
        'ispublished'           => 'xsd:boolean',
        'ispublishedinpublickb' => 'xsd:boolean',
        'isreviewed'            => 'xsd:boolean',
        'lastmodifiedbyid'      => 'xsd:string',
        'lastmodifieddate'      => 'xsd:dateTime',
        'ownerid'               => 'xsd:string',
        'solutionname'          => 'xsd:string',
        'solutionnote'          => 'xsd:string',
        'solutionnumber'        => 'xsd:string',
        'status'                => 'xsd:string',
        'systemmodstamp'        => 'xsd:dateTime',
    },
    'solutionstatus' => {
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'isdefault'        => 'xsd:boolean',
        'isreviewed'       => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'masterlabel'      => 'xsd:string',
        'sortorder'        => 'xsd:int',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'task' => {
        'accountid'        => 'xsd:string',
        'activitydate'     => 'xsd:date',
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'description'      => 'xsd:string',
        'isclosed'         => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'ownerid'          => 'xsd:string',
        'priority'         => 'xsd:string',
        'status'           => 'xsd:string',
        'subject'          => 'xsd:string',
        'systemmodstamp'   => 'xsd:dateTime',
        'whatid'           => 'xsd:string',
        'whoid'            => 'xsd:string',
    },
    'taskpriority' => {
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'isdefault'        => 'xsd:boolean',
        'ishighpriority'   => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'masterlabel'      => 'xsd:string',
        'sortorder'        => 'xsd:int',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'taskstatus' => {
        'createdbyid'      => 'xsd:string',
        'createddate'      => 'xsd:dateTime',
        'isclosed'         => 'xsd:boolean',
        'isdefault'        => 'xsd:boolean',
        'lastmodifiedbyid' => 'xsd:string',
        'lastmodifieddate' => 'xsd:dateTime',
        'masterlabel'      => 'xsd:string',
        'sortorder'        => 'xsd:int',
        'systemmodstamp'   => 'xsd:dateTime',
    },
    'user' => {
        'alias'                         => 'xsd:string',
        'city'                          => 'xsd:string',
        'companyname'                   => 'xsd:string',
        'country'                       => 'xsd:string',
        'createdbyid'                   => 'xsd:string',
        'createddate'                   => 'xsd:dateTime',
        'department'                    => 'xsd:string',
        'division'                      => 'xsd:string',
        'email'                         => 'xsd:string',
        'emailencodingkey'              => 'xsd:string',
        'employeenumber'                => 'xsd:string',
        'fax'                           => 'xsd:string',
        'firstname'                     => 'xsd:string',
        'isactive'                      => 'xsd:boolean',
        'languagelocalekey'             => 'xsd:string',
        'lastlogindate'                 => 'xsd:dateTime',
        'lastmodifiedbyid'              => 'xsd:string',
        'lastmodifieddate'              => 'xsd:dateTime',
        'lastname'                      => 'xsd:string',
        'localesidkey'                  => 'xsd:string',
        'mobilephone'                   => 'xsd:string',
        'offlinepdatrialexpirationdate' => 'xsd:dateTime',
        'offlinetrialexpirationdate'    => 'xsd:dateTime',
        'phone'                         => 'xsd:string',
        'postalcode'                    => 'xsd:string',
        'profileid'                     => 'xsd:string',
        'receivesadmininfoemails'       => 'xsd:boolean',
        'receivesinfoemails'            => 'xsd:boolean',
        'state'                         => 'xsd:string',
        'street'                        => 'xsd:string',
        'systemmodstamp'                => 'xsd:dateTime',
        'timezonesidkey'                => 'xsd:string',
        'title'                         => 'xsd:string',
        'userpermissionsmarketinguser'  => 'xsd:boolean',
        'userpermissionsofflineuser'    => 'xsd:boolean',
        'userroleid'                    => 'xsd:string',
        'username'                      => 'xsd:string',
    },
    'userrole' => {
        'caseaccessforaccountowner'        => 'xsd:string',
        'lastmodifiedbyid'                 => 'xsd:string',
        'lastmodifieddate'                 => 'xsd:dateTime',
        'name'                             => 'xsd:string',
        'opportunityaccessforaccountowner' => 'xsd:string',
        'parentroleid'                     => 'xsd:string',
        'rollupdescription'                => 'xsd:string',
        'systemmodstamp'                   => 'xsd:dateTime',
    },
    'weblink' => {
        'createdbyid'       => 'xsd:string',
        'createddate'       => 'xsd:dateTime',
        'encodingkey'       => 'xsd:string',
        'hasmenubar'        => 'xsd:boolean',
        'hasscrollbars'     => 'xsd:boolean',
        'hastoolbar'        => 'xsd:boolean',
        'height'            => 'xsd:int',
        'isresizable'       => 'xsd:boolean',
        'lastmodifiedbyid'  => 'xsd:string',
        'lastmodifieddate'  => 'xsd:dateTime',
        'linktype'          => 'xsd:string',
        'name'              => 'xsd:string',
        'opentype'          => 'xsd:string',
        'pageorsobjecttype' => 'xsd:string',
        'position'          => 'xsd:string',
        'scontrolid'        => 'xsd:string',
        'showslocation'     => 'xsd:boolean',
        'showsstatus'       => 'xsd:boolean',
        'systemmodstamp'    => 'xsd:dateTime',
        'url'               => 'xsd:string',
        'width'             => 'xsd:int',
    },
    'sobject' => {},
);

sub type {
    my $class = shift;
    my ( $object, $key ) = @_;
    return $TYPES{ lc($object) }->{ lc($key) };
}

sub register_type {
    my $class = shift;
    my ( $object, $key, $type ) = @_;
    $TYPES{ lc($object) }->{ lc($key) } = $type;
}

sub register_types {
    my $class = shift;
    my (%param) = @_;

    foreach my $object ( keys %param ) {
        foreach my $key ( keys %{ $param{$object} } ) {
            $TYPES{ lc($object) }->{ lc($key) } = $param{$object}->{$key};
        }
    }
}

1;
