#!/usr/bin/env perl
package WWW::SFDC::Apex;
# ABSTRACT: Interface to the salesforce.com Apex SOAP Api

use 5.12.0;
use strict;
use warnings;

our $VERSION = '0.30'; # VERSION

use Log::Log4perl ':easy';
use SOAP::Lite;

use Moo;
with "WWW::SFDC::Role::SessionConsumer";

has 'uri',
    is => 'ro',
    default=> "http://soap.sforce.com/2006/08/apex";

sub _extractURL {
    return $_[1]->{serverUrl} =~ s{/u/}{/s/}r;
}



sub compileAndTest {
  my ($self, @names) = @_;

  return $self->_call(
    'compileAndTest',
    map {\SOAP::Data->name(classes => $_)} @names
    );
}


sub compileClasses {
  my ($self, @names) = @_;

  return $self->_call(
    'compileClasses',
    SOAP::Data->value(map {SOAP::Data->name(scripts => $_)} @names)
    );
}


sub compileTriggers {
  my ($self, @names) = @_;

  return $self->_call(
    'compileTriggers',
    map {\SOAP::Data->name(classes => $_)} @names
    );
}


sub executeAnonymous {
  my ($self, $code, %options) = @_;
  my ($result, $headers) = $self->_call(
    'executeAnonymous',
    SOAP::Data->name(string => $code),
    $options{debug} ? SOAP::Header->name('DebuggingHeader' => \SOAP::Data->name(
        debugLevel => 'DEBUGONLY'
      ))->uri($self->uri) : (),
   );

  LOGDIE "ExecuteAnonymous failed to compile: " . $result->{compileProblem}
    if $result->{compiled} eq "false";

  LOGDIE "ExecuteAnonymous failed to complete: " . $result->{exceptionMessage}
    if ($result->{success} eq "false");

  return $result, (defined $headers ? $headers->{debugLog} : ());
}


sub runTests {
  my ($self, @names) = @_;

  return $self->_call(
    'runTests',
    map {\SOAP::Data->name(classes => $_)} @names
    );
}


sub wsdlToApex {
    ...
}

1;

__END__

=pod

=head1 NAME

WWW::SFDC::Apex - Interface to the salesforce.com Apex SOAP Api

=head1 VERSION

version 0.30

=head1 METHODS

=head2 compileAndTest

=head2 compileClasses

=head2 compileTriggers

=head2 executeAnonymous

=head2 runTests

=head2 wsdlToApex

Unimplemented

=head1 AUTHOR

Alexander Brett <alexander.brett@sophos.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by Sophos Limited.

This is free software, licensed under:

  The MIT (X11) License

The full text of the license can be found in the
F<LICENSE> file included with this distribution.

=cut
