#
# Makefile.PL
#
# Copyright (C) 1999-2006 Gregor N. Purdy. All rights reserved.
# This program is free software. It is subject to the same license as Perl.
#
# [ $Id: Makefile.PL 2209 2006-07-04 19:55:33Z gregor $ ]
#

use ExtUtils::MakeMaker;

WriteMakefile (
  NAME         => 'Scrape::USPS::ZipLookup',
  VERSION_FROM => 'lib/Scrape/USPS/ZipLookup.pm',
  PREREQ_PM    => {
    WWW::Mechanize         => 1.14, # To communicate with USPS and get HTML
  },
  EXE_FILES    => [
    'script/stdaddr'
  ],
  AUTHOR       => 'Gregor N. Purdy (gregor@focusresearch.com)',
  ABSTRACT     => 'Programmatic interaction with the USPS Zip Code Lookup web application',
  dist         => { COMPRESS => 'gzip -9f', SUFFIX => 'gz' }
);

#
# End of file.
#
