package Game::HeroesVsAliens::Hero;

use Moo;

with 'Game::HeroesVsAliens::Role::ResourceDirectory';

use Game::HeroesVsAliens::Projectile;
use Data::LnArray;
use SDLx::Sprite::Animated;

has x => (
	is => 'rw'
);

has y => (
	is => 'rw'
);

has width => (
	is => 'rw',
	default => sub { 100 }
);

has height => (
	is => 'rw',
	default => sub { 100 }
);

has shooting => (
	is => 'rw',
	default => sub { 1 }
);

has block_shot => (
	is => 'rw',
	default => sub { 0 }

);

has health => (
	is => 'rw',
	default => sub { 100 }
);

has projectiles => (
	is => 'rw',
	default => sub { Data::LnArray->new }
);

has timer => (
	is => 'rw',
	default => sub { 0 }
);

has idle_sprite => (
	is => 'rw',
	default => sub {
		my $sprite = SDLx::Sprite::Animated->new( 
			image => $_[0]->resource_directory . 'resources/boy-hero-idle.png',
			width => 100,
			height => 100,
			type => 'reverse'
		);
		return $sprite;	
	}
);

has shooting_sprite => (
	is => 'rw',
	default => sub {
		my $sprite = SDLx::Sprite::Animated->new(
			image => $_[0]->resource_directory . 'resources/boy-hero-shooting.png',
			width => 100,
			height => 100,
		);
	}
);

sub draw {
	my ($self, $app) = @_;

	if ($self->shooting) {
		$self->shooting_sprite->rect->x($self->x);
		$self->shooting_sprite->rect->y($self->y);
		if ($app->frame % 3 == 0) {	
			$self->block_shot(0);	
			$self->shooting_sprite->next;
		}
		$self->shooting_sprite->draw($app->ctx);
	} else {
		$self->idle_sprite->rect->x($self->x);
		$self->idle_sprite->rect->y($self->y);
		if ($app->frame % 3 == 0) {
			$self->idle_sprite->next;
		}
		$self->idle_sprite->draw($app->ctx);
	}
	$app->draw_text($self->x + 15, $self->y + 15, 18, [255, 255, 255, 255], int($self->health))
}

sub update {
	my ($self, $app) = @_;
	if ($self->shooting && !$self->block_shot) {
		if ($self->shooting_sprite->current_frame == 1) {
			$self->projectiles->push(Game::HeroesVsAliens::Projectile->new({
				x => $self->x + 70,
				y => $self->y + 15,
			}));
			$self->block_shot(1);
		}
	} else {
		$self->timer(0);
	}
	$self->handle_projectiles($app);
}

sub handle_projectiles {
	my ($self, $app) = @_;
	my $projectiles = $self->projectiles;
	for (my $i = 0; $i < scalar @{$projectiles}; $i++) {
		$projectiles->[$i]->update($app);
		$projectiles->[$i]->draw($app);
		if ($projectiles->[$i]->collision) {
			if ( $projectiles->[$i]->explode_sprite->current_loop > 1 ) {
				$projectiles->splice($i, 1);
				$i--;
			}
		} else {
			my $aliens = $app->aliens;
			for (my $j = 0; $j < scalar @{$aliens}; $j++) {
				if ($aliens->[$j] && $projectiles->[$i] && $app->collision($projectiles->[$i], $aliens->[$j])) {
					$aliens->[$j]->health($aliens->[$j]->health - $projectiles->[$i]->power);
					$projectiles->[$i]->collision(1);
				}
			}
		}

		if ($projectiles->[$i] && $projectiles->[$i]->x > $app->app_width - $app->cell_size) {
			$projectiles->splice($i, 1);
			$i--;
		}
	}
}

1;
