package Task::CatInABox; # git description: 37d81df

#pod =pod
#pod
#pod =head1 NAME
#pod
#pod Task::CatInABox - Catalyst and related modules for exploring Catalyst
#pod
#pod =head1 DESCRIPTION
#pod
#pod This distribution defined a set of modules to cover common modules used
#pod in Catalyst applications.
#pod
#pod This package is used by L<Perl::Dist::CatInABox> to produce a standalone
#pod Catalyst installer for Win32, but is made available separately so that
#pod others can update their installations to match the same module set.
#pod
#pod The "Catalyst in a Box" module collection is curated by Kieren Diment
#pod E<lt>zarquon@cpan.orgE<gt>, please contact him regarding the list of
#pod modules and to request additions.
#pod
#pod =head1 MODULES
#pod
#pod =over
#pod
#pod =item *
#pod
#pod L<Catalyst::Devel>
#pod
#pod =item *
#pod
#pod L<Template|Template Toolkit>
#pod
#pod =item *
#pod
#pod L<DBIx::Class>
#pod
#pod =item *
#pod
#pod L<DBIx::Class::EncodedColumn>
#pod
#pod =item *
#pod
#pod L<DBIx::Class::TimeStamp>
#pod
#pod =item *
#pod
#pod L<DBIx::Class::InflateColumn::DateTime>
#pod
#pod =item *
#pod
#pod L<DBIx::Class::Schema::Loader>
#pod
#pod =item *
#pod
#pod L<Catalyst::View::TT>
#pod
#pod =item *
#pod
#pod L<Catalyst::View::JSON>
#pod
#pod =item *
#pod
#pod L<Catalyst::Model::DBIC::Schema>
#pod
#pod =item *
#pod
#pod L<Catalyst::Model::DBIC::File>
#pod
#pod =item *
#pod
#pod L<Catalyst::Plugin::Authentication>
#pod
#pod =item *
#pod
#pod L<Catalyst::Authentication::Store::DBIx::Class>
#pod
#pod =item *
#pod
#pod L<Catalyst::Authentication::Store::Htpasswd>
#pod
#pod =item *
#pod
#pod L<Catalyst::Authentication::Credential::Password>
#pod
#pod =item *
#pod
#pod L<Catalyst::Authentication::Credential::HTTP>
#pod
#pod =back
#pod
#pod =cut

use 5.008;
use strict;

our $VERSION = '0.04';

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Task::CatInABox

=head1 VERSION

version 0.04

=head1 DESCRIPTION

This distribution defined a set of modules to cover common modules used
in Catalyst applications.

This package is used by L<Perl::Dist::CatInABox> to produce a standalone
Catalyst installer for Win32, but is made available separately so that
others can update their installations to match the same module set.

The "Catalyst in a Box" module collection is curated by Kieren Diment
E<lt>zarquon@cpan.orgE<gt>, please contact him regarding the list of
modules and to request additions.

=head1 NAME

Task::CatInABox - Catalyst and related modules for exploring Catalyst

=head1 MODULES

=over

=item *

L<Catalyst::Devel>

=item *

L<Template|Template Toolkit>

=item *

L<DBIx::Class>

=item *

L<DBIx::Class::EncodedColumn>

=item *

L<DBIx::Class::TimeStamp>

=item *

L<DBIx::Class::InflateColumn::DateTime>

=item *

L<DBIx::Class::Schema::Loader>

=item *

L<Catalyst::View::TT>

=item *

L<Catalyst::View::JSON>

=item *

L<Catalyst::Model::DBIC::Schema>

=item *

L<Catalyst::Model::DBIC::File>

=item *

L<Catalyst::Plugin::Authentication>

=item *

L<Catalyst::Authentication::Store::DBIx::Class>

=item *

L<Catalyst::Authentication::Store::Htpasswd>

=item *

L<Catalyst::Authentication::Credential::Password>

=item *

L<Catalyst::Authentication::Credential::HTTP>

=back

=head1 COPYRIGHT

Copyright 2008 - 2009 Adam Kennedy.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SUPPORT

Please contact the curator with bugs or questions regarding the module list
and contact the author with bugs or questions regarding the L<Task> package.

You can find documentation for this module with the perldoc command.

Bugs may be submitted through L<the RT bug tracker|https://rt.cpan.org/Public/Dist/Display.html?Name=Task-CatInABox>
(or L<bug-Task-CatInABox@rt.cpan.org|mailto:bug-Task-CatInABox@rt.cpan.org>).

=head1 AUTHOR

Adam Kennedy E<lt>adamk@cpan.orgE<gt>

=head1 CONTRIBUTORS

=for stopwords Karen Etheridge Adam Kennedy Alexandr Ciornii Kieren Diment

=over 4

=item *

Karen Etheridge <ether@cpan.org>

=item *

Adam Kennedy <adam@ali.as>

=item *

Alexandr Ciornii <alexchorny@gmail.com>

=item *

Kieren Diment <zarquon@cpan.org>

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2008 by Adam Kennedy.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
