# Generated by default/object.tt
package Paws::LookoutVision::DatasetDescription;
  use Moose;
  has CreationTimestamp => (is => 'ro', isa => 'Str');
  has DatasetType => (is => 'ro', isa => 'Str');
  has ImageStats => (is => 'ro', isa => 'Paws::LookoutVision::DatasetImageStats');
  has LastUpdatedTimestamp => (is => 'ro', isa => 'Str');
  has ProjectName => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has StatusMessage => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutVision::DatasetDescription

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutVision::DatasetDescription object:

  $service_obj->Method(Att1 => { CreationTimestamp => $value, ..., StatusMessage => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutVision::DatasetDescription object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTimestamp

=head1 DESCRIPTION

The description for a dataset. For more information, see
DescribeDataset.

=head1 ATTRIBUTES


=head2 CreationTimestamp => Str

The Unix timestamp for the time and date that the dataset was created.


=head2 DatasetType => Str

The type of the dataset. The value C<train> represents a training
dataset or single dataset project. The value C<test> represents a test
dataset.


=head2 ImageStats => L<Paws::LookoutVision::DatasetImageStats>




=head2 LastUpdatedTimestamp => Str

The Unix timestamp for the date and time that the dataset was last
updated.


=head2 ProjectName => Str

The name of the project that contains the dataset.


=head2 Status => Str

The status of the dataset.


=head2 StatusMessage => Str

The status message for the dataset.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutVision>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

