package App::InteractivePerlTutorial::Chapter::IO::Diamond;

use 5.014000;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'The diamond operator';

1;
__DATA__

=encoding utf-8

=head1 The diamond operator

Another way to read input is with the diamond operator: B<< <> >>

The invocation arguments* to a program are normally a number of words on the command line after the name of the program. In this case, they give the names of the files your program will process in sequence:

$ ./my_program annie mary john        #  this means run the command "my program" and then process file annie* followed by file Mary  followed by file john

If you give no invocation arguments, the program should process the standard input stream; in the list above you can replace one of the file names by - for referring to the standard input.

B<@ARGV> is a special array that is preset by the Perl interpreter as the list of the invocation arguments.

The diamond operator is actually a special kind of line-input operator. But instead of getting the input from the keyboard, it comes from the user's choice of input:

  while (defined($line = <>)) {
    chomp($line);
    print "$line\n";
  }

This program will read [a line from file annie], [another line from file annie], etc until the end of file annie; then it will move on to file mary etc

You can use the diamond operator to shorten a program:

  while (<>) {
    chomp;
    print " $_ \n";
  }


=cut
