package WordList::EN::PersonName::PopularBabyName::US::SSA::2000::MaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-22'; # DATE
our $DIST = 'WordLists-EN-PersonName-PopularBabyName-US-SSA'; # DIST
our $VERSION = '0.003'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("num_words_contain_unicode",0,"num_words_contains_nonword_chars",0,"num_words_contains_unicode",0,"shortest_word_len",2,"avg_word_len",5.864,"num_words_contains_whitespace",0,"num_words_contain_whitespace",0,"num_words",1000,"num_words_contain_nonword_chars",0,"longest_word_len",11); # STATS

1;
# ABSTRACT: Top 1000 most popular names for male babies born in the USA in 2000 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::EN::PersonName::PopularBabyName::US::SSA::2000::MaleTop1000 - Top 1000 most popular names for male babies born in the USA in 2000 (from Social Security Administration)

=head1 VERSION

This document describes version 0.003 of WordList::EN::PersonName::PopularBabyName::US::SSA::2000::MaleTop1000 (from Perl distribution WordLists-EN-PersonName-PopularBabyName-US-SSA), released on 2020-05-22.

=head1 SYNOPSIS

 use WordList::EN::PersonName::PopularBabyName::US::SSA::2000::MaleTop1000;

 my $wl = WordList::EN::PersonName::PopularBabyName::US::SSA::2000::MaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Iterate
 my $first_word = $wl->first_word;
 while (defined(my $word = $wl->next_word)) { ... }

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.864 |
 | longest_word_len                 | 11    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-EN-PersonName-PopularBabyName-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-EN-PersonName-PopularBabyName-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-EN-PersonName-PopularBabyName-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Jacob
Michael
Matthew
Joshua
Christopher
Nicholas
Andrew
Joseph
Daniel
Tyler
William
Brandon
Ryan
John
Zachary
David
Anthony
James
Justin
Alexander
Jonathan
Christian
Austin
Dylan
Ethan
Benjamin
Noah
Samuel
Robert
Nathan
Cameron
Kevin
Thomas
Jose
Hunter
Jordan
Kyle
Caleb
Jason
Logan
Aaron
Eric
Brian
Gabriel
Adam
Jack
Isaiah
Juan
Luis
Connor
Charles
Elijah
Isaac
Steven
Evan
Jared
Sean
Timothy
Luke
Cody
Nathaniel
Alex
Seth
Mason
Richard
Carlos
Angel
Patrick
Devin
Bryan
Cole
Jackson
Ian
Garrett
Trevor
Jesus
Chase
Adrian
Mark
Blake
Sebastian
Antonio
Lucas
Jeremy
Gavin
Miguel
Julian
Dakota
Alejandro
Jesse
Dalton
Bryce
Tanner
Kenneth
Stephen
Jake
Victor
Spencer
Marcus
Paul
Brendan
Jeremiah
Xavier
Jeffrey
Tristan
Jalen
Jorge
Edward
Riley
Colton
Wyatt
Joel
Maxwell
Aidan
Travis
Shane
Colin
Dominic
Carson
Vincent
Derek
Oscar
Grant
Eduardo
Peter
Henry
Parker
Collin
Hayden
George
Bradley
Mitchell
Devon
Ricardo
Shawn
Taylor
Nicolas
Gregory
Francisco
Liam
Kaleb
Preston
Erik
Alexis
Owen
Omar
Diego
Dustin
Corey
Fernando
Clayton
Carter
Ivan
Jaden
Javier
Alec
Johnathan
Scott
Manuel
Cristian
Alan
Raymond
Brett
Max
Andres
Gage
Mario
Dawson
Dillon
Cesar
Wesley
Levi
Jakob
Chandler
Martin
Malik
Edgar
Sergio
Trenton
Josiah
Nolan
Marco
Peyton
Harrison
Hector
Micah
Roberto
Drew
Brady
Erick
Conner
Jonah
Casey
Jayden
Edwin
Emmanuel
Andre
Phillip
Brayden
Landon
Giovanni
Bailey
Ronald
Braden
Damian
Donovan
Ruben
Frank
Gerardo
Pedro
Andy
Chance
Abraham
Calvin
Trey
Cade
Donald
Derrick
Payton
Darius
Enrique
Keith
Raul
Jaylen
Troy
Jonathon
Cory
Marc
Eli
Skyler
Rafael
Trent
Griffin
Colby
Johnny
Chad
Armando
Kobe
Caden
Marcos
Cooper
Elias
Brenden
Israel
Avery
Zane
Dante
Josue
Zackary
Allen
Mathew
Dennis
Leonardo
Ashton
Philip
Julio
Miles
Damien
Ty
Gustavo
Drake
Jaime
Simon
Jerry
Curtis
Kameron
Lance
Brock
Bryson
Alberto
Dominick
Jimmy
Kaden
Douglas
Gary
Brennan
Zachery
Randy
Louis
Larry
Nickolas
Albert
Tony
Fabian
Keegan
Saul
Danny
Tucker
Myles
Damon
Arturo
Corbin
Deandre
Ricky
Kristopher
Lane
Pablo
Darren
Jarrett
Zion
Alfredo
Micheal
Angelo
Carl
Oliver
Kyler
Tommy
Walter
Dallas
Jace
Quinn
Theodore
Grayson
Lorenzo
Joe
Arthur
Bryant
Roman
Brent
Russell
Ramon
Lawrence
Moises
Aiden
Quentin
Jay
Tyrese
Tristen
Emanuel
Salvador
Terry
Morgan
Jeffery
Esteban
Tyson
Braxton
Branden
Marvin
Brody
Craig
Ismael
Rodney
Isiah
Marshall
Maurice
Ernesto
Emilio
Brendon
Kody
Eddie
Malachi
Abel
Keaton
Jon
Shaun
Skylar
Ezekiel
Nikolas
Santiago
Kendall
Axel
Camden
Trevon
Bobby
Conor
Jamal
Lukas
Malcolm
Zackery
Jayson
Javon
Roger
Reginald
Zachariah
Desmond
Felix
Johnathon
Dean
Quinton
Ali
Davis
Gerald
Rodrigo
Demetrius
Billy
Rene
Reece
Kelvin
Leo
Justice
Chris
Guillermo
Kevon
Steve
Frederick
Clay
Weston
Dorian
Hugo
Roy
Orlando
Terrance
Kai
Khalil
Graham
Noel
Willie
Nathanael
Terrell
Tyrone
Camron
Mauricio
Amir
Nelson
Darian
Jarod
Kade
Reese
Kristian
Garret
Rodolfo
Marquis
Dane
Felipe
Todd
Elian
Walker
Mateo
Jaylon
Kenny
Ezra
Bruce
Damion
Ross
Francis
Tate
Reid
Warren
Byron
Randall
Bennett
Jermaine
Triston
Harley
Jaquan
Jessie
Duncan
Franklin
Reed
Charlie
Blaine
Braeden
Holden
Ahmad
Issac
Melvin
Moses
Kendrick
Sawyer
Solomon
Sam
Alvin
Cedric
Jaylin
Jordon
Mohammad
Beau
Elliot
Lee
Darrell
Jarred
Mohamed
Davion
Wade
Tomas
Uriel
Jaxon
Deven
Maximilian
Gilberto
Rogelio
Ronnie
Julius
Allan
Joey
Brayan
Deshawn
Terrence
Noe
Alfonso
Ahmed
Tyree
Tyrell
Jerome
Devan
Neil
Ramiro
Pierce
Davon
Devonte
Leon
Jamie
Adan
Eugene
Stanley
Wayne
Marlon
Leonard
Quincy
Will
Alvaro
Ernest
Harry
Jonas
Addison
Ray
Alonzo
Jadon
Keyshawn
Rolando
Mohammed
Tristin
Donte
Leonel
Dominique
Wilson
Gilbert
Kieran
Coby
Dangelo
Colten
Keenan
Koby
Jarrod
Dale
Toby
Dwayne
Harold
Elliott
Osvaldo
Cyrus
Kolby
Sage
Coleman
Declan
Adolfo
Ariel
Brennen
Darryl
Trace
Efrain
Orion
Rudy
Shamar
Keshawn
Ulises
Darien
Braydon
Ben
Vicente
Nasir
Dayton
Joaquin
Karl
Dandre
Isaias
Cullen
Rylan
Sterling
Quintin
Stefan
Brice
Lewis
Gunnar
Humberto
Alfred
Nigel
Asher
Agustin
Daquan
Easton
Salvatore
Jaron
Nathanial
Ralph
Everett
Tobias
Hudson
Marquise
Glenn
Antoine
Jasper
Elvis
Kane
Sidney
Aron
Ezequiel
Tylor
Dashawn
Devyn
Mike
Silas
Jaiden
Jayce
Deonte
Romeo
Deon
Cristopher
Freddy
Kurt
Kolton
River
August
Clarence
Roderick
Derick
Jamar
Raphael
Kareem
Muhammad
Rohan
Demarcus
Sheldon
Cayden
Markus
Luca
Tre
Jean
Titus
Jamison
Rory
Brad
Clinton
Jaylan
Emiliano
Jevon
Julien
Lamar
Alonso
Cordell
Gordon
Ignacio
Cruz
Jett
Keon
Baby
Rashad
Tariq
Armani
Milton
Deangelo
Geoffrey
Elisha
Moshe
Asa
Bernard
Bret
Darion
Darnell
Izaiah
Irvin
Jairo
Howard
Aldo
Norman
Zechariah
Ayden
Garrison
Stuart
Travon
Kellen
Shemar
Dillan
Junior
Darrius
Rhett
Barry
Kamron
Jude
Rigoberto
Amari
Jovan
Perry
Octavio
Kole
Misael
Hassan
Jaren
Latrell
Roland
Quinten
German
Ibrahim
Justus
Gonzalo
Nehemiah
Forrest
Mackenzie
Talon
Anton
Chaz
Leroy
Guadalupe
Winston
Antwan
Austen
Brooks
Conrad
Greyson
Dion
Lincoln
Earl
Jaydon
Landen
Gunner
Brenton
Jefferson
Fredrick
Kurtis
Maximillian
Stephan
Stone
Shannon
Shayne
Stephon
Karson
Nestor
Tristian
Frankie
Gianni
Keagan
Dimitri
Kory
Zakary
Daryl
Donavan
Draven
Jameson
Clifton
Emmett
Cortez
Destin
Jamari
Dallin
Estevan
Grady
Davin
Santos
Marcel
Carlton
Dylon
Mitchel
Clifford
Syed
Dexter
Adonis
Keyon
Reynaldo
Devante
Arnold
Clark
Kasey
Sammy
Thaddeus
Glen
Jarvis
Nick
Ulysses
Garett
Infant
Keanu
Kenyon
Dwight
Kent
Denzel
Lamont
Houston
Layne
Darin
Jorden
Anderson
Kayden
Khalid
Antony
Deondre
Ellis
Marquez
Ari
Cornelius
Reuben
Austyn
Brycen
Abram
Remington
Braedon
Hamza
Ryder
Zaire
Terence
Guy
Jamel
Kelly
Porter
Tevin
Alexandro
Dario
Jordy
Trever
Jackie
Judah
Keven
Raymundo
Cristobal
Josef
Paris
Colt
Giancarlo
Rahul
Savion
Deshaun
Josh
Korey
Gerard
Jacoby
Lonnie
Reilly
Seamus
Don
Giovanny
Jamil
Kristofer
Samir
Vernon
Benny
Dominik
Finn
Jan
Kaiden
Cale
Irving
Jaxson
Marcelo
Nico
Rashawn
Aubrey
Gaven
Jabari
Sincere
Kirk
Maximus
Mikel
Davonte
Elmer
Heath
Justyn
Kadin
Alden
Kelton
Brandan
Courtney
Camren
Dewayne
Duane
Maverick
Darrin
Darrion
Nikhil
Sonny
Abdullah
Chaim
Nathen
Xzavier
Bronson
Efren
Jovani
Phoenix
Reagan
Aden
Blaze
Gideon
Luciano
Royce
Tyrek
Tyshawn
Deontae
Fidel
Gaige
Neal
Ronaldo
Matteo
Prince
Rickey
Deion
Denver
Benito
London
Samson
Bernardo
Raven
Simeon
Turner
Carlo
Gino
Johan
Rocky
Ryley
Domenic
Hugh
Trystan
Emerson
Joan
Trevion
Heriberto
Marques
Raheem
Tyreek
Vaughn
Clint
Nash
Mariano
Myron
Ladarius
Lloyd
Omari
Pierre
Keshaun
Rick
Xander
Amos
Eliseo
Jeff
Bradly
Freddie
Kavon
Mekhi
Sabastian
Shea
Dan
Adrien
Alessandro
Blaise
Isai
Kian
Maximiliano
Paxton
Rasheed
Brodie
Donnie
Isidro
Jaeden
Javion
Jimmie
Johnnie
Kennedy
Tyrique
Andreas
Augustus
Jalon
Jamir
Valentin
Korbin
Lawson
Maxim
Fred
Herbert
Bruno
Donavon
Javonte
Ean
Kamren
Rowan
Alek
Brandyn
Demarco
Harvey
Hernan
Alexzander
Bo
Branson
Brennon
Genaro
Jamarcus
Aric
Barrett
Rey
Braiden
Brant
Dontae
Jovany
Kale
Nicklaus
Zander
Dillion
Donnell
Kylan
Treyvon
Vincenzo
Dayne
Francesco
Isaak
