/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.trees.ConstituentFactory;
import edu.stanford.nlp.trees.LabeledConstituent;
import edu.stanford.nlp.trees.LabeledScoredConstituentFactory;

public class LabeledScoredConstituent
extends LabeledConstituent {
    private double score;

    public LabeledScoredConstituent() {
    }

    public LabeledScoredConstituent(int start, int end) {
        super(start, end);
    }

    public LabeledScoredConstituent(int start, int end, Label label, double score) {
        super(start, end, label);
        this.score = score;
    }

    @Override
    public double score() {
        return this.score;
    }

    @Override
    public void setScore(double score) {
        this.score = score;
    }

    @Override
    public LabelFactory labelFactory() {
        return LabelFactoryHolder.lf;
    }

    @Override
    public ConstituentFactory constituentFactory() {
        return ConstituentFactoryHolder.cf;
    }

    public static ConstituentFactory factory() {
        return ConstituentFactoryHolder.cf;
    }

    private static class ConstituentFactoryHolder {
        private static final ConstituentFactory cf = new LabeledScoredConstituentFactory();

        private ConstituentFactoryHolder() {
        }
    }

    private static class LabelFactoryHolder {
        static final LabelFactory lf = new LabeledScoredConstituentLabelFactory();

        private LabelFactoryHolder() {
        }
    }

    private static class LabeledScoredConstituentLabelFactory
    implements LabelFactory {
        private LabeledScoredConstituentLabelFactory() {
        }

        @Override
        public Label newLabel(String labelStr) {
            return new LabeledScoredConstituent(0, 0, new StringLabel(labelStr), 0.0);
        }

        @Override
        public Label newLabel(String labelStr, int options) {
            return this.newLabel(labelStr);
        }

        @Override
        public Label newLabelFromString(String labelStr) {
            return this.newLabel(labelStr);
        }

        @Override
        public Label newLabel(Label oldLabel) {
            return new LabeledScoredConstituent(0, 0, oldLabel, 0.0);
        }
    }
}

