# Generated by default/object.tt
package Paws::LexRuntimeV2::StartConversationRequestEventStream;
  use Moose;
  has AudioInputEvent => (is => 'ro', isa => 'Paws::LexRuntimeV2::AudioInputEvent');
  has ConfigurationEvent => (is => 'ro', isa => 'Paws::LexRuntimeV2::ConfigurationEvent');
  has DisconnectionEvent => (is => 'ro', isa => 'Paws::LexRuntimeV2::DisconnectionEvent');
  has DTMFInputEvent => (is => 'ro', isa => 'Paws::LexRuntimeV2::DTMFInputEvent');
  has PlaybackCompletionEvent => (is => 'ro', isa => 'Paws::LexRuntimeV2::PlaybackCompletionEvent');
  has TextInputEvent => (is => 'ro', isa => 'Paws::LexRuntimeV2::TextInputEvent');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexRuntimeV2::StartConversationRequestEventStream

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexRuntimeV2::StartConversationRequestEventStream object:

  $service_obj->Method(Att1 => { AudioInputEvent => $value, ..., TextInputEvent => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexRuntimeV2::StartConversationRequestEventStream object:

  $result = $service_obj->Method(...);
  $result->Att1->AudioInputEvent

=head1 DESCRIPTION

Represents a stream of events between your application and Amazon Lex
V2.

=head1 ATTRIBUTES


=head2 AudioInputEvent => L<Paws::LexRuntimeV2::AudioInputEvent>

Speech audio sent from your client application to Amazon Lex V2. Audio
starts accumulating when Amazon Lex V2 identifies a voice and continues
until a natural pause in the speech is found before processing.


=head2 ConfigurationEvent => L<Paws::LexRuntimeV2::ConfigurationEvent>

Configuration information sent from your client application to Amazon
Lex V2


=head2 DisconnectionEvent => L<Paws::LexRuntimeV2::DisconnectionEvent>

Event sent from the client application to indicate to Amazon Lex V2
that the conversation is over.


=head2 DTMFInputEvent => L<Paws::LexRuntimeV2::DTMFInputEvent>

DTMF information sent to Amazon Lex V2 by your application. Amazon Lex
V2 accumulates the DMTF information from when the user sends the first
character and ends

=over

=item *

when there's a pause longer that the value configured for the end
timeout.

=item *

when there's a digit that is the configured end character.

=item *

when Amazon Lex V2 accumulates characters equal to the maximum DTMF
character configuration.

=back



=head2 PlaybackCompletionEvent => L<Paws::LexRuntimeV2::PlaybackCompletionEvent>

Event sent from the client application to Amazon Lex V2 to indicate
that it has finished playing audio and that Amazon Lex V2 should start
listening for user input.


=head2 TextInputEvent => L<Paws::LexRuntimeV2::TextInputEvent>

Text sent from your client application to Amazon Lex V2. Each
C<TextInputEvent> is processed individually.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexRuntimeV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

