# Generated by default/object.tt
package Paws::XRay::RequestImpactStatistics;
  use Moose;
  has FaultCount => (is => 'ro', isa => 'Int');
  has OkCount => (is => 'ro', isa => 'Int');
  has TotalCount => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::XRay::RequestImpactStatistics

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::XRay::RequestImpactStatistics object:

  $service_obj->Method(Att1 => { FaultCount => $value, ..., TotalCount => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::XRay::RequestImpactStatistics object:

  $result = $service_obj->Method(...);
  $result->Att1->FaultCount

=head1 DESCRIPTION

Statistics that describe how the incident has impacted a service.

=head1 ATTRIBUTES


=head2 FaultCount => Int

The number of requests that have resulted in a fault,


=head2 OkCount => Int

The number of successful requests.


=head2 TotalCount => Int

The total number of requests to the service.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::XRay>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

