package ShiftJIS::Regexp::Equiv;
use strict;
use Carp;

use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
$VERSION = '1.03';

require Exporter;
@ISA       = qw(Exporter);
@EXPORT    = qw();
@EXPORT_OK = qw(%Eq);

use vars qw(%Eq);

my $Open = 5.005 > $] ? '(?:' : '(?-i:';
my $Close = ')';

foreach(
['!', 'I'],
['#', ''],
['$', ''],
['%', ''],
['&', ''],
['(', 'i'],
[')', 'j'],
['*', ''],
['+', '{'],
[',', 'C'],
['.', 'D'],
['/', '^'],
['0', 'O'],
['1', 'P'],
['2', 'Q'],
['3', 'R'],
['4', 'S'],
['5', 'T'],
['6', 'U'],
['7', 'V'],
['8', 'W'],
['9', 'X'],
[':', 'F'],
[';', 'G'],
['<', ''],
['=', ''],
['>', ''],
['?', 'H'],
['@', ''],
['[', 'm'],
['\\',''],
[']', 'n'],
['^', 'O'],
['_', 'Q'],
['`', 'M'],
['{', 'o'],
['|', 'b'],
['}', 'p'],
['~', 'P'],
['B', ''],
['u', ''],
['v', ''],
['A', ''],
['E', ''],
['[', ''],
['a', '', 'A', '`'],
['b', '', 'B', 'a'],
['c', '', 'C', 'b'],
['d', '', 'D', 'c'],
['e', '', 'E', 'd'],
['f', '', 'F', 'e'],
['g', '', 'G', 'f'],
['h', '', 'H', 'g'],
['i', '', 'I', 'h'],
['j', '', 'J', 'i'],
['k', '', 'K', 'j'],
['l', '', 'L', 'k'],
['m', '', 'M', 'l'],
['n', '', 'N', 'm'],
['o', '', 'O', 'n'],
['p', '', 'P', 'o'],
['q', '', 'Q', 'p'],
['r', '', 'R', 'q'],
['s', '', 'S', 'r'],
['t', '', 'T', 's'],
['u', '', 'U', 't'],
['v', '', 'V', 'u'],
['w', '', 'W', 'v'],
['x', '', 'X', 'w'],
['y', '', 'Y', 'x'],
['z', '', 'Z', 'y'],
[qw/ @   A  /],
[qw/ B   C  /],
[qw/ D   E    /],
[qw/ F   G  /],
[qw/ H   I  /],
[qw/ K   J  /],
[qw/ M   L  /],
[qw/ O   N  /],
[qw/ Q   P   /],
[qw/ S   R  /],
[qw/ U   T  /],
[qw/ W   V  /],
[qw/ Y   X  /],
[qw/ [   Z  /],
[qw/ ]   \  /],
[qw/ _   ^  /],
[qw/ a   `  /],
[qw/ d   c   b /],
[qw/ f   e  /],
[qw/ h   g  /],
[qw/ i  /],
[qw/ j  /],
[qw/ k  /],
[qw/ l  /],
[qw/ m  /],
[qw/ o   p   n  /],
[qw/ r   s   q  /],
[qw/ u   v   t  /],
[qw/ x   y   w  /],
[qw/ {   |   z  /],
[qw/ }  /],
[qw/ ~  /],
[qw/   /],
[qw/   /],
[qw/   /],
[qw/      /],
[qw/      /],
[qw/      /],
[qw/   /],
[qw/   /],
[qw/   /],
[qw/   /],
[qw/   /],
[qw/     /],
[qw/  /],
[qw/  /],
[qw/   /],
[qw/   /],
[qw/T R U S /],
[qw/J K     /],
) {
    my $arr = $_;
    my $re = $Open.join('|', map {
	length($_) == 1
	    ? sprintf('\x%02x', ord $_)
	    : sprintf('\x%02x\x%02x', unpack 'C2', $_)
	} @$arr) .$Close;
    @Eq{@$arr} = ($re) x @$arr;
}

1;
__END__
