/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public class ResultColumn
extends ValueNode
implements ResultColumnDescriptor,
Comparable {
    String name;
    String exposedName;
    String tableName;
    String sourceTableName;
    String sourceSchemaName;
    ValueNode expression;
    ColumnDescriptor columnDescriptor;
    boolean isGenerated;
    boolean isGeneratedForUnmatchedColumnInInsert;
    boolean isGroupingColumn;
    boolean isReferenced;
    boolean isRedundant;
    boolean isNameGenerated;
    boolean updated;
    boolean updatableByCursor;
    private boolean defaultColumn;
    boolean autoincrementGenerated;
    boolean autoincrement;
    private int resultSetNumber = -1;
    ColumnReference reference;
    private int virtualColumnId;

    public void init(Object object, Object object2) {
        if (object instanceof String || object == null) {
            this.exposedName = this.name = (String)object;
            this.expression = (ValueNode)object2;
        } else if (object instanceof ColumnReference) {
            ColumnReference columnReference = (ColumnReference)object;
            this.name = columnReference.getColumnName();
            this.exposedName = columnReference.getColumnName();
            this.reference = columnReference;
            this.expression = (ValueNode)object2;
        } else if (object instanceof ColumnDescriptor) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)object;
            DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType();
            this.exposedName = this.name = columnDescriptor.getColumnName();
            this.setType(new DataTypeDescriptor(dataTypeDescriptor, dataTypeDescriptor.isNullable()));
            this.columnDescriptor = columnDescriptor;
            this.expression = (ValueNode)object2;
            this.autoincrement = columnDescriptor.isAutoincrement();
        } else {
            this.setType((DataTypeDescriptor)object);
            this.expression = (ValueNode)object2;
            if (object2 instanceof ColumnReference) {
                this.reference = (ColumnReference)object2;
            }
        }
        if (this.expression != null && this.expression.isInstanceOf(100)) {
            this.defaultColumn = true;
        }
    }

    public boolean isDefaultColumn() {
        return this.defaultColumn;
    }

    public void setDefaultColumn(boolean bl) {
        this.defaultColumn = bl;
    }

    public String getName() {
        return this.exposedName;
    }

    public String getSchemaName() throws StandardException {
        if (this.columnDescriptor != null && this.columnDescriptor.getTableDescriptor() != null) {
            return this.columnDescriptor.getTableDescriptor().getSchemaName();
        }
        if (this.expression != null) {
            return this.expression.getSchemaName();
        }
        return null;
    }

    public String getTableName() {
        if (this.tableName != null) {
            return this.tableName;
        }
        if (this.columnDescriptor != null && this.columnDescriptor.getTableDescriptor() != null) {
            return this.columnDescriptor.getTableDescriptor().getName();
        }
        return this.expression.getTableName();
    }

    public String getSourceTableName() {
        return this.sourceTableName;
    }

    public String getSourceSchemaName() {
        return this.sourceSchemaName;
    }

    public void clearTableName() {
        if (this.expression instanceof ColumnReference) {
            ((ColumnReference)this.expression).setTableNameNode(null);
        }
    }

    public DataTypeDescriptor getType() {
        return this.dataTypeServices;
    }

    public DataTypeDescriptor getExpressionType() {
        return this.expression == null ? this.dataTypeServices : this.expression.getTypeServices();
    }

    public int getColumnPosition() {
        if (this.columnDescriptor != null) {
            return this.columnDescriptor.getPosition();
        }
        return this.virtualColumnId;
    }

    public void setExpression(ValueNode valueNode) {
        this.expression = valueNode;
    }

    public ValueNode getExpression() {
        return this.expression;
    }

    void setExpressionToNullNode() throws StandardException {
        this.expression = this.getNullNode(this.getTypeId(), this.getContextManager());
    }

    public void setName(String string) {
        if (this.name == null) {
            this.name = string;
        }
        this.exposedName = string;
    }

    public boolean isNameGenerated() {
        return this.isNameGenerated;
    }

    public void setNameGenerated(boolean bl) {
        this.isNameGenerated = bl;
    }

    public void setResultSetNumber(int n) {
        this.resultSetNumber = n;
    }

    public int getResultSetNumber() {
        return this.resultSetNumber;
    }

    public void setClause(int n) {
        super.setClause(n);
        if (this.expression != null) {
            this.expression.setClause(n);
        }
    }

    public void adjustVirtualColumnId(int n) {
        this.virtualColumnId += n;
    }

    public void setVirtualColumnId(int n) {
        this.virtualColumnId = n;
    }

    public int getVirtualColumnId() {
        return this.virtualColumnId;
    }

    public void guaranteeColumnName() throws StandardException {
        if (this.exposedName == null) {
            this.exposedName = "SQLCol" + this.getCompilerContext().getNextColumnNumber();
            this.isNameGenerated = true;
        }
    }

    public String toString() {
        return "";
    }

    public void printSubNodes(int n) {
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        if (this.expression.isParameterNode() && this.getTypeServices() != null) {
            ((ParameterNode)this.expression).setDescriptor(this.getTypeServices());
        }
        this.expression = this.expression.bindExpression(fromList, subqueryList, vector);
        if (this.expression instanceof ColumnReference) {
            this.autoincrement = ((ColumnReference)this.expression).getSource().isAutoincrement();
        }
        return this;
    }

    void bindResultColumnByPosition(TableDescriptor tableDescriptor, int n) throws StandardException {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(n);
        if (columnDescriptor == null) {
            String string = "";
            String string2 = tableDescriptor.getSchemaName();
            if (string2 != null) {
                string = string + string2 + ".";
            }
            string = string + tableDescriptor.getName();
            throw StandardException.newException("42X06", string);
        }
        this.setColumnDescriptor(tableDescriptor, columnDescriptor);
        this.setVirtualColumnId(n);
    }

    public void bindResultColumnByName(TableDescriptor tableDescriptor, int n) throws StandardException {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.exposedName);
        if (columnDescriptor == null) {
            String string = "";
            String string2 = tableDescriptor.getSchemaName();
            if (string2 != null) {
                string = string + string2 + ".";
            }
            string = string + tableDescriptor.getName();
            throw StandardException.newException("42X14", this.exposedName, (Object)string);
        }
        this.setColumnDescriptor(tableDescriptor, columnDescriptor);
        this.setVirtualColumnId(n);
    }

    public void typeUntypedNullExpression(ResultColumn resultColumn) throws StandardException {
        TypeId typeId = resultColumn.getTypeId();
        if (typeId == null) {
            throw StandardException.newException("42X07");
        }
        if (this.expression instanceof UntypedNullConstantNode) {
            this.expression = this.getNullNode(typeId, this.getContextManager());
        } else if (this.expression instanceof ColumnReference && this.expression.getTypeServices() == null) {
            this.expression.setType(resultColumn.getType());
        }
    }

    void setColumnDescriptor(TableDescriptor tableDescriptor, ColumnDescriptor columnDescriptor) throws StandardException {
        this.setType(columnDescriptor.getType());
        this.columnDescriptor = columnDescriptor;
        if (this.reference != null && this.reference.getTableName() != null && !tableDescriptor.getName().equals(this.reference.getTableName())) {
            String string = tableDescriptor.getName();
            String string2 = this.reference.getTableName();
            throw StandardException.newException("42X55", string, (Object)string2);
        }
    }

    public void bindResultColumnToExpression() throws StandardException {
        this.setType(this.expression.getTypeServices());
        if (this.expression instanceof ColumnReference) {
            ColumnReference columnReference = (ColumnReference)this.expression;
            this.tableName = columnReference.getTableName();
            this.sourceTableName = columnReference.getSourceTableName();
            this.sourceSchemaName = columnReference.getSourceSchemaName();
        }
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        if (this.expression == null) {
            return this;
        }
        this.expression = this.expression.preprocess(n, fromList, subqueryList, predicateList);
        return this;
    }

    public void checkStorableExpression(ResultColumn resultColumn) throws StandardException {
        TypeId typeId = resultColumn.getTypeId();
        if (typeId == null) {
            return;
        }
        TypeId typeId2 = this.getTypeId();
        if (!this.getTypeCompiler().storable(typeId, this.getClassFactory())) {
            throw StandardException.newException("42821", typeId2.getSQLTypeName(), (Object)typeId.getSQLTypeName());
        }
    }

    public void checkStorableExpression() throws StandardException {
        TypeId typeId = this.getTypeId();
        TypeId typeId2 = this.getExpressionType().getTypeId();
        if (!this.getTypeCompiler().storable(typeId2, this.getClassFactory())) {
            throw StandardException.newException("42821", typeId.getSQLTypeName(), (Object)typeId2.getSQLTypeName());
        }
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.expression.generateExpression(expressionClassBuilder, methodBuilder);
    }

    public void generateHolder(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        expressionClassBuilder.generateNull(methodBuilder, this.getTypeCompiler());
        methodBuilder.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
    }

    boolean columnTypeAndLengthMatch() throws StandardException {
        DataTypeDescriptor dataTypeDescriptor = this.expression.getTypeServices();
        if (this.expression.isParameterNode()) {
            return false;
        }
        DataTypeDescriptor dataTypeDescriptor2 = this.getType();
        if (!dataTypeDescriptor2.getTypeId().getSQLTypeName().equals(dataTypeDescriptor.getTypeId().getSQLTypeName())) {
            return false;
        }
        if (dataTypeDescriptor2.getPrecision() != dataTypeDescriptor.getPrecision()) {
            return false;
        }
        if (dataTypeDescriptor2.getScale() != dataTypeDescriptor.getScale()) {
            return false;
        }
        if (dataTypeDescriptor2.getMaximumWidth() != dataTypeDescriptor.getMaximumWidth()) {
            return false;
        }
        return dataTypeDescriptor2.isNullable() || !dataTypeDescriptor.isNullable();
    }

    boolean columnTypeAndLengthMatch(ResultColumn resultColumn) throws StandardException {
        ValueNode valueNode = resultColumn.getExpression();
        DataTypeDescriptor dataTypeDescriptor = this.getType();
        DataTypeDescriptor dataTypeDescriptor2 = resultColumn.getType();
        if (valueNode != null && valueNode.isParameterNode() || this.expression.isParameterNode()) {
            return false;
        }
        if (!dataTypeDescriptor.getTypeId().equals(dataTypeDescriptor2.getTypeId())) {
            DataValueDescriptor dataValueDescriptor;
            ConstantNode constantNode;
            DataValueDescriptor dataValueDescriptor2;
            if (valueNode instanceof ConstantNode && (dataValueDescriptor2 = (constantNode = (ConstantNode)resultColumn.getExpression()).getValue()) != (dataValueDescriptor = this.convertConstant(dataTypeDescriptor.getTypeId(), dataTypeDescriptor.getMaximumWidth(), dataValueDescriptor2)) && dataValueDescriptor2 instanceof StringDataValue == dataValueDescriptor instanceof StringDataValue) {
                constantNode.setValue(dataValueDescriptor);
                constantNode.setType(this.getTypeServices());
                resultColumn.bindResultColumnToExpression();
                dataTypeDescriptor2 = resultColumn.getType();
            }
            if (!dataTypeDescriptor.getTypeId().equals(dataTypeDescriptor2.getTypeId())) {
                return false;
            }
        }
        if (dataTypeDescriptor.getPrecision() != dataTypeDescriptor2.getPrecision()) {
            return false;
        }
        if (dataTypeDescriptor.getScale() != dataTypeDescriptor2.getScale()) {
            return false;
        }
        if (dataTypeDescriptor.getMaximumWidth() != dataTypeDescriptor2.getMaximumWidth()) {
            return false;
        }
        return dataTypeDescriptor.isNullable() || !dataTypeDescriptor2.isNullable() && !resultColumn.isGeneratedForUnmatchedColumnInInsert();
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public boolean isGeneratedForUnmatchedColumnInInsert() {
        return this.isGeneratedForUnmatchedColumnInInsert;
    }

    public void markGenerated() {
        this.isGenerated = true;
        this.isReferenced = true;
    }

    public void markGeneratedForUnmatchedColumnInInsert() {
        this.isGeneratedForUnmatchedColumnInInsert = true;
        this.isReferenced = true;
    }

    public boolean isReferenced() {
        return this.isReferenced;
    }

    public void setReferenced() {
        this.isReferenced = true;
    }

    void pullVirtualIsReferenced() {
        if (this.isReferenced()) {
            return;
        }
        ValueNode valueNode = this.expression;
        while (valueNode != null && valueNode instanceof VirtualColumnNode) {
            VirtualColumnNode virtualColumnNode = (VirtualColumnNode)valueNode;
            ResultColumn resultColumn = virtualColumnNode.getSourceColumn();
            if (resultColumn.isReferenced()) {
                this.setReferenced();
                return;
            }
            valueNode = resultColumn.getExpression();
        }
    }

    public void setUnreferenced() {
        this.isReferenced = false;
    }

    void markAllRCsInChainReferenced() {
        this.setReferenced();
        ValueNode valueNode = this.expression;
        while (valueNode instanceof VirtualColumnNode) {
            VirtualColumnNode virtualColumnNode = (VirtualColumnNode)valueNode;
            ResultColumn resultColumn = virtualColumnNode.getSourceColumn();
            resultColumn.setReferenced();
            valueNode = resultColumn.getExpression();
        }
    }

    public boolean isRedundant() {
        return this.isRedundant;
    }

    public void setRedundant() {
        this.isRedundant = true;
    }

    public void markAsGroupingColumn() {
        this.isGroupingColumn = true;
    }

    void rejectParameter() throws StandardException {
        if (this.expression != null && this.expression.isParameterNode()) {
            throw StandardException.newException("42X34");
        }
    }

    public int compareTo(Object object) {
        ResultColumn resultColumn = (ResultColumn)object;
        return this.getColumnPosition() - resultColumn.getColumnPosition();
    }

    void markUpdated() {
        this.updated = true;
    }

    void markUpdatableByCursor() {
        this.updatableByCursor = true;
    }

    boolean updated() {
        return this.updated;
    }

    public boolean updatableByCursor() {
        return this.updatableByCursor;
    }

    ResultColumn cloneMe() throws StandardException {
        ResultColumn resultColumn;
        ValueNode valueNode = this.expression instanceof ColumnReference ? ((ColumnReference)this.expression).getClone() : this.expression;
        if (this.columnDescriptor != null) {
            resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, this.columnDescriptor, this.expression, this.getContextManager());
            resultColumn.setExpression(valueNode);
        } else {
            resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, this.getName(), valueNode, this.getContextManager());
        }
        resultColumn.setVirtualColumnId(this.getVirtualColumnId());
        resultColumn.setName(this.getName());
        resultColumn.setType(this.getTypeServices());
        resultColumn.setNameGenerated(this.isNameGenerated());
        if (this.isGeneratedForUnmatchedColumnInInsert()) {
            resultColumn.markGeneratedForUnmatchedColumnInInsert();
        }
        if (this.isReferenced()) {
            resultColumn.setReferenced();
        }
        if (this.updated()) {
            resultColumn.markUpdated();
        }
        if (this.updatableByCursor()) {
            resultColumn.markUpdatableByCursor();
        }
        if (this.isAutoincrementGenerated()) {
            resultColumn.setAutoincrementGenerated();
        }
        if (this.isAutoincrement()) {
            resultColumn.setAutoincrement();
        }
        return resultColumn;
    }

    public int getMaximumColumnSize() {
        return this.dataTypeServices.getTypeId().getApproximateLengthInBytes(this.dataTypeServices);
    }

    protected int getOrderableVariantType() throws StandardException {
        int n = this.expression != null ? this.expression.getOrderableVariantType() : (this.isAutoincrementGenerated() ? 0 : 3);
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: {
                return 1;
            }
        }
        return 3;
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        Visitable visitable = visitor.visit(this);
        if (visitor.skipChildren(this)) {
            return visitable;
        }
        if (this.expression != null && !visitor.stopTraversal()) {
            this.expression = (ValueNode)this.expression.accept(visitor);
        }
        return visitable;
    }

    public void setNullability(boolean bl) {
        this.dataTypeServices.setNullability(bl);
    }

    public boolean foundInList(String[] stringArray) {
        return this.foundString(stringArray, this.name);
    }

    void verifyOrderable() throws StandardException {
        if (!this.getTypeId().orderable(this.getClassFactory())) {
            throw StandardException.newException("X0X67.S", this.getTypeId().getSQLTypeName());
        }
    }

    ColumnDescriptor getTableColumnDescriptor() {
        return this.columnDescriptor;
    }

    public boolean isAutoincrementGenerated() {
        return this.autoincrementGenerated;
    }

    public void setAutoincrementGenerated() {
        this.autoincrementGenerated = true;
    }

    public void resetAutoincrementGenerated() {
        this.autoincrementGenerated = false;
    }

    public boolean isAutoincrement() {
        return this.autoincrement;
    }

    public void setAutoincrement() {
        this.autoincrement = true;
    }

    private DataValueDescriptor convertConstant(TypeId typeId, int n, DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n2 = typeId.getTypeFormatId();
        DataValueFactory dataValueFactory = this.getDataValueFactory();
        switch (n2) {
            default: {
                return dataValueDescriptor;
            }
            case 13: 
            case 369: 
            case 370: {
                String string = dataValueDescriptor.getString();
                int n3 = string.length();
                if (n3 <= n) {
                    switch (n2) {
                        case 370: {
                            if (n3 < n) {
                                StringBuffer stringBuffer = new StringBuffer(string);
                                int n4 = n - n3;
                                char[] cArray = new char[n4];
                                for (int i = 0; i < n4; ++i) {
                                    cArray[i] = 32;
                                }
                                stringBuffer.append(cArray, 0, n - n3);
                                string = stringBuffer.toString();
                            }
                            return dataValueFactory.getNationalCharDataValue(string);
                        }
                        case 369: {
                            return dataValueFactory.getNationalVarcharDataValue(string);
                        }
                        case 13: {
                            return dataValueFactory.getVarcharDataValue(string);
                        }
                    }
                }
                for (int i = n; i < n3; ++i) {
                    if (string.charAt(i) == ' ') continue;
                    String string2 = null;
                    switch (n2) {
                        case 370: {
                            string2 = "NATIONAL CHAR";
                            break;
                        }
                        case 369: {
                            string2 = "NATIONAL CHAR VARYING";
                            break;
                        }
                        case 13: {
                            string2 = "VARCHAR";
                        }
                    }
                    throw StandardException.newException("22001", string2, (Object)StringUtil.formatForPrint(string), (Object)String.valueOf(n));
                }
                switch (n2) {
                    case 370: {
                        return dataValueFactory.getNationalCharDataValue(string.substring(0, n));
                    }
                    case 369: {
                        return dataValueFactory.getNationalVarcharDataValue(string.substring(0, n));
                    }
                    case 13: {
                        return dataValueFactory.getVarcharDataValue(string.substring(0, n));
                    }
                }
            }
            case 230: {
                return dataValueFactory.getLongvarcharDataValue(dataValueDescriptor.getString());
            }
            case 362: 
        }
        return dataValueFactory.getNationalLongvarcharDataValue(dataValueDescriptor.getString());
    }

    public TypeId getTypeId() {
        DataTypeDescriptor dataTypeDescriptor;
        TypeId typeId = super.getTypeId();
        if (typeId == null && this.expression != null && (dataTypeDescriptor = this.getTypeServices()) != null) {
            typeId = dataTypeDescriptor.getTypeId();
        }
        return typeId;
    }

    public DataTypeDescriptor getTypeServices() {
        DataTypeDescriptor dataTypeDescriptor = super.getTypeServices();
        if (dataTypeDescriptor == null && this.expression != null && (dataTypeDescriptor = this.expression.getTypeServices()) != null) {
            this.setType(dataTypeDescriptor);
        }
        return dataTypeDescriptor;
    }

    public TableName getTableNameObject() {
        return null;
    }
}

