#ifndef WDEFS_H
#define WDEFS_H


#define d1fprintf if (wGetDebug() >= 1) fprintf
#define d2fprintf if (wGetDebug() >= 2) fprintf
#define d3fprintf if (wGetDebug() >= 3) fprintf


#define CR          '\015'
#define LF          '\012'
#define CRLF        "\015\012"
#define QUOTE       '"'
#define WHITE_SPACE " \t"

#define CMD_START '@'
#define CMD_END " \t:" /* characters that can terminate a command */
#define CONS_SEP ','
#define WEQUAL    '='
#define GCONS_START ':'
#define LCONS_START ','
#define SRCH_SEP ';'

#define	GEN_SRCH_EXCL	";:,"

#define SRCH_ALL    '*'
#define SRCH_ATTR   '.'
#define SRCH_HANDLE '!'
#define SRCH_TEMPL  '^'
#define SRCH_VALUE  '#'
#define SHORT_CHARS "*.!^#" /* all the short search methods */

#define	 FULL_LIMIT  10	    /* Limit for the number of FULL responses */
#define	 OUT_BUFSIZ  82
#define	 MAX_LINE    81
#define	 HOLD_BUFSIZ 4096  

/*  
 *  For ANSI prototypes.
 */  
#ifdef __STDC__
# define proto_(p) p
#else
# define const
# define volatile
# define proto_(p) ()
#endif

/*  
 *  Pointer argument checking.
 */
#define ptr_check(var, vname, fname, rval) \
if ( ! (var)) \
{ \
  d1fprintf(stderr, "%s: parameter `%s' is a NULL pointer.\n", fname, vname); \
  return rval; \
}


typedef enum
{
  /* WItem Query Formats */

  F_ALL,                        /* no long form equivalent */
  F_ATTR,                       /* "ATTRIBUTE=foo" or ".foo" */
  F_VALUE,                      /* "VALUE=foo" or "#foo" */
  F_TEMPL,                      /* "TEMPLAGE=foo" or "^foo" */
  F_HAND,                       /* "HANDLE=foo" or "!foo" */
  F_HEAD,                       /* special header item to hold global constraints for queries */
  F_ATTR_VAL,                   /* e.g. "NAME=foo" or "EMAIL=foo" or "<anything>=foo" */


  /* WItem Response Formats */

  R_ABRIDGED = -10000,
  R_FULL,
  R_FULL_FMT,                     /* for lines like `# USER PD45' */
  R_HANDLE,
  R_MIME,
  R_POINT,
  R_SUM,
  R_ERROR,
  

  /* WHOIS++ Item Types */

  T_CONS = -1000,
  T_SEARCH,
  T_SYSTEM,
  T_REPLY,

  
  /* Globally applicable values */

  NO_VAL = -100,

  /* search logicals */

  WAND = -50,
  WOR
} Val;


typedef struct witem_ WItem;
struct witem_
{
  Val type;                     /* type of item: one of T_* */
  Val format;
  const char *lhs;
  const char *rhs;
  WItem *cons;                  /* constraints */
  WItem *next;                  /* next item in list */
};

#define	 MAX_COMMAND_LEN      64
#define	 MAX_COMMAND_DESC    128

typedef enum{
   C_HELP = 0,
   C_DESCRIBE,
   C_COMMANDS,
   C_CONSTRAINTS,
   C_LIST,
   C_VERSION,
   C_LAST		  /* Must be the last one in the list */
} c_num_t;
   
typedef struct{
   c_num_t  c_num;		    /* Index number for command */
   char	c_name[MAX_COMMAND_LEN];    /* Command string (name)    */
   char c_desc[MAX_COMMAND_DESC];
} command_set_t;

#endif
