
/* Copyright (c) CNIDR (Work in progress) */

#include "synonym.h"
#include "cutil.h"

int     syn_compare (arg1, arg2)
        void * arg1, *arg2;
{
    t_Synonym * p1, *p2;
    p1 = (t_Synonym *) arg1;
    p2 = (t_Synonym *) arg2;
    return strcasecmp (p1 -> key, p2 -> key);
}

char   *lookup_Synonym (word, syn_Table, syn_Table_Size)
char   *word;
t_Synonym * syn_Table;
int     syn_Table_Size;
{
    t_Synonym tmp;
    t_Synonym * rec;
    if (syn_Table_Size == 0)
	return word;
    tmp.key = (char *) s_malloc (strlen (word) + 1);
    strcpy (tmp.key, word);
    rec = (t_Synonym *) bsearch (&tmp, syn_Table, syn_Table_Size, sizeof (t_Synonym), syn_compare);
    s_free (tmp.key);
    if (rec)
	return rec -> root;
    return word;
}
void syn_ReadFile (fn, ptr, syn_Table_Size)
char   *fn;
t_Synonym ** ptr;
int    *syn_Table_Size;
{
    char   *key,
           *datum,
            inputLine[SYN_FILE_LINE_LENGTH];
    FILE * fp = fopen (fn, "rb");
    t_Synonym * syn_Table = NULL;
    *syn_Table_Size = 0;
    if (!fp) {
	waislog (WLOG_HIGH, WLOG_WARNING, "Warning: couldn't open %s - translation disabled", fn);
	return;
    }
    syn_Table = (t_Synonym *) s_malloc (sizeof (t_Synonym));
    if (!syn_Table) {
	waislog (WLOG_HIGH, WLOG_WARNING, "Warning: error allocating space for %s - translation disabled", fn);
	return;
    }
    while (!feof (fp)) {
	fgets (inputLine, SYN_FILE_LINE_LENGTH - 1, fp);
	datum = (char *) strtok (inputLine, " \n\r");
	if (datum[0] != '#')	/* skip comment lines */
	    while ((key = (char *) strtok (NULL, " \n\r"))) {
		(*syn_Table_Size)++;
		syn_Table =
		    (t_Synonym *) realloc (syn_Table, (*syn_Table_Size) * sizeof (t_Synonym));
		if (!syn_Table) {
		    waislog (WLOG_HIGH, WLOG_WARNING, "Warning: error allocating space for %s - translation disabled", fn);
		    (*syn_Table_Size)--;
		    return;
		}
		synptr (root) = (char *) s_malloc (strlen (datum) + 1);
		synptr (key) = (char *) s_malloc (strlen (key) + 1);
		if (!synptr (root) || !synptr (key)) {
		    waislog (WLOG_HIGH, WLOG_WARNING, "Warning: error allocating space for %s - translation disabled", fn);
		    return;
		}
		strcpy (synptr (root), datum);
		strcpy (synptr (key), key);
	    }
    }
    fclose (fp);
    qsort (syn_Table, (*syn_Table_Size), sizeof (t_Synonym), syn_compare);
    (*ptr) = (t_Synonym *) syn_Table;
    return;
}

void syn_Free (syn_Table, syn_Table_Size)
t_Synonym * syn_Table;
int    *syn_Table_Size;
{
    int     i;
    for (i = 0; i < (*syn_Table_Size); i++) {
	s_free (syn_Table[i].root);
	s_free (syn_Table[i].key);
    }
    s_free (syn_Table);
    syn_Table = NULL;
    syn_Table_Size = 0;
    return;
}

/* 
   test stub for synonym routines 

char* log_file_name=NULL;
FILE* logfile;
main( argc,argv )
int argc;
char* argv[];
{
  char word[256];  
  t_Synonym* syn_Table;
  int syn_Table_Size;
  logfile=stderr;
  log_file_name="/dev/null";
  syn_ReadFile( "test.syn",&syn_Table,&syn_Table_Size );
  printf( "%s",lookup_Synonym( argv[1],syn_Table,syn_Table_Size ));
  syn_Free( syn_Table,&syn_Table_Size );
}   

*/
