/*
 * Copyright 1993, Bunyip Information Systems. This file is part of the
 * Bunyip WHOIS++ distribution and may be freely distributed as long as
 * this notice remains intact. This file may not be used in any product for
 * commercial gain.
 */

#include <stdio.h>
#include <strings.h>
#include "whois.h"
#include "whoisd.h"



/* do_system

   As commands are added to the WHOIS++ protocol, they need to be handled
   here. It returns 0 on success, non-zero on failure

 */


int do_system(input_list, result)
   WItem *input_list;
   WItem *result;
{
   extern char *version;   /* global version string	      */
   extern command_set_t command_set[];
   extern constraint_set_t constraint_set[];
   
   c_num_t i, j;
   char *lhs, *rhs;
   WItem *curr_item;
   WItem *w;

   /* handle commands */

   curr_item = input_list;

   while((curr_item = wNextItem(curr_item)) != (WItem *) NULL){
      int done = 0;

      if(done)
         break;

      /* commands can have arguments */

      lhs = wGetLHS(curr_item);
      rhs = wGetRHS(curr_item);
      
      for(i = 0; !done && (i < C_LAST); i++){

	 if(strcasecmp(lhs, command_set[i].c_name) != 0)
	    continue;

	 switch(i){

	    case C_HELP:
	       break;

	    case C_DESCRIBE:

	       /* The easiest way to do this is just to make up the
		  appropriate protocol request and send it along to the
		  searching code */

	       if(wGetRHS(curr_item))
		  wAppendSystemMessage(result, wErrorReply(WWARN_NOARG_COMMAND, "'%s'", command_set[i].c_name));

	       w = wCreateSearch();
	       wAppendTerm(w, F_TEMPL, "services", "");
	       wAppendTerm(w, F_ATTR_VAL, "description", "describe");
	       do_search(wNextItem(w), result);
	       wFreeList(w);
	       break;
	       
	    case C_COMMANDS:

	       if(wGetRHS(curr_item))
		  wAppendSystemMessage(result, wErrorReply(WWARN_NOARG_COMMAND, "'%s'", command_set[i].c_name));

	       for(j = 0; j < C_LAST; j++){
		  wAppendTerm(result, R_FULL_FMT, "command", command_set[j].c_name);
		  wAppendTerm(result, F_ATTR_VAL, "Name", command_set[j].c_name);
		  wAppendTerm(result, F_ATTR_VAL, "Description", command_set[j].c_desc);
	       }
	       done = 1 ;
	       break;

	    case C_CONSTRAINTS:

	       if(wGetRHS(curr_item))
		  wAppendSystemMessage(result, wErrorReply(WWARN_NOARG_COMMAND, "'%s'", command_set[i].c_name));

	       for(j = 0; j < CON_LAST; j++){

		  wAppendTerm(result, R_FULL_FMT, "constraint", constraint_set[j].con_name);
		  wAppendTerm(result, F_ATTR_VAL, "Name", constraint_set[j].con_name);
		  wAppendTerm(result, F_ATTR_VAL, "Description", constraint_set[j].con_desc);
		  wAppendTerm(result, F_ATTR_VAL, "Values", constraint_set[j].con_values);		  
		  wAppendTerm(result, F_ATTR_VAL, "Scope", constraint_set[j].con_scope == C_SGLOBAL ? "global" : "local");
	       }

	       done = 1 ;
	       break;

	    case C_LIST:
	       list_templates(result, rhs);

	       /* BUG */
	       /* This should be a lot cleaner. This is put here where its
	          more visible*/

	       /* Constraint template */

	       if(rhs && *rhs){
	         if(strcasecmp(rhs, "constraint") == 0){

		  wAppendTerm(result, R_FULL_FMT, "TEMPLATE", "constraint");
		  wAppendTerm(result, F_ATTR_VAL, "Name", "Name of contraint");
		  wAppendTerm(result, F_ATTR_VAL, "Description", "Description of constraint");
		  wAppendTerm(result, F_ATTR_VAL, "Values", "Range of values of constraint");
		  wAppendTerm(result, F_ATTR_VAL, "Scope", "Scope of constraint");
		 }
	       }
	       else{

		  wAppendTerm(result, R_FULL_FMT, "TEMPLATE", "constraint");
		  wAppendTerm(result, F_ATTR_VAL, "Name", "Name of contraint");
		  wAppendTerm(result, F_ATTR_VAL, "Description", "Description of constraint");
		  wAppendTerm(result, F_ATTR_VAL, "Values", "Range of values of constraint");
		  wAppendTerm(result, F_ATTR_VAL, "Scope", "Scope of constraint");
	       }
	       /* Command template */

	       if(rhs && *rhs){
	         if(strcasecmp(rhs, "command") == 0){

		  wAppendTerm(result, R_FULL_FMT, "TEMPLATE", "command");
		  wAppendTerm(result, F_ATTR_VAL, "Name", "Name of command");
		  wAppendTerm(result, F_ATTR_VAL, "Description", "Description of command");
		 }
	       }
	       else{
		  wAppendTerm(result, R_FULL_FMT, "TEMPLATE", "command");
		  wAppendTerm(result, F_ATTR_VAL, "Name", "Name of command");
		  wAppendTerm(result, F_ATTR_VAL, "Description", "Description of command");
	       }

	       done = 1;
	       break;

	    case C_VERSION:

	       if(wGetRHS(curr_item))
		  wAppendSystemMessage(result, wErrorReply(WWARN_NOARG_COMMAND, "'%s'", command_set[i].c_name));

	       wAppendTerm(result, NO_VAL, "Version", version);
	       done = 1;
	       break;

	    default:
	       break;
	 }

	 /* If "command" is not recognized, then we try it as a general search */
      }

      if(i > C_LAST)
	 return(1);
   }

   return(0);

}
