VERSION 2.00
Begin Form Bubbles 
   BackColor       =   &H00000000&
   BorderStyle     =   0  'None
   ClientHeight    =   4095
   ClientLeft      =   1290
   ClientTop       =   1695
   ClientWidth     =   7260
   ControlBox      =   0   'False
   ForeColor       =   &H00000000&
   Height          =   4560
   Icon            =   BUBBLES.FRX:0000
   Left            =   1200
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   273
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   484
   Top             =   1320
   Width           =   7440
   WindowState     =   2  'Maximized
   Begin MMControl MMControl2 
      BackVisible     =   0   'False
      BorderStyle     =   0  'None
      EjectVisible    =   0   'False
      Height          =   375
      Left            =   6300
      NextVisible     =   0   'False
      PauseVisible    =   0   'False
      PrevVisible     =   0   'False
      RecordVisible   =   0   'False
      StepVisible     =   0   'False
      TabIndex        =   5
      Top             =   840
      Visible         =   0   'False
      Width           =   870
   End
   Begin MMControl MMControl1 
      BackVisible     =   0   'False
      BorderStyle     =   0  'None
      EjectVisible    =   0   'False
      Height          =   375
      Left            =   6300
      NextVisible     =   0   'False
      PauseVisible    =   0   'False
      PrevVisible     =   0   'False
      RecordVisible   =   0   'False
      StepVisible     =   0   'False
      TabIndex        =   6
      Top             =   480
      Visible         =   0   'False
      Width           =   870
   End
   Begin Frame History 
      BackColor       =   &H00000000&
      ForeColor       =   &H00000000&
      Height          =   1095
      Left            =   780
      TabIndex        =   2
      Top             =   0
      Visible         =   0   'False
      Width           =   5355
      Begin CommandButton OK 
         Cancel          =   -1  'True
         Caption         =   "OK"
         Default         =   -1  'True
         Height          =   315
         Left            =   60
         TabIndex        =   4
         Top             =   720
         Width           =   5235
      End
      Begin Label HighestDisplay 
         Alignment       =   2  'Center
         BackColor       =   &H00000000&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Session High: 0;   Low: 0"
         ForeColor       =   &H0000FFFF&
         Height          =   255
         Left            =   60
         TabIndex        =   0
         Top             =   420
         Width           =   5235
      End
      Begin Label HistoryDisplay 
         Alignment       =   2  'Center
         BackColor       =   &H00000000&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Historical High: 0"
         ForeColor       =   &H0000FFFF&
         Height          =   255
         Left            =   60
         TabIndex        =   3
         Top             =   120
         Width           =   5235
      End
   End
   Begin Timer Timer1 
      Interval        =   1
      Left            =   6480
      Top             =   60
   End
   Begin Label CounterDisplay 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00000000&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "0"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00C00000&
      Height          =   255
      Left            =   5820
      TabIndex        =   1
      Top             =   3540
      Width           =   1035
   End
   Begin Label ChangeDisplay 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00000000&
      BorderStyle     =   1  'Fixed Single
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H0000FFFF&
      Height          =   315
      Left            =   4380
      TabIndex        =   7
      Top             =   3240
      Visible         =   0   'False
      Width           =   2475
   End
End
Option Explicit

Const MaxNo = 14                    'Absolute maximum number of bubbles
Const LevelStep = 50000             'Level Score Step

Dim Moves As Integer                'Mouse mouve discounter
Dim NextLevel As Long               'Score boundary for next level
Dim DisplayTimer As Long            'Level increase display timer
Dim Highest As Long                 'Highest running score in current session
Dim Lowest As Long                  'Lowest...
Dim Number_Bubbles As Integer       'Maximum number of active bubbles
Dim Current_Bubbles As Integer      'Number of Active Bubbles
Dim Index As Integer                'Bubble Index
Dim Bubble_Flag(MaxNo) As Integer   'Alive Bubble
Dim Bubble_Color(MaxNo) As Integer  'Bubble color
Dim Expansion_Rate As Integer       'Rate of bubble expansion
Dim X_Coord(MaxNo), Y_Coord(MaxNo), Radius(MaxNo) As Integer    'Bubble coordinates
Dim Prev_X(MaxNo), Prev_Y(MaxNo), Prev_Radius(MaxNo) As Integer 'Previous bubble coordinates

Sub Form_Activate ()
    If Setup_Flag Then                  'Setup mode
	If Setup_Show Then              'Setup form asked for
	    Setup_Show = False          'Got the msg - cancel it
	    Setup.Show 1                'Show it (modal)
	End If
    Else                                'Other modes: start with "hidden" cursor (at lower right of screen)
	Dummy = SetCursorPos(Bubbles.ScaleWidth, Bubbles.ScaleHeight)
    End If
    History.Left = Bubbles.ScaleWidth \ 2 - History.Width \ 2   'Place in middle of screen
    ChangeDisplay.Top = Bubbles.ScaleHeight - 3 * CounterDisplay.Height + 7 'Place at bottom right
    ChangeDisplay.Left = Bubbles.ScaleWidth - ChangeDisplay.Width           'at proper height...
    CounterDisplay.Top = Bubbles.ScaleHeight - 2 * CounterDisplay.Height + 5
    CounterDisplay.Left = Bubbles.ScaleWidth - CounterDisplay.Width
    'As a function of screen dimensions...
    Movement_Rate = Bubbles.ScaleHeight \ Movement_Factor       'Initial bubble movement rate
    Expansion_Rate = Bubbles.ScaleHeight \ 130                  'Bubble expansion rate
    If Expansion_Rate < 1 Then
	Expansion_Rate = 1              'But not lower than 1
    End If
    Number_Bubbles = Bubbles.ScaleHeight \ 30
    If Number_Bubbles > MaxNo Then      'Just in case
	Number_Bubbles = MaxNo
    End If
    'If Number_Bubbles < 3 Then
    '    Number_Bubbles = 3              'For icons (not used in this version)
    'End If
End Sub

Sub Form_KeyDown (KeyCode As Integer, Shift As Integer)
    If KeyCode = Key_F1 Then                'Setup form asked for
	Setup_Flag = True
	'Place cursor in middle of screen
	Dummy = SetCursorPos(ScaleWidth / 2, ScaleHeight / 2)
	Setup.Show 1                        'Show it (modal)
    ElseIf KeyCode = Key_F2 Then            'Historical High asked for
	HistoryDisplay = "Historical High: " & HighestScore & ",  reached on " & HighestTime
	History.Visible = True
    Else
	Terminate                           'Any other key terminates
    End If
End Sub

Sub Form_Load ()
    Dim Tmp As Integer, Tmps As String          'Temporary variables

    If App.PrevInstance Then                    'No other instance allowed...
	End                                     '...a must for screen savers
    End If
    If InStr(UCase$(Command$), "/C") > 0 Then   'Setup mode asked for
	Setup_Flag = True                       'Flag it
	Setup_Show = True                       'Call for it
    End If
    Load Setup                                  'Preload it
    MMControl1.Notify = False                   'MCI setup
    MMControl1.Wait = True                      'for 2 sounds
    MMControl1.Shareable = False
    MMControl1.DeviceType = "WaveAudio"
    MMControl1.FileName = "Bubble1.Wav"
    MMControl1.Command = "Open"
    MMControl2.Notify = False
    MMControl2.Wait = True
    MMControl2.Shareable = False
    MMControl2.DeviceType = "WaveAudio"
    MMControl2.FileName = "Bubble2.Wav"
    MMControl2.Command = "Open"
    Randomize (Timer)                           'Randomize
    'Get previously stored values
    On Error GoTo BadFile                       'In case file doesn't exist
    Open "Drowned.Ini" For Input As #1          'Open it
    Input #1, Tmps
    If Tmps <> Version Then                     'Check version
	GoTo BadFile
    End If
    Input #1, Tmp                               'Game mode
    Setup.MnuGame.Checked = Tmp
    Input #1, Tmp                               'Sound1
    Setup.MnuSound1.Checked = Tmp
    Input #1, Tmp                               'Sound2
    Setup.MnuSound2.Checked = Tmp
    Input #1, Tmp                               'Counter display toggle
    Setup.MnuDisplay.Checked = Tmp
    Input #1, Tmp                               'Previous speed
    Setup.Speed.Value = Tmp
    CalcMovement                                'Force a recalc to avoid /0
    Input #1, Tmp                               'Previous difficulty level
    Setup.Level.Value = Tmp
    Input #1, HighestScore, HighestTime         'Historical High & Date/Time
FileOK:
    Close #1                                    'Done
    On Error GoTo 0                             'Cancel error handling
    Select Case Setup.Level.Value               'Set Level display in setup form
	Case 0
	    Setup.LevelDisplay = Setup.Level.Value & ": Toddler"
	Case 1
	    Setup.LevelDisplay = Setup.Level.Value & ": Recruit"
	Case 2
	    Setup.LevelDisplay = Setup.Level.Value & ": Fighter"
	Case 3
	    Setup.LevelDisplay = Setup.Level.Value & ": Hero"
	Case 4
	    Setup.LevelDisplay = Setup.Level.Value & ": SuperHero"
    End Select
    If Setup.MnuGame.Checked Then               'If game mode on...
	ChangeDisplay.Visible = Setup.MnuDisplay.Checked    'Displays wanted?
	CounterDisplay.Visible = Setup.MnuDisplay.Checked
    Else                                        'otherwise hide counter displays
	ChangeDisplay.Visible = False
	CounterDisplay.Visible = False
    End If
    'Disable selected menu items in non-game mode
    Setup.MnuDisplay.Enabled = Setup.MnuGame.Checked
    Setup.MnuLevel.Enabled = Setup.MnuGame.Checked
    NextLevel = LevelStep                       'Next counter level target
    DrawMode = 13                               'Copy pen
    Exit Sub                                    'Done
BadFile:
    'If no good .INI file
    Setup.Speed.Value = 8                       'Start at speed 8
    CalcMovement                                'Force recalc to avoid /0
    Setup.Level.Value = 1                       'Start difficulty level at 1
    Resume FileOK                               'Do the rest of initialization
End Sub

Sub Form_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim i As Integer                                'Index
    Dim Arc_Start As Single                         'Arc start
    Dim Arc_Step As Single                          'Explosion: arc frequency
    Dim Popped As Integer                           'Popped bubbles counter
    If Button = 2 Or Not Setup.MnuGame.Checked Then
	Terminate                                   'Quit
    End If
    CounterDisplay = CounterDisplay - 100           'Click cost
    If Lowest > CounterDisplay Then                 'Adjust lowest count
	Lowest = CounterDisplay
	HighestDisplay = "Session High: " & Highest & ",   Low: " & Lowest 'display it
    End If
    Popped = 0                                      'Initialize (redundant - I know)
    For i = 1 To MaxNo                              'All possible bubbles...
	If Bubble_Flag(i) Then                      'Only live ones...
	    'Click in range?
	    If X >= Prev_X(i) - Prev_Radius(i) - Diff And X <= Prev_X(i) + Prev_Radius(i) + Diff And Y >= Prev_Y(i) - Prev_Radius(i) - Diff And Y <= Prev_Y(i) + Prev_Radius(i) + Diff Then
		Popped = Popped + 1                 'Yes - increment popped counter
		If Prev_Radius(i) > 10 Then         'Had reflection arc?
		    'Erase it
		    Circle (Prev_X(i), Prev_Y(i)), Prev_Radius(i) - 6, , 2, 3
		End If
		'Erase bubble
		Circle (Prev_X(i), Prev_Y(i)), Prev_Radius(i)                        'erase circle
		Arc_Step = Rnd * .5 + .5            'Explosion: random arc step
		'Pop it
		For Arc_Start = 0 To 6.18 Step Arc_Step
		    Circle (Prev_X(i), Prev_Y(i)), Prev_Radius(i) + 10, QBColor(Bubble_Color(i)), Arc_Start, Arc_Start + .1
		Next Arc_Start
		'Increase game counter
		If CounterDisplay < 0 Then          'If counter was negative
		    CounterDisplay = 0              'Start at 0 (not required - but I like it better)
		End If
		'Increase by factor determined by bubble vert. position and radius
		CounterDisplay = CounterDisplay + 10 * (Prev_Y(i) \ Prev_Radius(i))
		If Highest < CounterDisplay Then    'High?
		    Highest = CounterDisplay
		    HighestDisplay = "Session High: " & Highest & ",   Low: " & Lowest 'display it
		    If HighestScore < Highest Then
			HighestScore = Highest
			HighestTime = Now
		    End If
		    'Increase level and speed?
		    If Highest >= NextLevel And Setup.Level < Setup.Level.Max Then
			Beep                        'Notify of increase
			'Accuracy level
			Setup.Level.Value = Setup.Level + 1
			NextLevel = NextLevel + LevelStep
			ChangeDisplay.Visible = True
			DisplayTimer = Timer
			'Bubbles' speed
			If Setup.Speed < Setup.Speed.Max - 1 Then
			    Setup.Speed.Value = Setup.Speed + 1
			End If
		    End If
		End If
		'Erase pop
		For Arc_Start = 0 To 6.18 Step Arc_Step
		    Circle (Prev_X(i), Prev_Y(i)), Prev_Radius(i) + 10, , Arc_Start, Arc_Start + .1
		Next Arc_Start
		Bubble_Flag(i) = False              'Kill bubble
	    End If
	End If
    Next i
    'Sounds?
    If Setup.MnuSound1.Checked Then
	Select Case Popped
	    Case 0
	    Case 1
		MMControl1.Command = "Play"
		MMControl1.Command = "Prev"
	    Case Else
		MMControl2.Command = "Play"
		MMControl2.Command = "Prev"
		DoEvents
	End Select
    End If
End Sub

Sub Form_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    'Moves in non-game mode terminates
    If Not Setup.MnuGame.Checked And Not Setup_Flag Then
	If Moves >= 5 Then          'Allow for 4 prior moves
	    Terminate
	Else
	    Moves = Moves + 1
	End If
    End If
End Sub

Sub Form_Unload (Cancel As Integer)
    'MCI sound close
    MMControl1.Command = "Close"
    MMControl2.Command = "Close"
End Sub

Sub OK_Click ()
    History.Visible = False
End Sub

Sub OK_KeyDown (KeyCode As Integer, Shift As Integer)
    'Setup form request
    If KeyCode = Key_F1 Then
	Setup_Flag = True
	Dummy = SetCursorPos(Bubbles.ScaleWidth / 2, Bubbles.ScaleHeight / 2)
	Setup.Show 1                'Show it (modal)
    End If
    'Historical display toggle = hide
    If KeyCode = Key_F2 Then
	History.Visible = False
    End If
End Sub

Sub Terminate ()
    'Save selected settings in file
    Open "Drowned.Ini" For Output As #1
    Write #1, Version
    Write #1, Setup.MnuGame.Checked
    Write #1, Setup.MnuSound1.Checked
    Write #1, Setup.MnuSound2.Checked
    Write #1, Setup.MnuDisplay.Checked
    Write #1, Setup.Speed.Value
    Write #1, Setup.Level.Value
    Write #1, HighestScore, HighestTime
    Close #1
    End
End Sub

Sub Timer1_Timer ()
    Current_Bubbles = 0                         'Initialize live bubbles counter
    'Count live bubbles
    For Index = 1 To MaxNo
	Current_Bubbles = Current_Bubbles + Abs(Bubble_Flag(Index))
    Next
    'New bubble needed?
    If Current_Bubbles < Number_Bubbles Then
	For Index = 1 To Number_Bubbles
	    'In free slot
	    If Not Bubble_Flag(Index) And Rnd < .1 Then
		'Bubble Birth
		Bubble_Flag(Index) = True
		'Starting point
		X_Coord(Index) = Bubbles.ScaleWidth \ 2 + Rnd * 10
		Y_Coord(Index) = Bubbles.ScaleHeight
		Radius(Index) = 2               'Has to be > 1 for future expansion...
		Bubble_Color(Index) = Int(Rnd * 7) + 9  'Color
		Circle (X_Coord(Index), Y_Coord(Index)), Radius(Index), QBColor(Bubble_Color(Index))
		If Radius(Index) > 10 Then      'Reflection arc if sufficiently large
		    Circle (X_Coord(Index), Y_Coord(Index)), Radius(Index) - 6, QBColor(Bubble_Color(Index)), 2, 3  'reflection
		End If
		'Store for later erasures
		Prev_X(Index) = X_Coord(Index)
		Prev_Y(Index) = Y_Coord(Index)
		Prev_Radius(Index) = Radius(Index)
	    End If
	Next
    End If
    'Now check all lives bubbles and make them float up...
    For Index = 1 To MaxNo
	If Bubble_Flag(Index) Then              'Live?
	    If Rnd < .2 Then                    'Average of 1 out of 5 aren't growing
		'Growth
		Radius(Index) = Radius(Index) + Expansion_Rate
	    End If
	    'Float up
	    X_Coord(Index) = X_Coord(Index) + Sgn(Rnd - .5) * Rnd * Movement_Rate
	    Y_Coord(Index) = Y_Coord(Index) - Rnd * Movement_Rate
	    'Erase reflection?
	    If Prev_Radius(Index) > 10 Then
		Circle (Prev_X(Index), Prev_Y(Index)), Prev_Radius(Index) - 6, , 2, 3
	    End If
	    'Erase bubble
	    Circle (Prev_X(Index), Prev_Y(Index)), Prev_Radius(Index)
	    'Bubble too big or too high?
	    If Y_Coord(Index) < 5 Then
		'Bubble Death
		If Setup.MnuSound2.Checked Then
		    MMControl2.Command = "Play"
		    MMControl2.Command = "Prev"
		End If
		Bubble_Flag(Index) = False
		'Decrease counter in game mode (except when showing a window)
		If Setup.MnuGame.Checked And Not Setup_Flag Then
		    CounterDisplay = CounterDisplay - 1
		End If
		If Lowest > CounterDisplay Then
		    Lowest = CounterDisplay
		    HighestDisplay = "Session High: " & Highest & ",   Low: " & Lowest 'display it
		End If
	    Else
		'New position
		Circle (X_Coord(Index), Y_Coord(Index)), Radius(Index), QBColor(Bubble_Color(Index))
		'Reflection?
		If Radius(Index) > 10 Then
		    Circle (X_Coord(Index), Y_Coord(Index)), Radius(Index) - 6, QBColor(Bubble_Color(Index)), 2, 3  'reflection
		End If
		'Store for future erasure
		Prev_X(Index) = X_Coord(Index)
		Prev_Y(Index) = Y_Coord(Index)
		Prev_Radius(Index) = Radius(Index)
	    End If
	End If
    Next
    'Erase the temporary Level Change Indicator after 10 seconds
    If ChangeDisplay.Visible And Timer > DisplayTimer + 10 Then
	ChangeDisplay.Visible = False
    End If
End Sub

