/*-
 * Copyright (c) 1996, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *      Author: Kelly Djahandari, Trusted Information Systems, Inc.
 */

/*
	wrapper.h

	This file contains information specific to the MBone application
	wrapper program.
*/

/* The MBone application wrapper can be started either (using vic as example):
    1)  vic 224.2.197.230/49182 (where vic is a symbolic link to wrapper
		and the real vic application location is specified here)
	or
    2)  wrapper vic 224.2.197.230/49182 (where the "real" vic application 
		location is located from the user's PATH or specified here)
*/

/* 
 * Define MBONE_APPL_DIRECTORY to the directory location of the MBone 
 * applications.  The trailing '/' is required.  Symbolic links of the 
 * MBone application names to the wrapper executable is required
 * (i.e.  vic -> wrapper).  Use this method for #1 or #2 above.
 */
/*
#define MBONE_APPL_DIRECTORY "/usr/people/kelly/bin/"
*/


/* 
 * Define MBONE_APPL_DIRECTORY to be null if using method #2 above and want 
 * the location of the MBone application will be located from the user's path. 
 */
#define MBONE_APPL_DIRECTORY "" 


/*
 * This is the name of the wrapper executable.  This is used to determine if
 * using method #2 above.
 */
#define WRAPPER_NAME "wrapper"

/* This is the maximum string length for the path, including application, 
 * of the MBone applications.  This can be modified. */
#define MAX_APPL_PATH_STR 200


/* This is the list of MBone applications which are checked when starting as 
"wrapper mbone-app."  */
static char *mbone_app[] = {"sdr", "vic", "vat", "wb", "nt"};
static int num_mbone_apps = 5;
