/*                                                                           */
/*  * This is where we drop in the various dependencies for different        */
/*  * systems. Someday this might be remotely complete.                      */
/*  *                                                                        */
/*  * I kept the name pmachine.h because it was already in all of the        */
/*  * files...this barely resembles the pmachine.h that comes with the       */
/*  * real Prospero, though.                                                 */
#include "config.h"
#include "includes.h"
#include "defs.h"
#include "protos.h"
#include "socks.h"

#ifdef u3b2
# define USG
# define MAXPATHLEN 1024       /* There's no maxpathlen in any 3b2 .h file.  */
#endif

#ifdef m88k
#define MAXPATHLEN 1024
#endif

/* These are required for a Sequent running Dynix/PTX, their SysV variant.
   Archie builds fine untouched on a system running their BSD-based OS.  */
#ifdef _SEQUENT_
# define USG
#endif

#ifdef _AUX_SOURCE
# define AUX
# define NBBY 8	/* Number of bits in a byte.  */
typedef long Fd_mask;
# define NFDBITS (sizeof(Fd_mask) * NBBY)	/* bits per mask */
#endif

#ifdef _AIX
# define _NONSTD_TYPES
# define _BSD_INCLUDES
#endif

/* General problems.  */
#ifndef HAVE_INDEX
#define index		strchr
#endif
#ifndef HAVE_RINDEX
#define rindex		strrchr
#endif
#ifndef HAVE_BCOPY
#define bcopy(a,b,n)	memcpy(b,a,n)
#endif
#ifndef HAVE_BZERO
#define bzero(a,n)	memset(a,0,n)
#endif

/*
 * FD_SET: lib/pfs/dirsend.c, user/vget/ftp.c
 */
#define SELECTARG fd_set
#if !defined(FD_SET) && !defined(linux)
#define	FD_SETSIZE	32
#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#undef FD_ZERO
#define FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))
#endif
