dnl try to find an ansi compiler.
AC_DEFUN(AC_PROG_ANSI_CC, [
AC_CHECK_PROG(CC, gcc2, gcc2)
OCFLAGS="$CFLAGS"
CFLAGS=
AC_PROG_CC	
CDEBUG_FLAGS="$CFLAGS"
CFLAGS="$OCFLAGS"
savedcc="CC"
if test "$GCC" = "yes"; then
	CFLAGS="$CFLAGS -D__USE_FIXED_PROTOTYPES__"
elif test "$OS" = "HP-UX"; then
	unset CC 
	AC_CHECK_PROG(CC, c89, c89, $savedcc)
	CFLAGS="-D_HPUX_SOURCE"
elif test "$OS" = "SunOS"; then
	unset CC 
	AC_CHECK_PROG(CC, acc, acc, $savedcc)
	CC="ACC"
fi
if test "$savedcc" != "CC"; then AC_MSG_RESULT(resetting CC to gcc2); fi 
])dnl

AC_DEFUN(AC_KERBEROS5, [
AC_ARG_WITH(krb5,           --with-krb5		Turn on Kerberos 5,                             [KRB5="$withval"], [KRB5="no"])
if test "$KRB5" != "no"; then
echo
AC_MSG_CHECKING(Kerberos 5)
AC_CACHE_VAL(r_cv_krb5_home, [
if test "$KRB5" = "yes" -o "$KRB5" = ""; then
	r_cv_krb5_home=`egrep \^klogin /etc/inetd.conf|awk '{print [$]6;}'|awk -F/ '{ORS="/";for(i=1;i<=NF-2;i++) print $i;}'`
else
	r_cv_krb5_home=$KRB5
fi])dnl

if test "$KRB5" = "" -a "$r_cv_krb5_home" != "" -a  ! -d $r_cv_krb5_home/include/krb5; then
	r_cv_krb5_home=""
fi
KRB5_HOME=$r_cv_krb5_home
if test "$KRB5_HOME" != ""; then
	AC_MSG_RESULT("$KRB5_HOME")
elif test "$KRB5" != ""; then
	AC_MSG_RESULT("default")
else 
	AC_MSG_RESULT("no")
fi
if test "$KRB5" != "" -o "$KRB5_HOME" != ""; then
	if test "$KRB5_HOME" != ""; then
		[CFLAGS="$CFLAGS -I$KRB5_HOME/include"]
		[LDFLAGS="$LDFLAGS -L$KRB5_HOME/lib"]
	fi
	AC_CHECK_LIB(db,          main)
	dnl check whether db has been found
	if test "$ac_cv_lib_db_main" = "no"; then
		AC_CHECK_LIB(ndbm,main)
	fi
	AC_CHECK_LIB(isode,       main)
	AC_CHECK_LIB(com_err,     main)
	AC_CHECK_LIB(crypto,      main)
	AC_CHECK_LIB(krb5,        main)
	AC_CHECK_LIB(gssapi_krb5, main)
fi
fi
])dnl

AC_DEFUN(AC_MAKE_SHAREDLIB, [
SHLIB_LD="ld"
SHLIB_LIB=""
SHLIB_LFLAGS="-shared"
SHLIB_CFLAGS="-r"
SHLIB_OFLAGS="-o "
if test "$exec_prefix" != "NONE"; then
	SHLIB_DIR=$exec_prefix/lib
elif test "$prefix" != "NONE"; then
	SHLIB_DIR=$prefix/lib
else
	SHLIB_DIR=/usr/local/lib
fi
PRELOADS="echo Shared libraries not supported; exit; :"
PRELOADA=""
AC_MSG_CHECKING(shared library support)
if test "$ac_cv_func_dlopen" = "yes"; then
	SHLIB_LIB="libsocks5_sh.so"
	case `uname -rs` in
	UNIX_SV*|UNIX_System_V*)
		SHLIB_LFLAGS="-G"
		;;
	FreeBSD*)
		SHLIB_LFLAGS="-Bshareable"
		SHLIB_CFLAGS="-fpic"
		PRELOADS="LD_PRELOAD"
		;;
	SunOS*4.*)
 		SHLIB_CFLAGS="-P"
		SHLIB_LFLAGS="-dp -assert pure-text -assert nodefinitions"
		PRELOADS="LD_PRELOAD"
		;;
	SunOS*5.*)
		SHLIB_LD="cc"
		SHLIB_CFLAGS="-KPIC"
		SHLIB_LFLAGS="-G"
		SHLIB_OFLAGS="-W0,-y-o -W0,-y"
		PRELOADS="LD_PRELOAD"
		;;	
	IRIX*5.*|IRIX*6.*)
		SHLIB_CFLAGS="-KPIC"
		PRELOADS="_RLD_LIST"
		PRELOADA=":DEFAULT"
		;;
	BSD/OS*)
		SHLIB_LIB=
		;;
	OSF1*)
		PRELOADS="_RLD_LIST"
		PRELOADA=":DEFAULT"
		;;
	*)
		PRELOADS="LD_PRELOAD"
		;;
	esac

	if test "$GCC" = "yes" ; then
		SHLIB_CFLAGS="-fpic"
		case `uname -rs` in
		SunOS*4.*)
			DLLIBS="-lc"
			;;
		SunOS*5.*)
			SHLIB_LD="gcc"
			SHLIB_OFLAGS="-o "
			SHLIB_LFLAGS="-shared"
			;;
		UNIX_SV*|UNIX_System_V*)
			SHLIB_CFLAGS=
			;;
		FreeBSD*)
			;;
		*)
			SHLIB_LD="gcc"
			SHLIB_LFLAGS="-shared"
		esac
	fi

dnl I don't think this works, -r should produce the svr3.2 
dnl shared libs, not the svr4 ones that we want...

	if test `uname -s` = "FreeBSD"; then
		SHLIB_CFLAGS="-fpic -r"
	fi

	AC_MSG_RESULT("lflags: $SHLIB_LFLAGS cflags: $SHLIB_CFLAGS")
    else
	AC_MSG_RESULT(no)
fi
SHLIB_LIBS="$SHLIB_LIBS $LIBS"
AC_SUBST(DLLIBS)
AC_SUBST(SHLIB_LD)
AC_SUBST(SHLIB_DIR)
AC_SUBST(SHLIB_LIB)
AC_SUBST(SHLIB_LIBS)
AC_SUBST(SHLIB_CFLAGS)
AC_SUBST(SHLIB_OFLAGS)
AC_SUBST(SHLIB_LFLAGS)
AC_SUBST(PRELOADS)
AC_SUBST(PRELOADA)
])dnl

AC_DEFUN(AC_CHECK_SHLIB, [
ac_safe=`echo "$1" | tr './\055' '___'`
AC_MSG_CHECKING(for shared $1)
AC_CACHE_VAL(r_cv_name_$ac_safe, [
case `uname -rs` in
	IRIX*5.*)
dnl 		1 versioned number takes precedence over unversioned...
dnl 		2 /usr/lib, lib
		if test -n "`ls /usr/lib/$ac_safe.so.* 2>/dev/null | sort -r | head -1`"; then
			eval "r_cv_name_$ac_safe=`ls /usr/lib/$ac_safe.so.* | sort -r | head -1`"
		elif test -n "`ls /lib/$ac_safe.so.* 2>/dev/null | sort -r | head -1`"; then
			eval "r_cv_name_$ac_safe=`ls /lib/$ac_safe.so.* | sort -r | head -1`"
		elif test -f /usr/lib/$ac_safe.so; then
			eval "r_cv_name_$ac_safe=/usr/lib/$ac_safe.so"
		elif test -f /lib/$ac_safe.so; then
			eval "r_cv_name_$ac_safe=/lib/$ac_safe.so"
		fi
		;;
	OSF1*)
dnl		1 no versioning
dnl  	 	2 /usr/shlib, /usr/lib, /lib
		if test -f /usr/shlib/$ac_safe.so; then
			eval "r_cv_name_$ac_safe=/usr/shlib/$ac_safe.so"
		elif test -f /usr/lib/$ac_safe.so; then
			eval "r_cv_name_$ac_safe=/usr/lib/$ac_safe.so"
		elif test -f /lib/$ac_safe.so; then
			eval "r_cv_name_$ac_safe=/lib/$ac_safe.so"
		fi
		;;
	Linux*1.*)
dnl		1 versioned (w/o maj/min), versioned, unversioned 
dnl		2 /lib, /usr/lib
dnl		no path
		if test -n "`ls /lib/$ac_safe.so.? 2>/dev/null | sort -r | head -1`"; then
			eval "r_cv_name_$ac_safe=`cd /lib; ls $ac_safe.so.? | sort -r | head -1`"
		elif test -n "`ls /usr/lib/$ac_safe.so.? 2>/dev/null | sort -r | head -1`"; then
			eval "r_cv_name_$ac_safe=`cd /usr/lib; ls $ac_safe.so.* | sort -r | head -1`"
		elif test -n "`ls /lib/$ac_safe.so.* 2>/dev/null | sort -r | head -1`"; then
			eval "r_cv_name_$ac_safe=`cd /lib; ls $ac_safe.so.* | sort -r | head -1`"
		elif test -n "`ls /usr/lib/$ac_safe.so.* 2>/dev/null | sort -r | head -1`"; then
			eval "r_cv_name_$ac_safe=`cd /usr/lib; ls $ac_safe.so.* | sort -r | head -1`"
		elif test -f /lib/$ac_safe.so; then
			eval "r_cv_name_$ac_safe=/lib/$ac_safe.so"
		elif test -f /usr/lib/$ac_safe.so; then
			eval "r_cv_name_$ac_safe=/usr/lib/$ac_safe.so"
		fi
		;;
	SunOS*)
dnl		1 unversioned takes precedence over versioned
dnl		2 /usr/lib /lib
		if test -f /usr/lib/$ac_safe.so; then
			eval "r_cv_name_$ac_safe=/usr/lib/$ac_safe.so"
		elif test -n "`ls /usr/lib/$ac_safe.so.* 2>/dev/null | sort -r | head -1`"; then
			eval "r_cv_name_$ac_safe=`ls /usr/lib/$ac_safe.so.* | sort -r | head -1`"
		elif test -f /lib/$ac_safe.so; then
			eval "r_cv_name_$ac_safe=/lib/$ac_safe.so"
		elif test -n "`ls /lib/$ac_safe.so.* 2>/dev/null | sort -r | head -1`"; then
			eval "r_cv_name_$ac_safe=`ls /lib/$ac_safe.so.* | sort -r | head -1`"
		fi
		;;
	dgux*)
dnl		1 /usr/dglib 
dnl		2 versioned, unversioned
		if test -f /usr/dglib/$ac_safe.so; then
			eval "r_cv_name_$ac_safe=/usr/dglib/$ac_safe.so"
		elif test -n "`ls /usr/dglib/$ac_safe.so.* 2>/dev/null | sort -r | head -1`"; then
			eval "r_cv_name_$ac_safe=`ls /usr/dglib/$ac_safe.so.* | sort -r | head -1`"
		fi
		;;
	*)
dnl		1 unversioned number takes precedence over versioned...
dnl		2 /lib, /usr/lib
		if test -f /lib/$ac_safe.so; then
			eval "r_cv_name_$ac_safe=/lib/$ac_safe.so"
		elif test -n "`ls /lib/$ac_safe.so.* 2>/dev/null | sort -r | head -1`"; then
			eval "r_cv_name_$ac_safe=`ls /lib/$ac_safe.so.* | sort -r | head -1`"
		elif test -f /usr/lib/$ac_safe.so; then
			eval "r_cv_name_$ac_safe=/usr/lib/$ac_safe.so"
		elif test -n "`ls /usr/lib/$ac_safe.so.* 2>/dev/null | sort -r | head -1`"; then
			eval "r_cv_name_$ac_safe=`ls /usr/lib/$ac_safe.so.* | sort -r | head -1`"
		fi
		;;
esac
])dnl
ac_result=`eval echo '$r_cv_name_'$ac_safe`
if test "$ac_result" != ""; then
	AC_MSG_RESULT($ac_result)
	ifelse([$2], , :, [$2])dnl
else 
	AC_MSG_RESULT(no)
	ifelse([$3], , , [$3])dnl
fi
])dnl	

AC_DEFUN(AC_CHECK_SHLIBS, [
for r_lib_name in $1
do
AC_CHECK_SHLIB($r_lib_name, [
changequote(, )dnl
r_fixed=`echo $r_lib_name | tr '[a-z]./\055' '[A-Z]___'`_NAME
changequote([, ])dnl
AC_DEFINE_UNQUOTED($r_fixed, "$ac_result") $2], $3)dnl
done
])

AC_DEFUN(AC_IDENT, [
AC_ARG_WITH(ident,           --with-ident		Turn on ident verification, [IDENT="$withval"], [IDENT="yes"])
if test "$IDENT" != "no"; then
    if test "$IDENT" != "yes"; then
	[CFLAGS="$CFLAGS -I$IDENT/include"]
	[LDFLAGS="$LDFLAGS -L$IDENT/lib -lident"]
    fi
    AC_CHECK_HEADER(ident.h)
    if test "$ac_cv_header_ident_h" = "yes" ; then
	AC_CHECK_LIB(ident,	main)
    fi
fi
])


AC_DEFUN(AC_SKEY, [
AC_ARG_WITH(skey,           --with-skey		Turn on Skey (or OTP) for NEC internal use, [SKEY="$withval"], [SKEY="no"])
if test "$SKEY" != "no"; then
echo
AC_MSG_CHECKING(Skey)
AC_CACHE_VAL(r_cv_skey_home, [
if test "$SKEY" = "yes" -o "$SKEY" = ""; then
	AC_PATH_PROG(skey_path, skey.init)
	if test "$skey_path" = ""; then
		AC_PATH_PROG(skey_path, otp.init)
	fi
	r_cv_skey_home=`echo $skey_path|awk -F/ '{ORS="/";for(i=1;i<=NF-2;i++) print $i;}'`
else
	r_cv_skey_home=$SKEY
fi])dnl

if test "$r_cv_skey_home" != ""; then
	if test ! -f $r_cv_skey_home/include/skey.h; then
		if test ! -f $r_cv_skey_home/include/otp.h; then
			r_cv_skey_home=""
		else
			otp="yes"
		fi
	fi
fi

SKEY_HOME=$r_cv_skey_home
if test "$SKEY_HOME" != ""; then
	AC_MSG_RESULT("$SKEY_HOME")
elif test "$SKEY" != ""; then
	AC_MSG_RESULT("default")
else 
	AC_MSG_RESULT("no")
fi
if test "$SKEY" != "" -o "$SKEY_HOME" != ""; then
	if test "$SKEY_HOME" != ""; then
		[CFLAGS="$CFLAGS -I$SKEY_HOME/include"]
		[LDFLAGS="$LDFLAGS -L$SKEY_HOME/lib"]
	fi
	if test "$otp" != "yes"; then
dnl Sometimes skey includes bsd/sgtty.h which uses bsd_ioctl
		AC_CHECK_LIB(bsd,           main)
		AC_CHECK_LIB(skey,          main)
	fi
	if test "$ac_cv_lib_skey_main" != "yes"; then
		AC_CHECK_LIB(otp,           main)
	fi
fi
fi
])dnl

dnl Check if struct sockaddr_un has sun_len
AC_DEFUN(AC_SOCKADDR_SUN_LEN,[
AC_MSG_CHECKING(whether sockaddr_un has sun_len)
AC_CACHE_VAL(sc_cv_sockaddr_sun_len,
[AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/un.h>],
[struct sockaddr_un s_un; s_un.sun_len=0;],
sc_cv_sockaddr_sun_len=yes, sc_cv_sockaddr_sun_len=no)])
if test "$sc_cv_sockaddr_sun_len" = "yes"; then AC_DEFINE(HAVE_SOCKADDR_SUN_LEN) fi
AC_MSG_RESULT($sc_cv_sockaddr_sun_len)
])

