 /*
 * monPort.h --
 *
 *      Portability header file for Monitor daemon.
 *
 * Copyright(C) 1995, 1996 NEC Corporation. All rights reserved.
 * This is a genuine component of Socks5Toolkit(TM).
 *
 * $Header: /insg/project/socks/s5watch/include/monPort.h,v 1.5 1997/08/14 04:42:52 miked Exp $
 * $Log: monPort.h,v $
 * Revision 1.5  1997/08/14 04:42:52  miked
 * #define INVALID_HANDLE_VALUE for both WIN32 and UNIX.
 *
 * Revision 1.4  1997/08/12  00:04:57  miked
 * Define UNIX macro Alive().
 *
 * Revision 1.3  1997/06/26  00:27:01  miked
 * typedef'ed HANDLE and DWORD for UNIX.
 *
 * Revision 1.2  1997/02/06  19:31:30  miked
 * Merged OSTC/NT and NWSL/UNIX versions.
 *
 * Revision 1.4  1996/09/10 22:40:59  jwg
 * changed pid_t typedef to int
 * Revision 1.3  1996/09/09 20:34:13  naomi
 * got rid of GetPid() macro since NT has its own getpid()
 * 
 * Revision 1.2  1996/09/05 21:22:28  naomi
 * Changes to where Jonathan left off...
 * Revision 1.1  1996/09/04 21:43:11  naomi
 * Initial revision
 * Revision 1.1.1.1  1996/08/30 02:43:49  miked
 * Initial version.
 *
 * Revision 1.9  1996/07/31  23:38:34  miked
 * Added #include <netdb.h> because s5dbAPI.h needs it.
 *
 * Revision 1.8  1996/07/30  21:01:01  miked
 * Yet another copyright notice.
 *
 * Revision 1.7  1996/07/17  23:47:33  miked
 * Moved typedef of SOCKET to monTcp.h so as to not clash with other headers.
 *
 * Revision 1.6  1996/07/15  18:11:49  miked
 * Moved #include "monConfig.h" out of #ifdef _WINDOWS
 *
 * Revision 1.5  1996/07/11  00:36:03  miked
 * Corrected typo in last version.
 *
 * Revision 1.4  1996/07/11  00:31:56  miked
 * Added #define INVALID_SOCKET for non Windows/NT.
 *
 * Revision 1.3  1996/07/09  23:57:49  miked
 * Added new copyright notice.
 *
 * Revision 1.2  1996/07/08  20:07:43  miked
 * Moved UNIX #includes inside non-Windows/NT #ifdef.
 *
 * Revision 1.1.1.1  1996/07/08  15:09:41  miked
 * Initial version for Socks5 API.
 */

#ifndef _H_MONPORT
#define _H_MONPORT

#ifdef WIN32

#ifndef SIZEOF_LONG
#define SIZEOF_LONG  4
#endif

#else

#include "monConfig.h"
#define FAR
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#ifdef __STDC__
#include <stddef.h>
#include <stdlib.h>
#endif

#endif /* !WIN32 */

#ifndef BUFSIZ
#include <stdio.h>
#endif

/*
 *----------------------------------------------------------------------
 *    C O N S T A N T S
 *----------------------------------------------------------------------
 */

/*
 * Definitions that allow this header file to be used either with or
 * without ANSI C features like function prototypes.
 */

#undef _ANSI_ARGS_
#undef CONST
#if (defined(__STDC__) && !defined(NO_PROTOTYPE)) || defined(__cplusplus)
#   define _USING_PROTOTYPES_ 1
#   define _ANSI_ARGS_(x)     x
#   define CONST const
#   ifdef __cplusplus
#       define VARARGS (...)
#   else
#       define VARARGS ()
#   endif
#else
#   define _ANSI_ARGS_(x)    ()
#   define CONST
#endif

#ifdef __cplusplus
#   define EXTERN extern "C"
#else
#   define EXTERN extern
#endif

/*
 * Macro to use instead of "void" for arguments that must have
 * type "void *" in ANSI C;  maps them to type "char *" in
 * non-ANSI systems.
 */

#ifndef VOID
#   ifdef __STDC__
#       define VOID void
#   else
#       define VOID char
#   endif
#endif

/*
 * Miscellaneous declarations 
 */

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef NULL
#define NULL 0
#endif

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS 0
#endif

#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif

#ifndef CHAR_BIT
#define CHAR_BIT 8
#endif

/*
 * The following typedef's should be used in data structures and
 * messages which are passed between different computers and compilers. 
 * They may need to be #ifdef'ed appropriately for each system.
 */

typedef unsigned char         Boolean_t;
typedef unsigned char         Byte_t;
typedef unsigned short        Uint16;  /* Unsigned integer 16-bits */
typedef short                 Sint16;  /* Signed   integer 16-bits */

#if SIZEOF_INT==4
typedef unsigned int          Uint32;  /* Unsigned integer 32-bits */
typedef int                   Sint32;  /* Signed   integer 32-bits */
#elif SIZEOF_LONG==4
typedef unsigned long         Uint32;  /* Unsigned integer 32-bits */
typedef long                  Sint32;  /* Signed   integer 32-bits */
#endif /* SIZEOF */

#ifndef WIN32
typedef Uint32                HANDLE;
typedef Sint32                DWORD;

#define Alive(THREAD, PID)    (kill(PID, 0) >= 0 || errno != ESRCH)
#endif /* !WIN32 */

#define INVALID_HANDLE_VALUE  0xffffffff

/*
 * Windows vs UNIX file descriptors and sockets.
 */

#ifdef WIN32
typedef HANDLE                FILE_D;
#else
typedef int                   FILE_D;
#endif /* !WIN32 */

/*
 * Windows needs type caddr_t and off_t defined
 */

#ifdef WIN32
typedef void*                 caddr_t;
#include <sys/types.h>        /* for off_t */
#include <process.h>          /* for getpid() */
#endif /* WIN32 */

/*
 * 1. pid's aren't that useful in NT, use tid's
 * 2. sleep(x) = Sleep(1000 x)
 */

#ifdef WIN32
#define sleep(X)             Sleep(X*1000)
#endif /* !WIN32 */

#endif /* _H_MONPORT */
