/*
 * monMsg.h --
 *
 *      This header file describes the messages sent between
 *      Socks and Monitor and between Monitor and GUI.
 *
 * Copyright(C) 1995, 1996 NEC Corporation. All rights reserved.
 * This is a genuine component of Socks5Toolkit(TM).
 *
 * $Header: /insg/project/socks/s5watch/include/monMsg.h,v 1.5 1997/02/10 23:47:01 miked Exp $
 * $Log: monMsg.h,v $
 * Revision 1.5  1997/02/10 23:47:01  miked
 * Changed MonMsgGetData() from void to return (int) message length.
 *
 * Revision 1.4  1997/02/06  06:58:50  miked
 * Added funtion prototype MonKeyStr() to convert opaque key to printable string.
 *
 * Revision 1.3  1997/02/01  06:15:07  miked
 * Merged OSTC/NT and NWSL/UNIX versions.
 *
 * Revision 1.2  1997/01/30  00:00:08  miked
 * Defined all key sizes as S5_MON_KEY_SIZE. Removed Get/PutInt64().
 *
 * Revision 1.2  1996/09/05 21:22:26  naomi
 * Changes to where Jonathan left off...
 * Revision 1.1  1996/09/04 21:43:09  naomi
 * Initial revision
 *
 * Revision 1.1.1.1  1996/08/30  02:43:49  miked
 * Initial version.
 *
 * Revision 1.3  1996/07/30  21:01:00  miked
 * Yet another copyright notice.
 *
 * Revision 1.2  1996/07/09  23:57:47  miked
 * Added new copyright notice.
 *
 * Revision 1.1.1.1  1996/07/08  15:09:44  miked
 * Initial version for Socks5 API.
 */

#ifndef _H_MONMSG
#define _H_MONMSG

#include "monAPI.h"

/*
 *----------------------------------------------------------------------
 *    C O N S T A N T S
 *----------------------------------------------------------------------
 */

/*
 *  Message types.
 */

#define MON_MSG_GET       1     /* Request - Specify key, get Socks5 data rec */
#define MON_MSG_GET_NEXT  2     /* Request - Get next Socks5 data record */
#define MON_MSG_DATA      3     /* Response - Socks5 data record */

#define MON_MSG_FREE_SIZE 2048  /* Max message free space size in bytes */

/*
 *----------------------------------------------------------------------
 *    D A T A   S T R U C T U R E S
 *----------------------------------------------------------------------
 */

/*
 * Note: Fields in messages are unaligned;
 * variable length items have a 2-byte length and data offset;
 * integers are in network byte order.
 * End Of multiple Messages (EOM) is indicated by msg with len = 0.
 */

typedef struct {
    Byte_t             len          [sizeof(Uint16)]; /* Length of data */
    Byte_t             offset       [sizeof(Uint16)]; /* Offset in free[] */
} MonVarLen_t;


typedef struct {
    Byte_t             type;
    Byte_t             key          [S5_MON_KEY_SIZE];
} MonMsgGet_t;

typedef struct {
    Byte_t             type;
    Byte_t             all;
} MonMsgGetNext_t;


typedef struct {
    Byte_t             type;
    Byte_t             key          [S5_MON_KEY_SIZE];
    Byte_t             nextKey      [S5_MON_KEY_SIZE];
    Byte_t             state        [sizeof(Uint32)];

    Byte_t             startTime    [sizeof(S5Time)];
    Byte_t             curTime      [sizeof(S5Time)];
    Byte_t             endTime      [sizeof(S5Time)];

    Byte_t             inTotBytes   [sizeof(Uint32)];
    Byte_t             outTotBytes  [sizeof(Uint32)];

    Byte_t             socksErr     [sizeof(Uint32)];
    Byte_t             socksCmd     [sizeof(Uint16)];
    Byte_t             authen       [sizeof(Uint16)];

    Byte_t             srcSockAddr  [sizeof(MonVarLen_t)];
    Byte_t             proxySockAddr[sizeof(MonVarLen_t)];
    Byte_t             dstSockAddr  [sizeof(MonVarLen_t)];

    Byte_t             srcHostName  [sizeof(MonVarLen_t)];
    Byte_t             dstHostName  [sizeof(MonVarLen_t)];
    Byte_t             proxyHostName[sizeof(MonVarLen_t)];

    Byte_t             userName     [sizeof(MonVarLen_t)];
    Byte_t             appName      [sizeof(MonVarLen_t)];
    Byte_t             socksErrMsg  [sizeof(MonVarLen_t)];

    Byte_t             optData      [sizeof(MonVarLen_t)];
    Byte_t             free[MON_MSG_FREE_SIZE]; /* Free space varlen items */
} MonMsgData_t;

/*
 *----------------------------------------------------------------------
 *    P R O C E D U R E S
 *----------------------------------------------------------------------
 */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Convert connection key to null terminated char string suitable for printing.
 */

EXTERN char *
MonKeyStr _ANSI_ARGS_((
    S5MonKey             key,        /* IN -- Connection key */
    char FAR*            bufPtr      /* IN/OUT -- Pointer to buffer returned */
));


/*
 * Put Socks5 data record into message buffer.
 */

EXTERN int
MonMsgPutData _ANSI_ARGS_((
    CONST S5MonData FAR* dataPtr,    /* IN -- Pointer to Data */
    MonMsgData_t FAR*    msgPtr      /* IN -- Pointer to message buffer */
));

/*
 * Get Socks5 data record from message buffer.
 */

EXTERN int
MonMsgGetData _ANSI_ARGS_((
    S5MonData FAR*     dataPtr,      /* OUT -- Pointer to Data */
    CONST MonMsgData_t FAR* bufPtr   /* IN -- Pointer to message buffer */
));


/*
 * Put/Get a 16/32-bit integer to/from a message buffer.
 */

EXTERN void
MonMsgPutInt16 _ANSI_ARGS_((
    Uint16             uint16,       /* IN -- Value to be packed into buffer */
    VOID FAR*          bufPtr        /* IN -- Current pointer to buffer */
));

EXTERN void
MonMsgGetInt16 _ANSI_ARGS_((
    Uint16 FAR*        uint16Ptr,    /* OUT -- Ptr to unpacked value from buf */
    CONST VOID FAR*    bufPtr        /* IN  -- Current pointer to buffer */
));

EXTERN void
MonMsgPutInt32 _ANSI_ARGS_((
    Uint32             uint32,       /* IN -- Value to be packed into buffer */
    VOID FAR*          bufPtr        /* IN -- Current pointer to buffer */
));

EXTERN void
MonMsgGetInt32 _ANSI_ARGS_((
    Uint32 FAR*        uint32Ptr,    /* OUT -- Ptr to unpacked value from buf */
    CONST VOID FAR*    bufPtr        /* IN  -- Current pointer to buffer */
));


/*
 * Put/Get a variable length item to/from a message buffer.
 */

EXTERN void
MonMsgPutVarLen _ANSI_ARGS_((
    CONST VOID FAR*    dataPtr,      /* IN -- Ptr to data to put into buf */
    Uint16             dataLen,      /* IN -- Length of data */
    VOID FAR*          bufPtr,       /* IN -- Current pointer to buffer */
    CONST VOID FAR*    freePtr,      /* IN -- Pointer to start of free space */
    Uint16 FAR*        offsetPtr     /* IN/OUT -- Current offset in free[] */
));

EXTERN void
MonMsgGetVarLen _ANSI_ARGS_((
    VOID FAR*          dataPtr,      /* OUT -- Ptr to data from buf */
    Uint16 FAR*        dataLenPtr,   /* OUT -- Ptr to length of data */
    CONST VOID FAR*    bufPtr,       /* IN -- Current pointer to buffer */
    CONST VOID FAR*    freePtr       /* IN -- Pointer to start of free space */
));

#ifdef __cplusplus
}
#endif

#endif /* _H_MONMSG */
