//: c09:CompType.java
// Implementing Comparable in a class.
import com.bruceeckel.simpletest.*;
import com.bruceeckel.util.*;
import java.util.*;

public class CompType implements Comparable {
  int i;
  int j;
  public CompType(int n1, int n2) {
    i = n1;
    j = n2;
  }
  public String toString() {
    return "[i = " + i + ", j = " + j + "]";
  }
  public int compareTo(Object rv) {
    int rvi = ((CompType)rv).i;
    return (i < rvi ? -1 : (i == rvi ? 0 : 1));
  }
  private static Random r = new Random();
  private static int randInt() {
    return Math.abs(r.nextInt()) % 100;
  }
  public static Generator generator() {
    return new Generator() {
      public Object next() {
        return new CompType(randInt(),randInt());
      }
    };
  }
  public static void main(String[] args) {
    SimpleTest monitor =
      new SimpleTest("CompType");
    CompType[] a = new CompType[10];
    Arrays2.fill(a, generator());
    Arrays2.print("before sorting, a = ", a);
    Arrays.sort(a);
    Arrays2.print("after sorting, a = ", a);
    monitor.expectRegularExpression (
      new Object[] {
        new RegularExpression("before sorting, a =  \\((\\[i = \\d{1,2}, j = \\d{1,2}\\](, ){0,1}){10}\\)"),
        new RegularExpression("after sorting, a =  \\((\\[i = \\d{1,2}, j = \\d{1,2}\\](, ){0,1}){10}\\)")});
  }
} ///:~