#!/bin/sh
# Copyright 1992 Z-Code Software Corporation.  All rights reserved.

# Make sure sh is running properly
true || exec sh $0
export PATH || eval "echo Switching to /bin/sh ... && exec sh $0"
#if test ! -t 0
if test "$0" = sh -o -z "$0"
 then
    echo 'Please use "sh '`basename $0`'" not "sh <'`basename $0`'".'
    exit 1
fi

if test -z "$ORIGINAL_SCRIPT_NAME"
then
    ORIGINAL_SCRIPT_NAME="$0"
    export ORIGINAL_SCRIPT_NAME
fi

PHONE_NUMBER='+1 415 499 8649'

# Figure out how to do echo without newline
c=`echo "hi there\c" | sed 's/[^c]//g'`
if test -z "$c"
then
    n=''
    c='\c'
else
    n='-n'
    c=''
fi

if test -z "$HOSTNAME"
then
    hostname=`( hostname || uname -n || uuname -l ) 2>/dev/null`
    if test -z "$hostname"
    then
	echo ""
	echo "I can't seem to figure out this machine's hostname ..."
	hostname="unknown"
    fi
    HOSTNAME=$hostname
    export HOSTNAME
fi

# Figure out net address.
# First try "arp", then try grepping the hosts database.
hostaddr=""
if test "$hostname" != "unknown"
then
    hostaddr=`( arp $hostname | sed -e "s/).*//" -e "s/.*(//" ) 2>/dev/null`
    if test -z "$hostaddr"
    then
	hostaddr=`( ( ypcat hosts || cat /etc/hosts ) |
			egrep "^[^#].*[ 	]$hostname([ 	]|"'$)' |
			sed "s/[ 	].*//") 2>/dev/null`
    fi
fi
if test -z "$hostaddr"
then
    echo ""
    echo "I can't seem to figure out this machine's network address ..."
    hostaddr="unknown"
    HOSTADDR=$hostaddr
    export HOSTADDR
fi


# Make sure that we are running as the superuser
case $ROOTPID in
$$)
    ;;
*)
    ROOTPID=$$
    export ROOTPID

    # Check to see that we're all set to go

    cat <<EOM

Your Network License Server activation key, if you have one, is
clearly labeled on your Intallation Instructions sheet.  If you do
not have these license keys, call Z-Code Software at $PHONE_NUMBER to
request them; you can continue with this installation without them,
but you won't be able to register your license and users, which will
mean you won't be able to start the license server daemon yet.

EOM
    def=y
    echo $n "Will this machine act as the license server for Z-Mail? [$def] $c"
    read ans
    ans=`echo $ans.|sed -e 's/^[^yYnN]/'$def/ -e 's/\(.\).*/\1/'|tr YN yn`
    echo ""
    if test "$ans" = "n"
    then
        echo You must run this installation script on the machine that will
        echo act as the local network server for Z-Mail licenses.
	echo ""
	hostname=""	# So we will abort momentarily
    fi
    hostid=`hostid 2>/dev/null || echo 0`
    def=y
    echo $n "Do you have two Z-Mail license activation keys? [$def] $c"
    read ans
    ans=`echo $ans.|sed -e 's/^[^yYnN]/'$def/ -e 's/\(.\).*/\1/'|tr YN yn`
    if test "$ans" = "n"
    then
	cat <<EOM

To get your activation keys, call Z-Code Software at $PHONE_NUMBER
and provide the following information:

    Your Z-Mail serial number (printed on the tape or diskette;
        serial number is not required for demonstration copies)
    The hardware type of your server machine
EOM
	if test -z "$hostname"
	then
	    if test "$hostid" = 0
	    then
		echo "    The host name of your server machine"
	    else
		echo "    The host id of your server machine"
	    fi
	    echo "    The network address of your server machine"
	else
	    if test "$hostid" = 0
	    then
		echo "    Your host name: $hostname"
	    else
		echo "    Your host id:   $hostid"
	    fi
	    if test "$hostaddr" != "unknown"
	    then
		echo "    Your network address: $hostaddr"
	    else
		echo "    Your network address"
	    fi
	fi
	echo "    The network port you want to use (2722 unless you specify otherwise)."
    fi
    if test -z "$hostname"	# they are running on the wrong machine
    then
	echo ""
	echo "Run this script ($0) again on the server machine."
	exit 0
    fi
    if test "$ans" = n		# they don't have activation keys
    then
	echo ""
	echo You may proceed with installation, but you will be unable to
	echo register any users until you have your license activation keys.
	echo ""
	def=n
	echo $n "Proceed with intallation anyway? [$def] $c"
	read ans
	ans=`echo $ans.|sed -e 's/^[^yYnN]/'$def/ -e 's/\(.\).*/\1/'|tr YN yn`
    fi
    if test "$ans" = "n"
    then
	echo Network License Server installation aborted.
	if test "$ORIGINAL_SCRIPT_NAME" != "$0"
	then
	    echo 'To retry, run "'$REAL_SH $0'".'
	fi
	echo ""
	exit 0
    fi

    cat <<EOM

-------------------------

You must be root to run this script.  If you are already root,
the script will proceed.  Otherwise, you will need to enter
your system's root password here.

EOM

    cat <<EOM > /tmp/rm-me$$
This is a test to see if I am already running as root.
EOM
    if (chmod 0 /tmp/rm-me$$ && cat /tmp/rm-me$$) >/dev/null 2>&1
    then
	rm -f /tmp/rm-me$$
	echo "Thank you!  I'm already root."
    else
	rm -f /tmp/rm-me$$
	if test -n "$NLSINSTALL_DONT_SU"
	then
	    echo NOT SUING TO ROOT
	else
	    exec su root -c "exec sh $0" || exit 1
	fi
    fi
    ;;
esac

if test -z "$ZMSHIPDIR"
then
    ZMSHIPDIR=`cd .. ; pwd`
fi
REG_ENV=.register.env
if test -f ./$REG_ENV
then
    . ./$REG_ENV
elif test -f $ZMLIB/$REG_ENV
then
    . $ZMLIB/$REG_ENV
else
    REG_ENV=false
fi

# Now jump through hoops to make sure this all works right.
# If ZM_INSTALL_PID
case $ZM_INSTALL_PID in
$$) ;;
*)
    ZM_INSTALL_PID=$$
    export ZM_INSTALL_PID

    if test "$REG_ENV" = false
    then
	ZMLIB=/usr/lib/Zmail
    fi
    export ZMLIB

    REAL_SH=sh
    export REAL_SH

    echo ""
    echo Performing sanity checks ...

    case `basename $ZMSHIPDIR` in
    zmail.apollo)
	;;
    zmail.atari)
	SGID=mail
	;;
    zmail.hp*)
	SGID=mail
	;;
    zmail.m88k)
	;;
    zmail.mips)
	;;
    zmail.*[34]86*|zmail.inter)
	SGID=mail
	;;
    zmail.pyr*)
	# OSX has no -x in test ...
	if test -f /.attbin/sh
	then
	    REAL_SH=/.attbin/sh
	    echo ""
	    echo Your ucb sh may be very old and braindamaged.
	    echo Executing the att sh just in case ...
	    exec /.attbin/sh $0
	fi
	;;
    zmail.rs6000)
	if test "$REG_ENV" = false
	then
	    ZMLIB=/usr/lpp/Zmail
	    export ZMLIB
	fi
	;;
    zmail.seqptx)
	;;
    zmail.sgi)
	;;
    zmail.sun*)
	;;
    zmail.sony)
	case `strings /bin/sh | grep '^DATE'` in
	*1978*)
	    echo ""
	    echo Your machine does not have a shell that can run this script.
	    echo Please complain to Sony after installing Z-Mail by hand. 
	    echo See instructions in your Z-Mail Installation Guide.
	    echo '(No, there are not instructions for how to complain.)'
	    exit 1
	    ;;
	esac
	;;
    zmail.ultrix)
	if test -f /bin/sh5
	then
	    REAL_SH=/bin/sh5
	    echo ""
	    echo Your /bin/sh may be very old and braindamaged.
	    echo Executing /bin/sh5 just in case ...
	    exec /bin/sh5 $0
	fi
	;;
    *)
	echo ""
	echo I can not determine the architecture and operating system
	echo that are required by this version of Z-Mail.
	echo ""
	echo 'This script "'$0'" should be run in the directory named'
	echo '"zmail.xxx/zcnls" where xxx is your system type,'
	echo 'or set your environment variable ZMSHIPDIR to zmail.xxx'
	echo 'before running this script.'
	echo ""
	exit 0
    esac
    if test "$REG_ENV" = false
    then
	# Try once more to find REG_ENV with new settings
	exec $REAL_SH $0
    fi
    ;;
esac

# Now, finally, initialize defaults and get on with it

if test "$REG_ENV" = false
then
    LICENSE_LIB=$ZMLIB
    LOCAL=/usr/local
    BIN=$LOCAL/bin
fi

cat <<EOM

-------------------------

This is the Z-Code Network License Server installation script.  If you are
installing the Network License Server, you will need to run this script on
each machine that will act as a server for the local network.

EOM

# ZMLIB is set by now; if it wasn't, that would mean
# REG_ENV was not found, and so the line above that sets ZMLIB to /usr/lib/Zmail
# would have been executed.

while :
do
    if test ! -d $ZMLIB
    then
	echo Directory $ZMLIB does not exist.
	echo $n "Where is the Z-Mail library directory? $c"
	read ans
	ans=`echo $ans`
    else
	echo $n "Where is the Z-Mail library? [$ZMLIB] $c"
	read ans
	ans=`echo $ans`
	if test -z "$ans"
	then
	    ans=$ZMLIB
	fi
    fi

    if test -n "$ans" -a -d "$ans"
    then
	break		# this is the only way out of this loop other than exiting
    fi

    if test -z "$ans" -o ! -d "$ans"
    then
	if test -n "$ans"
	then
	    echo Directory $ans does not exist.
	fi

	echo You must install Z-Mail before installing the Network License Server.
	echo ""
	def=y
	echo $n "Has Z-Mail been installed? [$def] $c"
	read ans
	echo ""
	ans=`echo $ans.|sed -e 's/^[^yYnN]/'$def/ -e 's/\(.\).*/\1/'|tr YN yn`

	if test "$ans" = n
	then
	    echo Network License Server installation aborted.
	    if test "$ORIGINAL_SCRIPT_NAME" != "$0"
	    then
		echo 'To retry, run "'$REAL_SH $0'".'
		fi
	    echo ""
	    exit 1
	fi
    fi
done

ZMLIB="$ans"

if test -f $ZMLIB/$REG_ENV
then
    . $ZMLIB/$REG_ENV
    REG_ENV=true
fi

echo ""
echo Checking out your network configuration files ...

if test -f /etc/services
then
    SERVICES=/etc/services
else
    SERVICES=/dev/null
fi

PORTNUM=`grep '^zcnls.*/tcp' $SERVICES 2>/dev/null | tail -1`
if test -z "$PORTNUM"
then
    IN_SERVICES=false
    PORTNUM=""
else
    IN_SERVICES=true
    echo ""
    echo You have a Z-Code Network License Server entry in /etc/services.
    echo $n "I will attempt to use the port number from that entry. $c"
    PORTNUM=`echo "$PORTNUM" | sed 's@[^0-9]*\([0-9]*\)/tcp.*@\1@'`
    echo "($PORTNUM)"
fi

if test -z "$PORTNUM"
then
    def=2722
    cat <<EOM
Please enter the port number you will be using for your network
license service.  Your license activation key will only allow the
server daemon to run at this port.  If you didn't specifically ask
for a different one, the port number will be $def.

EOM

    echo $n "Port number for network server: [$def] $c"
    read ans
    ans=`echo $ans`
    if test -n "$ans"
    then
	PORTNUM=$ans
    else
	PORTNUM=$def
    fi
fi

portnum=$PORTNUM

# Input the locations where everthing should be installed

LICENSE_LIB=$ZMLIB	# default
echo "Enter parent directory for Network License Server subdirectory:"
echo $n "    [$LICENSE_LIB] $c"
read ans
ans=`echo $ans`
if test -n "$ans"
then
    LICENSE_LIB=$ans
fi
LICENSE_DIR=$LICENSE_LIB/license
LICENSE_BIN=$LICENSE_DIR/bin
LICENSE_FILE=$LICENSE_DIR/license.data
echo ""

# Figure out if we can make paths
mkdir -p /tmp/z$$z/z$$z 2>/dev/null
if test -d ./-p
then
    mkdir=mkdir
    rmdir ./-p
elif test -d /tmp/z$$z/z$$z
then
    mkdir='mkdir -p'
else
    mkdir=mkdir
fi
/bin/rm -rf /tmp/z$$z

# Check that the license directories exist
if test ! -d $LICENSE_LIB
then
    echo ""
    echo "Installing $LICENSE_LIB for licensing ..."
    $mkdir $LICENSE_LIB || exit 1
fi
if test ! -d $LICENSE_DIR
then
    $mkdir $LICENSE_DIR || exit 1
fi

license_dir=`basename $LICENSE_DIR`
if test -d $license_dir
then
    echo ""
    echo "Installing $LICENSE_DIR ..."
    ( cd $license_dir ; tar -cf - . ; ) | \
    ( cd $LICENSE_DIR ; tar -xmof - ; )
fi

if test -f README.NLS
then
    echo Copying README.NLS to $LICENSE_DIR
    cp README.NLS $LICENSE_DIR
    echo ""
fi

echo "Checking modes of files in $LICENSE_LIB..."
find $LICENSE_LIB -type d -exec chmod a+rx {} \; || WARNING=true
find $LICENSE_LIB -type f -exec chmod a+r {} \; || WARNING=true
find $LICENSE_BIN -exec chmod a+x {} \; || ERROR=true

if test -f /etc/inetd.conf
then
    INETDCONF=/etc/inetd.conf
elif test -f /usr/etc/inetd.conf
then
    INETDCONF=/usr/etc/inetd.conf
elif test -f /etc/servers
then
    INETDCONF=/etc/servers
else
    INETDCONF=/dev/null
fi

if test -f $INETDCONF -a -s $INETDCONF
then
    echo ""
    echo "Your inetd configuration appears to be: $INETDCONF"
    def=y
    echo $n "Is this correct? [$def] $c"
    read ans
    ans=`echo $ans.|sed -e 's/^[^yYnN]/'$def/ -e 's/\(.\).*/\1/'|tr YN yn`
    if test "$ans" = "n"
    then
	echo Skipping inetd setup.
	INETDCONF=/dev/null
    fi
fi

if grep -s zcnls $INETDCONF 2>&1 >/dev/null
then
    IN_INETDCONF=true
else
    IN_INETDCONF=false
fi

case `basename $ZMSHIPDIR` in
    zmail.apollo)
	;;
    zmail.atari)
	;;
    zmail.*[34]86*)
	;;
    zmail.rs6000)
	cat <<EOM
Configuration of services and the inet superdaemon on RS/6000 machines
should be performed using the configuration tools supplied with your AIX
operating system and the README.NLS installation guide.

EOM
	INETDCONF=/dev/null
	;;
    zmail.seqptx)
	;;
#    zmail.sgi)
#	if test "$IN_SERVICES" = false && test -f /etc/services
#	then
#	    cat >>/etc/services <<EOM
#
#zcnls		$PORTNUM/tcp	zcnlsd zserver  # Z-Code Network License Server
#EOM
#	PORTNUM=""
#	fi
#	cat > /etc/init.d/zcnlserv <<EOM
#case $1 in
#start) $LICENSE_BIN/zcnlsd $LICENSE_FILE $PORTNUM ;;
#stop) /etc/killall -1 zcnlsd ;;
#esac
#EOM
#	ln -s /etc/init.d/zcnlserv /etc/rc2.d/S515zmail
#	START_IT=true
#	;;
   zmail.ultrix|zmail.hp*|zmail.m88k|zmail.mips|zmail.pyr*|zmail.sgi|zmail.sun*)
	if test "$IN_SERVICES" = false
	then
	    echo Adding zcnls to $SERVICES ...
	    cat >> $SERVICES <<EOM

zcnls		$PORTNUM/tcp	zcnlsd zserver  # Z-Code Network License Server
EOM
	else
	    echo Making a backup copy of $SERVICES in /tmp/`basename $SERVICES`$$ ...
	    if cp $SERVICES /tmp/`basename $SERVICES`$$
	    then
		echo Rewriting $SERVICES ...
		cat /tmp/`basename $SERVICES`$$ |
		sed "/^zcnls.*tcp/s@[0-9][^/]*/@$PORTNUM/@" > $SERVICES
	    fi
	fi
	# This will fail on /dev/null (not a plain file)
	if test -f $SERVICES -a -s $SERVICES
	then
	    PORTNUM=""
	fi
	if test "$IN_INETDCONF" = false -a -f $INETDCONF -a -s $INETDCONF
	then
	    echo Adding zcnls to $INETDCONF ...
	    # Some inetd's can't handle blank lines in $INETDCONF
	    cat >> $INETDCONF <<EOM
#
# Z-Code Software's Network License Server for Z-Mail
#
zcnls	stream	tcp	wait	root	$LICENSE_BIN/zcnlsd	zcnlsd $LICENSE_FILE -inet
EOM
	elif test -f $INETDCONF -a -s $INETDCONF
	then
	    echo Making a backup copy of $INETDCONF in /tmp/`basename $INETDCONF`$$ ...
	    if cp $INETDCONF /tmp/`basename $INETDCONF`$$
	    then
		echo Rewriting $INETDCONF ...
		cat /tmp/`basename $INETDCONF`$$ |
		sed > $INETDCONF \
		    -e "/^zcnls/s@nowait@wait@" \
		    -e "/^zcnls/s@/.*/zcnlsd @$LICENSE_BIN/zcnlsd @" \
		    -e "/^zcnls/s@zcnlsd /.*@zcnlsd $LICENSE_FILE -inet@"
	    fi
	else
	    echo No inetd configuration.
	fi
	;;
    zmail.sony)
	;;
    *)
	;;
esac

echo ""

echo Checking process status ...
nn=1
psout=`ps x 2>/dev/null | sed -n 1p`
case $psout in
*PID*) W=lawwx;;
*) W="-lea";;
esac
ps $W > /tmp/ps$$
for i in `sed 1q < /tmp/ps$$`
do
    case $i in
    PID) N=$nn;;
    *) nn=`expr $nn + 1`;;
    esac
done
pid=`grep zcnls /tmp/ps$$ | awk '{ print $'$N' }'`
ipid=`grep inetd /tmp/ps$$ | awk '{ print $'$N' }'`
echo ""
if test -n "$pid"
then
    echo "A Z-Code Network License Server may already be running:"
    echo ""
    sed -n -e 1p -e "/$pid/p" < /tmp/ps$$
    cat <<EOM

You may need to kill $pid before starting your new Network License Server.

EOM
fi
rm /tmp/ps$$

#
# Doesn't make sense to start it now,
# since it is not registered yet (it won't be able to run).
START_IT=false

if test "$START_IT" = true
then
    if test -n "$pid"
    then
	def=y
	echo $n "kill $pid [$def] $c"
	read ans
	ans=`echo $ans.|sed -e 's/^[^yYnN]/'$def/ -e 's/\(.\).*/\1/'|tr YN yn`
	if test $ans = "y"
	then
	    kill $pid
	fi
    fi
    echo Starting Z-Code Network License Server ...
    # Currently no way to simultaneously put it in background
    # and tell whether it successfully started or not.  So we start it
    # in background, and sleep 3 seconds to give it the opportunity to
    # complain.
    echo "$LICENSE_BIN/zcnlsd $LICENSE_FILE $PORTNUM &"
	  $LICENSE_BIN/zcnlsd $LICENSE_FILE $PORTNUM &
    sleep 3
elif test -f $INETDCONF -a -s $INETDCONF
then
    cat <<EOM
When you are finished with this script, send a SIGHUP to your inetd to
start the Network License Server.  Determine the process id (pid) of
your inetd by using the command:

	ps $W

and then send the SIGHUP with:

	kill -HUP pid
EOM
    if test -n "$ipid"
    then
	echo ""
	echo "Your current inetd pid appears to be $ipid."
    fi
else
    cat <<EOM
I am unable to start the Network License Server automatically.  You will
need to modify your system initialization files to start the server.  If
you need assistance, call Z-Code Software at $PHONE_NUMBER.
EOM
fi

echo ""
echo $n "Press return to continue.$c"
read ans

# Explain usage

cat <<EOM

-------------------------

IMPORTANT:
=========

    Each Z-Mail user must set the environment variable ZCNLSERV to the
    host name and port number of the Z-Code Network License Server as
    follows.

    In csh:      setenv ZCNLSERV $HOSTNAME:$portnum
    In sh/ksh:   ZCNLSERV=$HOSTNAME:$portnum ; export ZCNLSERV

    Depending on your network configuration, it may be necessary to
    replace "$HOSTNAME" with a more "qualified" name, of the form
    "$HOSTNAME.subnet.network" (replace "subnet" and "network" with
    your local network names).

Optionally, you may add the appropriate commands to global initialization
scripts such as /etc/profile and /etc/cshrc.  The availability of these
global initialization files varies from system to system.

-------------------------

EOM

if test -d "$ZMSHIPDIR" && test -f $ZMLIB/register.sh
then
    if test "$ZMSHIPDIR" != "$ZMLIB"
    then
	# We may already be in ZMSHIPDIR, but make sure ....
	if cd $ZMSHIPDIR
	then
	    def=n
	    echo "Network License server installation completed."
	    echo $n "Remove `pwd`? [$def] $c"
	    read ans
	    ans=`echo $ans.|sed -e 's/^[^yYnN]/'$def/ -e 's/\(.\).*/\1/'|tr YN yn`
	    if test "$ans" = "y"
	    then
		def=`pwd`
		cd /
		echo "Removing $def ..."
		/bin/rm -rf $def
	    fi
	fi
    fi
fi

#
# Run register -p ZCNLSD repeatedly
# until it succeeds or the user decides to give up.
#
helping_verb=""
adverb="now"
while :
do
    def=y
    echo $n "Do you wish to$helping_verb register your ZCNLSD activation key $adverb? [$def] $c"
    read ans
    ans=`echo $ans.|sed -e 's/^[^yYnN]/'$def/ -e 's/\(.\).*/\1/'|tr YN yn`
    echo ""

    if test "$ans" = n
    then
	if test "$LICENSE_FILE" != /usr/lib/Zmail/license/license.data
	then
	    f_arg="-f $LICENSE_FILE"
	else
	    f_arg=""
	fi
	if test -n "$portnum" -a "$portnum" != 2722
	then
	    n_arg="$HOSTNAME:$portnum"
	else
	    n_arg=""
	fi
	cat <<EOM
When you are ready to register your ZCNLSD activation key, make sure
you have permission to write $LICENSE_DIR/$LICENSE_FILE
and then type:

	$LICENSE_BIN/register -p ZCNLSD $f_arg $n_arg

EOM
        break
    fi

    if $LICENSE_BIN/register -p ZCNLSD -f $LICENSE_FILE
    then
        break
    fi
    helping_verb=" try to"
    adverb="again"
    echo ""
done

#
# Run zmail -register repeatedly
# until it succeeds or the user decides to give up.
#
helping_verb=""
adverb="now"
while :
do
    # Use zmail -register instead of register, since it knows
    # what its version is.
    # We're not sure BIN has been set at this point.
    # If not, don't worry too much about it; just tell the user
    # the zmail command to run and let them find zmail on their own time.
    if test -f "$BIN/zmail"
    then
	def=y
	echo $n "Do you wish to$helping_verb register your Z-Mail activation key $adverb? [$def] $c"
	read ans
	ans=`echo $ans.|sed -e 's/^[^yYnN]/'$def/ -e 's/\(.\).*/\1/'|tr YN yn`
	echo ""
    else
	ans=n
    fi

    if test "$ans" = n
    then
	cat <<EOM
When you are ready to register your Z-Mail activation key and users,
make sure you have permission to write $LICENSE_FILE
and then type:

EOM
	if test "$LICENSE_FILE" != /usr/lib/Zmail/license/license.data
	then
	    echo "    zmail -register -f $LICENSE_FILE"
	else
	    echo "    zmail -register"
	fi
        echo ""
        break
    fi

    if $BIN/zmail -register -f $LICENSE_FILE
    then
        break
    fi
    helping_verb=" try to"
    adverb="again"
    echo ""
done

cat <<EOM

Network License Server installation and registration script finished.

EOM

exit 0
