#!/bin/sh
# Copyright 1992 Z-Code Software Corporation.  All rights reserved.

# Make sure sh is running properly
true || exec sh $0
export PATH || eval "echo Switching to /bin/sh ... && exec sh $0"
if test ! -t 0
then
    echo 'Please use "sh doinstall" not "sh <doinstall".'
    exit 1
fi

if test -z "$ORIGINAL_SCRIPT_NAME"
then
    ORIGINAL_SCRIPT_NAME="$0"
    export ORIGINAL_SCRIPT_NAME
fi

PHONE_NUMBER='+1 415 499 8649'

# Figure out how to do echo without newline
c=`echo "hi there\c" | sed 's/[^c]//g'`
if test -z "$c"
then
    n=''
    c='\c'
else
    n='-n'
    c=''
fi

# Make sure that we are running as the superuser
case $ROOTPID in
$$)
    echo ""
    echo "Stepping quickly into a nearby phone booth, I emerge as SuperUser!"
    echo "I am now acting as root."
    ;;
*)
    ROOTPID=$$
    export ROOTPID

    # Check to see that we're all set to go

    echo ""
    echo "You should have your Z-Mail license activation key ready before"
    echo "proceeding with installation.  Your will enter the license key"
    echo "during registration after installation is complete.  If you do"
    echo "not have a license key, call Z-Code Software at $PHONE_NUMBER"
    echo "to request one."
    echo ""
    def=Yes
    echo $n "Do you have a Z-Mail activation key? [$def] $c"
    read ans
    ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
    if test "$ans" != "y"
    then
	echo ""
	echo To get an activation key, call Z-Code Software at $PHONE_NUMBER
	echo and provide the following information:
	echo ""
	echo "    Your Z-Mail serial number (printed on the tape or diskette;"
	echo "        serial number is not required for demonstration copies)"
	hostid=`(./hostid || hostid) 2>/dev/null || echo 0`
	if test $hostid = 0
	then
	    hostname=`( hostname || uname -n || uuname -l ) 2>/dev/null`
	    echo "    Your host name:  $hostname"
	else
	    echo "    Your host id:    $hostid"
	fi
	echo ""
	echo You may proceed with installation, but you will be unable to
	echo register any users until you have your activation key.
	echo ""
	def=No
	echo $n "Proceed with intallation anyway? [$def] $c"
	read ans
	ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
	if test "$ans" != "y"
	then
	    echo ""
	    echo Installation discontinued.
	    echo ""
	    exit 0
	fi
    fi

    echo ""
    echo "-------------------------"
    echo ""
    echo "I must be root to run this script.  If you are already root,"
    echo "the script will proceed.  Otherwise, you will need to enter"
    echo "your system's root password here."
    echo ""
    cat <<EOM > /tmp/rm-me$$
This is a test to see if I am already running as root.
EOM
    if (chmod 0 /tmp/rm-me$$ && cat /tmp/rm-me$$) >/dev/null 2>&1
    then
	rm -f /tmp/rm-me$$
	echo "Thank you!  I'm already root."
    else
	rm -f /tmp/rm-me$$
	exec su root -c "exec sh $0" || exit 1
    fi
    ;;
esac

# Now jump through hoops to make sure this all works right
case $ZM_INSTALL_PID in
$$) ;;
*)
    ZM_INSTALL_PID=$$
    export ZM_INSTALL_PID

    LOCAL=/usr/local
    ZMLIB=/usr/lib/Zmail
    export LOCAL ZMLIB

    ZMAPPDEF=Zmail
    export ZMAPPDEF

    ZAPPLRESDIR=/usr/lib/X11/app-defaults
    export ZAPPLRESDIR

    REAL_SH=sh
    export REAL_SH

    PATH=/etc:/usr/etc:"$PATH"

    echo ""
    echo Performing sanity checks ...

    ZMSHIPDIR=`pwd`
    export ZMSHIPDIR
    case `basename $ZMSHIPDIR` in
    zmail.apollo)
	SGID=mail
	;;
    zmail.atari)
	SGID=mail
	;;
    zmail.hp*)
	SGID=mail
	;;
    zmail.m88k)
	;;
    zmail.mips)
	;;
    zmail.*[34]86*|zmail.inter)
	SGID=mail
	;;
    zmail.pyr*)
	# OSX has no -x in test ...
	if test -f /.attbin/sh
	then
	    REAL_SH=/.attbin/sh
	    echo ""
	    echo Your ucb sh may be very old and braindamaged.
	    echo Executing the att sh just in case ...
	    exec /.attbin/sh $0
	fi
	;;
    zmail.rs6000)
	LOCAL=/usr/lpp
	ZMLIB=/usr/lpp/Zmail
	;;
    zmail.seqptx)
	;;
    zmail.sco)
	SGID=mmdf
	;;
    zmail.sgi)
	;;
    zmail.sun4ol)
	ZAPPLRESDIR=""
	ZMAPPDEF=Zmail_ol
	;;
    zmail.sun*)
	;;
    zmail.sony)
	case `strings /bin/sh | grep '^DATE'` in
	*1978*)
	    echo ""
	    echo Your machine does not have a shell that can run this script.
	    echo Please complain to Sony after installing Z-Mail by hand. 
	    echo See instructions in your Z-Mail Installation Guide.
	    echo '(No, there are not instructions for how to complain.)'
	    exit 1
	    ;;
	esac
	;;
    zmail.ultrix)
	if test -f /bin/sh5
	then
	    REAL_SH=/bin/sh5
	    echo ""
	    echo Your /bin/sh may be very old and braindamaged.
	    echo Executing /bin/sh5 just in case ...
	    exec /bin/sh5 $0
	fi
	;;
    *)
	echo ""
	echo I can not determine the architecture and operating system
	echo that are required by this version of Z-Mail.
	echo ""
	def=No
	echo $n "Proceed with installation anyway? [$def] $c"
	read ans
	ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
	if test "$ans" != "y"
	then
	    echo Installation discontinued.
	    exit 0
	fi
	echo ""
    esac
    ;;
esac

# Prepending stuff to PATH may have changed which "echo"
# we are using, so we gotta do this again...
# Figure out how to do echo without newline
c=`echo "hi there\c" | sed 's/[^c]//g'`
if test -z "$c"
then
    n=''
    c='\c'
else
    n='-n'
    c=''
fi

# Now, finally, initialize defaults and get on with it

LICENSE_LIB=$ZMLIB
LICENSE_DIR=$LICENSE_LIB/license
LICENSE_FILE=license.data

ZCNLSDIR=zcnls
ZCNLDAEMON=$ZCNLSDIR/license/bin/zcnlsd
ZCNLINST=$ZCNLSDIR/nlsinstall.sh
export ZCNLSDIR

DO_NLSINSTALL=false
if test -d "$ZCNLSDIR" -a -f "$ZCNLDAEMON"
then
    echo ""
    if test ! -f "$ZCNLINST"
    then
	cat <<EOM
Hmmm... you have Z-Code Network License Server software, but not the
Network License Server installation program.  If you want to install
the Network License Server software, first complete this Z-Mail
installation, then follow the manual installation instructions in the
file README.NLS or call Z-Code at $PHONE_NUMBER to get the program.

EOM
	    echo $n "Press return to continue. $c"
	    read ans
	    NETWORK_LICENSE=false
	    license_message="cannot be changed"
    else
	cat <<EOM
Z-Code Network License Server software is available with this
installation.  If you have a Network License Server activation
key, you may install and use the Network License Server.  I will
offer to install the Network License Server for you after this
Z-Mail installation is completed successfully.

Your Network License Server activation key, if you have one, is
clearly labeled on your Quick Installation Guide sheet.  If you do
not have an Quick Installation Guide and you want to use the Network
License Server, call Z-Code at $PHONE_NUMBER for assistance.
You may install the Network License Server even if you do not have a
key, but you will need a key before using the software.

EOM
	echo $n "Press return to continue. $c"
	read ans
    fi
    tmp=`echo $LICENSE_DIR | sed 's:\([^/]\)//*:\1/:g'`
    tmp=`echo $tmp | sed 's:\(.*/\).*/license:\1:'`
    if mkdir ${tmp}rm.me$$ 2>/dev/null
    then
	rmdir ${tmp}rm.me$$ 2>/dev/null
    else
	cat <<EOM

If you will not be using the Network License Server, Z-Mail must have
access to the directory $LICENSE_DIR to validate
user licenses.  I do not seem to have permission from the operating
system to create $LICENSE_DIR/$LICENSE_FILE.  

If you are concerned that this may be a problem, discontinue this
installation now.

EOM
	def=Yes
	echo $n "Do you want to continue installation? [$def] $c"
	read ans
	ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
	if test "$ans" != "y"
	then
	    echo ""
	    echo "Installation discontinued."
	    exit
	fi
    fi
    if test -f "$ZCNLINST"
    then
	cat <<EOM

Should I install the Network License Server later?  If yes, you may
locate $LICENSE_FILE wherever you desire.  If no, $LICENSE_FILE must
reside in $LICENSE_DIR.

If you are installing a demonstration copy of Z-Mail, you should
answer "No" to this question.

If you have installed (or will be installing) the Network License
Server on another machine, for use with this copy of Z-Mail, you
should answer "Yes" to this question.  However, if you answer "Yes",
then you must install the Network License Server before registering
activation keys and users.

EOM
	def=Yes
	echo $n "Install the Network License Server later? [$def] $c"
	read ans
	ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
	if test "$ans" != "y"
	then
	    NETWORK_LICENSE=false
	    license_message="cannot be changed"
	else
	    DO_NLSINSTALL=true
	    NETWORK_LICENSE=true
	    license_message="configure via network server"
	fi
    fi
else
    NETWORK_LICENSE=false
    license_message="cannot be changed"
fi

# Figure out where X resources go ...
if test -n "$OPENWINHOME"
then
    ZAPPLRESDIR=$OPENWINHOME/lib/app-defaults
    if test -d /usr/lib/X11
    then
	cat <<EOM

-------------------------

You appear to have both X11 and OpenWindows installed on your machine.
EOM
	case $ZMSHIPDIR in
	*ol) cat <<EOM
This is an OpenLook version of Z-Mail, so I will install Z-Mail
resources in $ZAPPLRESDIR unless you choose otherwise by
specifying a different location.  Do this by answering "No" when asked
if you wish to install in the default locations and specifying the new
location when prompted for the location of X resources.

EOM
	    ;;
	*) cat <<EOM
Z-Mail will look for X resources in /usr/lib/X11/app-defaults by
default.  If you plan to install Zmail resources in the OpenWindows
tree, all users will need to set XAPPLRESDIR to point to:

	$ZAPPLRESDIR

and you will also need to specify this directory for installation of X
resources.  Do this by answering "No" when asked if you wish to install
in the default locations and then specifying the above directory when
prompted for the location of X resources.

EOM
	    ZAPPLRESDIR=/usr/lib/X11/app-defaults
	    ;;
	esac
	echo $n "Press return to continue. $c"
	read ans
    fi
    XAPPLRESDIR=$ZAPPLRESDIR
fi
if test -z "$XAPPLRESDIR"
then
    XAPPLRESDIR=/usr/lib/X11/app-defaults
fi
if test -z "$ZAPPLRESDIR"
then
    ZAPPLRESDIR=$XAPPLRESDIR
fi

BIN=$LOCAL/bin

RM_IT=true

cat <<EOM

-------------------------

This script automatically installs the Z-Mail library and executables.
If you wish to customize locations for the installation on this machine,
you may do so at this time.  Otherwise, Z-Mail will be installed in the
following default directories:

    Library:      $ZMLIB
    Licensing:    $LICENSE_DIR    [$license_message]
    X Resources:  $XAPPLRESDIR
    Executables:  $BIN

EOM

# Input the locations where everthing should be installed

def=Yes
echo $n "Do you wish to install Z-Mail in the above locations? [$def] $c"
read ans
ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
if test "$ans" != "y"
then
    if test "$NETWORK_LICENSE" = false
    then
	cat << EOM

-------------------------

Z-Mail requires access to the directory $LICENSE_DIR
to validate user licenses.  You may not change this location.
Installation of Z-Mail will create this directory if it does
not exist.  If you do not wish to create this directory at
this time, discontinue installation now.

EOM
	def=Yes
	echo $n "Do you wish to continue installation? [$def] $c"
	read ans
	ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
	if test "$ans" != "y"
	then
	    echo "Installation discontinued."
	    exit
	fi
    fi
    cat << EOM

-------------------------

Z-Mail expects to find initialization data and online help
in $ZMLIB.  If you change the location of $ZMLIB,
Z-Mail users will need to set the environment variable ZMLIB
to the new name.

Enter directory for Z-Mail library:
EOM
    def=$ZMLIB
    echo $n "[$def] $c"
    read ans
    if test ! -z "$ans"
    then
	if test "$ZMLIB" = "$ZMSHIPDIR"
	then
	    cat <<EOM

Sorry, I can't install Z-Mail in $ZMSHIPDIR.
If you wish to install Z-Mail in $ZMSHIPDIR,
please begin by reading your Z-Mail tape or diskette into a different
directory, and then re-execute this installation script from there.

Installation aborted.
EOM
	    exit 1
	else
	    ZMLIB=$ans
	fi
    fi

    cat << EOM

-------------------------

The Z-Mail executables may be installed in any directory that
normally appears in the PATH environment variable.

Enter directory for Z-Mail executables:
EOM
    def=$BIN
    echo $n "[$def] $c"
    read ans
    if test ! -z "$ans"
    then
	BIN=$ans
	LOCAL=`expr $BIN : '\(.*\)/.*'`
    fi

    cat << EOM

-------------------------

Z-Mail expects to find application default X resources in
$ZAPPLRESDIR.  If you change the location of
$ZAPPLRESDIR, Z-Mail users will need to set the
environment variable XAPPLRESDIR to the new name.

Enter directory for X application defaults:
EOM
    def=$XAPPLRESDIR
    echo $n "[$def] $c"
    read ans
    if test ! -z "$ans"
    then
	XAPPLRESDIR=$ans
    fi

    cat << EOM

-------------------------

You have specified the following locations:

    Library:      $ZMLIB
    X Resources:  $XAPPLRESDIR
    Executables:  $BIN

These directories will be created if they do not already exist.

EOM
    def=Yes
    echo $n "Do you wish to continue installation? [$def] $c"
    read ans
    ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
    if test "$ans" != "y"
    then
	echo "Installation discontinued."
	exit
    fi
fi

case $PATH in
$BIN:*) ;;
*:$BIN) ;;
*:$BIN:*) ;;
*) cat <<EOM

WARNING: $BIN
         does not appear in your PATH environment variable.
         This may cause problems with future user registrations.

EOM
    echo $n "Press return to continue. $c"
    read ans
    ;;
esac

# Now make sure the existing file system is in a safe state
# This definition intentionally begins with a newline!
backitup="
    $ZMLIB/license/license.data
    $ZMLIB/attach.types
    $ZMLIB/system.zmailrc
    $XAPPLRESDIR/$ZMAPPDEF"

if test -d "$ZMLIB"
then
    WARNING=true
    cat << EOM

-------------------------

$ZMLIB already exists from a previous installation.
In order to continue installation, the existing $ZMLIB
must be removed, or you can restart the installation
and change the installation locations.

EOM
    if test "$ZMLIB" = "$LICENSE_LIB"
    then
	cat <<EOM
Installing a new copy of Z-Mail will replace the current registration
information and may interfere with Z-Mail sessions currently in
progress.

EOM
    fi
    cat << EOM
Proceed with caution.  For your convenience, backup copies of the
following files will be made if they exist and you choose to continue:
$backitup

Note that no matter what you say now, $ZMLIB will
not be removed until I say "I am now ready to install your new Z-Mail".

EOM
    def=Yes
    echo $n "Will it be OK to remove $ZMLIB? [$def] $c"
    read ans
    ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
    if test "$ans" != "y"
    then
	def=No
	echo $n "Do you wish to install other files anyway? [$def] $c"
	read ans
	ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
	if test "$ans" != "y"
	then
	    echo Installation discontinued.
	    exit
	fi
	RM_IT=false
    fi
else
    WARNING=false
fi

echo ""
echo "-------------------------"
echo ""

# Check for the ownership and permissions we should attach to everything

cat <<EOM
Some platforms or sites have special accounts for installed software.
These accounts have names like "bin" or "daemon".  You may wish to
have one of these special accounts own the Z-Mail library, or you may
wish to assign ownership to an adminstrative person's account.

Most sites use the "root" account for ownership of these libraries.

EOM

getpasswd='((ypcat passwd) 2>/dev/null || cat /etc/passwd)'
getgroup='((ypcat group) 2>/dev/null || cat /etc/group)'

def=root
while :
do
    echo $n "Which account should own the files in $ZMLIB? [$def] $c"
    read ans
    ans=`echo $ans`
    if test -z "$ans"
    then
	LIBOWNER=root
    elif ( eval $getpasswd | grep -s "^${ans}:" ) >/dev/null 2>&1
    then
	LIBOWNER=$ans
    else
	echo "$ans is not a known account.  Please try another."
	continue
    fi
    break
done

gid=`eval $getpasswd | grep "^${LIBOWNER}:" | sed 's/[^:]*:[^:]*:[^:]*:\([^:]*\):.*/\1/' | sed 1q`
group=`eval $getgroup | sed -n "/[^:][^:]*:[^:][^:]*:${gid}:.*/p" | sed 's/:.*//' | sed 1q`

if test -n "$group"
then
    def=`echo "$group" | sed 1q`
else
    def=`eval $getgroup | sed 1q | sed 's/:.*//'`
fi

cat <<EOM

The account "$LIBOWNER" appears to be a member of the group "$def".
You may wish to assign the Z-Mail library to a different group if
access is to be restricted to a particular group of users.

EOM

while :
do
    echo $n "To what group should $ZMLIB belong? [$def] $c"
    read ans
    ans=`echo $ans`
    if test -z "$ans"
    then
	LIBGROUP=$def
    elif (eval $getgroup | grep -s "^${ans}:") >/dev/null 2>&1
    then
	LIBGROUP=$ans
    else
	echo "$ans is not a known group.  Please try another."
	continue
    fi
    break
done

echo ""

if (eval $getpasswd | grep -s '^bin:') >/dev/null 2>&1
then
    def=bin
else
    def=$LIBOWNER
fi
while :
do
    echo $n "Which account should own the Z-Mail executables? [$def] $c"
    read ans
    ans=`echo $ans`
    if test -z "$ans"
    then
	ZMOWNER=$def
    elif (eval $getpasswd | grep -s "^${ans}:") >/dev/null 2>&1
    then
	ZMOWNER=$ans
    else
	echo "$ans is not a known user.  Please try another."
	continue
    fi
break
done

group=""	# Tested below

if test -n "$SGID"
then
    def=$SGID
    SGID=true
else

    # Figure out how to get the group name from ls
    ls='ls -ld'
    if test `eval $ls . | awk '{ print NF }'` -eq 8
    then
	ls='ls -ldg'
    fi

    mail='/var/mail /usr/mail /var/spool/mail /usr/spool/mail'
    perm=`eval $ls $mail 2>/dev/null | sed -n '/^d/p' | sed 1q`
    if test -n "$perm"
    then
	mail=`echo "$perm" | awk '{ print $9 }'`
	group=`echo "$perm" | awk '{ print $4 }'`
	perm=`echo "$perm" | awk '{ print $1 }'`
    else
	perm=`eval $ls $mail 2>/dev/null | sed 1q`
	if test -n "$perm"
	then
	    mail=`echo "$perm" | awk '{ print $9 }'`
	    group=`echo "$perm" | awk '{ print $4 }'`
	    perm=`echo "$perm" | awk '{ print $1 }'`
	fi
    fi
    case $perm in
    l*)
	ls="${ls}L"
	perm=`eval $ls $mail 2>/dev/null | sed -n '/^d/p' | sed 1q`
	if test -n "$perm"
	then
	    mail=`echo "$perm" | awk '{ print $9 }'`
	    group=`echo "$perm" | awk '{ print $4 }'`
	    perm=`echo "$perm" | awk '{ print $1 }'`
	fi
	;;
    esac
    cat <<EOM

-------------------------

EOM
    case $perm in
    d???????w?) cat <<EOM
Your $mail is writable by any user.

This probably means that your mail delivery agent uses lock files
in this system delivery area to synchronize file access with mail
user agents like Z-Mail.
EOM
	case $perm in
	*t) cat <<EOM

This is fine.
EOM
	    ;;
	*) cat <<EOM

However, permissions allow other users to remove mail files from
this directory.  This is a security problem.  See your operating
system documentation for an appropriate remedy; one possible
solution may be the command:

	chmod 3777 $mail
EOM
	    ;;
	esac
	SGID=false
	;;
    d????w????) cat <<EOM
Your $mail is group-writable by the group "$group".

This probably means that your mail delivery agent uses lock files
in this system delivery area to synchronize file access with mail
user agents like Z-Mail.

This is fine.
EOM
	SGID=""
	;;
    d?????????) cat <<EOM
Your $mail is writable only by its owner.

This may be a problem if you are using NFS for mail delivery.
Z-Mail will not be able to create lock files in $mail
for secure mailbox access.  Even if you are not using NFS, there
may be problems if mailbox files in $mail are removed.

You should NOT use NFS for mail delivery if you are concerned about
loss of mail.  One possible solution is to make $mail
group-writable and arrange for your mail delivery agent to create
lock files during mail delivery.  Check the documentation for your
mail delivery agent to determine whether this is possible.

EOM

	echo $n "Press return to continue. $c"
	read ans
	SGID=false
	;;
    *) cat <<EOM
I cannot locate your mail delivery directory.  Z-Mail users may
need to set the environment variable MAIL to the name of the file
where their mail is delivered by the local delivery agent.

You can also set the environment variable MAIL in the Z-Mail system
configuration file $ZMLIB/system.zmailrc.
EOM
	echo $n "Press return to continue. $c"
	read ans
	SGID=""
	;;
    esac
fi

if test -z "$SGID"
then
    cat <<EOM

If your mail delivery agent uses lock files to synchronize mail
delivery you will need to give Z-Mail permission to write lock files
into $mail.

This is normally done by putting the Z-Mail executables in group
"mail" (or whatever group owns $mail) and setting the
modes of the executables for "set-group-id-upon-execution".

If you plan to use NFS-mounted spool directories, the use of lock
files is recommended.  Check the documentation for your delivery
agent to see if it can be configured to use file locking.

EOM
    def=Yes
    echo $n "Should Z-Mail be installed set-group-id? [$def] $c"
    read ans
    ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
    if test "$ans" != "n"
    then
	SGID=true
	if test -z "$group"
	then
	    group=`eval $getgroup | grep mail`
	fi
    else
	SGID=false
	gid=`eval $getpasswd | grep "^$ZMOWNER:" | \
		sed 's/[^:]*:[^:]*:[^:]*:\([^:]*\):.*/\1/'`
	group=`eval $getgroup | sed -n "/[^:][^:]*:[^:][^:]*:$gid:.*/p" | \
		sed 's/:.*//'`
    fi
    if test -z "$group"
    then
	group=`eval $ls $mail 2>/dev/null | sed 1q | awk '{ print $4 }'`
	if test -z "$group"
	then
	    def=$LIBGROUP
	else
	    def=$group
	fi
    else
	def=mail
    fi
else
    cat <<EOM

It does not appear that you need to install Z-Mail with any special
permissions.  However, if your mail delivery agent uses lock files to
synchronize mail delivery, you may need to modify the Z-Mail system
configuration file $ZMLIB/system.zmailrc to include the line:

	set dot_lock

-------------------------

EOM
fi

while :
do
    echo $n "To what group should the executables belong? [$def] $c"
    read ans
    ans=`echo $ans`
    if test -z "$ans"
    then
	ZMGROUP=$def
    elif (eval $getgroup | grep -s "^${ans}:") >/dev/null 2>&1
    then
	ZMGROUP=$ans
    else
	echo "$ans is not a known group.  Please try another."
	continue
    fi
    break
done

if $RM_IT
then
    if $WARNING
    then
	cat <<EOM

-------------------------

I am now ready to install your new Z-Mail.  If you do not wish to
remove the existing copy, you should discontinue installation now.

Nothing has been permanently changed up to this point.  However,
if you continue, the existing installation will be removed and
the new copy installed.  These files will be backed up if they
exist: $backitup

EOM
    else
	cat <<EOM

-------------------------

I am now ready to install your new Z-Mail.

Nothing has been permanently changed up to this point.  However,
if you continue, Z-mail will be copied into the locations you have
specified.  These files will be backed up if they exist: $backitup

EOM
    fi
    def=Yes
    echo $n "Proceed with Z-Mail installation? [$def] $c"
    read ans
    ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
    if test "$ans" != "y"
    then
	echo Installation discontinued.
	exit
    fi
    if mkdir /tmp/zmbackup.$$
    then
	for f in $backitup
	do
	    if test -f "$f"
	    then
		echo ""
		echo "Backing up $f in /tmp/zmbackup.$$ ..."
		/bin/cp $f /tmp/zmbackup.$$
	    fi
	done
    else
	echo "Unable to create directory for backups!"
	def=No
	echo $n "Proceed with Z-Mail installation? [$def] $c"
	read ans
	ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
	if test "$ans" != "y"
	then
	    echo Installation discontinued.
	    exit
	fi
    fi
    if $WARNING
    then
	echo ""
	echo Removing $ZMLIB ...
    fi
    /bin/rm -rf $ZMLIB
else
    cat << EOM

Your Z-Mail library may not match the other files that are
about to be installed.  You should install $ZMLIB
at the earliest possible opportunity.
EOM
fi

if $RM_IT && test -d "$ZMLIB"
then
    cat << EOM

-------------------------

$ZMLIB still exists.  Proceeding with installation will
overwrite all contents of this directory.

EOM
    def=No
    echo $n "Are you sure you wish to continue? [$def] $c"
    read ans
    ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
    if test "$ans" != "y"
    then
	echo "Installation discontinued."
	exit
    fi
fi

# Everything OK, so here we go ....

# Figure out if we can make paths
mkdir -p /tmp/z$$z/z$$z 2>/dev/null
if test -d ./-p
then
    mkdir=mkdir
    rmdir ./-p
elif test -d /tmp/z$$z/z$$z
then
    mkdir='mkdir -p'
else
    mkdir=mkdir
fi
/bin/rm -rf /tmp/z$$z

cat <<EOM

-------------------------

Checking existence of various system directories ...
EOM

ERROR=false
WARNING=false

# Check that XAPPLRESDIR isn't relative to a directory that
# we're expected to create later; if not, make sure it exists.
case $XAPPLRESDIR in
$ZMLIB*) ;;
$LICENSE_LIB*) ;;
*)
    if test ! -d "$XAPPLRESDIR"
    then
	# Note!  Explicitly NOT $mkdir here!
	mkdir $XAPPLRESDIR || XAPPLRESDIR=""
    fi
    ;;
esac

if test ! -d "$LOCAL"
then
    $mkdir $LOCAL || exit 1
fi
if test ! -d "$BIN"
then
    $mkdir $BIN || exit 1
fi

if $RM_IT
then
    echo ""
    echo Installing $ZMLIB ...
    if test ! -d "$ZMLIB"
    then
	$mkdir $ZMLIB || exit 1
    fi
    ( cd lib && tar -cf - . ; ) | ( cd $ZMLIB && tar -xf - ; )
    # cp register.sh $ZMLIB || ERROR=true
    # cp doinstall $ZMLIB || WARNING=true
    test -d "$ZMLIB" || ERROR=true
    if test -f COPYRIGHTS
    then
	cp COPYRIGHTS $ZMLIB || WARNING=true
	chmod a=r $ZMLIB/COPYRIGHTS || WARNING=true
    fi
    if test -f RELNOTES
    then
	cp RELNOTES $ZMLIB || WARNING=true
	chmod a=r $ZMLIB/RELNOTES || WARNING=true
    fi
    if test -f hostid
    then
	cp hostid $ZMLIB || WARNING=true
	chmod a+x $ZMLIB/hostid || WARNING=true
    fi
    if $SGID
    then
	cat <<EOM >>$ZMLIB/system.zmailrc

# Set use of file locking for SGID $ZMGROUP
set dot_lock
EOM
    fi
fi

# Check that the license directories exists
if test "$NETWORK_LICENSE" = false
then
    if test ! -d "$LICENSE_LIB"
    then
	echo ""
	echo "Installing $LICENSE_LIB for licensing ..."
	$mkdir $LICENSE_LIB || L_ERROR=true
	if test ! -d "$LICENSE_DIR"
	then
	    if test "$L_ERROR" != true
	    then
		$mkdir $LICENSE_DIR || L_ERROR=true
	    fi
	fi
	if test "$L_ERROR" != true
	then
	    license_dir=lib/`basename $LICENSE_DIR`
	    if test -d "$license_dir"
	    then
		( cd $license_dir ; tar -cf - . ; ) | \
		( cd $LICENSE_DIR ; tar -xf - ; )
	    fi
	    cat <<EOM > $LICENSE_DIR/README
This directory must exist if Z-Mail is to be registered and run as a
self-licensed program, that is, without using the Z-Code Network License
Server.  If you are using the Network License Server on this or another
machine and you do not wish to use $LICENSE_DIR for licensing,
you may remove $LICENSE_DIR.

If $LICENSE_LIB is empty except for this subdirectory,
you may remove $LICENSE_LIB as well.
EOM
	    if test "$ZMLIB" != "$LICENSE_LIB"
	    then
		find $LICENSE_LIB -exec chown $LIBOWNER {} \; || WARNING=true
		find $LICENSE_LIB -exec chgrp $LIBGROUP {} \; || WARNING=true
		find $LICENSE_LIB -type d -exec chmod a+rx {} \; || WARNING=true
		find $LICENSE_LIB -type f -exec chmod a+r {} \; || WARNING=true
	    fi
	fi
    else
	if test ! -d "$LICENSE_DIR"
	then
	    mkdir $LICENSE_DIR || WARNING=true
	fi
    fi
fi

if test "$ERROR" != true
then
    echo Resetting owner, group, and mode in $ZMLIB ...

    find $ZMLIB -exec chown $LIBOWNER {} \; || WARNING=true
    find $ZMLIB -exec chgrp $LIBGROUP {} \; || WARNING=true
    find $ZMLIB -type d -exec chmod a+rx {} \; || ERROR=true
    find $ZMLIB -type f -exec chmod a+r {} \; || ERROR=true
    find $ZMLIB/bin -type f -exec chmod a+x {} \; || ERROR=true
fi
echo ""

# Check XAPPLRESDIR again in case we didn't create it before ...
if test -n "$XAPPLRESDIR"
then
    if test ! -d "$XAPPLRESDIR"
    then
	# Note!  Explicitly NOT $mkdir here!
	mkdir $XAPPLRESDIR || XAPPLRESDIR=""
    fi
fi
if test -n "$XAPPLRESDIR"
then
    echo Installing X Resources in $XAPPLRESDIR...

    if cp lib/$ZMAPPDEF $XAPPLRESDIR/$ZMAPPDEF
    then
	chown $LIBOWNER $XAPPLRESDIR/$ZMAPPDEF || WARNING=true
	chgrp $LIBGROUP $XAPPLRESDIR/$ZMAPPDEF || WARNING=true
	chmod 644 $XAPPLRESDIR/$ZMAPPDEF || WARNING=true
    else
	WARNING=true
    fi
else
    echo "I can't seem to find a place to install X resources."
    echo "Check that X11 is properly installed on your system."
    WARNING=true
fi

echo ""
echo Installing executables in $BIN...
mv $BIN/zmail $BIN/.zmail 2>/dev/null
if cp zmail $BIN
then
    /bin/rm -f $BIN/.zmail
    chown $ZMOWNER $BIN/zmail || WARNING=true
    chgrp $ZMGROUP $BIN/zmail || WARNING=true
    chmod a+x $BIN/zmail || WARNING=true
    if $SGID
    then
	chmod g+s $BIN/zmail || WARNING=true
    fi
else
    mv $BIN/.zmail $BIN/zmail 2>/dev/null
    ERROR=true
fi
if test -f zmail.small
then
    mv $BIN/zmail.small $BIN/.zmail.small 2>/dev/null
    if cp zmail.small $BIN
    then
	/bin/rm -f $BIN/.zmail.small
	chown $ZMOWNER $BIN/zmail.small || WARNING=true
	chgrp $ZMGROUP $BIN/zmail.small || WARNING=true
	chmod a+x $BIN/zmail.small || WARNING=true
	if $SGID
	then
	    chmod g+s $BIN/zmail.small || WARNING=true
	fi
    else
	if test -f $BIN/.zmail.small
	then
	    echo "Existing zmail.small left in $BIN/.zmail.small"
	fi
	WARNING=true
    fi
fi
if test -f lib/bin/metamail && test -f lib/mailcap && test ! -f /etc/mailcap
then
    cat <<EOM

-------------------------

This version of Z-Mail supplies the "metamail" program for processing
messages formatted with the Multipurpose Internet Mail Extensions (MIME)
conventions.  In order for metamail to function properly, a configuration
file named "mailcap" needs to be installed in /etc on your system.  This
file is also included in your Z-Mail distribution.

You should be aware that the functioning of metamail is highly dependent
on the local environment.  After installing the mailcap file, you should
examine it and make changes accordingly.  Manual pages describing the
metamail package are supplied in $ZMLIB/man.

EOM
    echo $n "Would you like to install the /etc/mailcap file? $c"
    read ans
    ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
    if test "$ans" = "y"
    then
	cp lib/mailcap /etc/mailcap || WARNING=true
    fi
    echo "-------------------------"
    echo ""
fi

if test "$L_ERROR" = true
then
    ERROR=true
fi

if test "$ERROR" = true
then
    echo ""
    echo An error occurred during installation.  If you need assistance,
    echo call Z-Code at $PHONE_NUMBER between the hours of 9am and 5pm PST.
    echo ""
    exit 1
fi

echo ""

if test "$WARNING" = true
then
    cat <<EOM
A non-fatal error occured during installation.  You may proceed
with Z-Mail registration, but you may see warning messages when
using the Z-Mail program.  None of these warnings should have
any significant effect on the operation of Z-Mail.
EOM
else
    cat <<EOM
No errors were detected during installation into these locations:

    Library:      $ZMLIB
EOM
    if test "$NETWORK_LICENSE" = false
    then
	cat <<EOM
    Licensing:    $LICENSE_DIR
EOM
    fi
    cat <<EOM
    X Resources:  $XAPPLRESDIR
    Executables:  $BIN
EOM
fi

# Dump our environment, appropriately munged, so register.sh can grab it.
# This is a hack, because if register.sh is not running in $ZMLIB, it will
# not be able to find this file anyway.

cat <<EOM > $ZMLIB/.register.env
BIN=$BIN
LICENSE_LIB=$LICENSE_LIB
LICENSE_DIR=$LICENSE_DIR
LOCAL=$LOCAL
PATH=${PATH}:$BIN
ZMLIB=$ZMLIB
ZMSHIPDIR=$ZMSHIPDIR
ZMPASSWD=$ZMPASSWD
EOM

if test -f "$ZCNLINST" && test "$DO_NLSINSTALL" = true
then
    echo ""
    echo "-------------------------"
    echo ""
    echo "You may optionally install the Z-Code Network License Server."
    echo ""
    def=Yes
    echo $n "Install the network server now, on this machine? [$def] $c"
    read ans
    ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
    if test "$ans" = "y"
    then
	cd $ZCNLSDIR
	exec $REAL_SH `basename $ZCNLINST`
    fi
elif test "$NETWORK_LICENSE" = true
then
    echo ""
    echo Please call Z-Code Software at $PHONE_NUMBER for instructions on
    echo installation of your Z-Code Network License Server software.
    echo ""
fi

if test "$NETWORK_LICENSE" = true
then
    cat <<EOM

You must install the network license server in order to register your
activation keys and users.  If the license server is to be installed
on another machine, register your keys and users there.
EOM
fi

if test -d "$ZMSHIPDIR"
then
    if test "$ZMSHIPDIR" != "$ZMLIB"
    then
	cat <<EOM

Z-Mail installation completed.  You may register your Z-Mail program
and users now, or later at your convenience with "zmail -register".

You can remove the installation directory:
	$ZMSHIPDIR
if you will not be using it for further installations of Z-Mail
or of the Network License Server.
EOM
    fi
fi

if test "$NETWORK_LICENSE" = true
then
    exit 0
fi

#
# Run zmail -register repeatedly
# until it succeeds or the user decides to give up.
#
helping_verb=""
adverb="now"
while :
do
    if test -f "$BIN/zmail"
    then
	def=y
	echo $n "Do you wish to$helping_verb register your Z-Mail activation key $adverb? [$def] $c"
	read ans
	ans=`echo $ans.|sed -e 's/^[^yYnN]/'$def/ -e 's/\(.\).*/\1/'|tr YN yn`
	echo ""
    else
	ans=n
    fi

    if test "$ans" = n
    then
	cat <<EOM
When you are ready to register your Z-Mail activation key and users,
make sure you have permission to write $LICENSE_DIR/$LICENSE_FILE
and then type:

EOM
	if test "$LICENSE_DIR/$LICENSE_FILE" != /usr/lib/Zmail/license/license.data
	then
	    echo "    zmail -register -f $LICENSE_DIR/$LICENSE_FILE"
	else
	    echo "    zmail -register"
	fi
        echo ""
        break
    fi

    if $BIN/zmail -register -f $LICENSE_DIR/$LICENSE_FILE
    then
        break
    fi
    helping_verb=" try to"
    adverb="again"
    echo ""
done

cat <<EOM

Z-Mail installation and registration script finished.

EOM

exit 0
