#!/bin/sh

# Make sure sh is running properly
true || exec sh $0
export PATH || eval "echo Switching to /bin/sh ... && exec sh $0"
if test ! -t 0
then
    echo 'Please use "sh register.sh" not "sh <register.sh".'
    exit 1
fi

# Figure out how to do echo without newline
c=`echo "hi there\c" | sed 's/[^c]//g'`
if test -z "$c"
then
    n=''
    c='\c'
else
    n='-n'
    c=''
fi

# Initialize variables

ZFSHIPDIR=`pwd`
REG_ENV=.register.env
if [ -f ./$REG_ENV ]
then
    . ./$REG_ENV
elif [ -f $ZFAXLIB/$REG_ENV ]
then
    . $ZFAXLIB/$REG_ENV
    cd $ZFAXLIB
else
    REG_ENV=false
fi

zfaxlib=${ZFAXLIB-/usr/lib/Zfax}
licensedir=${LICENSE_DIR-/usr/lib/Zmail/license}
datafile=$licensedir/license.data
textfile=$licensedir/license.text
if [ -f $BIN/zfax ]
then
    startup="$BIN/zfax -register -p Z-Fax -v 0.9"
else
    startup="$BIN/zfaxd -register -p Z-Fax -v 0.9"
fi

# Now jump through hoops to make sure this all works right
case $ZM_INSTALL_PID in
$$) ;;
*)
    ZM_INSTALL_PID=$$
    export ZM_INSTALL_PID

    if test "$REG_ENV" = false
    then
	ZFAXLIB=/usr/lib/Zfax
    fi
    export ZFAXLIB

    REAL_SH=sh
    export REAL_SH

    echo ""
    echo Performing sanity checks ...

    case `basename $ZFSHIPDIR` in
    zfax.atari)
	;;
    zfax.hp700)
	;;
    zfax.m88k)
	;;
    zfax.mips)
	;;
    zfax.pyr*)
	if [ -x /.attbin/sh ]
	then
	    REAL_SH=/.attbin/sh
	    echo ""
	    echo Your ucb sh may be very old and braindamaged.
	    echo Executing the att sh just in case ...
	    exec /.attbin/sh $0
	fi
	;;
    zfax.rs6000)
	if test "$REG_ENV" = false
	then
	    ZFAXLIB=/usr/lpp/Zfax
	    export ZFAXLIB
	    LICENSE_DIR=$ZFAXLIB/license
	fi
	;;
    zfax.seqptx)
	;;
    zfax.sgi)
	;;
    zfax.sun*)
	;;
    zfax.sony)
	case `strings /bin/sh | grep '^DATE'` in
	*1978*)
	    echo ""
	    echo Your machine does not have a shell that can run this script.
	    echo Please complain to Sony after registering Z-Fax by hand. 
	    echo See instructions in your Z-Fax Installation Guide.
	    echo '(No, there are not instructions for how to complain.)'
	    exit 1
	    ;;
	esac
	;;
    zfax.ultrix)
	if [ -x /bin/sh5 ]
	then
	    REAL_SH=/bin/sh5
	    echo ""
	    echo Your /bin/sh may be very old and braindamaged.
	    echo Executing /bin/sh5 just in case ...
	    exec /bin/sh5 $0
	fi
	;;
    *)
	echo ""
	echo I can not determine the architecture and operating system
	echo that are required by this version of Z-Fax.  If your system
	echo is a Sony NeWS, Digital Equipment, Pyramid, or IBM RS/6000
	echo machine, this script may not have initialized properly.
	echo ""
	def=No
	echo $n "Attempt proceed with registration anyway? [$def] $c"
	read ans
	ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
	if test "$ans" != "y"
	then
	    echo Registration aborted.
	    exit 0
	fi
	echo ""
    esac
    if test "$REG_ENV" = false
    then
	# Try once more to find REG_ENV with new settings
	exec $REAL_SH $0
    fi
    ;;
esac

cat <<EOM

-------------------------

This is the Z-Fax license server registration script.  Using this
script, you can register users to use Z-Fax in accordance with the
licensing activation key(s) you have received from Z-Code Software.
If you have not yet received a activation key from Z-Code, please
call
	1-415-499-8649

This registration program requires at least one activation key.

EOM

def=y
echo $n "Do you need additional registration information? [$def] $c"
read ans
ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
if test $ans = "y"
then

cat <<EOM

Each activation key you receive enables a single computer to have a
certain number of users depending on the term of your license.  This
script will enable you to register licensing information on more than
one host and store multiple host/user information in a single license
database.

The database consists of the following files:

    $textfile  --human readable/editable file
    $datafile  --the file Z-Fax uses

This program will help you to create and/or edit `basename $textfile`
and to create `basename $datafile` from it.

EOM
echo $n "Press return to continue." $c
read ans

cat <<EOM

Since these files contain information about multiple hosts, the same
files can be replicated among all the hosts where Z-Fax will be used.
You can do this using rcp, ftp, or by using NFS mounting techniques.
Replicating the files simplifies system administration for sites that
are using the same local area network and file sharing is easy.

For sites that have many system administrators or remote machines that
are not well connected, you may want to maintain a separate database
for each host.  If this is the case, run this script separately while
logged in to the other (remote) machines.
 
EOM

echo $n "Press return to continue." $c
read ans

cat <<EOM

If you have only one or two machines and a short list of users, or if
you are unfamiliar with text file editing in UNIX, you may prefer to
register each machine interactively by using "$startup".
This is a simpler but potentially more time-consuming way to register
your users.

EOM

fi

# Make sure the lib and license directories exist for zmail -register
if test ! -d $licensedir
then
    echo " "
    def=y
    echo $n "$licensedir does not exist. Create it? [$def] $c"
    read ans
    ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
    if test "$ans" != n
    then
	if test ! -d $zfaxlib
	then
	    echo mkdir $zfaxlib
	    mkdir $zfaxlib
	    chmod 755 $zfaxlib
	fi
	echo mkdir $licensedir
	mkdir $licensedir
	chmod 755 $licensedir
    else
	echo "Installation discontinued."
	exit
    fi
    echo " "
fi

# Create the data file so we know the modes are correct
cat >>$datafile<<EOM
EOM

if test $? != 0
then
    cat <<EOM
You must be able to write into $datafile.
Either change to echo the appropriate user or change the file
permissions.  If you are attempting to install Z-Fax on an NFS
mounted file system, you may need to run the registration program
as root on the server machine.
EOM
    exit 1
fi
chmod 644 $datafile

def=y
echo $n "Would you like to use $startup interactively? [$def] $c"
read ans
ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
if test $ans = "y"
then
    if test -f $textfile
    then
	cat <<EOM
WARNING:  The file $textfile exists.
	  This file will not be updated by $startup.
          To keep `basename $textfile` and `basename $datafile` synchronized,
	  you should always edit `basename $textfile` via this program.
EOM
	def=n
	echo $n "Would you like to use $startup anyway? [$def] $c"
	read ans
	ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
    fi
fi
if test $ans = "y"
then
    echo Running $startup ....
    echo ""
    exec $startup
fi

cat <<EOM

You are about to edit a file that contains a list of hostnames and
the users that can use Z-Fax on those hosts.  The format of the
file is documented within the file.

EOM

zlsdoit=/tmp/zlsdoit
vi=${EDITOR-vi}
vi=${VISUAL-$vi}

echo $n "Editor to use: [$vi] $c"
read ans
if [ -n "$ans" ]
then
    vi=$ans
fi

ans=n
if test -f "$textfile"
then
    echo " "
    echo "$textfile already exists."
    x=0
    backupfile=/tmp/`basename $textfile`$x
    while [ -f "$backupfile" ]
    do
#	echo $n "$x $c"
	x=`expr $x + 1`
	backupfile=/tmp/`basename $textfile`$x
    done
#   if [ $x != 0 ] ; then echo " " ; fi
    echo "Saving existing file in $backupfile"
    cp $textfile $backupfile
    def=y
    echo $n "Do you want to reuse the existing file? [$def] $c"
    read ans
    ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
    if test $ans = "n"
    then
	echo " "
	echo "All data in `basename $textfile` will be overwritten."
	echo "But a backup file was made... remember?"
    fi
fi

if test $ans = "n"	# we're creating a new file
then
    cat <<FORMAT > $textfile
# This file should contain the hostname, hostid and license activation
# key for each machine licensed to use Z-Fax.  If there are any hosts
# in the existing file that you do not want processed, place a # in
# front of those hosts and each of its associated users, if any.
#
# The hostid of the machine may be determined by running the "hostid"
# command.  If your system does not have this command, and it is not
# provided as part of your Z-Fax shipment, enter 0 as the hostid.
# You may also enter 0 if your activation key is a for a demo version.
#
# User name lists can be inserted after each host, one user per line,
# on lines beginning with a space or tab character.
#
# User names listed on lines before the first host in this file
# will be licensed on all the hosts.
#
# For example (omit the # characters from your real entries):
#
# Hostname	Hostid		Activation Key
#	martha
#	john
#	mary
#	david
#xhost1		0x11ff22b8	1be94bf6be468318
#	henry
#	fred
#xhost2		0x24fa3e79	773f59c3ea108f3a
#	alice
#	carol
#
# The above example shows entries for two machines, "xhost1", whose
# hostid is 0x11ff22b8, and "xhost2", whose hostid is 0x24fa3e79.
# The users martha, john, mary, and david are to be registered on both
# of these machines.  The users henry and fred are to be registered
# only on xhost1, and the users alice and carol are to be registered
# only on xhost2.
#
# Hostname	Hostid		Activation Key
FORMAT

cat <<EOM

For your convenience, the user names from /etc/passwd can be placed in
this file saving you lots of editing time if most of the users on this
system are going to use Z-Fax.  You can generate your own list of names
outside of this program and read it into the editor buffer, if you like.
EOM
def=y	# generate user name list by default since it's a new file

else

cat <<EOM

Since this file exists, you probably don't need to have a list of
users from /etc/passwd added to it, but I can still do it if you want.

EOM

def=n # generate user name list by default since it's an old file
fi

echo $n "Generate a list of user names from /etc/passwd? [$def] $c"
read ans
ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`

if test "$ans" = y
then
    cat >> $textfile <<EOM

# The following list was automatically generated from /etc/passwd.
# Remove unwanted or inappropriate users.  All those that you want
# to be licensed on *all* machines should be listed -before- any
# hostname listed in this file.
#
# This comment could also be removed.
EOM
    awk 'BEGIN {FS=":"}
	{print "    " $1}' < /etc/passwd |
	sed '/+$/d' >> $textfile
    cat <<EOM

This list of users just appended to `basename $textfile` includes pseudo-users
such as "daemon", "bin" and "uucp" who are extremely unlikely to use
Z-Fax.  You should remove all unnecessary users when you edit the file.

If you are asked to re-edit the file and do not wish to do so, type 'q'
to discontinue this script.

EOM
fi

adjective=
happy_with_commands=nope
until [ $happy_with_commands = yes_very_much ]; do
    echo $n "Press return to "$adjective"edit the licensed host database: $c"
    adjective=re-
    read ans
    ans=`echo $ans | sed 's/\(.\).*/\1/' | tr Q q`
    if [ "$ans" = q ]
    then
	echo Registration discontinued.
	echo ""
	exit 1
    fi
    $vi $textfile
    echo " "
    echo $n "Generating registration command file $zlsdoit...$c"

    sed < $textfile \
	-e 's/#.*//' \
	-e 's/	/ /g' \
	-e 's/^ *$//g' \
    | awk '
	/^ / {
	    if (NF == 1) {
		if (got_a_host)
		    print $1
		else
		    dudes[ndudes++] = $1
	    } else {
		print "Error on line " NR ":"
		print "   a line beginning with a space must contain a single user name."
	    }
	}
	/^[^ #]/ {
	    if (NF == 3) {
		if (got_a_host)
		    print "END"
		got_a_host = 1
		print "'"$startup"'", "-hostname", $1, "-hostid", $2, $3, "<< END"
		for (i = 0; i < ndudes; ++i)
		    print dudes[i]
	    } else {
		print "Error on line " NR ":"
		print "   a line not beginning with a space must consist of"
		print "   hostname, hostid, and activation key."
	    }
	}
	END {
	    if (got_a_host)
		print "END"
	}
    ' > $zlsdoit

    echo
    if test ! -s $zlsdoit
    then
	echo No hosts specified!
    elif egrep "Error on line|with a space|and activation key" $zlsdoit
    then
	true
    else
	happy_with_commands=yes_very_much
    fi
done

cat <<EOM

The file $zlsdoit contains shell commands that run Z-Fax with the
proper command line arguments to register the users you have specified.
The resulting data file can then be distributed to all the necessary
hosts as described in the introduction of this session.  You may want to
save this file yourself and edit it accordingly to avoid having to run
this script again.

EOM

def=y
echo $n "Execute it? [$def] $c"
read ans
ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`

if test "$ans" != y
then
    echo Registration postponed.
    exit 0
fi

echo "Executing registration command file $zlsdoit...."
echo ""

set -e
. $zlsdoit

echo ""
echo Registration completed.
exit 0
