#!/bin/sh
# Copyright 1992 Z-Code Software Corporation.  All rights reserved.

# Make sure sh is running properly.
true || exec sh $0
export PATH || eval "echo Switching to /bin/sh ... && exec sh $0"
if test ! -t 0
then
    echo 'Please use "sh doinstall.sh" not "sh <doinstall.sh".'
    exit 1
fi

if test -z "$ORIGINAL_SCRIPT_NAME"
then
    ORIGINAL_SCRIPT_NAME="$0"
    export ORIGINAL_SCRIPT_NAME
fi

PHONE_NUMBER='+1 415 499 8649'

# Figure out how to do echo without newline.
c=`echo "hi there\c" | sed 's/[^c]//g'`
if test -z "$c"
then
    n=''
    c='\c'
else
    n='-n'
    c=''
fi

# Make sure that we are running as the superuser.
case $ROOTPID in
$$)
    echo ""
    echo "Stepping quickly into a nearby phone booth, you emerge as SuperUser!"
    echo "I am now acting as root."
    ;;
*)
    ROOTPID=$$
    export ROOTPID

    # Check to see that we're all set to go.

    echo ""
    echo "Responses enclosed in square brackets [] are defaults.  Press"
    echo "ENTER or RETURN to select these responses."

    echo ""
    echo "You should have your Z-Fax license activation key ready before"
    echo "proceeding with installation.  Your license key will be entered"
    echo "during registration after installation is completed.  If you do"
    echo "not have a license key, call Z-Code Software at $PHONE_NUMBER"
    echo "to request one."
    echo ""
    def=Yes
    echo $n "Do you have a Z-Fax activation key? [$def] $c"
    read ans
    ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
    if test "$ans" != "y"
    then
	echo ""
	echo To get an activation key, call Z-Code Software at $PHONE_NUMBER
	echo and provide the following information:
	echo ""
	echo "    Your Z-Fax serial number (printed on the tape or diskette;"
	echo "        serial number is not required for demonstration copies)"
	hostid=`(./hostid || hostid) 2>/dev/null || echo 0`
	if test $hostid = 0
	then
	    hostname=`( hostname || uname -n || uuname -l ) 2>/dev/null`
	    echo "    Your host name:  $hostname"
	else
	    echo "    Your host id:    $hostid"
	fi
	echo ""
	echo You may proceed with installation, but you will be unable to
	echo register any users until you have your activation key.
	echo ""
	def=No
	echo $n "Proceed with intallation anyway? [$def] $c"
	read ans
	ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
	if test "$ans" != "y"
	then
	    echo ""
	    echo Installation aborted.
	    echo ""
	    exit 0
	fi
    fi

    echo ""
    echo "-------------------------"
    echo ""
    echo "I must be root to run this script.  If you are already root,"
    echo "the script will proceed.  Otherwise, you will need to enter"
    echo "your system's root password here."
    echo ""
    cat <<EOM > /tmp/rm-me$$
This is a test to see if I am already running as root.
EOM
    if (chmod 0 /tmp/rm-me$$ && cat /tmp/rm-me$$) >/dev/null 2>&1
    then
	rm -f /tmp/rm-me$$
	echo "Thank you!  I'm already root."
    else
	rm -f /tmp/rm-me$$
	exec su root -c "exec sh $0" || exit 1
    fi
    ;;
esac

# Now jump through hoops to make sure this all works right.
case $ZF_INSTALL_PID in
$$) ;;
*)
    ZF_INSTALL_PID=$$
    export ZF_INSTALL_PID

    LOCAL=/usr/local
    ZFAXLIB=/usr/lib/Zfax
    export LOCAL ZFAXLIB

    ZFAPPDEF=Zfax
    export ZFAPPDEF

    ZAPPLRESDIR=/usr/lib/X11/app-defaults
    export ZAPPLRESDIR

    REAL_SH=sh
    export REAL_SH

    ln=ln

    PATH=/etc:/usr/etc:"$PATH"

    echo ""
    echo Performing sanity checks...

    ZFSHIPDIR=`pwd`
    export ZFSHIPDIR
    case `basename $ZFSHIPDIR` in
    zfax.apollo)
	SGID=mail
	if test -d /sys5/bin
	then
	    PATH=/sys5/bin:"$PATH"
	fi
	;;
    zfax.atari)
	SGID=mail
	;;
    zfax.hp*)
	SGID=mail
	;;
    zfax.m88k)
	;;
    zfax.mips)
	;;
    zfax.ncr486|zfax.i386|zfax.inter)
	SGID=mail
	;;
    zfax.pyr*)
	# OSX has no -x in test...
	if test -f /.attbin/sh
	then
	    REAL_SH=/.attbin/sh
	    echo ""
	    echo Your ucb sh may be very old and braindamaged.
	    echo Executing the att sh just in case...
	    exec /.attbin/sh $0
	fi
	;;
    zfax.rs6000)
	LOCAL=/usr/lpp
	ZFAXLIB=/usr/lpp/Zfax
	;;
    zfax.seqptx)
	;;
    zfax.sco)
	SGID=mmdf
	;;
    zfax.sgi)
	ln="ln -s"
	;;
    zfax.sun4ol)
	ZAPPLRESDIR=""
	;;
    zfax.sun*)
	ln="ln -s"
	;;
    zfax.sony)
	case `strings /bin/sh | grep '^DATE'` in
	*1978*)
	    echo ""
	    echo Your machine does not have a shell that can run this script.
	    echo Please complain to Sony after installing Z-Fax by hand. 
	    echo See instructions in your Z-Fax Installation Guide.
	    echo '(No, there are not instructions for how to complain.)'
	    exit 1
	    ;;
	esac
	;;
    zfax.ultrix)
	if test -x /bin/sh5
	then
	    REAL_SH=/bin/sh5
	    echo ""
	    echo Your /bin/sh may be very old and braindamaged.
	    echo Executing /bin/sh5 just in case...
	    exec /bin/sh5 $0
	fi
	;;
    *)
	echo ""
	echo I can not determine the architecture and operating system
	echo that are required by this version of Z-Fax.
	echo ""
	def=No
	echo $n "Proceed with installation anyway? [$def] $c"
	read ans
	ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
	if test "$ans" != "y"
	then
	    echo Installation discontinued.
	    exit 0
	fi
	echo ""
    esac
    ;;
esac

# Prepending stuff to PATH may have changed which "echo"
# we are using, so we gotta do this again...
# Figure out how to do echo without newline
c=`echo "hi there\c" | sed 's/[^c]//g'`
if test -z "$c"
then
    n=''
    c='\c'
else
    n='-n'
    c=''
fi

# Now, finally, initialize defaults and get on with it.

LICENSE_LIB=$ZFAXLIB
LICENSE_DIR=$LICENSE_LIB/license
LICENSE_FILE=license.data

ZCNLSDIR=zcnls
ZCNLDAEMON=$ZCNLSDIR/license/bin/zcnlsd
ZCNLINST=$ZCNLSDIR/nlsinstall.sh
export ZCNLSDIR

DO_NLSINTALL=false
if test -d "$ZCNLSDIR" -a -f "$ZCNLDAEMON"
then
    echo ""
    if test ! -f "$ZCNLINST"
    then
	cat <<EOM
Hmmm... you have Z-Code Network License Server software, but not the
Network License Server installation program.  If you want to install
the Network License Server software, first complete this Z-Fax
installation, then follow the manual installation instructions in the
file README.NLS or call Z-Code at $PHONE_NUMBER to get the program.

EOM
	    echo $n "Press return to continue. $c"
	    read ans
	    NETWORK_LICENSE=false
	    license_message="cannot be changed"
    else
	cat <<EOM
Z-Code Network License Server software is available with this
installation.  If you have a Network License Server activation
key, you may install and use the Network License Server.  I will
offer to install the Network License Server for you after this
Z-Fax installation is completed successfully.

Your Network License Server activation key, if you have one, is
clearly labeled on your Quick Installation Guide sheet.  If you do
not have an Quick Installation Guide and you want to use the Network
License Server, call Z-Code at $PHONE_NUMBER for assistance.
You may install the Network License Server even if you do not have a
key, but you will need a key before using the software.

EOM
	echo $n "Press return to continue. $c"
	read ans
    fi
    tmp=`echo $LICENSE_DIR | sed 's:\([^/]\)//*:\1/:g'`
    tmp=`echo $tmp | sed 's:\(.*/\).*/license:\1:'`
    if mkdir ${tmp}rm.me$$ 2>/dev/null
    then
	rmdir ${tmp}rm.me$$ 2>/dev/null
    else
	cat <<EOM

If you will not be using the Network License Server, Z-Fax must have
access to the directory $LICENSE_DIR to validate
user licenses.  I do not seem to have permission from the operating
system to create $LICENSE_DIR/$LICENSE_FILE.  

If you are concerned that this may be a problem, discontinue this
installation now.

EOM
	def=Yes
	echo $n "Do you want to continue installation? [$def] $c"
	read ans
	ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
	if test "$ans" != "y"
	then
	    echo ""
	    echo "Installation discontinued."
	    exit
	fi
    fi
    if test -f "$ZCNLINST"
    then
	cat <<EOM

Should I install the Network License Server later?  If yes, you may
locate $LICENSE_FILE wherever you desire.  If no, $LICENSE_FILE must
reside in $LICENSE_DIR.

If you are installing a demonstration copy of Z-Fax, you should
answer "No" to this question.

If you have installed (or will be installing) the Network License
Server on another machine, for use with this copy of Z-Fax, you
should answer "Yes" to this question.  However, if you answer "Yes",
then you must install the Network License Server before registering
activation keys and users.

EOM
	def=Yes
	echo $n "Install the Network License Server later? [$def] $c"
	read ans
	ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
	if test "$ans" != "y"
	then
	    NETWORK_LICENSE=false
	    license_message="cannot be changed"
	else
	    DO_NLSINTALL=true
	    NETWORK_LICENSE=true
	    license_message="configure via network server"
	fi
    fi
else
    NETWORK_LICENSE=false
    license_message="cannot be changed"
fi

# Figure out where X resources go ...
if test -n "$OPENWINHOME"
then
    ZAPPLRESDIR=$OPENWINHOME/lib/app-defaults
    if test -d /usr/lib/X11
    then
	cat <<EOM

-------------------------

You appear to have both X11 and OpenWindows installed on your machine.
EOM
	case $ZFSHIPDIR in
	*ol) cat <<EOM
This is an OpenLook version of Z-Fax, so I will install Z-Fax
resources in $ZAPPLRESDIR unless you choose otherwise by
specifying a different location.  Do this by answering "No" when asked
if you wish to install in the default locations and specifying the new
location when prompted for the location of X resources.

EOM
	    ;;
	*) cat <<EOM
Z-Fax will look for X resources in /usr/lib/X11/app-defaults by
default.  If you plan to install Zfax resources in the OpenWindows
tree, all users will need to set XAPPLRESDIR to point to:

	$ZAPPLRESDIR

and you will also need to specify this directory for installation of X
resources.  Do this by answering "No" when asked if you wish to install
in the default locations and then specifying the above directory when
prompted for the location of X resources.

EOM
	    ZAPPLRESDIR=/usr/lib/X11/app-defaults
	    ;;
	esac
	echo $n "Press return to continue. $c"
	read ans
    fi
    XAPPLRESDIR=$ZAPPLRESDIR
fi
if test -z "$XAPPLRESDIR"
then
    XAPPLRESDIR=/usr/lib/X11/app-defaults
fi
if test -z "$ZAPPLRESDIR"
then
    ZAPPLRESDIR=$XAPPLRESDIR
fi

BIN=$LOCAL/bin
MANDIR=/usr/man/man1
MANSEC=1
GS_LIB=/usr/lib/Ghostscript
SPOOLDIR=/usr/spool/fax

RM_IT=true

# Is this a client and server distribution, or just client?

DIST_TYPE=client
[ -f bin/zfaxd -a -f bin/netfaxq -a -f bin/c2test ] && DIST_TYPE=server

if [ "$DIST_TYPE" = client ]
then
    INSTALL_GS=true;
    INSTALL_CLIENT=true;
    INSTALL_SERVER=false;
else
    INSTALL_GS=true;
    INSTALL_CLIENT=true;
    INSTALL_SERVER=true;

    cat <<EOM

-------------------------

This distribution contains both the client and server portions of Z-Fax.
The Z-Fax server consists of the queue manager, network queue interface,
and modem drivers.  The Z-Fax client consists of the graphical user
interface, command-line utilities, Postscript interpreter and fonts,
and the client portion of the network queue interface.

Please select the configuration you would like to install:

    1) Client only
    2) Server only
    3) Both client and server

EOM

    while true
    do
	def=3
        echo $n "Please enter 1, 2, or 3: [$def] $c"
	read ans
	[ "" = "$ans" ] && ans=$def
	case $ans in
	  1*) INSTALL_SERVER=false ; break;;
	  2*) INSTALL_CLIENT=false ;  break;;
	  3*) break;;
	esac
    done
fi

[ "false" = "$INSTALL_SERVER" ] && SPOOLDIR="(not part of client)"
[ "false" = "$INSTALL_CLIENT" ] && XAPPLRESDIR="(not part of server)"
[ "false" = "$INSTALL_CLIENT" ] && GS_LIB="(not part of server)" \
				&& INSTALL_GS=false

if test "false" != "$INSTALL_GS"
then
    cat <<EOM

-------------------------

This distribution contains Ghostscript, a free Postscript interpreter.
It is used by Z-Fax to convert Postscript and ASCII files to fax
format.  If you already have Ghostscript installed or you want to
install your own version, you can skip installing Z-Fax's version.

EOM

    def=Yes
    echo $n "Do you wish to install Ghostscript? [$def] $c"
    read ans
    ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
    if test "$ans" != "y"
    then
        INSTALL_GS=false
        GS_LIB="(not installed)"
    fi
fi


cat <<EOM

-------------------------

This script automatically installs the Z-Fax library and executables.
If you wish to specify locations for the installation on this machine,
you may do so at this time.  Otherwise, Z-Fax will be installed in the
following default directories:

    Z-Fax Library:        $ZFAXLIB
    Licensing:            $LICENSE_DIR    [$license_message]
    X Resources:          $XAPPLRESDIR
    Executables:          $BIN
    Man pages:            $MANDIR (section $MANSEC)
    Ghostscript Library:  $GS_LIB
    Spool Directories:    $SPOOLDIR

EOM

# Input the locations where everthing should be installed.

def=Yes
echo $n "Do you wish to install Z-Fax in the default locations? [$def] $c"
read ans
ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
if test "$ans" != "y"
then
    if "$NETWORK_LICENSE" = false
    then
	cat << EOM

-------------------------

Z-Fax requires access to the directory $LICENSE_DIR
to validate user licenses.  This location is not configurable.
Installation of Z-Fax will create this directory if it does
not exist.  If you do not wish to create this directory at
this time, discontinue installation now.

EOM
	def=Yes
	echo $n "Do you wish to continue installation? [$def] $c"
	read ans
	ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
	if test "$ans" != "y"
	then
	    echo "Installation discontinued."
	    exit
	fi
    fi


    cat << EOM

-------------------------

Z-Fax expects to find initialization data and online help
in $ZFAXLIB.  If you change the location of $ZFAXLIB,
Z-Fax users will need to set the environment variable ZFAXLIB
to the new name.

Enter directory for Z-Fax library:
EOM
    def=$ZFAXLIB
    echo $n "[$def] $c"
    read ans
    if test ! -z "$ans"
    then
	if test "$ZFAXLIB" = "$ZFSHIPDIR"
	then
	    cat <<EOM

Sorry, I can't install Z-Fax in $ZFSHIPDIR.
If you wish to install Z-Fax in $ZFSHIPDIR,
please begin by reading your Z-Fax tape or diskette into a different
directory, and then re-execute this installation script from there.

Installation aborted.
EOM
	    exit 1
	else
	    ZFAXLIB=$ans
	fi
    fi


    if [ "$INSTALL_GS" = "true" ]
    then
        cat << EOM

-------------------------

Z-Fax uses Ghostscript to convert Postscript documents to fax
format.  Ghostscript expects to find initialization files and
fonts in $GS_LIB.  If you change the location of
$GS_LIB, Z-Fax users will need to set the environment
variable GS_LIB to the new name.

Enter directory for Ghostscript library:
EOM
        def=$GS_LIB
        echo $n "[$def] $c"
        read ans
        if test ! -z "$ans"
        then
	    GS_LIB=$ans
        fi
    fi


    if [ "$INSTALL_SERVER" = "true" ]
    then
        cat << EOM

-------------------------

Z-Fax stores received faxes and faxes waiting to be transmitted in
spool directories normally in $SPOOLDIR.  If you change this location,
you will need to set the TRANSMIT_DIR and RECEIVE_DIR entries in the
$ZFAXLIB/config file.

Enter directory to contain fax queue subdirectories:
EOM
        def=$SPOOLDIR
        echo $n "[$def] $c"
        read ans
        if test ! -z "$ans"
        then
	    SPOOLDIR=$ans
        fi
    fi


    cat << EOM

-------------------------

The Z-Fax executables may be installed in any directory that
normally appears in the PATH environment variable.

Enter directory for Z-Fax executables:
EOM
    def=$BIN
    echo $n "[$def] $c"
    read ans
    if test ! -z "$ans"
    then
	BIN=$ans
	LOCAL=`expr $BIN : '\(.*\)/.*'`
    fi


    cat << EOM

-------------------------

The Z-Fax man pages are typically installed in /usr/man/man1, section 1.
You can install them elsewhere if you like.  If you install them outside
of the default man page directory tree, your users may have to set the
MANPATH environment variable in order to see them.

Enter directory for Z-Fax man pages:
EOM
    def=$MANDIR
    echo $n "[$def] $c"
    read ans
    if test ! -z "$ans"
    then
	MANDIR=$ans
    fi


    cat << EOM

Enter section for Z-Fax man pages (typically the last letter of
the man page directory):
EOM
    def=$MANSEC
    echo $n "[$def] $c"
    read ans
    if test ! -z "$ans"
    then
	MANSEC=$ans
    fi


    if [ "$INSTALL_CLIENT" = "true" ]
    then
        cat << EOM

-------------------------

Z-Fax expects to find application default X resources in
$XAPPLRESDIR.  If you change the location of
$XAPPLRESDIR, Z-Fax users will need to set the
environment variable XAPPLRESDIR to the new name.

Enter directory for X application defaults:
EOM
        def=$XAPPLRESDIR
        echo $n "[$def] $c"
        read ans
        if test ! -z "$ans"
        then
	    XAPPLRESDIR=$ans
        fi
    fi


    cat << EOM

-------------------------

You have specified the following locations:

    Z-Fax Library:        $ZFAXLIB
    X Resources:          $XAPPLRESDIR
    Executables:          $BIN
    Man pages:            $MANDIR (section $MANSEC)
    Ghostscript Library:  $GS_LIB
    Spool Directories:    $SPOOLDIR

These directories will be created if they do not already exist.

EOM
    def=Yes
    echo $n "Do you wish to continue installation? [$def] $c"
    read ans
    ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
    if test "$ans" != "y"
    then
	echo "Installation discontinued."
	exit
    fi
fi

case $PATH in
$BIN:*) ;;
*:$BIN) ;;
*:$BIN:*) ;;
*) cat <<EOM

WARNING: $BIN
         does not appear in your PATH environment variable.
         This may cause problems with future user registrations.
EOM
    echo $n "Press return to continue. $c"
    read ans
    ;;
esac

# Now make sure the existing file system is in a safe state.
# This definition intentionally begins with a newline!
backitup="
    $ZFAXLIB/license/license.data
    $XAPPLRESDIR/$ZFAPPDEF"

if test -d $ZFAXLIB
then
    WARNING=true
    cat << EOM

-------------------------

$ZFAXLIB already exists from a previous installation.
In order to continue installation, the existing $ZFAXLIB
must be removed, or you can restart the installation
and change the installation locations.

EOM
    if test "$ZFAXLIB" = "$LICENSE_LIB"
    then
	cat <<EOM
Installing a new copy of Z-Fax will replace the current registration
information and may interfere with Z-Fax sessions currently in
progress.

EOM
    fi
    cat << EOM
Proceed with caution.  For your convenience, backup copies of the
following files will be made if they exist and you choose to continue:
$backitup

Note that no matter what you say now, $ZFAXLIB will
not be removed until I say "I am now ready to install your new Z-Fax".

EOM
    def=Yes
    echo $n "Will it be OK to remove $ZFAXLIB? [$def] $c"
    read ans
    ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
    if test "$ans" != "y"
    then
	def=No
	echo $n "Do you wish to install other files anyway? [$def] $c"
	read ans
	ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
	if test "$ans" != "y"
	then
	    echo Installation discontinued.
	    exit
	fi
	RM_IT=false
    fi
else
    WARNING=false
fi

echo ""
echo "-------------------------"
echo ""

# Check for the ownership and permissions we should attach to everything.

cat <<EOM
Some platforms or sites have special accounts for installed software.
These accounts have names like "bin" or "daemon".  You may wish to
have one of these special accounts own the Z-Fax library, or you may
wish to assign ownership to an adminstrative person's account.

Most sites use the "root" account for ownership of these libraries.

EOM

getpasswd='((ypcat passwd) 2>/dev/null || cat /etc/passwd)'
getgroup='((ypcat group) 2>/dev/null || cat /etc/group)'

def=root
while :
do
    echo $n "Which account should own files in $ZFAXLIB? [$def] $c"
    read ans
    ans=`echo $ans`
    if test -z "$ans"
    then
	LIBOWNER=root
    elif ( eval $getpasswd | grep -s "^${ans}:" ) >/dev/null 2>&1
    then
	LIBOWNER=$ans
    else
	echo "$ans is not a known account.  Please try another."
	continue
    fi
    break
done

gid=`eval $getpasswd | grep "^${LIBOWNER}:" | sed 's/[^:]*:[^:]*:[^:]*:\([^:]*\):.*/\1/' | sed 1q`
group=`eval $getgroup | sed -n "/[^:][^:]*:[^:][^:]*:${gid}:.*/p" | sed 's/:.*//' | sed 1q`

if test -n "$group"
then
    def=`echo "$group" | sed 1q`
else
    def=`eval $getgroup | sed 1q | sed 's/:.*//'`
fi

cat <<EOM

The account "$LIBOWNER" appears to be a member of the group "$def".
You may wish to assign the Z-Fax library to a different group if
access is to be restricted to a particular group of users.

EOM

while :
do
    echo $n "To what group should $ZFAXLIB belong? [$def] $c"
    read ans
    ans=`echo $ans`
    if test -z "$ans"
    then
	LIBGROUP=$def
    elif (eval $getgroup | grep -s "^${ans}:") >/dev/null 2>&1
    then
	LIBGROUP=$ans
    else
	echo "$ans is not a known group.  Please try another."
	continue
    fi
    break
done

echo ""

if (eval $getpasswd | grep -s '^bin:') >/dev/null 2>&1
then
    def=bin
else
    def=$LIBOWNER
fi
while :
do
    echo $n "Which account should own the Z-Fax executables? [$def] $c"
    read ans
    ans=`echo $ans`
    if test -z "$ans"
    then
	ZFOWNER=$def
    elif (eval $getpasswd | grep -s "^${ans}:") >/dev/null 2>&1
    then
	ZFOWNER=$ans
    else
	echo "$ans is not a known user.  Please try another."
	continue
    fi
    break
done

SGID=false

while :
do
    echo $n "To what group should the executables belong? [$def] $c"
    read ans
    ans=`echo $ans`
    if test -z "$ans"
    then
	ZFGROUP=$def
    elif (eval $getgroup | grep -s "^${ans}:") >/dev/null 2>&1
    then
	ZFGROUP=$ans
    else
	echo "$ans is not a known group.  Please try another."
	continue
    fi
    break
done

if $RM_IT
then
    cat <<EOM

-------------------------

I am now ready to install your new Z-Fax.  If you do not wish to
remove the existing copy, you should discontinue installation now.

Nothing has been permanently changed up to this point.  However,
if you continue, the existing installation will be removed and
the new copy installed.  These files will be backed up if they
exist: $backitup

EOM
    def=Yes
    echo $n "Proceed with Z-Fax installation? [$def] $c"
    read ans
    ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
    if test "$ans" != "y"
    then
	echo Installation discontinued.
	exit
    fi
    if mkdir /tmp/zfbackup.$$
    then
	for f in $backitup
	do
	    if test -f "$f"
	    then
		echo ""
		echo "Backing up $f in /tmp/zfbackup.$$ ..."
		/bin/cp $f /tmp/zfbackup.$$
	    fi
	done
    else
	echo "Unable to create directory for backups!"
	def=No
	echo $n "Proceed with Z-Fax installation? [$def] $c"
	read ans
	ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
	if test "$ans" != "y"
	then
	    echo Installation discontinued.
	    exit
	fi
    fi
    if $WARNING
    then
	echo ""
	echo Removing $ZFAXLIB ...
    fi
    rm -rf $ZFAXLIB
else
    cat << EOM

Your Z-Fax library may not match the other files that are
about to be installed.  You should install $ZFAXLIB
at the earliest possible opportunity.
EOM
fi

if $RM_IT && test -d "$ZFAXLIB"
then
    cat << EOM

-------------------------

$ZFAXLIB still exists.  Proceeding with installation will
overwrite all contents of this directory.

EOM
    def=No
    echo $n "Are you sure you wish to continue? [$def] $c"
    read ans
    ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
    if test "$ans" != "y"
    then
	echo "Installation discontinued."
	exit
    fi
fi

# Everything OK, so here we go...

# Figure out if we can make paths.
mkdir -p /tmp/z$$z/z$$z 2>/dev/null
if test -d ./-p
then
    mkdir=mkdir
    rmdir ./-p
elif test -d /tmp/z$$z/z$$z
then
    mkdir='mkdir -p'
else
    mkdir=mkdir
fi
rm -rf /tmp/z$$z

cat <<EOM

-------------------------

Checking existence of various system directories ...
EOM

ERROR=false
WARNING=false

if [ "INSTALL_CLIENT" = "true" ]
then
    # Check that XAPPLRESDIR isn't relative to a directory that
    # we're expected to create later; if not, make sure it exists.
    case $XAPPLRESDIR in
    $ZFAXLIB*) ;;
    $LICENSE_LIB*) ;;
    *)
        if test ! -d $XAPPLRESDIR
        then
	    # Note!  Explicitly NOT $mkdir here!
	    mkdir $XAPPLRESDIR || XAPPLRESDIR=""
        fi
        ;;
    esac
fi

if test ! -d $LOCAL
then
    $mkdir $LOCAL || exit 1
fi
if test ! -d $BIN
then
    $mkdir $BIN || exit 1
fi
if test ! -d $MANDIR
then
    $mkdir $MANDIR || exit 1
fi

if $RM_IT
then
    echo ""
    echo Installing $ZFAXLIB ...
    if test ! -d $ZFAXLIB
    then
	$mkdir $ZFAXLIB || exit 1
	$mkdir $ZFAXLIB/bin || exit 1
    fi
    ( cd lib && tar -cf - . ; ) | ( cd $ZFAXLIB && tar -xf - ; )
    cp register.sh $ZFAXLIB || ERROR=true
    # cp doinstall.sh $ZFAXLIB || WARNING=true
    test -d "$ZFAXLIB" || ERROR=true
    if test -f RELNOTES
    then
	cp RELNOTES $ZFAXLIB || WARNING=true
	chmod a=r $ZFAXLIB/RELNOTES || WARNING=true
    fi
    if test -f hostid
    then
	cp hostid $ZFAXLIB || WARNING=true
	chmod a+x $ZFAXLIB/hostid || WARNING=true
    fi
fi

# Check that the license directories exists.
if test "$NETWORK_LICENSE" = false
then
    if test ! -d "$LICENSE_LIB"
    then
	echo ""
	echo "Installing $LICENSE_LIB for licensing ..."
	$mkdir $LICENSE_LIB || L_ERROR=true
	if test ! -d "$LICENSE_DIR"
	then
	    if test "$L_ERROR" != true
	    then
		$mkdir $LICENSE_DIR || L_ERROR=true
	    fi
	fi
	if test "$L_ERROR" != true
	then
	    license_dir=lib/`basename $LICENSE_DIR`
	    if test -d "$license_dir"
	    then
		( cd $license_dir ; tar -cf - . ; ) | \
		( cd $LICENSE_DIR ; tar -xf - ; )
	    fi
	    cat <<EOM > $LICENSE_DIR/README
This directory must exist if Z-Fax is to be registered and run as a
self-licensed program, that is, without using the Z-Code Network License
Server.  If you are using the Network License Server on this or another
machine and you do not wish to use $LICENSE_DIR for licensing,
you may remove $LICENSE_DIR.

If $LICENSE_LIB is empty except for this subdirectory,
you may remove $LICENSE_LIB as well.
EOM
	    if test "$ZFAXLIB" != "$LICENSE_LIB"
	    then
		find $LICENSE_LIB -exec chown $LIBOWNER {} \; || WARNING=true
		find $LICENSE_LIB -exec chgrp $LIBGROUP {} \; || WARNING=true
		find $LICENSE_LIB -type d -exec chmod a+rx {} \; || WARNING=true
		find $LICENSE_LIB -type f -exec chmod a+r {} \; || WARNING=true
	    fi
	fi
    else
	if test ! -d "$LICENSE_DIR"
	then
	    mkdir $LICENSE_DIR || WARNING=true
	fi
    fi
fi

# Install Ghostscript library files.

if [ "$INSTALL_GS" = "true" ]
then
    echo ""
    echo Installing $GS_LIB ...
    if test ! -d $GS_LIB
    then
        $mkdir $GS_LIB
    fi
    test -d $GS_LIB || ERROR=true
    test -d $GS_LIB && \
        ( cd Ghostscript && tar -cf - . ; ) | ( cd $GS_LIB && tar -xf - ; )
fi

if test "$ERROR" != true
then
    echo Resetting owner, group, and mode in $ZFAXLIB ...

    find $ZFAXLIB -exec chown $LIBOWNER {} \; || WARNING=true
    find $ZFAXLIB -exec chgrp $LIBGROUP {} \; || WARNING=true
    find $ZFAXLIB -type d -exec chmod a+rx {} \; || ERROR=true
    find $ZFAXLIB -type f -exec chmod a+r {} \; || ERROR=true
fi
echo ""

if [ "$INSTALL_CLIENT" = "true" ]
then
    # Check XAPPLRESDIR again in case we didn't create it before...
    if test -n "$XAPPLRESDIR"
    then
        if test ! -d "$XAPPLRESDIR"
        then
	    # Note!  Explicitly NOT $mkdir here!
	    mkdir $XAPPLRESDIR || XAPPLRESDIR=""
        fi
    fi
    if test -n "$XAPPLRESDIR"
    then
        echo Installing X resources in $XAPPLRESDIR...

        if cp lib/$ZFAPPDEF $XAPPLRESDIR/$ZFAPPDEF
        then
	    chown $LIBOWNER $XAPPLRESDIR/$ZFAPPDEF || WARNING=true
	    chgrp $LIBGROUP $XAPPLRESDIR/$ZFAPPDEF || WARNING=true
	    chmod 644 $XAPPLRESDIR/$ZFAPPDEF || WARNING=true
        else
	    WARNING=true
        fi
    else
        echo "I can't seem to find a place to install X resources."
        echo "Check that X11 is properly installed on your system."
        WARNING=true
    fi
fi


echo ""
echo Installing executables in $BIN...

bin_list="queuefax faxmail mailfax"
lib_list=""
man_list="queuefax faxmail mailfax"
if [ "$INSTALL_SERVER" = "true" ]
then
    bin_list="$bin_list zfaxd"
    lib_list="$lib_list c2test fax-recv fax-send netfaxq"
    man_list="$man_list c2test fax-recv fax-send netfaxq zfaxd"
fi
if [ "$INSTALL_CLIENT" = "true" ]
then
    bin_list="$bin_list buildfax faxit printfax zfax"
    man_list="$man_list buildfax faxit printfax zfax"
fi
if [ "$INSTALL_GS" = "true" ]
then
    bin_list="$bin_list gs"
fi

for prog in $bin_list
do
    [ -f $BIN/$prog ] && mv $BIN/$prog $BIN/$prog.old
    cp bin/$prog $BIN/$prog || ERROR=true
    chown $ZFOWNER $BIN/$prog || WARNING=true
    chgrp $ZFGROUP $BIN/$prog || WARNING=true
    chmod a+x $BIN/$prog || WARNING=true
done

for prog in $lib_list
do
    [ -f $ZFAXLIB/bin/$prog ] && mv $ZFAXLIB/bin/$prog $ZFAXLIB/bin/$prog.old
    cp bin/$prog $ZFAXLIB/bin/$prog || ERROR=true
    chown $ZFOWNER $ZFAXLIB/bin/$prog || WARNING=true
    chgrp $ZFGROUP $ZFAXLIB/bin/$prog || WARNING=true
    chmod a+x $ZFAXLIB/bin/$prog || WARNING=true
done

for prog in dequeuefax requeuefax listqueue
do
    ( cd $BIN ; rm -f $prog ; $ln queuefax $prog )
done

if [ "$INSTALL_SERVER" = "true" ]
then
    for prog in c2send c2recv
    do
	( cd $ZFAXLIB/bin ; rm -f $prog ; $ln c2test $prog )
    done
fi


echo ""
echo Installing man pages in $MANDIR...

for man in $man_list
do
    [ -f $MANDIR/${man}.$MANSEC ] && mv $MANDIR/${man}.$MANSEC $MANDIR/${man}.old
    cp man/${man}.1 $MANDIR/${man}.$MANSEC || ERROR=true
    chown $ZFOWNER $MANDIR/${man}.$MANSEC || WARNING=true
    chgrp $ZFGROUP $MANDIR/${man}.$MANSEC || WARNING=true
done

for man in dequeuefax requeuefax listqueue
do
    rm -f $MANDIR/${man}.$MANSEC
    $ln $MANDIR/queuefax.$MANSEC $MANDIR/${man}.$MANSEC
done

if [ "$INSTALL_SERVER" = "true" ]
then
    for man in c2send c2recv
    do
	rm -f $MANDIR/${man}.$MANSEC
	$ln $MANDIR/c2test.$MANSEC $MANDIR/${man}.$MANSEC
    done
fi


if [ "$INSTALL_SERVER" = "true" ]
then
    # Set up fax spool directories.

    [ -d $SPOOLDIR ] || $mkdir $SPOOLDIR
    [ -d $SPOOLDIR/incoming ] || $mkdir $SPOOLDIR/incoming
    [ -d $SPOOLDIR/outgoing ] || $mkdir $SPOOLDIR/outgoing

    # Set up permissions on send and receive programs to coexist with UUCP.

    chown uucp $SPOOLDIR/incoming $SPOOLDIR/outgoing $BIN/c2test
    chgrp uucp $SPOOLDIR/incoming $SPOOLDIR/outgoing $BIN/c2test $BIN/zfaxd $BIN/queuefax
    chmod 775  $SPOOLDIR/incoming $SPOOLDIR/outgoing
    chmod 775  $SPOOLDIR/incoming $SPOOLDIR/outgoing
    chmod ug+s $BIN/c2test
    chmod g+s  $BIN/zfaxd $BIN/queuefax

    # Create the log file so c2send and c2recv can write into it.

    touch $SPOOLDIR/log
    chown uucp $SPOOLDIR/log
    chgrp uucp $SPOOLDIR/log
    chmod 644  $SPOOLDIR/log

    # Set up config file with spool directories.

    sed -e "s%^TRANSMIT_DIR=.*%TRANSMIT_DIR=$SPOOLDIR/outgoing%" \
        -e "s%^RECEIVE_DIR=.*%RECEIVE_DIR=$SPOOLDIR/incoming%" \
        -e "s%^LOGFILE=.*%LOGFILE=$SPOOLDIR/log%" \
	$ZFAXLIB/config.example > $ZFAXLIB/config || ERROR=true

    chown $LIBOWNER $ZFAXLIB/config
    chgrp $LIBGROUP $ZFAXLIB/config
    chmod a+r $ZFAXLIB/config
else

    # For client-only installation, copy example config file unchanged.

    cp $ZFAXLIB/config.example $ZFAXLIB/config || ERROR=true
    chown $LIBOWNER $ZFAXLIB/config
    chgrp $LIBGROUP $ZFAXLIB/config
fi

if test "$L_ERROR" = true
then
    ERROR=true
fi

if test "$ERROR" = true
then
    echo ""
    echo An error occurred during installation.  If you need assistance,
    echo call Z-Code at $PHONE_NUMBER between the hours of 9am and 5pm PST.
    echo ""
    exit 1
fi

echo ""

if test "$WARNING" = true
then
    echo A non-fatal error occured during installation.  You may proceed
    echo with user registration, but you may see warning messages when
    echo using the Z-Fax program.  None of these warnings should have
    echo any significant effect on the operation of Z-Fax.
else
    cat <<EOM
No errors were detected during installation into these locations:

    Library:      $ZFAXLIB
EOM
    if test "$NETWORK_LICENSE" = false
    then
	cat <<EOM
    Licensing:    $LICENSE_DIR
EOM
    fi
    cat <<EOM
    X Resources:  $XAPPLRESDIR
    Executables:  $BIN
    Man pages:    $MANDIR (section $MANSEC)
EOM
fi

# Dump our environment, appropriately munged, so register.sh can grab it.
# This is a hack, because if register.sh is not running in $ZFAXLIB, it will
# not be able to find this file anyway.

cat <<EOM > $ZFAXLIB/.register.env
BIN=$BIN
MANDIR=$MANDIR
MANSEC=$MANSEC
LICENSE_LIB=$LICENSE_LIB
LICENSE_DIR=$LICENSE_DIR
LOCAL=$LOCAL
PATH=${PATH}:$BIN
ZFAXLIB=$ZFAXLIB
ZFSHIPDIR=$ZFSHIPDIR
ZFPASSWD=$ZFPASSWD
EOM

if test -f "$ZCNLINST" && test "$DO_NLSINSTALL" = true
then
    echo ""
    echo "-------------------------"
    echo ""
    echo "You may optionally install the Z-Code Network License Server."
    echo ""
    def=Yes
    echo $n "Install the network server now, on this machine? [$def] $c"
    read ans
    ans=`echo $ans $def | sed 's/\(.\).*/\1/' | tr YN yn`
    if test "$ans" = "y"
    then
	cd $ZCNLSDIR
	exec $REAL_SH `basename $ZCNLINST`
    fi
elif test "$NETWORK_LICENSE" = true
then
    echo ""
    echo Please call Z-Code Software at $PHONE_NUMBER for instructions on
    echo installation of your Z-Code Network License Server software.
    echo ""
fi

if test "$NETWORK_LICENSE" = true
then
    cat <<EOM

You must install the network license server in order to register your
activation keys and users.  If the license server is to be installed
on another machine, register your keys and users there.
EOM
fi

if test -d "$ZFSHIPDIR"
then
    if test "$ZFSHIPDIR" != "$ZFAXLIB"
    then
	cat <<EOM

Z-Fax installation completed.  You may register your Z-Fax program
and users now, or later at your convenience with "zfax -register".

You can remove the installation directory:
	$ZFSHIPDIR
if you will not be using it for further installations of Z-Fax
or of the Network License Server.
EOM
    fi
fi

if test "$NETWORK_LICENSE" = true
then
    exit 0
fi

#
# Run zfax -register repeatedly
# until it succeeds or the user decides to give up.
#
helping_verb=""
adverb="now"
while :
do
    if test -f "$BIN/zfax"
    then
	def=y
	echo $n "Do you wish to$helping_verb register your Z-Fax activation key $adverb? [$def] $c"
	read ans
	ans=`echo $ans.|sed -e 's/^[^yYnN]/'$def/ -e 's/\(.\).*/\1/'|tr YN yn`
	echo ""
    else
	ans=n
    fi

    if test "$ans" = n
    then
	cat <<EOM
When you are ready to register your Z-Fax activation key and users,
make sure you have permission to write $LICENSE_DIR/$LICENSE_FILE
and then type:

EOM
	if test "$LICENSE_DIR/$LICENSE_FILE" != /usr/lib/Zfax/license/license.data
	then
	    echo "    zfax -register -f $LICENSE_DIR/$LICENSE_FILE"
	else
	    echo "    zfax -register"
	fi
        echo ""
        break
    fi

    if $BIN/zfax -register -f $LICENSE_DIR/$LICENSE_FILE
    then
        break
    fi
    helping_verb=" try to"
    adverb="again"
    echo ""
done

cat <<EOM

Z-Fax installation and registration script finished.

EOM

exit 0
