/* Copyright Indiana University 1991

   Version 1.2(2)

   This IGRP protocol decoder for Network General Sniffer 
   was written by the Network Research and Planning group
   at Indiana University.  We hope you find it useful.  We
   don't guarantee anything and won't accept responsibility
   for and damages resulting from its use.  It works for
   us.  Your mileage may vary...

   We place this software in the public domain.  Feel free
   to modify it to suit your needs.  If you come up with
   a neat modification, we'd like to hear about it.  If
   you find a bug, we'd like to hear about that too.
   For either of the above contact:

   Allen Robel
   (812)855-7171
   robelr@mythos.ucs.indiana.edu

Change log.

3/26/91 Written  Allen Robel
3/26/91 - Don't use 1st byte of Local subnets to determine IP
          address of Nets in and outside AS. (allen)
3/27/91 - Changed K1-K5 from manifest constants to unsigned char 
          variables. (allen)
        - Changed test for K5=0 to include other values of
          K5 besides 0 and 1.  (allen)
3/27/91 - Added manifest constants for flag bits in 1st
          byte of header (Version, Update, Request) to
          igrp.h. (allen)
*/

#include "pi.h"
#include "igrp.h"

extern struct pi_data *pi_data_ip_igrp; /* pointer to PI data for IGRP */
extern int interp_ip();

struct igrp_header {
    unsigned char verOpcode;        /* version+opcode            */
    unsigned char edition;          /* serial incrementing       */
    unsigned char asystem[2];       /* autonomous system number  */
    unsigned char ninterior[2];     /* # of subnets in local net */
    unsigned char nsystem[2];       /* # of networks in AS       */
    unsigned char nexterior[2];     /* # of networks outside AS  */
    unsigned char checksum[2];      /* of igrp header and data   */
};

struct igrp_route_entry {
    unsigned char number[3];        /* 3 significant octets of IP    */
    unsigned char delay[3];         /* in tens of microseconds       */
    unsigned char bandwidth[3];     /* inverted, scaled * 10E10      */
    unsigned char mtu[2];           /* in octets                     */
    unsigned char rely;             /* % packets tx/rx OK (x/255)    */
    unsigned char load;             /* % of channel occupied (x/255) */
    unsigned char hopcount;         /* hops to this destination      */
};

int interp_ip_igrp(header, length)

struct igrp_header *header;
int length;                    /* length of remaining data             */

{
struct igrp_route_entry *route;
unsigned int routeCount;       /* number of routes to display in detail */
unsigned int LocalRoutes;      /* LocalRoutes in decimal                */
unsigned int InASRoutes;       /* Routes inside autonomous System       */
unsigned int OutASRoutes;      /* Routes outside autonomous system      */
unsigned int IPfirstByte;      /* Pointer to most significant byte of
                                  sender's address.                     */
unsigned igrp_start_addr;      /* Start of IGRP portion of frame       
                                  Used in calculation to see if we're 
                                  beyond end of frame */
unsigned igrp_current_addr;

char *Localbanner  = "Local Routes (Subnets in this network)";
char *InASbanner   = "System Routes (Major networks in this AS)";
char *OutASbanner  = "Exterior Routes (Candidate Default Routes)";
long BW;            /* Used to calculate Bandwidth that gets displayed */
long BWcalc;        /* Used in calculating composite metric            */
long delay;
int mtu;
long metric;        /* composite metric            */

/* weights for composite mmetric */

unsigned char K1 = 1;  
unsigned char K2 = 0;
unsigned char K3 = 1;
unsigned char K4 = 0;
unsigned char K5 = 0;


    /* set up PIF globals */

    pif_init(pi_data_ip_igrp, header, length);

    igrp_start_addr=(int)pif_get_addr(); /* Save current addr = start of IGRP */   

    if(pi_data_ip_igrp->do_sum) {

        if(((int)pif_get_addr())-igrp_start_addr+sizeof(struct igrp_header) > length-bytes_not_present) {

            sprintf(get_sum_line (pi_data_ip_igrp),
                "IGRP Header unreadable. Frame too short.");
            return ((length-bytes_not_present)-((int) pif_get_addr()-igrp_start_addr));

        }

        /* find out how many routes we're dealing with */

        LocalRoutes=(header->ninterior[1])+(header->ninterior[0] * 256);
        InASRoutes=(header->nsystem[1])+(header->nsystem[0] * 256);
        OutASRoutes=(header->nexterior[1])+(header->nexterior[0] * 256);

        /* Print sumary line */

        sprintf(get_sum_line (pi_data_ip_igrp),
            "IGRP  Routing Entries = %d",
             LocalRoutes+InASRoutes+OutASRoutes);
    }

    if (pi_data_ip_igrp->do_int) {

        if(((int) pif_get_addr())-igrp_start_addr+sizeof(struct igrp_header) > length-bytes_not_present) {

                sprintf(get_int_line(pi_data_ip_igrp,
                   pif_get_addr()-dlc_header,
                   (length-bytes_not_present)-((int) pif_get_addr()-igrp_start_addr)), 
                   "Frame too short. IGRP Header incomplete.");

            return ((length-bytes_not_present)-((int) pif_get_addr()-igrp_start_addr));

        }

        /* find out how many routes we're dealing with */

        LocalRoutes=(header->ninterior[1])+(header->ninterior[0] * 256);
        InASRoutes=(header->nsystem[1])+(header->nsystem[0] * 256);
        OutASRoutes=(header->nexterior[1])+(header->nexterior[0] * 256);


        /* Get first byte of sender's address to make local
           routes easier to read    */

        IPfirstByte=pif_get_byte(-8); 

        /* output the header line and highlite the whole header.
           pif_header() doesn't advance pif offset */

        pif_header(sizeof(struct igrp_header), "IGRP Protocol Header");

        /* display the fields.  pif_show_X advances buffer pointer past
           data item argument */

        pif_show_flag    ("Version and Opcode",19);
        pif_show_flagbit (IGRP_VERSION_1,"Version 1", "Unknown Version");
        pif_show_flagbit (IGRP_UPDATE,"Update"," ");
        pif_show_flagbit (IGRP_REQUEST,"Request"," ");

        pif_show_space();
  
        pif_show_byte    ("Edition             = %u");
        pif_show_word_hl ("AS Number           = %d");
        pif_show_word_hl ("Local Subnets       = %d");
        pif_show_word_hl ("Networks inside  AS = %d");
        pif_show_word_hl ("Networks outside AS = %d");
        pif_show_word_hl ("Checksum            = %x");

        pif_show_space();
        
        /* Print Banner for Local Routes  */

        if(LocalRoutes > 0) {
            pif_show_space();
            sprintf(get_int_line(pi_data_ip_igrp,
               pif_get_addr()-dlc_header,
               0), 
               "%s", 
               Localbanner);
            pif_show_space();
        }

        for(routeCount=1; routeCount <= LocalRoutes; routeCount++) {

            if(((int) pif_get_addr())-igrp_start_addr+sizeof(struct igrp_route_entry) > length-bytes_not_present) {
                                
                sprintf(get_int_line(pi_data_ip_igrp,
                   pif_get_addr()-dlc_header,
                   (length-bytes_not_present)-((int) pif_get_addr()-igrp_start_addr)), 
                   "Frame too short to display any more routes.  Bytes left = %d",
                   (length-bytes_not_present)-((int) pif_get_addr()-igrp_start_addr));

                return ((length-bytes_not_present)-((int) pif_get_addr()-igrp_start_addr));


            }

            /* set address of route entry structure to next route entry 
               in frame */

            route=(struct igrp_route_entry *)pif_get_addr();   
                                                           
            BW=(long)( 10000000/( (route->bandwidth[0])*4096 + (route->bandwidth[1])*256 + route->bandwidth[2] ) );
            BWcalc=(long)( (route->bandwidth[0]*4096) + (route->bandwidth[1]*256) + (route->bandwidth[2]) );
            delay=(long)((route->delay[0]*4096)+(route->delay[1]*256)+(route->delay[2]));    
            mtu=(int)(route->mtu[0]*256)+(int)(route->mtu[1]);

            if (K5 == 0)
                metric=(long)( (K1 * BWcalc)+ ((K2 * BWcalc)/(256-route->load)) + (K3 * delay) );
             else              
                metric=(long)((K1*BWcalc) + ((K2*BWcalc)/(256 - route->load)) + (K3 * delay)) * ((route->rely + K4)/K5);            
            
            sprintf(get_int_line(pi_data_ip_igrp,
               pif_get_addr()-dlc_header,
               IGRP_NUMBER+IGRP_DELAY+IGRP_BANDWIDTH+IGRP_MTU),
               "# %u [%u.%u.%u.%u]   DLY %ld usec, BW %ld Kbit, MTU %d bytes",
                routeCount,
                IPfirstByte,
                route->number[0],
                route->number[1],
                route->number[2],               
                delay*10,
                BW,
                mtu);
  
            pif_skip(IGRP_NUMBER+IGRP_DELAY+IGRP_BANDWIDTH+IGRP_MTU);
    
            sprintf(get_int_line(pi_data_ip_igrp,
               pif_get_addr()-dlc_header,
               IGRP_RELY+IGRP_LOAD+IGRP_HOPCOUNT), 
               "                     rely %u/255, load %u/255, Hops %u, Metric %ld", 
               route->rely,
               route->load, 
               route->hopcount,
               metric);
    
            pif_skip(IGRP_RELY+IGRP_LOAD+IGRP_HOPCOUNT);


        }      /* END for Local Nets *        

               /* Print Banner for Routes inside AS */

        if(InASRoutes > 0) {
            pif_show_space();
            sprintf(get_int_line(pi_data_ip_igrp,
               pif_get_addr()-dlc_header,
               0), 
               "%s", 
               InASbanner);
            pif_show_space();
        }

        for(routeCount=1; routeCount <= InASRoutes; routeCount++) {

            if(((int) pif_get_addr())-igrp_start_addr+sizeof(struct igrp_route_entry) > length-bytes_not_present) {
                
                   sprintf(get_int_line(pi_data_ip_igrp,
                       pif_get_addr()-dlc_header,
                       (length-bytes_not_present)-((int) pif_get_addr()-igrp_start_addr)), 
                       "Frame too short to display any more routes.  Bytes left = %d",
                       (length-bytes_not_present)-((int) pif_get_addr()-igrp_start_addr));

                   return ((length-bytes_not_present)-((int) pif_get_addr()-igrp_start_addr));

            }

            /* set address of route entry structure to next route entry 
               in frame */

            route=(struct igrp_route_entry *)pif_get_addr();     

            BW=(long)( 10000000/( (route->bandwidth[0])*4096 + (route->bandwidth[1])*256 + route->bandwidth[2] ) );
            BWcalc=(long)( (route->bandwidth[0]*4096) + (route->bandwidth[1]*256) + (route->bandwidth[2]) );
            delay=(long)((route->delay[0]*4096)+(route->delay[1]*256)+(route->delay[2]));    
            mtu=(int)(route->mtu[0]*256)+(int)(route->mtu[1]);

            if (K5 == 0)
                metric=(long)( (K1 * BWcalc)+ ((K2 * BWcalc)/(256-route->load)) + (K3 * delay) );
             else              
                metric=(long)((K1*BWcalc) + ((K2*BWcalc)/(256 - route->load)) + (K3 * delay)) * ((route->rely + K4)/K5);            
            
            sprintf(get_int_line(pi_data_ip_igrp,
               pif_get_addr()-dlc_header,
               IGRP_NUMBER+IGRP_DELAY+IGRP_BANDWIDTH+IGRP_MTU),
               "# %u [%u.%u.%u.%u]   DLY %ld usec, BW %ld Kbit, MTU %d bytes",
                routeCount,
                route->number[0],
                route->number[1],
                route->number[2],               
                0,
                delay*10,
                BW,
                mtu);
  
            pif_skip(IGRP_NUMBER+IGRP_DELAY+IGRP_BANDWIDTH+IGRP_MTU);
    
            sprintf(get_int_line(pi_data_ip_igrp,
               pif_get_addr()-dlc_header,
               IGRP_RELY+IGRP_LOAD+IGRP_HOPCOUNT), 
               "                    rely %u/255, load %u/255, Hops %u, Metric %ld", 
               route->rely,
               route->load, 
               route->hopcount,
               metric);
    
            pif_skip(IGRP_RELY+IGRP_LOAD+IGRP_HOPCOUNT);


        }      /* END for inside AS  */

               /* Print Banner for Routes outside AS */

        if(OutASRoutes > 0) {
            pif_show_space();
            sprintf(get_int_line(pi_data_ip_igrp,
               pif_get_addr()-dlc_header,
               0), 
               "%s", 
               OutASbanner);
            pif_show_space();
        }

        for(routeCount=1; routeCount <= OutASRoutes; routeCount++) {

            if(((int) pif_get_addr())-igrp_start_addr+sizeof(struct igrp_route_entry) > length-bytes_not_present) {
                
                sprintf(get_int_line(pi_data_ip_igrp,
                   pif_get_addr()-dlc_header,
                   (length-bytes_not_present)-((int) pif_get_addr()-igrp_start_addr)), 
                   "Frame too short to display any more routes.  Bytes left = %d",
                   (length-bytes_not_present)-((int) pif_get_addr()-igrp_start_addr));

                return ((length-bytes_not_present)-((int) pif_get_addr()-igrp_start_addr));

            }

            /* set address of route entry structure to next route entry 
               in frame */

            route=(struct igrp_route_entry *)pif_get_addr();   

            BW=(long)( 10000000/( (route->bandwidth[0])*4096 + (route->bandwidth[1])*256 + route->bandwidth[2] ) );
            BWcalc=(long)( (route->bandwidth[0]*4096) + (route->bandwidth[1]*256) + (route->bandwidth[2]) );
            delay=(long)((route->delay[0]*4096)+(route->delay[1]*256)+(route->delay[2]));    
            mtu=(int)(route->mtu[0]*256)+(int)(route->mtu[1]);

            if (K5 == 0)
                metric=(long)( (K1 * BWcalc)+ ((K2 * BWcalc)/(256-route->load)) + (K3 * delay) );
             else              
                metric=(long)((K1*BWcalc) + ((K2*BWcalc)/(256 - route->load)) + (K3 * delay)) * ((route->rely + K4)/K5);            
            
            sprintf(get_int_line(pi_data_ip_igrp,
               pif_get_addr()-dlc_header,
               IGRP_NUMBER+IGRP_DELAY+IGRP_BANDWIDTH+IGRP_MTU),
               "# %u [%u.%u.%u.%u]   DLY %ld usec, BW %ld Kbit, MTU %d bytes",
                routeCount,
                route->number[0],
                route->number[1],
                route->number[2],
                0,               
                delay*10,
                BW,
                mtu);
  
            pif_skip(IGRP_NUMBER+IGRP_DELAY+IGRP_BANDWIDTH+IGRP_MTU);
    
            sprintf(get_int_line(pi_data_ip_igrp,
               pif_get_addr()-dlc_header,
               IGRP_RELY+IGRP_LOAD+IGRP_HOPCOUNT), 
               "                     rely %u/255, load %u/255, Hops %u, Metric %ld", 
               route->rely,
               route->load, 
               route->hopcount,
               metric);
    
            pif_skip(IGRP_RELY+IGRP_LOAD+IGRP_HOPCOUNT);


        }     /* END for Outside AS  */

   pif_trailer();

   }          /* END if do_int       */


return ((length-bytes_not_present)-((int) pif_get_addr()-igrp_start_addr));

}             /* END igrp.c          */


