/*
 * ppp.h - PPP global declarations.
 *
 * Copyright (c) 1989 Carnegie Mellon University.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Carnegie Mellon University.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/*
 * TODO:
 */

#ifndef __PPP_H__
#define __PPP_H__
#include "args.h"
#define NPPP	1		/* One PPP interface supported (per process) */
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#include "../h/ppp.h"
#include "dpio.h"
extern int dialup;
extern int debug;		/* Debug flag */
extern char ifname[];		/* Interface name */
extern int dpfd;		/* Device file descriptor */
extern int fd;			/* Async file descriptor */
extern int s;			/* socket descriptor */
extern char hostname[];		/* hostname */
extern u_char hostname_len;	/* and its length */
extern u_char outpacket_buf[];	/* buffer for outgoing packets */

#define MAX_HOSTNAME_LEN 128	/* should be 255 - MAX_CHALLENGE_LEN + 1 */

void quit __ARGS((void));			/* Cleanup and exit */
void timeout __ARGS((void (*)(), caddr_t, int));
                            /* Look-alike of kernel's timeout() */
void untimeout __ARGS((void (*)(), caddr_t));
                            /* Look-alike of kernel's untimeout() */
void output __ARGS((int, u_char *, int));	/* Output a PPP packet */
void demuxprotrej __ARGS((int, u_short));	/* Demultiplex a Protocol-Reject */
u_char login __ARGS((char *, int, char *, int, char **, int *)); /* Login user */
void logout __ARGS((void));			/* Logout user */
void get_secret __ARGS((u_char *, u_char *, int *)); /* get "secret" for chap */
u_long GetMask __ARGS((u_long)); /* get netmask for address */
extern int errno;


/*
 * Inline versions of get/put char/short/long.
 * Pointer is advanced; we assume that both arguments
 * are lvalues and will already be in registers.
 * cp MUST be u_char *.
 */
#define GETCHAR(c, cp) { \
	(c) = *(cp)++; \
}
#define PUTCHAR(c, cp) { \
	*(cp)++ = (c); \
}


#define GETSHORT(s, cp) { \
	(s) = *(cp)++ << 8; \
	(s) |= *(cp)++; \
}
#define PUTSHORT(s, cp) { \
	*(cp)++ = (s) >> 8; \
	*(cp)++ = (s); \
}

#define GETLONG(l, cp) { \
	(l) = *(cp)++ << 8; \
	(l) |= *(cp)++; (l) <<= 8; \
	(l) |= *(cp)++; (l) <<= 8; \
	(l) |= *(cp)++; \
}
#define PUTLONG(l, cp) { \
	*(cp)++ = (l) >> 24; \
	*(cp)++ = (l) >> 16; \
	*(cp)++ = (l) >> 8; \
	*(cp)++ = (l); \
}

#define INCPTR(n, cp)	((cp) += (n))
#define DECPTR(n, cp)	((cp) -= (n))


/*
 * Data Link Layer header = Address, Control, Protocol.
 */
#define ALLSTATIONS	0xff	/* All-Stations Address */
#define UI		0x03	/* Unnumbered Information */
#define LCP		0xc021	/* Link Control Protocol */
#define IPCP		0x8021	/* IP Control Protocol */
#define UPAP		0xc023	/* User/Password Authentication Protocol */
#define LQR		0xc025  /* Link Quality Report */
#define CHAP            0xc223  /* Crytpographic Handshake Protocol */
#define IP_VJ_COMP	0x002d	/* VJ TCP compressed IP packet */
#define DLLHEADERLEN	(sizeof (u_char) + sizeof (u_char) + sizeof (u_short))
#define MTU		1500	/* Default MTU */


/*
 * System dependent definitions for user-level 4.3BSD UNIX implementation.
 */

#define DEMUXPROTREJ(u, p) demuxprotrej(u, p)

#define TIMEOUT(r, f, t) timeout((r), (f), (t))
#define UNTIMEOUT(r, f)	untimeout((r), (f))

#define BCOPY(s, d, l)	memcpy(d, s, l)
#define EXIT(u)		quit()

#define GETUSERPASSWD(u)
#define LOGIN(n, u, ul, p, pl, m, ml) login(u, ul, p, pl, m, ml);
#define LOGOUT(n)	logout()
#define GETSECRET(n, s, sl) get_secret(n, s, sl)
#define PRINTMSG(m, l)	{ m[l] = '\0'; syslog(LOG_INFO, "Remote message: %s", m); }

/*
 * return a pointer to the beginning of the data part of a packet.
 */

#define PACKET_DATA(p) (p + DLLHEADERLEN)

/*
 * MAKEHEADER - Add Header fields to a packet.  (Should we do
 * AC compression here?)
 */
#define MAKEHEADER(p, t) { \
    PUTCHAR(ALLSTATIONS, p); \
    PUTCHAR(UI, p); \
    PUTSHORT(t, p); }

/*
 * SIFUP - Config the interface up.
 */
#define SIFUP(u)	{ \
    struct ifreq ifr; \
    strncpy(ifr.ifr_name, ifname, sizeof (ifr.ifr_name)); \
    if (ioctl(s, SIOCGIFFLAGS, (caddr_t) &ifr) < 0) { \
	syslog(LOG_ERR, "ioctl (SIOCGIFFLAGS): %m"); \
	quit(); \
    } \
    ifr.ifr_flags |= IFF_UP; \
    if (ioctl(s, SIOCSIFFLAGS, (caddr_t) &ifr) < 0) { \
	syslog(LOG_ERR, "ioctl(SIOCSIFFLAGS): %m"); \
	quit(); \
    } }

/*
 * SIFBRINGUP - Start packets flowing.
 */
#define SIFBRINGUP(s)	{ \
    if (dialup) {\
	char stat = s; \
	if (strioctl(dpfd, DPIOCCALLSTAT, -1, sizeof(stat), &stat) < 0) { \
	    syslog(LOG_ERR, "ioctl (SIOCCALLSTAT): %m"); \
	    quit(); \
    } } }

/*
 * SIFSAPENABLE - Start packets flowing for a particular SAP (protocol)
 */
#define SIFSAPENABLE(s)	{ \
    if (dialup) {\
	ulong sap = s; \
	if (strioctl(dpfd, DPIOCSAPENABLE, -1, sizeof(sap), &sap) < 0) { \
	    syslog(LOG_ERR, "ioctl (SIOCSAPENABLE): %m"); \
	    quit(); \
    } } }
/*
 * SIFSAPDISABLE - Stop packets flowing for a particular SAP (protocol)
 */
#define SIFSAPDISABLE(s)  { \
    if (dialup) {\
	ulong sap = s; \
	if (strioctl(dpfd, DPIOCSAPDISABLE, -1, sizeof(sap), &sap) < 0) { \
	    syslog(LOG_ERR, "ioctl (SIOCSAPDISABLE): %m"); \
	    quit(); \
    } } }

/*
 * SIFDOWN - Config the interface down.
 */
#define SIFDOWN(u)	{ \
    struct ifreq ifr; \
    if (!dialup) { \
	strncpy(ifr.ifr_name, ifname, sizeof (ifr.ifr_name)); \
	if (ioctl(s, SIOCGIFFLAGS, (caddr_t) &ifr) < 0) { \
	    syslog(LOG_ERR, "ioctl (SIOCGIFFLAGS): %m"); \
	    quit(); \
	} \
	ifr.ifr_flags &= ~IFF_UP; \
	if (ioctl(s, SIOCSIFFLAGS, (caddr_t) &ifr) < 0) { \
	    syslog(LOG_ERR, "ioctl(SIOCSIFFLAGS): %m"); \
	    quit(); \
    } } }


/*
 * SIFMTU - Config the interface MTU.
 */
#ifndef	ifr_mtu
#define	ifr_mtu	ifr_metric
#endif
#define SIFMTU(u, mtu)	{ \
    struct ifreq ifr; \
    strncpy(ifr.ifr_name, ifname, sizeof (ifr.ifr_name)); \
    ifr.ifr_mtu = mtu; \
    if (ioctl(s, SIOCSIFMTU, (caddr_t) &ifr) < 0) { \
	syslog(LOG_ERR, "ioctl(SIOCSIFMTU): %m"); \
	quit(); \
    } }

/*
 * SIFVJCOMP - Config the interface for Van Jacobsen TCP header compression
 */
#define	SIFVJCOMP(u, a) 	{ \
    char x = a;			\
	if (debug) syslog(LOG_DEBUG, "SIFVJCOMP unit %d to value %d\n",u,x); \
	if(strioctl(dpfd, DPIOCSVJCOMP, -1, sizeof(x), (caddr_t) &x) < 0) { \
		syslog(LOG_ERR, "ioctl(DPIOCSVJCOMP): %m"); \
		quit(); \
	} \
}
#define	SIFASYNCMAP(u, a, err)	{ \
     u_long x = a; \
     if(strioctl(dpfd, DPIOCSASYNCMAP, -1, sizeof(x), (caddr_t)&x) < 0) { \
	if (!(err && err == errno)) \
	    syslog(LOG_ERR, "ioctl(DPIOCSASYNCMAP): %m"); \
    } }

/*
 * SIFPCOMPRESSION - Config the interface for protocol compression.
 */
#define SIFPCOMPRESSION(u, err)	{ \
    char c = 1; \
    if(strioctl(dpfd, DPIOCSCOMPPROT, -1, sizeof(c), (caddr_t)&c) < 0) { \
	if (!(err && err == errno)) \
	    syslog(LOG_ERR, "ioctl(DPIOCSCOMPPROT): %m"); \
    }}

/*
 * CIFPCOMPRESSION - Config the interface for no protocol compression.
 */
#define CIFPCOMPRESSION(u, err)	{ \
    char c = 0; \
    if(strioctl(dpfd, DPIOCSCOMPPROT, -1, sizeof(c), (caddr_t)&c) < 0) { \
	if (!(err && err == errno)) \
	    syslog(LOG_ERR, "ioctl(DPIOCSCOMPPROT): %m"); \
	quit(); \
    }}
/*
 * SIFACCOMPRESSION - Config the interface for address/control compression.
 */
#define SIFACCOMPRESSION(u, err)	{ \
   char c = 1; \
    if(strioctl(dpfd, DPIOCSCOMPAC, -1, sizeof(c), (caddr_t)&c) < 0) { \
	if (!(err && err == errno)) \
	    syslog(LOG_ERR, "ioctl(DPIOCSCOMPAC): %m"); \
	quit(); \
    }}
/*
 * CIFACCOMPRESSION - Config the interface for no address/control compression.
 */
#define CIFACCOMPRESSION(u, err)	{ \
    char c = 0; \
    if(strioctl(dpfd, DPIOCSCOMPAC, -1, sizeof(c), (caddr_t)&c) < 0) { \
	if (!(err && err == errno)) \
	    syslog(LOG_ERR, "ioctl(DPIOCSCOMPAC): %m"); \
	quit(); \
    }}
/*
 * SIFADDR - Config the interface IP addresses.
 */
#define SIFADDR(u, o, h)	{ \
    struct ifreq ifr; \
    strncpy(ifr.ifr_name, ifname, sizeof (ifr.ifr_name)); \
    (void)memset((char *) &ifr.ifr_addr, 0, sizeof(ifr.ifr_addr));  \
    ifr.ifr_addr.sa_family = AF_INET; \
    ((struct sockaddr_in *) &ifr.ifr_addr)->sin_addr.s_addr = o; \
    if (ioctl(s, SIOCSIFADDR, (caddr_t) &ifr) < 0) { \
	syslog(LOG_ERR, "ioctl(SIOCSIFADDR): %m"); \
    } \
    ((struct sockaddr_in *) &ifr.ifr_dstaddr)->sin_addr.s_addr = h; \
    if (ioctl(s, SIOCSIFDSTADDR, (caddr_t) &ifr) < 0) { \
	syslog(LOG_ERR, "ioctl(SIOCSIFDSTADDR): %m"); \
	quit(); \
    } }

/*
 * CIFADDR - Clear the interface IP addresses.
 */
#define CIFADDR(u, o, h)	{ \
    struct rtentry rt; \
    if (!dialup) { \
	(void)memset((char *) &rt.rt_dst, 0, sizeof(rt.rt_dst));  \
	rt.rt_dst.sa_family = AF_INET; \
	((struct sockaddr_in *) &rt.rt_dst)->sin_addr.s_addr = h; \
	(void)memset((char *) &rt.rt_gateway, 0, sizeof(rt.rt_gateway));  \
	rt.rt_gateway.sa_family = AF_INET; \
	((struct sockaddr_in *) &rt.rt_gateway)->sin_addr.s_addr = o; \
	rt.rt_flags |= RTF_HOST; \
	if (ioctl(s, SIOCDELRT, (caddr_t) &rt) < 0) { \
	    syslog(LOG_ERR, "ioctl(SIOCDELRT): %m"); \
	    quit(); \
    } } }


/*
 * SIFMASK - Config the interface net mask
 */
#define SIFMASK(u, mask)	{ \
    struct ifreq ifr; \
    strncpy(ifr.ifr_name, ifname, sizeof (ifr.ifr_name)); \
    (void)memset((char *) &ifr.ifr_addr, 0, sizeof(ifr.ifr_addr));  \
    ifr.ifr_addr.sa_family = AF_INET; \
    ((struct sockaddr_in *) &ifr.ifr_addr)->sin_addr.s_addr = mask; \
    if (ioctl(s, SIOCSIFNETMASK, (caddr_t) &ifr) < 0) { \
	syslog(LOG_ERR, "ioctl(SIOCSIFADDR): %m"); \
    } }

#if defined(DEBUG)
#define	DEBUGMAIN
#define	DEBUGFSM
#define	DEBUGLCP
#define	DEBUGIPCP
#define	DEBUGUPAP
#define	DEBUGCHAP 
#endif

#ifndef LOG_PPP			/* we use LOG_LOCAL2 for syslog by default */
#if defined(DEBUGMAIN) || defined(DEBUGFSM) || defined(DEBUG) \
  || defined(DEBUGLCP) || defined(DEBUGIPCP) || defined(DEBUGUPAP) \
  || defined(DEBUGCHAP) 
#define LOG_PPP LOG_LOCAL2
#else
#define LOG_PPP LOG_DAEMON
#endif
#endif /* LOG_PPP */

#ifdef DEBUGMAIN
#define MAINDEBUG(x)	if (debug) syslog x;
#else
#define MAINDEBUG(x)
#endif

#ifdef DEBUGFSM
#define FSMDEBUG(x)	if (debug) syslog x;
#else
#define FSMDEBUG(x)
#endif

#ifdef DEBUGLCP
#define LCPDEBUG(x)	if (debug) syslog x;
#else
#define LCPDEBUG(x)
#endif

#ifdef DEBUGIPCP
#define IPCPDEBUG(x)	if (debug) syslog x;
#else
#define IPCPDEBUG(x)
#endif

#ifdef DEBUGUPAP
#define UPAPDEBUG(x)	if (debug) syslog x;
#else
#define UPAPDEBUG(x)
#endif

#ifdef DEBUGCHAP
#define CHAPDEBUG(x)	if (debug) syslog x;
#else
#define CHAPDEBUG(x)
#endif

#ifdef DEBUGLQR
#define LQRDEBUG(x)	if (debug) syslog x;
#else
#define LQRDEBUG(x)
#endif

#ifndef SIGTYPE
#if defined(sun) || defined(SYSV) || defined(POSIX_SOURCE)
#define SIGTYPE void
#else
#define SIGTYPE int
#endif /* defined(sun) || defined(SYSV) || defined(POSIX_SOURCE) */
#endif /* SIGTYPE */
#endif /* __PPP_H__ */
