/*
 * ppp.h - Point-to-Point Protocol definitions.
 *
 * Copyright (c) 1989 Carnegie Mellon University.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Carnegie Mellon University.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
/*
 * Copyright (c) 1993 Purdue University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Purdue University.  The name of the University may not be used
 * to endorse or promote products derived * from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Note: this copyright applies to portions of this software developed
 * at Purdue beyond the software covered by the original copyright.
 */

#ifndef	_SYS_PPP_H
#define	_SYS_PPP_H

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Standard PPP header.
 */
typedef struct ppp_header {
	u_char	ph_address;	/* Address Field */
	u_char	ph_control;	/* Control Field */
	u_short	ph_protocol;	/* Protocol Field */
} phdr_t;

#define	PPP_HDR_SIZE	(sizeof(struct ppp_header))

#define	PPP_ALLSTATIONS	0xff	/* All-Stations broadcast address */
#define	PPP_UI		0x03	/* Unnumbered Information */
#define	PPP_FLAG	0x7e	/* Flag Sequence */
#define	PPP_ESCAPE	0x7d	/* Asynchronous Control Escape */
#define	PPP_TRANS	0x20	/* Asynchronous transparency modifier */
#define	PPP_SPECIAL(x)	((((x)-PPP_ESCAPE) & ~1) == 0)

/*
 * Protocol types.
 */
#define PPP_IP		0x0021	/* Internet Protocol */
#define	PPP_XNS		0x0025	/* Xerox NS */
#define	PPP_VJC_COMP	0x002d	/* VJ compressed TCP */
#define	PPP_VJC_UNCOMP	0x002f	/* VJ uncompressed TCP */

#define	PPP_NET		0x0000	/* Upper bits for Network Protocol Datagrams */
#define	PPP_LCP		0x8000	/* Upper bits for Link Control Protocol */
#define	PPP_NCP		0xc000	/* Upper bits for Network Control Protocol */

/*
 * Important FCS values.
 */
#define PPP_INITFCS	0xffff	/* Initial FCS value */
#define PPP_GOODFCS	0xf0b8	/* Good final FCS value */
#define PPP_FCS(fcs, c)	(((fcs) >> 8) ^ fcstab[((fcs) ^ (c)) & 0xff])

#define	PPP_MTU		1500	/* Default MTU (size of Info field) */
#define	PPP_HIWAT	1000	/* Don't start a new packet if HIWAT on que */
#define	CLISTRESERVE	1000	/* Can't let clists get too low */


#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_PPP_H */
